/*  Copyright (c) MediaArea.net SARL & AV Preservation by reto.ch.
 *
 *  Use of this source code is governed by a BSD-style license that can
 *  be found in the License.html file in the root of the source tree.
 */

//---------------------------------------------------------------------------
#include "Lib/CRC32/ZenCRC32.h"
using namespace std;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
static const uint32_t CRC32_Table[16*256] =
{
    0x00000000, 0xB71DC104, 0x6E3B8209, 0xD926430D,
    0xDC760413, 0x6B6BC517, 0xB24D861A, 0x0550471E,
    0xB8ED0826, 0x0FF0C922, 0xD6D68A2F, 0x61CB4B2B,
    0x649B0C35, 0xD386CD31, 0x0AA08E3C, 0xBDBD4F38,
    0x70DB114C, 0xC7C6D048, 0x1EE09345, 0xA9FD5241,
    0xACAD155F, 0x1BB0D45B, 0xC2969756, 0x758B5652,
    0xC836196A, 0x7F2BD86E, 0xA60D9B63, 0x11105A67,
    0x14401D79, 0xA35DDC7D, 0x7A7B9F70, 0xCD665E74,
    0xE0B62398, 0x57ABE29C, 0x8E8DA191, 0x39906095,
    0x3CC0278B, 0x8BDDE68F, 0x52FBA582, 0xE5E66486,
    0x585B2BBE, 0xEF46EABA, 0x3660A9B7, 0x817D68B3,
    0x842D2FAD, 0x3330EEA9, 0xEA16ADA4, 0x5D0B6CA0,
    0x906D32D4, 0x2770F3D0, 0xFE56B0DD, 0x494B71D9,
    0x4C1B36C7, 0xFB06F7C3, 0x2220B4CE, 0x953D75CA,
    0x28803AF2, 0x9F9DFBF6, 0x46BBB8FB, 0xF1A679FF,
    0xF4F63EE1, 0x43EBFFE5, 0x9ACDBCE8, 0x2DD07DEC,
    0x77708634, 0xC06D4730, 0x194B043D, 0xAE56C539,
    0xAB068227, 0x1C1B4323, 0xC53D002E, 0x7220C12A,
    0xCF9D8E12, 0x78804F16, 0xA1A60C1B, 0x16BBCD1F,
    0x13EB8A01, 0xA4F64B05, 0x7DD00808, 0xCACDC90C,
    0x07AB9778, 0xB0B6567C, 0x69901571, 0xDE8DD475,
    0xDBDD936B, 0x6CC0526F, 0xB5E61162, 0x02FBD066,
    0xBF469F5E, 0x085B5E5A, 0xD17D1D57, 0x6660DC53,
    0x63309B4D, 0xD42D5A49, 0x0D0B1944, 0xBA16D840,
    0x97C6A5AC, 0x20DB64A8, 0xF9FD27A5, 0x4EE0E6A1,
    0x4BB0A1BF, 0xFCAD60BB, 0x258B23B6, 0x9296E2B2,
    0x2F2BAD8A, 0x98366C8E, 0x41102F83, 0xF60DEE87,
    0xF35DA999, 0x4440689D, 0x9D662B90, 0x2A7BEA94,
    0xE71DB4E0, 0x500075E4, 0x892636E9, 0x3E3BF7ED,
    0x3B6BB0F3, 0x8C7671F7, 0x555032FA, 0xE24DF3FE,
    0x5FF0BCC6, 0xE8ED7DC2, 0x31CB3ECF, 0x86D6FFCB,
    0x8386B8D5, 0x349B79D1, 0xEDBD3ADC, 0x5AA0FBD8,
    0xEEE00C69, 0x59FDCD6D, 0x80DB8E60, 0x37C64F64,
    0x3296087A, 0x858BC97E, 0x5CAD8A73, 0xEBB04B77,
    0x560D044F, 0xE110C54B, 0x38368646, 0x8F2B4742,
    0x8A7B005C, 0x3D66C158, 0xE4408255, 0x535D4351,
    0x9E3B1D25, 0x2926DC21, 0xF0009F2C, 0x471D5E28,
    0x424D1936, 0xF550D832, 0x2C769B3F, 0x9B6B5A3B,
    0x26D61503, 0x91CBD407, 0x48ED970A, 0xFFF0560E,
    0xFAA01110, 0x4DBDD014, 0x949B9319, 0x2386521D,
    0x0E562FF1, 0xB94BEEF5, 0x606DADF8, 0xD7706CFC,
    0xD2202BE2, 0x653DEAE6, 0xBC1BA9EB, 0x0B0668EF,
    0xB6BB27D7, 0x01A6E6D3, 0xD880A5DE, 0x6F9D64DA,
    0x6ACD23C4, 0xDDD0E2C0, 0x04F6A1CD, 0xB3EB60C9,
    0x7E8D3EBD, 0xC990FFB9, 0x10B6BCB4, 0xA7AB7DB0,
    0xA2FB3AAE, 0x15E6FBAA, 0xCCC0B8A7, 0x7BDD79A3,
    0xC660369B, 0x717DF79F, 0xA85BB492, 0x1F467596,
    0x1A163288, 0xAD0BF38C, 0x742DB081, 0xC3307185,
    0x99908A5D, 0x2E8D4B59, 0xF7AB0854, 0x40B6C950,
    0x45E68E4E, 0xF2FB4F4A, 0x2BDD0C47, 0x9CC0CD43,
    0x217D827B, 0x9660437F, 0x4F460072, 0xF85BC176,
    0xFD0B8668, 0x4A16476C, 0x93300461, 0x242DC565,
    0xE94B9B11, 0x5E565A15, 0x87701918, 0x306DD81C,
    0x353D9F02, 0x82205E06, 0x5B061D0B, 0xEC1BDC0F,
    0x51A69337, 0xE6BB5233, 0x3F9D113E, 0x8880D03A,
    0x8DD09724, 0x3ACD5620, 0xE3EB152D, 0x54F6D429,
    0x7926A9C5, 0xCE3B68C1, 0x171D2BCC, 0xA000EAC8,
    0xA550ADD6, 0x124D6CD2, 0xCB6B2FDF, 0x7C76EEDB,
    0xC1CBA1E3, 0x76D660E7, 0xAFF023EA, 0x18EDE2EE,
    0x1DBDA5F0, 0xAAA064F4, 0x738627F9, 0xC49BE6FD,
    0x09FDB889, 0xBEE0798D, 0x67C63A80, 0xD0DBFB84,
    0xD58BBC9A, 0x62967D9E, 0xBBB03E93, 0x0CADFF97,
    0xB110B0AF, 0x060D71AB, 0xDF2B32A6, 0x6836F3A2,
    0x6D66B4BC, 0xDA7B75B8, 0x035D36B5, 0xB440F7B1,

    0x00000000, 0xDCC119D2, 0x0F9EF2A0, 0xD35FEB72,
    0xA9212445, 0x75E03D97, 0xA6BFD6E5, 0x7A7ECF37,
    0x5243488A, 0x8E825158, 0x5DDDBA2A, 0x811CA3F8,
    0xFB626CCF, 0x27A3751D, 0xF4FC9E6F, 0x283D87BD,
    0x139B5110, 0xCF5A48C2, 0x1C05A3B0, 0xC0C4BA62,
    0xBABA7555, 0x667B6C87, 0xB52487F5, 0x69E59E27,
    0x41D8199A, 0x9D190048, 0x4E46EB3A, 0x9287F2E8,
    0xE8F93DDF, 0x3438240D, 0xE767CF7F, 0x3BA6D6AD,
    0x2636A320, 0xFAF7BAF2, 0x29A85180, 0xF5694852,
    0x8F178765, 0x53D69EB7, 0x808975C5, 0x5C486C17,
    0x7475EBAA, 0xA8B4F278, 0x7BEB190A, 0xA72A00D8,
    0xDD54CFEF, 0x0195D63D, 0xD2CA3D4F, 0x0E0B249D,
    0x35ADF230, 0xE96CEBE2, 0x3A330090, 0xE6F21942,
    0x9C8CD675, 0x404DCFA7, 0x931224D5, 0x4FD33D07,
    0x67EEBABA, 0xBB2FA368, 0x6870481A, 0xB4B151C8,
    0xCECF9EFF, 0x120E872D, 0xC1516C5F, 0x1D90758D,
    0x4C6C4641, 0x90AD5F93, 0x43F2B4E1, 0x9F33AD33,
    0xE54D6204, 0x398C7BD6, 0xEAD390A4, 0x36128976,
    0x1E2F0ECB, 0xC2EE1719, 0x11B1FC6B, 0xCD70E5B9,
    0xB70E2A8E, 0x6BCF335C, 0xB890D82E, 0x6451C1FC,
    0x5FF71751, 0x83360E83, 0x5069E5F1, 0x8CA8FC23,
    0xF6D63314, 0x2A172AC6, 0xF948C1B4, 0x2589D866,
    0x0DB45FDB, 0xD1754609, 0x022AAD7B, 0xDEEBB4A9,
    0xA4957B9E, 0x7854624C, 0xAB0B893E, 0x77CA90EC,
    0x6A5AE561, 0xB69BFCB3, 0x65C417C1, 0xB9050E13,
    0xC37BC124, 0x1FBAD8F6, 0xCCE53384, 0x10242A56,
    0x3819ADEB, 0xE4D8B439, 0x37875F4B, 0xEB464699,
    0x913889AE, 0x4DF9907C, 0x9EA67B0E, 0x426762DC,
    0x79C1B471, 0xA500ADA3, 0x765F46D1, 0xAA9E5F03,
    0xD0E09034, 0x0C2189E6, 0xDF7E6294, 0x03BF7B46,
    0x2B82FCFB, 0xF743E529, 0x241C0E5B, 0xF8DD1789,
    0x82A3D8BE, 0x5E62C16C, 0x8D3D2A1E, 0x51FC33CC,
    0x98D88C82, 0x44199550, 0x97467E22, 0x4B8767F0,
    0x31F9A8C7, 0xED38B115, 0x3E675A67, 0xE2A643B5,
    0xCA9BC408, 0x165ADDDA, 0xC50536A8, 0x19C42F7A,
    0x63BAE04D, 0xBF7BF99F, 0x6C2412ED, 0xB0E50B3F,
    0x8B43DD92, 0x5782C440, 0x84DD2F32, 0x581C36E0,
    0x2262F9D7, 0xFEA3E005, 0x2DFC0B77, 0xF13D12A5,
    0xD9009518, 0x05C18CCA, 0xD69E67B8, 0x0A5F7E6A,
    0x7021B15D, 0xACE0A88F, 0x7FBF43FD, 0xA37E5A2F,
    0xBEEE2FA2, 0x622F3670, 0xB170DD02, 0x6DB1C4D0,
    0x17CF0BE7, 0xCB0E1235, 0x1851F947, 0xC490E095,
    0xECAD6728, 0x306C7EFA, 0xE3339588, 0x3FF28C5A,
    0x458C436D, 0x994D5ABF, 0x4A12B1CD, 0x96D3A81F,
    0xAD757EB2, 0x71B46760, 0xA2EB8C12, 0x7E2A95C0,
    0x04545AF7, 0xD8954325, 0x0BCAA857, 0xD70BB185,
    0xFF363638, 0x23F72FEA, 0xF0A8C498, 0x2C69DD4A,
    0x5617127D, 0x8AD60BAF, 0x5989E0DD, 0x8548F90F,
    0xD4B4CAC3, 0x0875D311, 0xDB2A3863, 0x07EB21B1,
    0x7D95EE86, 0xA154F754, 0x720B1C26, 0xAECA05F4,
    0x86F78249, 0x5A369B9B, 0x896970E9, 0x55A8693B,
    0x2FD6A60C, 0xF317BFDE, 0x204854AC, 0xFC894D7E,
    0xC72F9BD3, 0x1BEE8201, 0xC8B16973, 0x147070A1,
    0x6E0EBF96, 0xB2CFA644, 0x61904D36, 0xBD5154E4,
    0x956CD359, 0x49ADCA8B, 0x9AF221F9, 0x4633382B,
    0x3C4DF71C, 0xE08CEECE, 0x33D305BC, 0xEF121C6E,
    0xF28269E3, 0x2E437031, 0xFD1C9B43, 0x21DD8291,
    0x5BA34DA6, 0x87625474, 0x543DBF06, 0x88FCA6D4,
    0xA0C12169, 0x7C0038BB, 0xAF5FD3C9, 0x739ECA1B,
    0x09E0052C, 0xD5211CFE, 0x067EF78C, 0xDABFEE5E,
    0xE11938F3, 0x3DD82121, 0xEE87CA53, 0x3246D381,
    0x48381CB6, 0x94F90564, 0x47A6EE16, 0x9B67F7C4,
    0xB35A7079, 0x6F9B69AB, 0xBCC482D9, 0x60059B0B,
    0x1A7B543C, 0xC6BA4DEE, 0x15E5A69C, 0xC924BF4E,

    0x00000000, 0x87ACD801, 0x0E59B103, 0x89F56902,
    0x1CB26207, 0x9B1EBA06, 0x12EBD304, 0x95470B05,
    0x3864C50E, 0xBFC81D0F, 0x363D740D, 0xB191AC0C,
    0x24D6A709, 0xA37A7F08, 0x2A8F160A, 0xAD23CE0B,
    0x70C88A1D, 0xF764521C, 0x7E913B1E, 0xF93DE31F,
    0x6C7AE81A, 0xEBD6301B, 0x62235919, 0xE58F8118,
    0x48AC4F13, 0xCF009712, 0x46F5FE10, 0xC1592611,
    0x541E2D14, 0xD3B2F515, 0x5A479C17, 0xDDEB4416,
    0xE090153B, 0x673CCD3A, 0xEEC9A438, 0x69657C39,
    0xFC22773C, 0x7B8EAF3D, 0xF27BC63F, 0x75D71E3E,
    0xD8F4D035, 0x5F580834, 0xD6AD6136, 0x5101B937,
    0xC446B232, 0x43EA6A33, 0xCA1F0331, 0x4DB3DB30,
    0x90589F26, 0x17F44727, 0x9E012E25, 0x19ADF624,
    0x8CEAFD21, 0x0B462520, 0x82B34C22, 0x051F9423,
    0xA83C5A28, 0x2F908229, 0xA665EB2B, 0x21C9332A,
    0xB48E382F, 0x3322E02E, 0xBAD7892C, 0x3D7B512D,
    0xC0212B76, 0x478DF377, 0xCE789A75, 0x49D44274,
    0xDC934971, 0x5B3F9170, 0xD2CAF872, 0x55662073,
    0xF845EE78, 0x7FE93679, 0xF61C5F7B, 0x71B0877A,
    0xE4F78C7F, 0x635B547E, 0xEAAE3D7C, 0x6D02E57D,
    0xB0E9A16B, 0x3745796A, 0xBEB01068, 0x391CC869,
    0xAC5BC36C, 0x2BF71B6D, 0xA202726F, 0x25AEAA6E,
    0x888D6465, 0x0F21BC64, 0x86D4D566, 0x01780D67,
    0x943F0662, 0x1393DE63, 0x9A66B761, 0x1DCA6F60,
    0x20B13E4D, 0xA71DE64C, 0x2EE88F4E, 0xA944574F,
    0x3C035C4A, 0xBBAF844B, 0x325AED49, 0xB5F63548,
    0x18D5FB43, 0x9F792342, 0x168C4A40, 0x91209241,
    0x04679944, 0x83CB4145, 0x0A3E2847, 0x8D92F046,
    0x5079B450, 0xD7D56C51, 0x5E200553, 0xD98CDD52,
    0x4CCBD657, 0xCB670E56, 0x42926754, 0xC53EBF55,
    0x681D715E, 0xEFB1A95F, 0x6644C05D, 0xE1E8185C,
    0x74AF1359, 0xF303CB58, 0x7AF6A25A, 0xFD5A7A5B,
    0x804356EC, 0x07EF8EED, 0x8E1AE7EF, 0x09B63FEE,
    0x9CF134EB, 0x1B5DECEA, 0x92A885E8, 0x15045DE9,
    0xB82793E2, 0x3F8B4BE3, 0xB67E22E1, 0x31D2FAE0,
    0xA495F1E5, 0x233929E4, 0xAACC40E6, 0x2D6098E7,
    0xF08BDCF1, 0x772704F0, 0xFED26DF2, 0x797EB5F3,
    0xEC39BEF6, 0x6B9566F7, 0xE2600FF5, 0x65CCD7F4,
    0xC8EF19FF, 0x4F43C1FE, 0xC6B6A8FC, 0x411A70FD,
    0xD45D7BF8, 0x53F1A3F9, 0xDA04CAFB, 0x5DA812FA,
    0x60D343D7, 0xE77F9BD6, 0x6E8AF2D4, 0xE9262AD5,
    0x7C6121D0, 0xFBCDF9D1, 0x723890D3, 0xF59448D2,
    0x58B786D9, 0xDF1B5ED8, 0x56EE37DA, 0xD142EFDB,
    0x4405E4DE, 0xC3A93CDF, 0x4A5C55DD, 0xCDF08DDC,
    0x101BC9CA, 0x97B711CB, 0x1E4278C9, 0x99EEA0C8,
    0x0CA9ABCD, 0x8B0573CC, 0x02F01ACE, 0x855CC2CF,
    0x287F0CC4, 0xAFD3D4C5, 0x2626BDC7, 0xA18A65C6,
    0x34CD6EC3, 0xB361B6C2, 0x3A94DFC0, 0xBD3807C1,
    0x40627D9A, 0xC7CEA59B, 0x4E3BCC99, 0xC9971498,
    0x5CD01F9D, 0xDB7CC79C, 0x5289AE9E, 0xD525769F,
    0x7806B894, 0xFFAA6095, 0x765F0997, 0xF1F3D196,
    0x64B4DA93, 0xE3180292, 0x6AED6B90, 0xED41B391,
    0x30AAF787, 0xB7062F86, 0x3EF34684, 0xB95F9E85,
    0x2C189580, 0xABB44D81, 0x22412483, 0xA5EDFC82,
    0x08CE3289, 0x8F62EA88, 0x0697838A, 0x813B5B8B,
    0x147C508E, 0x93D0888F, 0x1A25E18D, 0x9D89398C,
    0xA0F268A1, 0x275EB0A0, 0xAEABD9A2, 0x290701A3,
    0xBC400AA6, 0x3BECD2A7, 0xB219BBA5, 0x35B563A4,
    0x9896ADAF, 0x1F3A75AE, 0x96CF1CAC, 0x1163C4AD,
    0x8424CFA8, 0x038817A9, 0x8A7D7EAB, 0x0DD1A6AA,
    0xD03AE2BC, 0x57963ABD, 0xDE6353BF, 0x59CF8BBE,
    0xCC8880BB, 0x4B2458BA, 0xC2D131B8, 0x457DE9B9,
    0xE85E27B2, 0x6FF2FFB3, 0xE60796B1, 0x61AB4EB0,
    0xF4EC45B5, 0x73409DB4, 0xFAB5F4B6, 0x7D192CB7,

    0x00000000, 0xB79A6DDC, 0xD9281ABC, 0x6EB27760,
    0x054CF57C, 0xB2D698A0, 0xDC64EFC0, 0x6BFE821C,
    0x0A98EAF9, 0xBD028725, 0xD3B0F045, 0x642A9D99,
    0x0FD41F85, 0xB84E7259, 0xD6FC0539, 0x616668E5,
    0xA32D14F7, 0x14B7792B, 0x7A050E4B, 0xCD9F6397,
    0xA661E18B, 0x11FB8C57, 0x7F49FB37, 0xC8D396EB,
    0xA9B5FE0E, 0x1E2F93D2, 0x709DE4B2, 0xC707896E,
    0xACF90B72, 0x1B6366AE, 0x75D111CE, 0xC24B7C12,
    0xF146E9EA, 0x46DC8436, 0x286EF356, 0x9FF49E8A,
    0xF40A1C96, 0x4390714A, 0x2D22062A, 0x9AB86BF6,
    0xFBDE0313, 0x4C446ECF, 0x22F619AF, 0x956C7473,
    0xFE92F66F, 0x49089BB3, 0x27BAECD3, 0x9020810F,
    0x526BFD1D, 0xE5F190C1, 0x8B43E7A1, 0x3CD98A7D,
    0x57270861, 0xE0BD65BD, 0x8E0F12DD, 0x39957F01,
    0x58F317E4, 0xEF697A38, 0x81DB0D58, 0x36416084,
    0x5DBFE298, 0xEA258F44, 0x8497F824, 0x330D95F8,
    0x559013D1, 0xE20A7E0D, 0x8CB8096D, 0x3B2264B1,
    0x50DCE6AD, 0xE7468B71, 0x89F4FC11, 0x3E6E91CD,
    0x5F08F928, 0xE89294F4, 0x8620E394, 0x31BA8E48,
    0x5A440C54, 0xEDDE6188, 0x836C16E8, 0x34F67B34,
    0xF6BD0726, 0x41276AFA, 0x2F951D9A, 0x980F7046,
    0xF3F1F25A, 0x446B9F86, 0x2AD9E8E6, 0x9D43853A,
    0xFC25EDDF, 0x4BBF8003, 0x250DF763, 0x92979ABF,
    0xF96918A3, 0x4EF3757F, 0x2041021F, 0x97DB6FC3,
    0xA4D6FA3B, 0x134C97E7, 0x7DFEE087, 0xCA648D5B,
    0xA19A0F47, 0x1600629B, 0x78B215FB, 0xCF287827,
    0xAE4E10C2, 0x19D47D1E, 0x77660A7E, 0xC0FC67A2,
    0xAB02E5BE, 0x1C988862, 0x722AFF02, 0xC5B092DE,
    0x07FBEECC, 0xB0618310, 0xDED3F470, 0x694999AC,
    0x02B71BB0, 0xB52D766C, 0xDB9F010C, 0x6C056CD0,
    0x0D630435, 0xBAF969E9, 0xD44B1E89, 0x63D17355,
    0x082FF149, 0xBFB59C95, 0xD107EBF5, 0x669D8629,
    0x1D3DE6A6, 0xAAA78B7A, 0xC415FC1A, 0x738F91C6,
    0x187113DA, 0xAFEB7E06, 0xC1590966, 0x76C364BA,
    0x17A50C5F, 0xA03F6183, 0xCE8D16E3, 0x79177B3F,
    0x12E9F923, 0xA57394FF, 0xCBC1E39F, 0x7C5B8E43,
    0xBE10F251, 0x098A9F8D, 0x6738E8ED, 0xD0A28531,
    0xBB5C072D, 0x0CC66AF1, 0x62741D91, 0xD5EE704D,
    0xB48818A8, 0x03127574, 0x6DA00214, 0xDA3A6FC8,
    0xB1C4EDD4, 0x065E8008, 0x68ECF768, 0xDF769AB4,
    0xEC7B0F4C, 0x5BE16290, 0x355315F0, 0x82C9782C,
    0xE937FA30, 0x5EAD97EC, 0x301FE08C, 0x87858D50,
    0xE6E3E5B5, 0x51798869, 0x3FCBFF09, 0x885192D5,
    0xE3AF10C9, 0x54357D15, 0x3A870A75, 0x8D1D67A9,
    0x4F561BBB, 0xF8CC7667, 0x967E0107, 0x21E46CDB,
    0x4A1AEEC7, 0xFD80831B, 0x9332F47B, 0x24A899A7,
    0x45CEF142, 0xF2549C9E, 0x9CE6EBFE, 0x2B7C8622,
    0x4082043E, 0xF71869E2, 0x99AA1E82, 0x2E30735E,
    0x48ADF577, 0xFF3798AB, 0x9185EFCB, 0x261F8217,
    0x4DE1000B, 0xFA7B6DD7, 0x94C91AB7, 0x2353776B,
    0x42351F8E, 0xF5AF7252, 0x9B1D0532, 0x2C8768EE,
    0x4779EAF2, 0xF0E3872E, 0x9E51F04E, 0x29CB9D92,
    0xEB80E180, 0x5C1A8C5C, 0x32A8FB3C, 0x853296E0,
    0xEECC14FC, 0x59567920, 0x37E40E40, 0x807E639C,
    0xE1180B79, 0x568266A5, 0x383011C5, 0x8FAA7C19,
    0xE454FE05, 0x53CE93D9, 0x3D7CE4B9, 0x8AE68965,
    0xB9EB1C9D, 0x0E717141, 0x60C30621, 0xD7596BFD,
    0xBCA7E9E1, 0x0B3D843D, 0x658FF35D, 0xD2159E81,
    0xB373F664, 0x04E99BB8, 0x6A5BECD8, 0xDDC18104,
    0xB63F0318, 0x01A56EC4, 0x6F1719A4, 0xD88D7478,
    0x1AC6086A, 0xAD5C65B6, 0xC3EE12D6, 0x74747F0A,
    0x1F8AFD16, 0xA81090CA, 0xC6A2E7AA, 0x71388A76,
    0x105EE293, 0xA7C48F4F, 0xC976F82F, 0x7EEC95F3,
    0x151217EF, 0xA2887A33, 0xCC3A0D53, 0x7BA0608F,

    0x00000000, 0x8D670D49, 0x1ACF1A92, 0x97A817DB,
    0x8383F420, 0x0EE4F969, 0x994CEEB2, 0x142BE3FB,
    0x0607E941, 0x8B60E408, 0x1CC8F3D3, 0x91AFFE9A,
    0x85841D61, 0x08E31028, 0x9F4B07F3, 0x122C0ABA,
    0x0C0ED283, 0x8169DFCA, 0x16C1C811, 0x9BA6C558,
    0x8F8D26A3, 0x02EA2BEA, 0x95423C31, 0x18253178,
    0x0A093BC2, 0x876E368B, 0x10C62150, 0x9DA12C19,
    0x898ACFE2, 0x04EDC2AB, 0x9345D570, 0x1E22D839,
    0xAF016503, 0x2266684A, 0xB5CE7F91, 0x38A972D8,
    0x2C829123, 0xA1E59C6A, 0x364D8BB1, 0xBB2A86F8,
    0xA9068C42, 0x2461810B, 0xB3C996D0, 0x3EAE9B99,
    0x2A857862, 0xA7E2752B, 0x304A62F0, 0xBD2D6FB9,
    0xA30FB780, 0x2E68BAC9, 0xB9C0AD12, 0x34A7A05B,
    0x208C43A0, 0xADEB4EE9, 0x3A435932, 0xB724547B,
    0xA5085EC1, 0x286F5388, 0xBFC74453, 0x32A0491A,
    0x268BAAE1, 0xABECA7A8, 0x3C44B073, 0xB123BD3A,
    0x5E03CA06, 0xD364C74F, 0x44CCD094, 0xC9ABDDDD,
    0xDD803E26, 0x50E7336F, 0xC74F24B4, 0x4A2829FD,
    0x58042347, 0xD5632E0E, 0x42CB39D5, 0xCFAC349C,
    0xDB87D767, 0x56E0DA2E, 0xC148CDF5, 0x4C2FC0BC,
    0x520D1885, 0xDF6A15CC, 0x48C20217, 0xC5A50F5E,
    0xD18EECA5, 0x5CE9E1EC, 0xCB41F637, 0x4626FB7E,
    0x540AF1C4, 0xD96DFC8D, 0x4EC5EB56, 0xC3A2E61F,
    0xD78905E4, 0x5AEE08AD, 0xCD461F76, 0x4021123F,
    0xF102AF05, 0x7C65A24C, 0xEBCDB597, 0x66AAB8DE,
    0x72815B25, 0xFFE6566C, 0x684E41B7, 0xE5294CFE,
    0xF7054644, 0x7A624B0D, 0xEDCA5CD6, 0x60AD519F,
    0x7486B264, 0xF9E1BF2D, 0x6E49A8F6, 0xE32EA5BF,
    0xFD0C7D86, 0x706B70CF, 0xE7C36714, 0x6AA46A5D,
    0x7E8F89A6, 0xF3E884EF, 0x64409334, 0xE9279E7D,
    0xFB0B94C7, 0x766C998E, 0xE1C48E55, 0x6CA3831C,
    0x788860E7, 0xF5EF6DAE, 0x62477A75, 0xEF20773C,
    0xBC06940D, 0x31619944, 0xA6C98E9F, 0x2BAE83D6,
    0x3F85602D, 0xB2E26D64, 0x254A7ABF, 0xA82D77F6,
    0xBA017D4C, 0x37667005, 0xA0CE67DE, 0x2DA96A97,
    0x3982896C, 0xB4E58425, 0x234D93FE, 0xAE2A9EB7,
    0xB008468E, 0x3D6F4BC7, 0xAAC75C1C, 0x27A05155,
    0x338BB2AE, 0xBEECBFE7, 0x2944A83C, 0xA423A575,
    0xB60FAFCF, 0x3B68A286, 0xACC0B55D, 0x21A7B814,
    0x358C5BEF, 0xB8EB56A6, 0x2F43417D, 0xA2244C34,
    0x1307F10E, 0x9E60FC47, 0x09C8EB9C, 0x84AFE6D5,
    0x9084052E, 0x1DE30867, 0x8A4B1FBC, 0x072C12F5,
    0x1500184F, 0x98671506, 0x0FCF02DD, 0x82A80F94,
    0x9683EC6F, 0x1BE4E126, 0x8C4CF6FD, 0x012BFBB4,
    0x1F09238D, 0x926E2EC4, 0x05C6391F, 0x88A13456,
    0x9C8AD7AD, 0x11EDDAE4, 0x8645CD3F, 0x0B22C076,
    0x190ECACC, 0x9469C785, 0x03C1D05E, 0x8EA6DD17,
    0x9A8D3EEC, 0x17EA33A5, 0x8042247E, 0x0D252937,
    0xE2055E0B, 0x6F625342, 0xF8CA4499, 0x75AD49D0,
    0x6186AA2B, 0xECE1A762, 0x7B49B0B9, 0xF62EBDF0,
    0xE402B74A, 0x6965BA03, 0xFECDADD8, 0x73AAA091,
    0x6781436A, 0xEAE64E23, 0x7D4E59F8, 0xF02954B1,
    0xEE0B8C88, 0x636C81C1, 0xF4C4961A, 0x79A39B53,
    0x6D8878A8, 0xE0EF75E1, 0x7747623A, 0xFA206F73,
    0xE80C65C9, 0x656B6880, 0xF2C37F5B, 0x7FA47212,
    0x6B8F91E9, 0xE6E89CA0, 0x71408B7B, 0xFC278632,
    0x4D043B08, 0xC0633641, 0x57CB219A, 0xDAAC2CD3,
    0xCE87CF28, 0x43E0C261, 0xD448D5BA, 0x592FD8F3,
    0x4B03D249, 0xC664DF00, 0x51CCC8DB, 0xDCABC592,
    0xC8802669, 0x45E72B20, 0xD24F3CFB, 0x5F2831B2,
    0x410AE98B, 0xCC6DE4C2, 0x5BC5F319, 0xD6A2FE50,
    0xC2891DAB, 0x4FEE10E2, 0xD8460739, 0x55210A70,
    0x470D00CA, 0xCA6A0D83, 0x5DC21A58, 0xD0A51711,
    0xC48EF4EA, 0x49E9F9A3, 0xDE41EE78, 0x5326E331,

    0x00000000, 0x780D281B, 0xF01A5036, 0x8817782D,
    0xE035A06C, 0x98388877, 0x102FF05A, 0x6822D841,
    0xC06B40D9, 0xB86668C2, 0x307110EF, 0x487C38F4,
    0x205EE0B5, 0x5853C8AE, 0xD044B083, 0xA8499898,
    0x37CA41B6, 0x4FC769AD, 0xC7D01180, 0xBFDD399B,
    0xD7FFE1DA, 0xAFF2C9C1, 0x27E5B1EC, 0x5FE899F7,
    0xF7A1016F, 0x8FAC2974, 0x07BB5159, 0x7FB67942,
    0x1794A103, 0x6F998918, 0xE78EF135, 0x9F83D92E,
    0xD9894268, 0xA1846A73, 0x2993125E, 0x519E3A45,
    0x39BCE204, 0x41B1CA1F, 0xC9A6B232, 0xB1AB9A29,
    0x19E202B1, 0x61EF2AAA, 0xE9F85287, 0x91F57A9C,
    0xF9D7A2DD, 0x81DA8AC6, 0x09CDF2EB, 0x71C0DAF0,
    0xEE4303DE, 0x964E2BC5, 0x1E5953E8, 0x66547BF3,
    0x0E76A3B2, 0x767B8BA9, 0xFE6CF384, 0x8661DB9F,
    0x2E284307, 0x56256B1C, 0xDE321331, 0xA63F3B2A,
    0xCE1DE36B, 0xB610CB70, 0x3E07B35D, 0x460A9B46,
    0xB21385D0, 0xCA1EADCB, 0x4209D5E6, 0x3A04FDFD,
    0x522625BC, 0x2A2B0DA7, 0xA23C758A, 0xDA315D91,
    0x7278C509, 0x0A75ED12, 0x8262953F, 0xFA6FBD24,
    0x924D6565, 0xEA404D7E, 0x62573553, 0x1A5A1D48,
    0x85D9C466, 0xFDD4EC7D, 0x75C39450, 0x0DCEBC4B,
    0x65EC640A, 0x1DE14C11, 0x95F6343C, 0xEDFB1C27,
    0x45B284BF, 0x3DBFACA4, 0xB5A8D489, 0xCDA5FC92,
    0xA58724D3, 0xDD8A0CC8, 0x559D74E5, 0x2D905CFE,
    0x6B9AC7B8, 0x1397EFA3, 0x9B80978E, 0xE38DBF95,
    0x8BAF67D4, 0xF3A24FCF, 0x7BB537E2, 0x03B81FF9,
    0xABF18761, 0xD3FCAF7A, 0x5BEBD757, 0x23E6FF4C,
    0x4BC4270D, 0x33C90F16, 0xBBDE773B, 0xC3D35F20,
    0x5C50860E, 0x245DAE15, 0xAC4AD638, 0xD447FE23,
    0xBC652662, 0xC4680E79, 0x4C7F7654, 0x34725E4F,
    0x9C3BC6D7, 0xE436EECC, 0x6C2196E1, 0x142CBEFA,
    0x7C0E66BB, 0x04034EA0, 0x8C14368D, 0xF4191E96,
    0xD33ACBA5, 0xAB37E3BE, 0x23209B93, 0x5B2DB388,
    0x330F6BC9, 0x4B0243D2, 0xC3153BFF, 0xBB1813E4,
    0x13518B7C, 0x6B5CA367, 0xE34BDB4A, 0x9B46F351,
    0xF3642B10, 0x8B69030B, 0x037E7B26, 0x7B73533D,
    0xE4F08A13, 0x9CFDA208, 0x14EADA25, 0x6CE7F23E,
    0x04C52A7F, 0x7CC80264, 0xF4DF7A49, 0x8CD25252,
    0x249BCACA, 0x5C96E2D1, 0xD4819AFC, 0xAC8CB2E7,
    0xC4AE6AA6, 0xBCA342BD, 0x34B43A90, 0x4CB9128B,
    0x0AB389CD, 0x72BEA1D6, 0xFAA9D9FB, 0x82A4F1E0,
    0xEA8629A1, 0x928B01BA, 0x1A9C7997, 0x6291518C,
    0xCAD8C914, 0xB2D5E10F, 0x3AC29922, 0x42CFB139,
    0x2AED6978, 0x52E04163, 0xDAF7394E, 0xA2FA1155,
    0x3D79C87B, 0x4574E060, 0xCD63984D, 0xB56EB056,
    0xDD4C6817, 0xA541400C, 0x2D563821, 0x555B103A,
    0xFD1288A2, 0x851FA0B9, 0x0D08D894, 0x7505F08F,
    0x1D2728CE, 0x652A00D5, 0xED3D78F8, 0x953050E3,
    0x61294E75, 0x1924666E, 0x91331E43, 0xE93E3658,
    0x811CEE19, 0xF911C602, 0x7106BE2F, 0x090B9634,
    0xA1420EAC, 0xD94F26B7, 0x51585E9A, 0x29557681,
    0x4177AEC0, 0x397A86DB, 0xB16DFEF6, 0xC960D6ED,
    0x56E30FC3, 0x2EEE27D8, 0xA6F95FF5, 0xDEF477EE,
    0xB6D6AFAF, 0xCEDB87B4, 0x46CCFF99, 0x3EC1D782,
    0x96884F1A, 0xEE856701, 0x66921F2C, 0x1E9F3737,
    0x76BDEF76, 0x0EB0C76D, 0x86A7BF40, 0xFEAA975B,
    0xB8A00C1D, 0xC0AD2406, 0x48BA5C2B, 0x30B77430,
    0x5895AC71, 0x2098846A, 0xA88FFC47, 0xD082D45C,
    0x78CB4CC4, 0x00C664DF, 0x88D11CF2, 0xF0DC34E9,
    0x98FEECA8, 0xE0F3C4B3, 0x68E4BC9E, 0x10E99485,
    0x8F6A4DAB, 0xF76765B0, 0x7F701D9D, 0x077D3586,
    0x6F5FEDC7, 0x1752C5DC, 0x9F45BDF1, 0xE74895EA,
    0x4F010D72, 0x370C2569, 0xBF1B5D44, 0xC716755F,
    0xAF34AD1E, 0xD7398505, 0x5F2EFD28, 0x2723D533,

    0x00000000, 0x1168574F, 0x22D0AE9E, 0x33B8F9D1,
    0xF3BD9C39, 0xE2D5CB76, 0xD16D32A7, 0xC00565E8,
    0xE67B3973, 0xF7136E3C, 0xC4AB97ED, 0xD5C3C0A2,
    0x15C6A54A, 0x04AEF205, 0x37160BD4, 0x267E5C9B,
    0xCCF772E6, 0xDD9F25A9, 0xEE27DC78, 0xFF4F8B37,
    0x3F4AEEDF, 0x2E22B990, 0x1D9A4041, 0x0CF2170E,
    0x2A8C4B95, 0x3BE41CDA, 0x085CE50B, 0x1934B244,
    0xD931D7AC, 0xC85980E3, 0xFBE17932, 0xEA892E7D,
    0x2FF224C8, 0x3E9A7387, 0x0D228A56, 0x1C4ADD19,
    0xDC4FB8F1, 0xCD27EFBE, 0xFE9F166F, 0xEFF74120,
    0xC9891DBB, 0xD8E14AF4, 0xEB59B325, 0xFA31E46A,
    0x3A348182, 0x2B5CD6CD, 0x18E42F1C, 0x098C7853,
    0xE305562E, 0xF26D0161, 0xC1D5F8B0, 0xD0BDAFFF,
    0x10B8CA17, 0x01D09D58, 0x32686489, 0x230033C6,
    0x057E6F5D, 0x14163812, 0x27AEC1C3, 0x36C6968C,
    0xF6C3F364, 0xE7ABA42B, 0xD4135DFA, 0xC57B0AB5,
    0xE9F98894, 0xF891DFDB, 0xCB29260A, 0xDA417145,
    0x1A4414AD, 0x0B2C43E2, 0x3894BA33, 0x29FCED7C,
    0x0F82B1E7, 0x1EEAE6A8, 0x2D521F79, 0x3C3A4836,
    0xFC3F2DDE, 0xED577A91, 0xDEEF8340, 0xCF87D40F,
    0x250EFA72, 0x3466AD3D, 0x07DE54EC, 0x16B603A3,
    0xD6B3664B, 0xC7DB3104, 0xF463C8D5, 0xE50B9F9A,
    0xC375C301, 0xD21D944E, 0xE1A56D9F, 0xF0CD3AD0,
    0x30C85F38, 0x21A00877, 0x1218F1A6, 0x0370A6E9,
    0xC60BAC5C, 0xD763FB13, 0xE4DB02C2, 0xF5B3558D,
    0x35B63065, 0x24DE672A, 0x17669EFB, 0x060EC9B4,
    0x2070952F, 0x3118C260, 0x02A03BB1, 0x13C86CFE,
    0xD3CD0916, 0xC2A55E59, 0xF11DA788, 0xE075F0C7,
    0x0AFCDEBA, 0x1B9489F5, 0x282C7024, 0x3944276B,
    0xF9414283, 0xE82915CC, 0xDB91EC1D, 0xCAF9BB52,
    0xEC87E7C9, 0xFDEFB086, 0xCE574957, 0xDF3F1E18,
    0x1F3A7BF0, 0x0E522CBF, 0x3DEAD56E, 0x2C828221,
    0x65EED02D, 0x74868762, 0x473E7EB3, 0x565629FC,
    0x96534C14, 0x873B1B5B, 0xB483E28A, 0xA5EBB5C5,
    0x8395E95E, 0x92FDBE11, 0xA14547C0, 0xB02D108F,
    0x70287567, 0x61402228, 0x52F8DBF9, 0x43908CB6,
    0xA919A2CB, 0xB871F584, 0x8BC90C55, 0x9AA15B1A,
    0x5AA43EF2, 0x4BCC69BD, 0x7874906C, 0x691CC723,
    0x4F629BB8, 0x5E0ACCF7, 0x6DB23526, 0x7CDA6269,
    0xBCDF0781, 0xADB750CE, 0x9E0FA91F, 0x8F67FE50,
    0x4A1CF4E5, 0x5B74A3AA, 0x68CC5A7B, 0x79A40D34,
    0xB9A168DC, 0xA8C93F93, 0x9B71C642, 0x8A19910D,
    0xAC67CD96, 0xBD0F9AD9, 0x8EB76308, 0x9FDF3447,
    0x5FDA51AF, 0x4EB206E0, 0x7D0AFF31, 0x6C62A87E,
    0x86EB8603, 0x9783D14C, 0xA43B289D, 0xB5537FD2,
    0x75561A3A, 0x643E4D75, 0x5786B4A4, 0x46EEE3EB,
    0x6090BF70, 0x71F8E83F, 0x424011EE, 0x532846A1,
    0x932D2349, 0x82457406, 0xB1FD8DD7, 0xA095DA98,
    0x8C1758B9, 0x9D7F0FF6, 0xAEC7F627, 0xBFAFA168,
    0x7FAAC480, 0x6EC293CF, 0x5D7A6A1E, 0x4C123D51,
    0x6A6C61CA, 0x7B043685, 0x48BCCF54, 0x59D4981B,
    0x99D1FDF3, 0x88B9AABC, 0xBB01536D, 0xAA690422,
    0x40E02A5F, 0x51887D10, 0x623084C1, 0x7358D38E,
    0xB35DB666, 0xA235E129, 0x918D18F8, 0x80E54FB7,
    0xA69B132C, 0xB7F34463, 0x844BBDB2, 0x9523EAFD,
    0x55268F15, 0x444ED85A, 0x77F6218B, 0x669E76C4,
    0xA3E57C71, 0xB28D2B3E, 0x8135D2EF, 0x905D85A0,
    0x5058E048, 0x4130B707, 0x72884ED6, 0x63E01999,
    0x459E4502, 0x54F6124D, 0x674EEB9C, 0x7626BCD3,
    0xB623D93B, 0xA74B8E74, 0x94F377A5, 0x859B20EA,
    0x6F120E97, 0x7E7A59D8, 0x4DC2A009, 0x5CAAF746,
    0x9CAF92AE, 0x8DC7C5E1, 0xBE7F3C30, 0xAF176B7F,
    0x896937E4, 0x980160AB, 0xABB9997A, 0xBAD1CE35,
    0x7AD4ABDD, 0x6BBCFC92, 0x58040543, 0x496C520C,

    0x00000000, 0xCADCA15B, 0x94B943B7, 0x5E65E2EC,
    0x9F6E466A, 0x55B2E731, 0x0BD705DD, 0xC10BA486,
    0x3EDD8CD4, 0xF4012D8F, 0xAA64CF63, 0x60B86E38,
    0xA1B3CABE, 0x6B6F6BE5, 0x350A8909, 0xFFD62852,
    0xCBA7D8AD, 0x017B79F6, 0x5F1E9B1A, 0x95C23A41,
    0x54C99EC7, 0x9E153F9C, 0xC070DD70, 0x0AAC7C2B,
    0xF57A5479, 0x3FA6F522, 0x61C317CE, 0xAB1FB695,
    0x6A141213, 0xA0C8B348, 0xFEAD51A4, 0x3471F0FF,
    0x2152705F, 0xEB8ED104, 0xB5EB33E8, 0x7F3792B3,
    0xBE3C3635, 0x74E0976E, 0x2A857582, 0xE059D4D9,
    0x1F8FFC8B, 0xD5535DD0, 0x8B36BF3C, 0x41EA1E67,
    0x80E1BAE1, 0x4A3D1BBA, 0x1458F956, 0xDE84580D,
    0xEAF5A8F2, 0x202909A9, 0x7E4CEB45, 0xB4904A1E,
    0x759BEE98, 0xBF474FC3, 0xE122AD2F, 0x2BFE0C74,
    0xD4282426, 0x1EF4857D, 0x40916791, 0x8A4DC6CA,
    0x4B46624C, 0x819AC317, 0xDFFF21FB, 0x152380A0,
    0x42A4E0BE, 0x887841E5, 0xD61DA309, 0x1CC10252,
    0xDDCAA6D4, 0x1716078F, 0x4973E563, 0x83AF4438,
    0x7C796C6A, 0xB6A5CD31, 0xE8C02FDD, 0x221C8E86,
    0xE3172A00, 0x29CB8B5B, 0x77AE69B7, 0xBD72C8EC,
    0x89033813, 0x43DF9948, 0x1DBA7BA4, 0xD766DAFF,
    0x166D7E79, 0xDCB1DF22, 0x82D43DCE, 0x48089C95,
    0xB7DEB4C7, 0x7D02159C, 0x2367F770, 0xE9BB562B,
    0x28B0F2AD, 0xE26C53F6, 0xBC09B11A, 0x76D51041,
    0x63F690E1, 0xA92A31BA, 0xF74FD356, 0x3D93720D,
    0xFC98D68B, 0x364477D0, 0x6821953C, 0xA2FD3467,
    0x5D2B1C35, 0x97F7BD6E, 0xC9925F82, 0x034EFED9,
    0xC2455A5F, 0x0899FB04, 0x56FC19E8, 0x9C20B8B3,
    0xA851484C, 0x628DE917, 0x3CE80BFB, 0xF634AAA0,
    0x373F0E26, 0xFDE3AF7D, 0xA3864D91, 0x695AECCA,
    0x968CC498, 0x5C5065C3, 0x0235872F, 0xC8E92674,
    0x09E282F2, 0xC33E23A9, 0x9D5BC145, 0x5787601E,
    0x33550079, 0xF989A122, 0xA7EC43CE, 0x6D30E295,
    0xAC3B4613, 0x66E7E748, 0x388205A4, 0xF25EA4FF,
    0x0D888CAD, 0xC7542DF6, 0x9931CF1A, 0x53ED6E41,
    0x92E6CAC7, 0x583A6B9C, 0x065F8970, 0xCC83282B,
    0xF8F2D8D4, 0x322E798F, 0x6C4B9B63, 0xA6973A38,
    0x679C9EBE, 0xAD403FE5, 0xF325DD09, 0x39F97C52,
    0xC62F5400, 0x0CF3F55B, 0x529617B7, 0x984AB6EC,
    0x5941126A, 0x939DB331, 0xCDF851DD, 0x0724F086,
    0x12077026, 0xD8DBD17D, 0x86BE3391, 0x4C6292CA,
    0x8D69364C, 0x47B59717, 0x19D075FB, 0xD30CD4A0,
    0x2CDAFCF2, 0xE6065DA9, 0xB863BF45, 0x72BF1E1E,
    0xB3B4BA98, 0x79681BC3, 0x270DF92F, 0xEDD15874,
    0xD9A0A88B, 0x137C09D0, 0x4D19EB3C, 0x87C54A67,
    0x46CEEEE1, 0x8C124FBA, 0xD277AD56, 0x18AB0C0D,
    0xE77D245F, 0x2DA18504, 0x73C467E8, 0xB918C6B3,
    0x78136235, 0xB2CFC36E, 0xECAA2182, 0x267680D9,
    0x71F1E0C7, 0xBB2D419C, 0xE548A370, 0x2F94022B,
    0xEE9FA6AD, 0x244307F6, 0x7A26E51A, 0xB0FA4441,
    0x4F2C6C13, 0x85F0CD48, 0xDB952FA4, 0x11498EFF,
    0xD0422A79, 0x1A9E8B22, 0x44FB69CE, 0x8E27C895,
    0xBA56386A, 0x708A9931, 0x2EEF7BDD, 0xE433DA86,
    0x25387E00, 0xEFE4DF5B, 0xB1813DB7, 0x7B5D9CEC,
    0x848BB4BE, 0x4E5715E5, 0x1032F709, 0xDAEE5652,
    0x1BE5F2D4, 0xD139538F, 0x8F5CB163, 0x45801038,
    0x50A39098, 0x9A7F31C3, 0xC41AD32F, 0x0EC67274,
    0xCFCDD6F2, 0x051177A9, 0x5B749545, 0x91A8341E,
    0x6E7E1C4C, 0xA4A2BD17, 0xFAC75FFB, 0x301BFEA0,
    0xF1105A26, 0x3BCCFB7D, 0x65A91991, 0xAF75B8CA,
    0x9B044835, 0x51D8E96E, 0x0FBD0B82, 0xC561AAD9,
    0x046A0E5F, 0xCEB6AF04, 0x90D34DE8, 0x5A0FECB3,
    0xA5D9C4E1, 0x6F0565BA, 0x31608756, 0xFBBC260D,
    0x3AB7828B, 0xF06B23D0, 0xAE0EC13C, 0x64D26067,

    0x00000000, 0x66AA00F2, 0x7B49C0E0, 0x1DE3C012,
    0x418F41C5, 0x27254137, 0x3AC68125, 0x5C6C81D7,
    0x3503428E, 0x53A9427C, 0x4E4A826E, 0x28E0829C,
    0x748C034B, 0x122603B9, 0x0FC5C3AB, 0x696FC359,
    0xDD1B4518, 0xBBB145EA, 0xA65285F8, 0xC0F8850A,
    0x9C9404DD, 0xFA3E042F, 0xE7DDC43D, 0x8177C4CF,
    0xE8180796, 0x8EB20764, 0x9351C776, 0xF5FBC784,
    0xA9974653, 0xCF3D46A1, 0xD2DE86B3, 0xB4748641,
    0xBA378A30, 0xDC9D8AC2, 0xC17E4AD0, 0xA7D44A22,
    0xFBB8CBF5, 0x9D12CB07, 0x80F10B15, 0xE65B0BE7,
    0x8F34C8BE, 0xE99EC84C, 0xF47D085E, 0x92D708AC,
    0xCEBB897B, 0xA8118989, 0xB5F2499B, 0xD3584969,
    0x672CCF28, 0x0186CFDA, 0x1C650FC8, 0x7ACF0F3A,
    0x26A38EED, 0x40098E1F, 0x5DEA4E0D, 0x3B404EFF,
    0x522F8DA6, 0x34858D54, 0x29664D46, 0x4FCC4DB4,
    0x13A0CC63, 0x750ACC91, 0x68E90C83, 0x0E430C71,
    0x746F1461, 0x12C51493, 0x0F26D481, 0x698CD473,
    0x35E055A4, 0x534A5556, 0x4EA99544, 0x280395B6,
    0x416C56EF, 0x27C6561D, 0x3A25960F, 0x5C8F96FD,
    0x00E3172A, 0x664917D8, 0x7BAAD7CA, 0x1D00D738,
    0xA9745179, 0xCFDE518B, 0xD23D9199, 0xB497916B,
    0xE8FB10BC, 0x8E51104E, 0x93B2D05C, 0xF518D0AE,
    0x9C7713F7, 0xFADD1305, 0xE73ED317, 0x8194D3E5,
    0xDDF85232, 0xBB5252C0, 0xA6B192D2, 0xC01B9220,
    0xCE589E51, 0xA8F29EA3, 0xB5115EB1, 0xD3BB5E43,
    0x8FD7DF94, 0xE97DDF66, 0xF49E1F74, 0x92341F86,
    0xFB5BDCDF, 0x9DF1DC2D, 0x80121C3F, 0xE6B81CCD,
    0xBAD49D1A, 0xDC7E9DE8, 0xC19D5DFA, 0xA7375D08,
    0x1343DB49, 0x75E9DBBB, 0x680A1BA9, 0x0EA01B5B,
    0x52CC9A8C, 0x34669A7E, 0x29855A6C, 0x4F2F5A9E,
    0x264099C7, 0x40EA9935, 0x5D095927, 0x3BA359D5,
    0x67CFD802, 0x0165D8F0, 0x1C8618E2, 0x7A2C1810,
    0xE8DE28C2, 0x8E742830, 0x9397E822, 0xF53DE8D0,
    0xA9516907, 0xCFFB69F5, 0xD218A9E7, 0xB4B2A915,
    0xDDDD6A4C, 0xBB776ABE, 0xA694AAAC, 0xC03EAA5E,
    0x9C522B89, 0xFAF82B7B, 0xE71BEB69, 0x81B1EB9B,
    0x35C56DDA, 0x536F6D28, 0x4E8CAD3A, 0x2826ADC8,
    0x744A2C1F, 0x12E02CED, 0x0F03ECFF, 0x69A9EC0D,
    0x00C62F54, 0x666C2FA6, 0x7B8FEFB4, 0x1D25EF46,
    0x41496E91, 0x27E36E63, 0x3A00AE71, 0x5CAAAE83,
    0x52E9A2F2, 0x3443A200, 0x29A06212, 0x4F0A62E0,
    0x1366E337, 0x75CCE3C5, 0x682F23D7, 0x0E852325,
    0x67EAE07C, 0x0140E08E, 0x1CA3209C, 0x7A09206E,
    0x2665A1B9, 0x40CFA14B, 0x5D2C6159, 0x3B8661AB,
    0x8FF2E7EA, 0xE958E718, 0xF4BB270A, 0x921127F8,
    0xCE7DA62F, 0xA8D7A6DD, 0xB53466CF, 0xD39E663D,
    0xBAF1A564, 0xDC5BA596, 0xC1B86584, 0xA7126576,
    0xFB7EE4A1, 0x9DD4E453, 0x80372441, 0xE69D24B3,
    0x9CB13CA3, 0xFA1B3C51, 0xE7F8FC43, 0x8152FCB1,
    0xDD3E7D66, 0xBB947D94, 0xA677BD86, 0xC0DDBD74,
    0xA9B27E2D, 0xCF187EDF, 0xD2FBBECD, 0xB451BE3F,
    0xE83D3FE8, 0x8E973F1A, 0x9374FF08, 0xF5DEFFFA,
    0x41AA79BB, 0x27007949, 0x3AE3B95B, 0x5C49B9A9,
    0x0025387E, 0x668F388C, 0x7B6CF89E, 0x1DC6F86C,
    0x74A93B35, 0x12033BC7, 0x0FE0FBD5, 0x694AFB27,
    0x35267AF0, 0x538C7A02, 0x4E6FBA10, 0x28C5BAE2,
    0x2686B693, 0x402CB661, 0x5DCF7673, 0x3B657681,
    0x6709F756, 0x01A3F7A4, 0x1C4037B6, 0x7AEA3744,
    0x1385F41D, 0x752FF4EF, 0x68CC34FD, 0x0E66340F,
    0x520AB5D8, 0x34A0B52A, 0x29437538, 0x4FE975CA,
    0xFB9DF38B, 0x9D37F379, 0x80D4336B, 0xE67E3399,
    0xBA12B24E, 0xDCB8B2BC, 0xC15B72AE, 0xA7F1725C,
    0xCE9EB105, 0xA834B1F7, 0xB5D771E5, 0xD37D7117,
    0x8F11F0C0, 0xE9BBF032, 0xF4583020, 0x92F230D2,

    0x00000000, 0x67A09080, 0x795DE005, 0x1EFD7085,
    0xF2BAC00B, 0x951A508B, 0x8BE7200E, 0xEC47B08E,
    0xE4758117, 0x83D51197, 0x9D286112, 0xFA88F192,
    0x16CF411C, 0x716FD19C, 0x6F92A119, 0x08323199,
    0xC8EB022F, 0xAF4B92AF, 0xB1B6E22A, 0xD61672AA,
    0x3A51C224, 0x5DF152A4, 0x430C2221, 0x24ACB2A1,
    0x2C9E8338, 0x4B3E13B8, 0x55C3633D, 0x3263F3BD,
    0xDE244333, 0xB984D3B3, 0xA779A336, 0xC0D933B6,
    0x90D7055E, 0xF77795DE, 0xE98AE55B, 0x8E2A75DB,
    0x626DC555, 0x05CD55D5, 0x1B302550, 0x7C90B5D0,
    0x74A28449, 0x130214C9, 0x0DFF644C, 0x6A5FF4CC,
    0x86184442, 0xE1B8D4C2, 0xFF45A447, 0x98E534C7,
    0x583C0771, 0x3F9C97F1, 0x2161E774, 0x46C177F4,
    0xAA86C77A, 0xCD2657FA, 0xD3DB277F, 0xB47BB7FF,
    0xBC498666, 0xDBE916E6, 0xC5146663, 0xA2B4F6E3,
    0x4EF3466D, 0x2953D6ED, 0x37AEA668, 0x500E36E8,
    0x20AF0BBC, 0x470F9B3C, 0x59F2EBB9, 0x3E527B39,
    0xD215CBB7, 0xB5B55B37, 0xAB482BB2, 0xCCE8BB32,
    0xC4DA8AAB, 0xA37A1A2B, 0xBD876AAE, 0xDA27FA2E,
    0x36604AA0, 0x51C0DA20, 0x4F3DAAA5, 0x289D3A25,
    0xE8440993, 0x8FE49913, 0x9119E996, 0xF6B97916,
    0x1AFEC998, 0x7D5E5918, 0x63A3299D, 0x0403B91D,
    0x0C318884, 0x6B911804, 0x756C6881, 0x12CCF801,
    0xFE8B488F, 0x992BD80F, 0x87D6A88A, 0xE076380A,
    0xB0780EE2, 0xD7D89E62, 0xC925EEE7, 0xAE857E67,
    0x42C2CEE9, 0x25625E69, 0x3B9F2EEC, 0x5C3FBE6C,
    0x540D8FF5, 0x33AD1F75, 0x2D506FF0, 0x4AF0FF70,
    0xA6B74FFE, 0xC117DF7E, 0xDFEAAFFB, 0xB84A3F7B,
    0x78930CCD, 0x1F339C4D, 0x01CEECC8, 0x666E7C48,
    0x8A29CCC6, 0xED895C46, 0xF3742CC3, 0x94D4BC43,
    0x9CE68DDA, 0xFB461D5A, 0xE5BB6DDF, 0x821BFD5F,
    0x6E5C4DD1, 0x09FCDD51, 0x1701ADD4, 0x70A13D54,
    0xF743D67C, 0x90E346FC, 0x8E1E3679, 0xE9BEA6F9,
    0x05F91677, 0x625986F7, 0x7CA4F672, 0x1B0466F2,
    0x1336576B, 0x7496C7EB, 0x6A6BB76E, 0x0DCB27EE,
    0xE18C9760, 0x862C07E0, 0x98D17765, 0xFF71E7E5,
    0x3FA8D453, 0x580844D3, 0x46F53456, 0x2155A4D6,
    0xCD121458, 0xAAB284D8, 0xB44FF45D, 0xD3EF64DD,
    0xDBDD5544, 0xBC7DC5C4, 0xA280B541, 0xC52025C1,
    0x2967954F, 0x4EC705CF, 0x503A754A, 0x379AE5CA,
    0x6794D322, 0x003443A2, 0x1EC93327, 0x7969A3A7,
    0x952E1329, 0xF28E83A9, 0xEC73F32C, 0x8BD363AC,
    0x83E15235, 0xE441C2B5, 0xFABCB230, 0x9D1C22B0,
    0x715B923E, 0x16FB02BE, 0x0806723B, 0x6FA6E2BB,
    0xAF7FD10D, 0xC8DF418D, 0xD6223108, 0xB182A188,
    0x5DC51106, 0x3A658186, 0x2498F103, 0x43386183,
    0x4B0A501A, 0x2CAAC09A, 0x3257B01F, 0x55F7209F,
    0xB9B09011, 0xDE100091, 0xC0ED7014, 0xA74DE094,
    0xD7ECDDC0, 0xB04C4D40, 0xAEB13DC5, 0xC911AD45,
    0x25561DCB, 0x42F68D4B, 0x5C0BFDCE, 0x3BAB6D4E,
    0x33995CD7, 0x5439CC57, 0x4AC4BCD2, 0x2D642C52,
    0xC1239CDC, 0xA6830C5C, 0xB87E7CD9, 0xDFDEEC59,
    0x1F07DFEF, 0x78A74F6F, 0x665A3FEA, 0x01FAAF6A,
    0xEDBD1FE4, 0x8A1D8F64, 0x94E0FFE1, 0xF3406F61,
    0xFB725EF8, 0x9CD2CE78, 0x822FBEFD, 0xE58F2E7D,
    0x09C89EF3, 0x6E680E73, 0x70957EF6, 0x1735EE76,
    0x473BD89E, 0x209B481E, 0x3E66389B, 0x59C6A81B,
    0xB5811895, 0xD2218815, 0xCCDCF890, 0xAB7C6810,
    0xA34E5989, 0xC4EEC909, 0xDA13B98C, 0xBDB3290C,
    0x51F49982, 0x36540902, 0x28A97987, 0x4F09E907,
    0x8FD0DAB1, 0xE8704A31, 0xF68D3AB4, 0x912DAA34,
    0x7D6A1ABA, 0x1ACA8A3A, 0x0437FABF, 0x63976A3F,
    0x6BA55BA6, 0x0C05CB26, 0x12F8BBA3, 0x75582B23,
    0x991F9BAD, 0xFEBF0B2D, 0xE0427BA8, 0x87E2EB28,

    0x00000000, 0xEE87ACF9, 0x6B1298F7, 0x8595340E,
    0x6139F1EB, 0x8FBE5D12, 0x0A2B691C, 0xE4ACC5E5,
    0x756F23D3, 0x9BE88F2A, 0x1E7DBB24, 0xF0FA17DD,
    0x1456D238, 0xFAD17EC1, 0x7F444ACF, 0x91C3E636,
    0x5DC387A2, 0xB3442B5B, 0x36D11F55, 0xD856B3AC,
    0x3CFA7649, 0xD27DDAB0, 0x57E8EEBE, 0xB96F4247,
    0x28ACA471, 0xC62B0888, 0x43BE3C86, 0xAD39907F,
    0x4995559A, 0xA712F963, 0x2287CD6D, 0xCC006194,
    0x0D9BCE41, 0xE31C62B8, 0x668956B6, 0x880EFA4F,
    0x6CA23FAA, 0x82259353, 0x07B0A75D, 0xE9370BA4,
    0x78F4ED92, 0x9673416B, 0x13E67565, 0xFD61D99C,
    0x19CD1C79, 0xF74AB080, 0x72DF848E, 0x9C582877,
    0x505849E3, 0xBEDFE51A, 0x3B4AD114, 0xD5CD7DED,
    0x3161B808, 0xDFE614F1, 0x5A7320FF, 0xB4F48C06,
    0x25376A30, 0xCBB0C6C9, 0x4E25F2C7, 0xA0A25E3E,
    0x440E9BDB, 0xAA893722, 0x2F1C032C, 0xC19BAFD5,
    0x1A369D83, 0xF4B1317A, 0x71240574, 0x9FA3A98D,
    0x7B0F6C68, 0x9588C091, 0x101DF49F, 0xFE9A5866,
    0x6F59BE50, 0x81DE12A9, 0x044B26A7, 0xEACC8A5E,
    0x0E604FBB, 0xE0E7E342, 0x6572D74C, 0x8BF57BB5,
    0x47F51A21, 0xA972B6D8, 0x2CE782D6, 0xC2602E2F,
    0x26CCEBCA, 0xC84B4733, 0x4DDE733D, 0xA359DFC4,
    0x329A39F2, 0xDC1D950B, 0x5988A105, 0xB70F0DFC,
    0x53A3C819, 0xBD2464E0, 0x38B150EE, 0xD636FC17,
    0x17AD53C2, 0xF92AFF3B, 0x7CBFCB35, 0x923867CC,
    0x7694A229, 0x98130ED0, 0x1D863ADE, 0xF3019627,
    0x62C27011, 0x8C45DCE8, 0x09D0E8E6, 0xE757441F,
    0x03FB81FA, 0xED7C2D03, 0x68E9190D, 0x866EB5F4,
    0x4A6ED460, 0xA4E97899, 0x217C4C97, 0xCFFBE06E,
    0x2B57258B, 0xC5D08972, 0x4045BD7C, 0xAEC21185,
    0x3F01F7B3, 0xD1865B4A, 0x54136F44, 0xBA94C3BD,
    0x5E380658, 0xB0BFAAA1, 0x352A9EAF, 0xDBAD3256,
    0x8371FB03, 0x6DF657FA, 0xE86363F4, 0x06E4CF0D,
    0xE2480AE8, 0x0CCFA611, 0x895A921F, 0x67DD3EE6,
    0xF61ED8D0, 0x18997429, 0x9D0C4027, 0x738BECDE,
    0x9727293B, 0x79A085C2, 0xFC35B1CC, 0x12B21D35,
    0xDEB27CA1, 0x3035D058, 0xB5A0E456, 0x5B2748AF,
    0xBF8B8D4A, 0x510C21B3, 0xD49915BD, 0x3A1EB944,
    0xABDD5F72, 0x455AF38B, 0xC0CFC785, 0x2E486B7C,
    0xCAE4AE99, 0x24630260, 0xA1F6366E, 0x4F719A97,
    0x8EEA3542, 0x606D99BB, 0xE5F8ADB5, 0x0B7F014C,
    0xEFD3C4A9, 0x01546850, 0x84C15C5E, 0x6A46F0A7,
    0xFB851691, 0x1502BA68, 0x90978E66, 0x7E10229F,
    0x9ABCE77A, 0x743B4B83, 0xF1AE7F8D, 0x1F29D374,
    0xD329B2E0, 0x3DAE1E19, 0xB83B2A17, 0x56BC86EE,
    0xB210430B, 0x5C97EFF2, 0xD902DBFC, 0x37857705,
    0xA6469133, 0x48C13DCA, 0xCD5409C4, 0x23D3A53D,
    0xC77F60D8, 0x29F8CC21, 0xAC6DF82F, 0x42EA54D6,
    0x99476680, 0x77C0CA79, 0xF255FE77, 0x1CD2528E,
    0xF87E976B, 0x16F93B92, 0x936C0F9C, 0x7DEBA365,
    0xEC284553, 0x02AFE9AA, 0x873ADDA4, 0x69BD715D,
    0x8D11B4B8, 0x63961841, 0xE6032C4F, 0x088480B6,
    0xC484E122, 0x2A034DDB, 0xAF9679D5, 0x4111D52C,
    0xA5BD10C9, 0x4B3ABC30, 0xCEAF883E, 0x202824C7,
    0xB1EBC2F1, 0x5F6C6E08, 0xDAF95A06, 0x347EF6FF,
    0xD0D2331A, 0x3E559FE3, 0xBBC0ABED, 0x55470714,
    0x94DCA8C1, 0x7A5B0438, 0xFFCE3036, 0x11499CCF,
    0xF5E5592A, 0x1B62F5D3, 0x9EF7C1DD, 0x70706D24,
    0xE1B38B12, 0x0F3427EB, 0x8AA113E5, 0x6426BF1C,
    0x808A7AF9, 0x6E0DD600, 0xEB98E20E, 0x051F4EF7,
    0xC91F2F63, 0x2798839A, 0xA20DB794, 0x4C8A1B6D,
    0xA826DE88, 0x46A17271, 0xC334467F, 0x2DB3EA86,
    0xBC700CB0, 0x52F7A049, 0xD7629447, 0x39E538BE,
    0xDD49FD5B, 0x33CE51A2, 0xB65B65AC, 0x58DCC955,

    0x00000000, 0x06E3F607, 0x0CC6ED0F, 0x0A251B08,
    0x188CDB1F, 0x1E6F2D18, 0x144A3610, 0x12A9C017,
    0x3018B73F, 0x36FB4138, 0x3CDE5A30, 0x3A3DAC37,
    0x28946C20, 0x2E779A27, 0x2452812F, 0x22B17728,
    0x60306E7F, 0x66D39878, 0x6CF68370, 0x6A157577,
    0x78BCB560, 0x7E5F4367, 0x747A586F, 0x7299AE68,
    0x5028D940, 0x56CB2F47, 0x5CEE344F, 0x5A0DC248,
    0x48A4025F, 0x4E47F458, 0x4462EF50, 0x42811957,
    0xC060DCFE, 0xC6832AF9, 0xCCA631F1, 0xCA45C7F6,
    0xD8EC07E1, 0xDE0FF1E6, 0xD42AEAEE, 0xD2C91CE9,
    0xF0786BC1, 0xF69B9DC6, 0xFCBE86CE, 0xFA5D70C9,
    0xE8F4B0DE, 0xEE1746D9, 0xE4325DD1, 0xE2D1ABD6,
    0xA050B281, 0xA6B34486, 0xAC965F8E, 0xAA75A989,
    0xB8DC699E, 0xBE3F9F99, 0xB41A8491, 0xB2F97296,
    0x904805BE, 0x96ABF3B9, 0x9C8EE8B1, 0x9A6D1EB6,
    0x88C4DEA1, 0x8E2728A6, 0x840233AE, 0x82E1C5A9,
    0x37DC79F9, 0x313F8FFE, 0x3B1A94F6, 0x3DF962F1,
    0x2F50A2E6, 0x29B354E1, 0x23964FE9, 0x2575B9EE,
    0x07C4CEC6, 0x012738C1, 0x0B0223C9, 0x0DE1D5CE,
    0x1F4815D9, 0x19ABE3DE, 0x138EF8D6, 0x156D0ED1,
    0x57EC1786, 0x510FE181, 0x5B2AFA89, 0x5DC90C8E,
    0x4F60CC99, 0x49833A9E, 0x43A62196, 0x4545D791,
    0x67F4A0B9, 0x611756BE, 0x6B324DB6, 0x6DD1BBB1,
    0x7F787BA6, 0x799B8DA1, 0x73BE96A9, 0x755D60AE,
    0xF7BCA507, 0xF15F5300, 0xFB7A4808, 0xFD99BE0F,
    0xEF307E18, 0xE9D3881F, 0xE3F69317, 0xE5156510,
    0xC7A41238, 0xC147E43F, 0xCB62FF37, 0xCD810930,
    0xDF28C927, 0xD9CB3F20, 0xD3EE2428, 0xD50DD22F,
    0x978CCB78, 0x916F3D7F, 0x9B4A2677, 0x9DA9D070,
    0x8F001067, 0x89E3E660, 0x83C6FD68, 0x85250B6F,
    0xA7947C47, 0xA1778A40, 0xAB529148, 0xADB1674F,
    0xBF18A758, 0xB9FB515F, 0xB3DE4A57, 0xB53DBC50,
    0xD9A532F6, 0xDF46C4F1, 0xD563DFF9, 0xD38029FE,
    0xC129E9E9, 0xC7CA1FEE, 0xCDEF04E6, 0xCB0CF2E1,
    0xE9BD85C9, 0xEF5E73CE, 0xE57B68C6, 0xE3989EC1,
    0xF1315ED6, 0xF7D2A8D1, 0xFDF7B3D9, 0xFB1445DE,
    0xB9955C89, 0xBF76AA8E, 0xB553B186, 0xB3B04781,
    0xA1198796, 0xA7FA7191, 0xADDF6A99, 0xAB3C9C9E,
    0x898DEBB6, 0x8F6E1DB1, 0x854B06B9, 0x83A8F0BE,
    0x910130A9, 0x97E2C6AE, 0x9DC7DDA6, 0x9B242BA1,
    0x19C5EE08, 0x1F26180F, 0x15030307, 0x13E0F500,
    0x01493517, 0x07AAC310, 0x0D8FD818, 0x0B6C2E1F,
    0x29DD5937, 0x2F3EAF30, 0x251BB438, 0x23F8423F,
    0x31518228, 0x37B2742F, 0x3D976F27, 0x3B749920,
    0x79F58077, 0x7F167670, 0x75336D78, 0x73D09B7F,
    0x61795B68, 0x679AAD6F, 0x6DBFB667, 0x6B5C4060,
    0x49ED3748, 0x4F0EC14F, 0x452BDA47, 0x43C82C40,
    0x5161EC57, 0x57821A50, 0x5DA70158, 0x5B44F75F,
    0xEE794B0F, 0xE89ABD08, 0xE2BFA600, 0xE45C5007,
    0xF6F59010, 0xF0166617, 0xFA337D1F, 0xFCD08B18,
    0xDE61FC30, 0xD8820A37, 0xD2A7113F, 0xD444E738,
    0xC6ED272F, 0xC00ED128, 0xCA2BCA20, 0xCCC83C27,
    0x8E492570, 0x88AAD377, 0x828FC87F, 0x846C3E78,
    0x96C5FE6F, 0x90260868, 0x9A031360, 0x9CE0E567,
    0xBE51924F, 0xB8B26448, 0xB2977F40, 0xB4748947,
    0xA6DD4950, 0xA03EBF57, 0xAA1BA45F, 0xACF85258,
    0x2E1997F1, 0x28FA61F6, 0x22DF7AFE, 0x243C8CF9,
    0x36954CEE, 0x3076BAE9, 0x3A53A1E1, 0x3CB057E6,
    0x1E0120CE, 0x18E2D6C9, 0x12C7CDC1, 0x14243BC6,
    0x068DFBD1, 0x006E0DD6, 0x0A4B16DE, 0x0CA8E0D9,
    0x4E29F98E, 0x48CA0F89, 0x42EF1481, 0x440CE286,
    0x56A52291, 0x5046D496, 0x5A63CF9E, 0x5C803999,
    0x7E314EB1, 0x78D2B8B6, 0x72F7A3BE, 0x741455B9,
    0x66BD95AE, 0x605E63A9, 0x6A7B78A1, 0x6C988EA6,

    0x00000000, 0x0556A4E8, 0xBDB189D5, 0xB8E72D3D,
    0xCD7ED2AF, 0xC8287647, 0x70CF5B7A, 0x7599FF92,
    0x2DE0655B, 0x28B6C1B3, 0x9051EC8E, 0x95074866,
    0xE09EB7F4, 0xE5C8131C, 0x5D2F3E21, 0x58799AC9,
    0x5AC0CBB6, 0x5F966F5E, 0xE7714263, 0xE227E68B,
    0x97BE1919, 0x92E8BDF1, 0x2A0F90CC, 0x2F593424,
    0x7720AEED, 0x72760A05, 0xCA912738, 0xCFC783D0,
    0xBA5E7C42, 0xBF08D8AA, 0x07EFF597, 0x02B9517F,
    0x039D5669, 0x06CBF281, 0xBE2CDFBC, 0xBB7A7B54,
    0xCEE384C6, 0xCBB5202E, 0x73520D13, 0x7604A9FB,
    0x2E7D3332, 0x2B2B97DA, 0x93CCBAE7, 0x969A1E0F,
    0xE303E19D, 0xE6554575, 0x5EB26848, 0x5BE4CCA0,
    0x595D9DDF, 0x5C0B3937, 0xE4EC140A, 0xE1BAB0E2,
    0x94234F70, 0x9175EB98, 0x2992C6A5, 0x2CC4624D,
    0x74BDF884, 0x71EB5C6C, 0xC90C7151, 0xCC5AD5B9,
    0xB9C32A2B, 0xBC958EC3, 0x0472A3FE, 0x01240716,
    0x063AADD2, 0x036C093A, 0xBB8B2407, 0xBEDD80EF,
    0xCB447F7D, 0xCE12DB95, 0x76F5F6A8, 0x73A35240,
    0x2BDAC889, 0x2E8C6C61, 0x966B415C, 0x933DE5B4,
    0xE6A41A26, 0xE3F2BECE, 0x5B1593F3, 0x5E43371B,
    0x5CFA6664, 0x59ACC28C, 0xE14BEFB1, 0xE41D4B59,
    0x9184B4CB, 0x94D21023, 0x2C353D1E, 0x296399F6,
    0x711A033F, 0x744CA7D7, 0xCCAB8AEA, 0xC9FD2E02,
    0xBC64D190, 0xB9327578, 0x01D55845, 0x0483FCAD,
    0x05A7FBBB, 0x00F15F53, 0xB816726E, 0xBD40D686,
    0xC8D92914, 0xCD8F8DFC, 0x7568A0C1, 0x703E0429,
    0x28479EE0, 0x2D113A08, 0x95F61735, 0x90A0B3DD,
    0xE5394C4F, 0xE06FE8A7, 0x5888C59A, 0x5DDE6172,
    0x5F67300D, 0x5A3194E5, 0xE2D6B9D8, 0xE7801D30,
    0x9219E2A2, 0x974F464A, 0x2FA86B77, 0x2AFECF9F,
    0x72875556, 0x77D1F1BE, 0xCF36DC83, 0xCA60786B,
    0xBFF987F9, 0xBAAF2311, 0x02480E2C, 0x071EAAC4,
    0xBB699BA1, 0xBE3F3F49, 0x06D81274, 0x038EB69C,
    0x7617490E, 0x7341EDE6, 0xCBA6C0DB, 0xCEF06433,
    0x9689FEFA, 0x93DF5A12, 0x2B38772F, 0x2E6ED3C7,
    0x5BF72C55, 0x5EA188BD, 0xE646A580, 0xE3100168,
    0xE1A95017, 0xE4FFF4FF, 0x5C18D9C2, 0x594E7D2A,
    0x2CD782B8, 0x29812650, 0x91660B6D, 0x9430AF85,
    0xCC49354C, 0xC91F91A4, 0x71F8BC99, 0x74AE1871,
    0x0137E7E3, 0x0461430B, 0xBC866E36, 0xB9D0CADE,
    0xB8F4CDC8, 0xBDA26920, 0x0545441D, 0x0013E0F5,
    0x758A1F67, 0x70DCBB8F, 0xC83B96B2, 0xCD6D325A,
    0x9514A893, 0x90420C7B, 0x28A52146, 0x2DF385AE,
    0x586A7A3C, 0x5D3CDED4, 0xE5DBF3E9, 0xE08D5701,
    0xE234067E, 0xE762A296, 0x5F858FAB, 0x5AD32B43,
    0x2F4AD4D1, 0x2A1C7039, 0x92FB5D04, 0x97ADF9EC,
    0xCFD46325, 0xCA82C7CD, 0x7265EAF0, 0x77334E18,
    0x02AAB18A, 0x07FC1562, 0xBF1B385F, 0xBA4D9CB7,
    0xBD533673, 0xB805929B, 0x00E2BFA6, 0x05B41B4E,
    0x702DE4DC, 0x757B4034, 0xCD9C6D09, 0xC8CAC9E1,
    0x90B35328, 0x95E5F7C0, 0x2D02DAFD, 0x28547E15,
    0x5DCD8187, 0x589B256F, 0xE07C0852, 0xE52AACBA,
    0xE793FDC5, 0xE2C5592D, 0x5A227410, 0x5F74D0F8,
    0x2AED2F6A, 0x2FBB8B82, 0x975CA6BF, 0x920A0257,
    0xCA73989E, 0xCF253C76, 0x77C2114B, 0x7294B5A3,
    0x070D4A31, 0x025BEED9, 0xBABCC3E4, 0xBFEA670C,
    0xBECE601A, 0xBB98C4F2, 0x037FE9CF, 0x06294D27,
    0x73B0B2B5, 0x76E6165D, 0xCE013B60, 0xCB579F88,
    0x932E0541, 0x9678A1A9, 0x2E9F8C94, 0x2BC9287C,
    0x5E50D7EE, 0x5B067306, 0xE3E15E3B, 0xE6B7FAD3,
    0xE40EABAC, 0xE1580F44, 0x59BF2279, 0x5CE98691,
    0x29707903, 0x2C26DDEB, 0x94C1F0D6, 0x9197543E,
    0xC9EECEF7, 0xCCB86A1F, 0x745F4722, 0x7109E3CA,
    0x04901C58, 0x01C6B8B0, 0xB921958D, 0xBC773165,

    0x00000000, 0xC1CEF747, 0x829DEF8F, 0x435318C8,
    0xB3261E1B, 0x72E8E95C, 0x31BBF194, 0xF07506D3,
    0x664D3C36, 0xA783CB71, 0xE4D0D3B9, 0x251E24FE,
    0xD56B222D, 0x14A5D56A, 0x57F6CDA2, 0x96383AE5,
    0xCC9A786C, 0x0D548F2B, 0x4E0797E3, 0x8FC960A4,
    0x7FBC6677, 0xBE729130, 0xFD2189F8, 0x3CEF7EBF,
    0xAAD7445A, 0x6B19B31D, 0x284AABD5, 0xE9845C92,
    0x19F15A41, 0xD83FAD06, 0x9B6CB5CE, 0x5AA24289,
    0x9835F1D8, 0x59FB069F, 0x1AA81E57, 0xDB66E910,
    0x2B13EFC3, 0xEADD1884, 0xA98E004C, 0x6840F70B,
    0xFE78CDEE, 0x3FB63AA9, 0x7CE52261, 0xBD2BD526,
    0x4D5ED3F5, 0x8C9024B2, 0xCFC33C7A, 0x0E0DCB3D,
    0x54AF89B4, 0x95617EF3, 0xD632663B, 0x17FC917C,
    0xE78997AF, 0x264760E8, 0x65147820, 0xA4DA8F67,
    0x32E2B582, 0xF32C42C5, 0xB07F5A0D, 0x71B1AD4A,
    0x81C4AB99, 0x400A5CDE, 0x03594416, 0xC297B351,
    0x877623B5, 0x46B8D4F2, 0x05EBCC3A, 0xC4253B7D,
    0x34503DAE, 0xF59ECAE9, 0xB6CDD221, 0x77032566,
    0xE13B1F83, 0x20F5E8C4, 0x63A6F00C, 0xA268074B,
    0x521D0198, 0x93D3F6DF, 0xD080EE17, 0x114E1950,
    0x4BEC5BD9, 0x8A22AC9E, 0xC971B456, 0x08BF4311,
    0xF8CA45C2, 0x3904B285, 0x7A57AA4D, 0xBB995D0A,
    0x2DA167EF, 0xEC6F90A8, 0xAF3C8860, 0x6EF27F27,
    0x9E8779F4, 0x5F498EB3, 0x1C1A967B, 0xDDD4613C,
    0x1F43D26D, 0xDE8D252A, 0x9DDE3DE2, 0x5C10CAA5,
    0xAC65CC76, 0x6DAB3B31, 0x2EF823F9, 0xEF36D4BE,
    0x790EEE5B, 0xB8C0191C, 0xFB9301D4, 0x3A5DF693,
    0xCA28F040, 0x0BE60707, 0x48B51FCF, 0x897BE888,
    0xD3D9AA01, 0x12175D46, 0x5144458E, 0x908AB2C9,
    0x60FFB41A, 0xA131435D, 0xE2625B95, 0x23ACACD2,
    0xB5949637, 0x745A6170, 0x370979B8, 0xF6C78EFF,
    0x06B2882C, 0xC77C7F6B, 0x842F67A3, 0x45E190E4,
    0xB9F0876E, 0x783E7029, 0x3B6D68E1, 0xFAA39FA6,
    0x0AD69975, 0xCB186E32, 0x884B76FA, 0x498581BD,
    0xDFBDBB58, 0x1E734C1F, 0x5D2054D7, 0x9CEEA390,
    0x6C9BA543, 0xAD555204, 0xEE064ACC, 0x2FC8BD8B,
    0x756AFF02, 0xB4A40845, 0xF7F7108D, 0x3639E7CA,
    0xC64CE119, 0x0782165E, 0x44D10E96, 0x851FF9D1,
    0x1327C334, 0xD2E93473, 0x91BA2CBB, 0x5074DBFC,
    0xA001DD2F, 0x61CF2A68, 0x229C32A0, 0xE352C5E7,
    0x21C576B6, 0xE00B81F1, 0xA3589939, 0x62966E7E,
    0x92E368AD, 0x532D9FEA, 0x107E8722, 0xD1B07065,
    0x47884A80, 0x8646BDC7, 0xC515A50F, 0x04DB5248,
    0xF4AE549B, 0x3560A3DC, 0x7633BB14, 0xB7FD4C53,
    0xED5F0EDA, 0x2C91F99D, 0x6FC2E155, 0xAE0C1612,
    0x5E7910C1, 0x9FB7E786, 0xDCE4FF4E, 0x1D2A0809,
    0x8B1232EC, 0x4ADCC5AB, 0x098FDD63, 0xC8412A24,
    0x38342CF7, 0xF9FADBB0, 0xBAA9C378, 0x7B67343F,
    0x3E86A4DB, 0xFF48539C, 0xBC1B4B54, 0x7DD5BC13,
    0x8DA0BAC0, 0x4C6E4D87, 0x0F3D554F, 0xCEF3A208,
    0x58CB98ED, 0x99056FAA, 0xDA567762, 0x1B988025,
    0xEBED86F6, 0x2A2371B1, 0x69706979, 0xA8BE9E3E,
    0xF21CDCB7, 0x33D22BF0, 0x70813338, 0xB14FC47F,
    0x413AC2AC, 0x80F435EB, 0xC3A72D23, 0x0269DA64,
    0x9451E081, 0x559F17C6, 0x16CC0F0E, 0xD702F849,
    0x2777FE9A, 0xE6B909DD, 0xA5EA1115, 0x6424E652,
    0xA6B35503, 0x677DA244, 0x242EBA8C, 0xE5E04DCB,
    0x15954B18, 0xD45BBC5F, 0x9708A497, 0x56C653D0,
    0xC0FE6935, 0x01309E72, 0x426386BA, 0x83AD71FD,
    0x73D8772E, 0xB2168069, 0xF14598A1, 0x308B6FE6,
    0x6A292D6F, 0xABE7DA28, 0xE8B4C2E0, 0x297A35A7,
    0xD90F3374, 0x18C1C433, 0x5B92DCFB, 0x9A5C2BBC,
    0x0C641159, 0xCDAAE61E, 0x8EF9FED6, 0x4F370991,
    0xBF420F42, 0x7E8CF805, 0x3DDFE0CD, 0xFC11178A,

    0x00000000, 0x72E10FDD, 0x53DFDEBE, 0x213ED163,
    0x11A37C79, 0x634273A4, 0x427CA2C7, 0x309DAD1A,
    0x2246F9F2, 0x50A7F62F, 0x7199274C, 0x03782891,
    0x33E5858B, 0x41048A56, 0x603A5B35, 0x12DB54E8,
    0xF39133E1, 0x81703C3C, 0xA04EED5F, 0xD2AFE282,
    0xE2324F98, 0x90D34045, 0xB1ED9126, 0xC30C9EFB,
    0xD1D7CA13, 0xA336C5CE, 0x820814AD, 0xF0E91B70,
    0xC074B66A, 0xB295B9B7, 0x93AB68D4, 0xE14A6709,
    0x513EA6C6, 0x23DFA91B, 0x02E17878, 0x700077A5,
    0x409DDABF, 0x327CD562, 0x13420401, 0x61A30BDC,
    0x73785F34, 0x019950E9, 0x20A7818A, 0x52468E57,
    0x62DB234D, 0x103A2C90, 0x3104FDF3, 0x43E5F22E,
    0xA2AF9527, 0xD04E9AFA, 0xF1704B99, 0x83914444,
    0xB30CE95E, 0xC1EDE683, 0xE0D337E0, 0x9232383D,
    0x80E96CD5, 0xF2086308, 0xD336B26B, 0xA1D7BDB6,
    0x914A10AC, 0xE3AB1F71, 0xC295CE12, 0xB074C1CF,
    0x15618D89, 0x67808254, 0x46BE5337, 0x345F5CEA,
    0x04C2F1F0, 0x7623FE2D, 0x571D2F4E, 0x25FC2093,
    0x3727747B, 0x45C67BA6, 0x64F8AAC5, 0x1619A518,
    0x26840802, 0x546507DF, 0x755BD6BC, 0x07BAD961,
    0xE6F0BE68, 0x9411B1B5, 0xB52F60D6, 0xC7CE6F0B,
    0xF753C211, 0x85B2CDCC, 0xA48C1CAF, 0xD66D1372,
    0xC4B6479A, 0xB6574847, 0x97699924, 0xE58896F9,
    0xD5153BE3, 0xA7F4343E, 0x86CAE55D, 0xF42BEA80,
    0x445F2B4F, 0x36BE2492, 0x1780F5F1, 0x6561FA2C,
    0x55FC5736, 0x271D58EB, 0x06238988, 0x74C28655,
    0x6619D2BD, 0x14F8DD60, 0x35C60C03, 0x472703DE,
    0x77BAAEC4, 0x055BA119, 0x2465707A, 0x56847FA7,
    0xB7CE18AE, 0xC52F1773, 0xE411C610, 0x96F0C9CD,
    0xA66D64D7, 0xD48C6B0A, 0xF5B2BA69, 0x8753B5B4,
    0x9588E15C, 0xE769EE81, 0xC6573FE2, 0xB4B6303F,
    0x842B9D25, 0xF6CA92F8, 0xD7F4439B, 0xA5154C46,
    0x9DDFDB17, 0xEF3ED4CA, 0xCE0005A9, 0xBCE10A74,
    0x8C7CA76E, 0xFE9DA8B3, 0xDFA379D0, 0xAD42760D,
    0xBF9922E5, 0xCD782D38, 0xEC46FC5B, 0x9EA7F386,
    0xAE3A5E9C, 0xDCDB5141, 0xFDE58022, 0x8F048FFF,
    0x6E4EE8F6, 0x1CAFE72B, 0x3D913648, 0x4F703995,
    0x7FED948F, 0x0D0C9B52, 0x2C324A31, 0x5ED345EC,
    0x4C081104, 0x3EE91ED9, 0x1FD7CFBA, 0x6D36C067,
    0x5DAB6D7D, 0x2F4A62A0, 0x0E74B3C3, 0x7C95BC1E,
    0xCCE17DD1, 0xBE00720C, 0x9F3EA36F, 0xEDDFACB2,
    0xDD4201A8, 0xAFA30E75, 0x8E9DDF16, 0xFC7CD0CB,
    0xEEA78423, 0x9C468BFE, 0xBD785A9D, 0xCF995540,
    0xFF04F85A, 0x8DE5F787, 0xACDB26E4, 0xDE3A2939,
    0x3F704E30, 0x4D9141ED, 0x6CAF908E, 0x1E4E9F53,
    0x2ED33249, 0x5C323D94, 0x7D0CECF7, 0x0FEDE32A,
    0x1D36B7C2, 0x6FD7B81F, 0x4EE9697C, 0x3C0866A1,
    0x0C95CBBB, 0x7E74C466, 0x5F4A1505, 0x2DAB1AD8,
    0x88BE569E, 0xFA5F5943, 0xDB618820, 0xA98087FD,
    0x991D2AE7, 0xEBFC253A, 0xCAC2F459, 0xB823FB84,
    0xAAF8AF6C, 0xD819A0B1, 0xF92771D2, 0x8BC67E0F,
    0xBB5BD315, 0xC9BADCC8, 0xE8840DAB, 0x9A650276,
    0x7B2F657F, 0x09CE6AA2, 0x28F0BBC1, 0x5A11B41C,
    0x6A8C1906, 0x186D16DB, 0x3953C7B8, 0x4BB2C865,
    0x59699C8D, 0x2B889350, 0x0AB64233, 0x78574DEE,
    0x48CAE0F4, 0x3A2BEF29, 0x1B153E4A, 0x69F43197,
    0xD980F058, 0xAB61FF85, 0x8A5F2EE6, 0xF8BE213B,
    0xC8238C21, 0xBAC283FC, 0x9BFC529F, 0xE91D5D42,
    0xFBC609AA, 0x89270677, 0xA819D714, 0xDAF8D8C9,
    0xEA6575D3, 0x98847A0E, 0xB9BAAB6D, 0xCB5BA4B0,
    0x2A11C3B9, 0x58F0CC64, 0x79CE1D07, 0x0B2F12DA,
    0x3BB2BFC0, 0x4953B01D, 0x686D617E, 0x1A8C6EA3,
    0x08573A4B, 0x7AB63596, 0x5B88E4F5, 0x2969EB28,
    0x19F44632, 0x6B1549EF, 0x4A2B988C, 0x38CA9751,

    0x00000000, 0x3ABFB72F, 0x747E6F5F, 0x4EC1D870,
    0xE8FCDEBE, 0xD2436991, 0x9C82B1E1, 0xA63D06CE,
    0x67E47C79, 0x5D5BCB56, 0x139A1326, 0x2925A409,
    0x8F18A2C7, 0xB5A715E8, 0xFB66CD98, 0xC1D97AB7,
    0xCEC8F9F2, 0xF4774EDD, 0xBAB696AD, 0x80092182,
    0x2634274C, 0x1C8B9063, 0x524A4813, 0x68F5FF3C,
    0xA92C858B, 0x939332A4, 0xDD52EAD4, 0xE7ED5DFB,
    0x41D05B35, 0x7B6FEC1A, 0x35AE346A, 0x0F118345,
    0x2B8C32E1, 0x113385CE, 0x5FF25DBE, 0x654DEA91,
    0xC370EC5F, 0xF9CF5B70, 0xB70E8300, 0x8DB1342F,
    0x4C684E98, 0x76D7F9B7, 0x381621C7, 0x02A996E8,
    0xA4949026, 0x9E2B2709, 0xD0EAFF79, 0xEA554856,
    0xE544CB13, 0xDFFB7C3C, 0x913AA44C, 0xAB851363,
    0x0DB815AD, 0x3707A282, 0x79C67AF2, 0x4379CDDD,
    0x82A0B76A, 0xB81F0045, 0xF6DED835, 0xCC616F1A,
    0x6A5C69D4, 0x50E3DEFB, 0x1E22068B, 0x249DB1A4,
    0xE105A4C6, 0xDBBA13E9, 0x957BCB99, 0xAFC47CB6,
    0x09F97A78, 0x3346CD57, 0x7D871527, 0x4738A208,
    0x86E1D8BF, 0xBC5E6F90, 0xF29FB7E0, 0xC82000CF,
    0x6E1D0601, 0x54A2B12E, 0x1A63695E, 0x20DCDE71,
    0x2FCD5D34, 0x1572EA1B, 0x5BB3326B, 0x610C8544,
    0xC731838A, 0xFD8E34A5, 0xB34FECD5, 0x89F05BFA,
    0x4829214D, 0x72969662, 0x3C574E12, 0x06E8F93D,
    0xA0D5FFF3, 0x9A6A48DC, 0xD4AB90AC, 0xEE142783,
    0xCA899627, 0xF0362108, 0xBEF7F978, 0x84484E57,
    0x22754899, 0x18CAFFB6, 0x560B27C6, 0x6CB490E9,
    0xAD6DEA5E, 0x97D25D71, 0xD9138501, 0xE3AC322E,
    0x459134E0, 0x7F2E83CF, 0x31EF5BBF, 0x0B50EC90,
    0x04416FD5, 0x3EFED8FA, 0x703F008A, 0x4A80B7A5,
    0xECBDB16B, 0xD6020644, 0x98C3DE34, 0xA27C691B,
    0x63A513AC, 0x591AA483, 0x17DB7CF3, 0x2D64CBDC,
    0x8B59CD12, 0xB1E67A3D, 0xFF27A24D, 0xC5981562,
    0x75168989, 0x4FA93EA6, 0x0168E6D6, 0x3BD751F9,
    0x9DEA5737, 0xA755E018, 0xE9943868, 0xD32B8F47,
    0x12F2F5F0, 0x284D42DF, 0x668C9AAF, 0x5C332D80,
    0xFA0E2B4E, 0xC0B19C61, 0x8E704411, 0xB4CFF33E,
    0xBBDE707B, 0x8161C754, 0xCFA01F24, 0xF51FA80B,
    0x5322AEC5, 0x699D19EA, 0x275CC19A, 0x1DE376B5,
    0xDC3A0C02, 0xE685BB2D, 0xA844635D, 0x92FBD472,
    0x34C6D2BC, 0x0E796593, 0x40B8BDE3, 0x7A070ACC,
    0x5E9ABB68, 0x64250C47, 0x2AE4D437, 0x105B6318,
    0xB66665D6, 0x8CD9D2F9, 0xC2180A89, 0xF8A7BDA6,
    0x397EC711, 0x03C1703E, 0x4D00A84E, 0x77BF1F61,
    0xD18219AF, 0xEB3DAE80, 0xA5FC76F0, 0x9F43C1DF,
    0x9052429A, 0xAAEDF5B5, 0xE42C2DC5, 0xDE939AEA,
    0x78AE9C24, 0x42112B0B, 0x0CD0F37B, 0x366F4454,
    0xF7B63EE3, 0xCD0989CC, 0x83C851BC, 0xB977E693,
    0x1F4AE05D, 0x25F55772, 0x6B348F02, 0x518B382D,
    0x94132D4F, 0xAEAC9A60, 0xE06D4210, 0xDAD2F53F,
    0x7CEFF3F1, 0x465044DE, 0x08919CAE, 0x322E2B81,
    0xF3F75136, 0xC948E619, 0x87893E69, 0xBD368946,
    0x1B0B8F88, 0x21B438A7, 0x6F75E0D7, 0x55CA57F8,
    0x5ADBD4BD, 0x60646392, 0x2EA5BBE2, 0x141A0CCD,
    0xB2270A03, 0x8898BD2C, 0xC659655C, 0xFCE6D273,
    0x3D3FA8C4, 0x07801FEB, 0x4941C79B, 0x73FE70B4,
    0xD5C3767A, 0xEF7CC155, 0xA1BD1925, 0x9B02AE0A,
    0xBF9F1FAE, 0x8520A881, 0xCBE170F1, 0xF15EC7DE,
    0x5763C110, 0x6DDC763F, 0x231DAE4F, 0x19A21960,
    0xD87B63D7, 0xE2C4D4F8, 0xAC050C88, 0x96BABBA7,
    0x3087BD69, 0x0A380A46, 0x44F9D236, 0x7E466519,
    0x7157E65C, 0x4BE85173, 0x05298903, 0x3F963E2C,
    0x99AB38E2, 0xA3148FCD, 0xEDD557BD, 0xD76AE092,
    0x16B39A25, 0x2C0C2D0A, 0x62CDF57A, 0x58724255,
    0xFE4F449B, 0xC4F0F3B4, 0x8A312BC4, 0xB08E9CEB,
};

#if 0
// Tables were created with:
// CRC32_Init(CRC32_Table, 0x04C11DB7);
#include <string>
#include <sstream>
#include <iomanip>
int ZenCRC32_Init(uint32_t *Table, uint32_t poly)
{
    for (size_t i = 0; i < 256; i++)
    {
        uint32_t c = i << 24;
        for (size_t j = 0; j < 8; j++)
        {
            bool PutPoly = (c >> 31);
            c <<= 1;
            if (PutPoly)
                c = c ^ poly;
        }
        Table[i] = ((c & 0xFF000000) >> 24) | ((c & 0x00FF0000) >> 8) | ((c & 0x0000FF00) << 8) | ((c & 0x000000FF) << 24); // Swap bytes
    }

    for (int j = 1; j < 16; j++)
        for (int i = 0; i < 256; i++)
            Table[j * 256 + i] = (Table[(j - 1) * 256 + i] >> 8) ^ Table[Table[(j - 1) * 256 + i] & 0xFF];

    stringstream A;
    for (int slice = 0; slice < 16; slice++)
    {
        for (int i = 0; i < 256; i++)
        {
            if ((i % 4) == 0)
                A << "\r\n    ";
            A << "0x" << hex << setfill('0') << setw(8) << Table[slice * 256 + i] << ", ";
        }
        A << "\r\n";
    }
    
    return 0;
}
#endif

uint32_t ZenCRC32(const uint8_t* Buffer, size_t Size)
{
    uint32_t C = 0; 
    const uint8_t *End = Buffer + Size;

    while (((intptr_t)Buffer & 15) && Buffer < End)
        C = (C >> 8) ^ CRC32_Table[((uint8_t)C) ^ *Buffer++] ;

    const uint64_t* Buffer16 = (uint64_t*)Buffer;
    const uint64_t* End16 = (uint64_t*)(((intptr_t)End)&((intptr_t)-1)-15);
    while (Buffer16 < End16)
    {
        uint64_t c0 = (*(const uint64_t *)Buffer16++) ^  C;
        uint64_t c1 = (*(const uint64_t *)Buffer16++);
        C = CRC32_Table[ 0 * 256 + ((uint8_t)(c1 >> 56))] ^
            CRC32_Table[ 1 * 256 + ((uint8_t)(c1 >> 48))] ^
            CRC32_Table[ 2 * 256 + ((uint8_t)(c1 >> 40))] ^
            CRC32_Table[ 3 * 256 + ((uint8_t)(c1 >> 32))] ^
            CRC32_Table[ 4 * 256 + ((uint8_t)(c1 >> 24))] ^
            CRC32_Table[ 5 * 256 + ((uint8_t)(c1 >> 16))] ^
            CRC32_Table[ 6 * 256 + ((uint8_t)(c1 >>  8))] ^
            CRC32_Table[ 7 * 256 + ((uint8_t) c1       )] ^
            CRC32_Table[ 8 * 256 + ((uint8_t)(c0 >> 56))] ^
            CRC32_Table[ 9 * 256 + ((uint8_t)(c0 >> 48))] ^
            CRC32_Table[10 * 256 + ((uint8_t)(c0 >> 40))] ^
            CRC32_Table[11 * 256 + ((uint8_t)(c0 >> 32))] ^
            CRC32_Table[12 * 256 + ((uint8_t)(c0 >> 24))] ^
            CRC32_Table[13 * 256 + ((uint8_t)(c0 >> 16))] ^
            CRC32_Table[14 * 256 + ((uint8_t)(c0 >>  8))] ^
            CRC32_Table[15 * 256 + ((uint8_t) c0       )];
    }
    Buffer = (const uint8_t*) Buffer16;

    while (Buffer < End)
        C = (C >> 8) ^ CRC32_Table[((uint8_t)C) ^ *Buffer++];

    return C;
}

