# Reading a QCTools Document

The QCTools Document is designed to be a self-descriptive metadata document that stores analytical metadata about video and audio frames and may be quickly rendered in QCTools version 0.5 or later. The QCTools Document is an XML expression of FFprobe's XML expression as defined by the ffprobe schema at [http://www.ffmpeg.org/schema/ffprobe.xsd](http://www.ffmpeg.org/schema/ffprobe.xsd). For more information about FFprobe's XML expression please visit: [http://www.ffmpeg.org/schema/ffprobe.xsd](http://ffmpeg.org/ffprobe.html#xml); for additional information about FFprobe's XML expression: [http://ffmpeg.org/ffprobe.html#xml](http://ffmpeg.org/ffprobe.html#xml).

In addition to frame metadata, the QCTools Document stores metadata values from the selected audio and video filters, such as signalstats, cropdetect, psnr, ssim, and ebur128. Starting in QCTools version 0.8 the QCTools document will also contain metadata about libraries of FFmpeg used as well as metadata about the streams and format of the analyzed video.

# Creating a QCTools Document

A QCTools Document can be created in any of the following ways:

1.  Via QCTools (version 0.5 or later)

    Open a video file for evaluation and then select "Export > To qctools.xml.gz".  

2.  Via QCTools' command line interface, known as "qcli", a report can be generated by a command such as "qcli -i FILE.mkv". See "qcli -h" for more information.

    Note that this `qcli` method is recommended over using FFmpeg's ffprobe directly (method 3). `qcli` will output stream and format metadata about the source file, whereas the below method would report such metadata about the demuxed/decoded file due to usage of the `movie` filter.  

3.  Via FFmpeg (version 2.3 or later)  

    For a file with video and audio named EXAMPLE.mov  
    ```
    ffprobe -f lavfi -i "movie=EXAMPLE.mov:s=v+a[in0][in1],[in0]signalstats=stat=tout+vrep+brng,cropdetect=reset=1:round=1,idet=half_life=1,deflicker=bypass=1,split[a][b];[a]field=top[a1];[b]field=bottom,split[b1][b2];[a1][b1]psnr[c1];[c1][b2]ssim[out0];[in1]ebur128=metadata=1,aformat=sample_fmts=flt|fltp,astats=metadata=1:reset=1:length=0.4[out1]" -show_frames -show_versions -of xml=x=1:q=1 -noprivate | gzip > EXAMPLE.mov.qctools.xml.gz  
    ```
 
    For a file with video and no audio named EXAMPLE.mov  
    ```
    ffprobe -f lavfi -i "movie=EXAMPLE.mov,signalstats=stat=tout+vrep+brng,cropdetect=reset=1:round=1,idet=half_life=1,deflicker=bypass=1,split[a][b];[a]field=top[a1];[b]field=bottom,split[b1][b2];[a1][b1]psnr[c1];[c1][b2]ssim" -show_frames -show_versions -of xml=x=1:q=1 -noprivate | gzip > EXAMPLE.mov.qctools.xml.gz
    ```

# About gzip Compression

Because of the large volume of data contained in a QCTools document, it is necessary to compress the XML file to ensure it is a manageable size. QCTools uses a compression software called gzip to do this ([en.wikipedia.org/wiki/Gzip](http://en.wikipedia.org/wiki/Gzip)) which accounts for the .gz file extension. Some text editing applications, such as [TextMate](https://github.com/textmate/textmate) can natively read g-zipping XML files. Also note that gzcat may be used to pipe the uncompressed output of the QCTools Document into other XML handling utilities, ex: "gzcat VIDEOTAPECAPTURE.qctools.xml.gz | xml sel -t -v "count(//tag[@key='lavfi.signalstats.SATMAX'][@value>496])" (which would report on the number of frames with a SATMAX value over 496).

# Additional Resources

For further information about FFmpeg, EBU audio specifications, etc., please see:  
**FFmpeg /** [ffmpeg.org](https://ffmpeg.org)  
**FFmpeg Documentation /** [http://ffmpeg.org/documentation.html](http://ffmpeg.org/documentation.html)  
**FFprobe XML Schema /** [https://github.com/FFmpeg/FFmpeg/blob/master/doc/ffprobe.xsd](https://github.com/FFmpeg/FFmpeg/blob/master/doc/ffprobe.xsd)
**GZIP /** [www.gzip.org](http://www.gzip.org/)  
