// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Tntregistry.pas' rev: 10.00

#ifndef TntregistryHPP
#define TntregistryHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Tntclasses.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Tntregistry
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TTntRegistry;
class PASCALIMPLEMENTATION TTntRegistry : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Registry::TRegistry* FAnsiRegistry;
	HKEY FCurrentKey;
	HKEY FRootKey;
	bool FLazyWrite;
	WideString FCurrentPath;
	bool FCloseRootKey;
	unsigned FAccess;
	void __fastcall SetRootKey(HKEY Value);
	
protected:
	void __fastcall ChangeKey(HKEY Value, const WideString Path);
	HKEY __fastcall GetBaseKey(bool Relative);
	int __fastcall GetData(const WideString Name, void * Buffer, int BufSize, Registry::TRegDataType &RegData);
	HKEY __fastcall GetKey(const WideString Key);
	void __fastcall PutData(const WideString Name, void * Buffer, int BufSize, Registry::TRegDataType RegData);
	void __fastcall SetCurrentKey(HKEY Value);
	
public:
	__fastcall TTntRegistry(void)/* overload */;
	__fastcall TTntRegistry(unsigned AAccess)/* overload */;
	__fastcall virtual ~TTntRegistry(void);
	void __fastcall CloseKey(void);
	bool __fastcall CreateKey(const WideString Key);
	bool __fastcall DeleteKey(const WideString Key);
	bool __fastcall DeleteValue(const WideString Name);
	bool __fastcall GetDataInfo(const WideString ValueName, Registry::TRegDataInfo &Value);
	int __fastcall GetDataSize(const WideString ValueName);
	Registry::TRegDataType __fastcall GetDataType(const WideString ValueName);
	bool __fastcall GetKeyInfo(Registry::TRegKeyInfo &Value);
	void __fastcall GetKeyNames(Tntclasses::TTntStrings* Strings);
	void __fastcall GetValueNames(Tntclasses::TTntStrings* Strings);
	bool __fastcall HasSubKeys(void);
	bool __fastcall KeyExists(const WideString Key);
	bool __fastcall LoadKey(const WideString Key, const WideString FileName);
	void __fastcall MoveKey(const WideString OldName, const WideString NewName, bool Delete);
	bool __fastcall OpenKey(const WideString Key, bool CanCreate);
	bool __fastcall OpenKeyReadOnly(const WideString Key);
	System::Currency __fastcall ReadCurrency(const WideString Name);
	int __fastcall ReadBinaryData(const WideString Name, void *Buffer, int BufSize);
	bool __fastcall ReadBool(const WideString Name);
	System::TDateTime __fastcall ReadDate(const WideString Name);
	System::TDateTime __fastcall ReadDateTime(const WideString Name);
	double __fastcall ReadFloat(const WideString Name);
	int __fastcall ReadInteger(const WideString Name);
	WideString __fastcall ReadString(const WideString Name);
	System::TDateTime __fastcall ReadTime(const WideString Name);
	bool __fastcall RegistryConnect(const WideString UNCName);
	void __fastcall RenameValue(const WideString OldName, const WideString NewName);
	bool __fastcall ReplaceKey(const WideString Key, const WideString FileName, const WideString BackUpFileName);
	bool __fastcall RestoreKey(const WideString Key, const WideString FileName);
	bool __fastcall SaveKey(const WideString Key, const WideString FileName);
	bool __fastcall UnLoadKey(const WideString Key);
	bool __fastcall ValueExists(const WideString Name);
	void __fastcall WriteCurrency(const WideString Name, System::Currency Value);
	void __fastcall WriteBinaryData(const WideString Name, void *Buffer, int BufSize);
	void __fastcall WriteBool(const WideString Name, bool Value);
	void __fastcall WriteDate(const WideString Name, System::TDateTime Value);
	void __fastcall WriteDateTime(const WideString Name, System::TDateTime Value);
	void __fastcall WriteFloat(const WideString Name, double Value);
	void __fastcall WriteInteger(const WideString Name, int Value);
	void __fastcall WriteString(const WideString Name, const WideString Value);
	void __fastcall WriteExpandString(const WideString Name, const WideString Value);
	void __fastcall WriteTime(const WideString Name, System::TDateTime Value);
	
private:
	HKEY __fastcall GetCurrentKey(void);
	WideString __fastcall GetCurrentPath();
	bool __fastcall GetLazyWrite(void);
	void __fastcall SetLazyWrite(bool Value);
	HKEY __fastcall GetRootKey(void);
	unsigned __fastcall GetAccess(void);
	void __fastcall SetAccess(unsigned Value);
	
public:
	__property HKEY CurrentKey = {read=GetCurrentKey, nodefault};
	__property WideString CurrentPath = {read=GetCurrentPath};
	__property bool LazyWrite = {read=GetLazyWrite, write=SetLazyWrite, nodefault};
	__property HKEY RootKey = {read=GetRootKey, write=SetRootKey, nodefault};
	__property unsigned Access = {read=GetAccess, write=SetAccess, nodefault};
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Tntregistry */
using namespace Tntregistry;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Tntregistry
