// File_Mpeg - Info for MPEG files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about MPEG files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#ifndef MediaInfo_MpegH
#define MediaInfo_MpegH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/File__Base.h"
#include "ZenLib/BitStream.h"
#include <ZenLib/Conf.h>
#include <vector>
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//---------------------------------------------------------------------------
typedef struct
{
  int64u PTS;
  int64u DTS;
  bool Have_PTS;
  bool Have_DTS;
} Mpeg_TimeStamp;

//---------------------------------------------------------------------------

//***************************************************************************
// Class File_Mpeg
//***************************************************************************

class File_MpegPs : public File__Base
{
protected :
    //Format
    void Read_Buffer_Init ();
    void Read_Buffer_Continue ();
    void Read_Buffer_Finalize ();

    //Information
    void HowTo (stream_t StreamKind);

public :
    //Where this file comes from?
    bool FromTS;

private :
    //Buffer
    bool PES_Packet ();
    bool PES_Packet_Header ();
    bool PES_Packet_Header_Data ();
    bool Element_Parse();
    size_t Element_Size;
    size_t Element_HeaderSize;
    int8u  Element_Name;
    size_t Element_Next;

    //Packet
    void Start ();
    void System ();
    void Padding ();
    void Mpeg1a ();
    void Mpeg1v ();
    void Private1 ();
    void Private2 ();

    //Helpers
    File__Base* Private1_ChooseParser(int8u Private1_ID);
    size_t MPEG_PES_Data   ();
    size_t MPEG_Stream     ();
    int64u MPEG_TimeStamp_Read (BitStream &BS);
    bool Detect_NonMPEGPS();
    void Detect_MPEG_Version();
    void Detect_EOF_Needed();
    size_t NextFrame();
    bool PES_Packet_NextFrame();
    bool PES_Packet_ElementName_IsOK();
    bool PES_Packet_ElementSizes_Get();
    void PES_Packet_ElementSizes_Unlimited();

    //Temp
    int MPEG_Version;
    Mpeg_TimeStamp TimeStamp;
    std::vector<File__Base*>    Video_Handle;
    std::vector<File__Base*>    Audio_Handle;
    std::vector<File__Base*>    Private1_Handle;
    std::vector<Mpeg_TimeStamp> Video_TimeStamp;
    std::vector<Mpeg_TimeStamp> Video_TimeStamp_End;
    std::vector<size_t>         Video_Handle_Error;
    std::vector<Mpeg_TimeStamp> Audio_TimeStamp;
    std::vector<Mpeg_TimeStamp> Private1_TimeStamp;
    bool Video_Unlimited;
};

} //NameSpace

#endif
