// GUI_Main - WxWidgets GUI for MediaInfo
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// WxWidgets GUI for MediaInfo
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#ifndef GUI_MainH
#define GUI_MainH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "wx/wxprec.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// the application icon (under Windows and OS/2 it is in resources)
#if defined(__WXGTK__) || defined(__WXMOTIF__) || defined(__WXMAC__) || defined(__WXMGL__) || defined(__WXX11__)
    #include "mondrian.xpm"
#endif
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
class FileDrop;
class Core;
class wxHtmlWindow;
class wxTextCtrl;
//---------------------------------------------------------------------------

//***************************************************************************
// GUI_Main
//***************************************************************************

class GUI_Main : public wxFrame
{
public:
    GUI_Main (const wxPoint& pos, const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);
    ~GUI_Main ();

    //Info
    void Show_Info ();

    //Menu - List
    wxMenuBar*  Menu;
    wxMenu*     Menu_File;
    wxMenuItem* Menu_File_Open_Files;
    wxMenuItem* Menu_File_Open_Directory;
    wxMenuItem* Menu_File_Quit;
    wxMenu*     Menu_View;
    wxMenuItem* Menu_View_HTML;
    wxMenuItem* Menu_View_Text;
    wxMenu*     Menu_Debug;
    wxMenuItem* Menu_Debug_Details;
    wxMenu*     Menu_Help;
    wxMenuItem* Menu_Help_About;

    //Menu - Actions
    void Menu_Create();
    void OnMenu_File_Open_Files     (wxCommandEvent& event);
    void OnMenu_File_Open_Directory (wxCommandEvent& event);
    void OnMenu_File_Quit           (wxCommandEvent& event);
    void OnMenu_View_HTML           (wxCommandEvent& event);
    void OnMenu_View_Text           (wxCommandEvent& event);
    void OnMenu_Debug_Details       (wxCommandEvent& event);
    void OnSize                     (wxSizeEvent&    event);

    //GUI
    void OnMenu_Help_About          (wxCommandEvent& event);


private:
    //Non-GUI Elements
    FileDrop* FD;
    Core* C;

    //GUI
    wxHtmlWindow* HTML;
    wxTextCtrl* Text;

    //wxWidgets
    DECLARE_EVENT_TABLE() // any class wishing to process wxWindows events must use this macro
};

#endif


