// GUI_Main - WxWidgets GUI for MediaInfo
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#include "GUI/WxWidgets/GUI_Main.h"
#include "GUI/WxWidgets/GUI_Main_FileDrop.h"
#include "Common/Core.h"
#include <wx/html/htmlwin.h>
#include <wx/file.h>
#include <wx/dnd.h>
#include <wx/fs_mem.h>
#include <MediaInfo/MediaInfoList.h>
using namespace MediaInfoLib;
//---------------------------------------------------------------------------

//***************************************************************************
// Constructor/Destructor
//***************************************************************************

//---------------------------------------------------------------------------
// Constructor
GUI_Main::GUI_Main(const wxPoint& pos, const wxSize& size, long style)
:wxFrame(NULL, -1, _T("MediaInfo"), pos, size, style)
{
    // set the frame icon
    SetIcon(wxICON(mondrian));

    //Menu
    Menu_Create();

    //Status bar
    CreateStatusBar(2);

    //Presentation
    HTML=new wxHtmlWindow(this, -1);
    HTML->SetSize(GetClientSize());
    HTML->Hide();
    Text=new wxTextCtrl(this, -1, L"", wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE);
    Text->SetSize(GetClientSize());
    Text->Hide();

    //Drag n drop
    C=new Core;
    FD=new FileDrop(C, this);
    SetDropTarget(FD);
    DragAcceptFiles(true);

    //GUI
    CenterOnScreen();
}

//---------------------------------------------------------------------------
GUI_Main::~GUI_Main()
{
    SetDropTarget(NULL);
    DragAcceptFiles(false);
    //delete FD;
}

//***************************************************************************
// Actions
//***************************************************************************

//---------------------------------------------------------------------------
void GUI_Main::Show_Info()
{
    C->Data_Prepare();
    if (C->HTML_Get())
    {
        Text->Hide();
        HTML->SetSize(GetClientSize());
        HTML->Show();
        //HTML->LoadFile(wxString(C->TempFile_Get().c_str()));
        wxFileSystem::AddHandler(new wxMemoryFSHandler);
        wxMemoryFSHandler::AddFile(_T("index.html"), C->TempText_Get().c_str());
        HTML->LoadPage(_T("memory:index.html"));
        wxMemoryFSHandler::RemoveFile(_T("index.html"));
    }
    else
    {
        HTML->Hide();
        Text->SetSize(GetClientSize());
        Text->Show();
        Text->SetValue(C->TempText_Get().c_str());
    }
}

//***************************************************************************
// Events
//***************************************************************************

//---------------------------------------------------------------------------
void GUI_Main::OnSize(wxSizeEvent& WXUNUSED(event))
{
    if (!IsShown())
        return;
    HTML->SetSize(GetClientSize());
    Text->SetSize(GetClientSize());
}
