#include <iostream>
#include <string>
#include <vector>

//Args
#if !defined(xx_WIN32) && defined(UNICODE)
    #include <wx/strconv.h>
#endif

//MediaInfo
#ifdef MEDIAINFO_DLL
    #include "MediaInfoDLL/MediaInfoDLL.h"
#else
    #include "MediaInfo/MediaInfoList.h"
#endif

//Unicode
#ifdef xx_WIN32
    #include <windows.h>
	#include <tchar.h>
    #define _TO(__x) _T(__x)
#else
    //Ubuntu does not support output in Unicode
    #undef  _tprintf
    #define _tprintf printf
    #define _TO(__x) __x
#endif

using namespace std;
using namespace MediaInfoLib;

#if !defined(xx_WIN32) && defined(UNICODE)
char* Buffer=NULL;
const char* cWC2MB(const wchar_t* Text)
{
    delete Buffer;
    size_t Buffer_Size=wxConvCurrent->WC2MB(NULL, Text, 0)+1;
    char* Buffer=new char[Buffer_Size];
    wxConvCurrent->WC2MB(Buffer, Text, Buffer_Size);
    return Buffer;
}

int main(int argc, char* argv_ansi[])
#else
const MediaInfoLib::Char* cWC2MB(const MediaInfoLib::Char* Text)
{
    return Text;
}

int main(int argc, MediaInfoLib::Char* argv[])
#endif
{
    //Get command line args
    #if defined(xx_WIN32) && defined(UNICODE)
        argv=CommandLineToArgvW(GetCommandLineW(), &argc);
    #endif
    #if !defined(xx_WIN32) && defined(UNICODE)
        //Transform command line in Unicode
        vector<MediaInfo_String> argv;
        for (int Pos=0; Pos<argc; Pos++)
        {
                size_t Buffer_Size=(wxConvCurrent->MB2WC(NULL, argv_ansi[Pos], 0)+1)*sizeof(MediaInfoLib::Char);
                MediaInfoLib::Char* Buffer=new MediaInfoLib::Char[Buffer_Size];
                wxConvCurrent->MB2WC(Buffer, argv_ansi[Pos], Buffer_Size);
                argv.push_back(Buffer);
                delete Buffer;
        }
    #endif

    MediaInfoList I;

    //Arguments
    vector<MediaInfo_String> List;
    for (int Pos=1; Pos<argc; Pos++)
    {
             if (MediaInfo_String(argv[Pos])==_T("-f"))
            I.Option(_T("Complete"), _T("1"));
        else if (MediaInfo_String(argv[Pos])==_T("-lang=raw"))
            I.Option(_T("Language"), _T("raw"));
		else
			List.push_back(argv[Pos]);
    }

    //No filenames
    if (List.empty())
    {
        _tprintf(_TO("MediaInfo Command line, "));
        _tprintf(cWC2MB(I.Option(_T("Info_Version")).c_str()));
        _tprintf(_TO("\n"));
        _tprintf(_TO("Usage: \"MediaInfo [-f] [-lang=raw] FileName1 [Filename2...]\",\n"));
        _tprintf(_TO("\n"));
        _tprintf(_TO("Options:\n"));
        _tprintf(_TO("-f for full information\n"));
        _tprintf(_TO("-lang=raw for non-translated words (internal text)\n"));
        return -1;
    }

    //Output
	for (size_t Pos=0; Pos<List.size(); Pos++)
    {
        I.Open(List[Pos]);
    }

    _tprintf(cWC2MB(I.Inform().c_str()));

    //cin>>DoNotAnalyse_Pos;
    return 0;
}
//---------------------------------------------------------------------------

