#! /bin/bash

#-----------------------------------------------------------------------
# Go on the top level
cd ../..

#-----------------------------------------------------------------------
# Preparing Directories
mkdir -p Shared/Include
mkdir -p Shared/Library/GCC_Linux_i386
mkdir -p Shared/Source/System
mkdir -p Shared/Source/MediaInfo

#-----------------------------------------------------------------------
# Downloads
wget http://www.zlib.net/zlib-1.2.3.tar.gz
tar xf zlib-1.2.3.tar.gz
mv zlib-1.2.3 Shared/Source/System/ZLib
rm zlib-1.2.3.tar.gz
wget http://prdownloads.sourceforge.net/wxwindows/wxWidgets-2.6.3.tar.gz
tar xf wxWidgets-2.6.3.tar.gz
mv wxWidgets-2.6.3 Shared/Source/System/WxWidgets
rm wxWidgets-2.6.3.tar.gz
wget http://dl.matroska.org/downloads/libebml/libebml-0.7.7.tar.bz2
tar xf libebml-0.7.7.tar.bz2
mv libebml-0.7.7 Shared/Source/MediaInfo/Ebml
rm libebml-0.7.7.tar.bz2
wget http://dl.matroska.org/downloads/libmatroska/libmatroska-0.8.0.tar.bz2
tar xf libmatroska-0.8.0.tar.bz2
mv libmatroska-0.8.0 Shared/Source/MediaInfo/Matroska
rm libmatroska-0.8.0.tar.bz2

#-----------------------------------------------------------------------
# ZLib
cd Shared/Source/System/ZLib
./configure
make
cp libz.a ../../../../Shared/Library/GCC_Linux_i386/libZLib.a
mkdir ../../../../Shared/Include/zlib
cp zconf.h ../../../../Shared/Include/zlib/
cp zlib.h ../../../../Shared/Include/zlib/
cd ../../../..

#-----------------------------------------------------------------------
# WxWidgets
cd Shared/Source/System/WxWidgets
./configure --disable-shared --disable-gui --enable-unicode --enable-monolithic
make
cp lib/libwx_baseu-2.6.a ../../../../Shared/Library/GCC_Linux_i386/libWxWidgets.a
cp -r include/wx ../../../../Shared/Include/
cp lib/wx/include/base-unicode-release-static-2.6/wx/setup.h ../../../../Shared/Include/wx
cd ../../../..

#-----------------------------------------------------------------------
# Ebml
cd Shared/Source/MediaInfo/Ebml/make/linux/
make
cd ../..
cp -r ebml ../../../../Shared/Include/
cp make/linux/libebml.a ../../../../Shared/Library/GCC_Linux_i386/libEbml.a
cd ../../../..

#-----------------------------------------------------------------------
# Matroska
cd Shared/Source/MediaInfo/Matroska/make/linux/
cp -r ../../../Ebml/ebml ../../
make
cd ../..
cp -r matroska ../../../../Shared/Include/
cp make/linux/libmatroska.a ../../../../Shared/Library/GCC_Linux_i386/libMatroska.a
cd ../../../..

#-----------------------------------------------------------------------
# ZenLib
cd ZenLib/Project/GCC/Library
mkdir -p .deps/Source/ZenLib
mkdir -p .objs/Source/ZenLib
make
cd ../../..
cp -r Include/ZenLib ../Shared/Include/
cp Release/GCC_Linux_i386/Library/libZenLib.a ../Shared/Library/GCC_Linux_i386/
cd ..

#-----------------------------------------------------------------------
# MediaInfo
cd MediaInfo/Project/GCC/CLI_WithoutLib
mkdir -p .deps/MediaInfo/Source/CLI
mkdir -p .deps/MediaInfoLib/Source/MediaInfo/Archive
mkdir -p .deps/MediaInfoLib/Source/MediaInfo/Audio
mkdir -p .deps/MediaInfoLib/Source/MediaInfo/Image
mkdir -p .deps/MediaInfoLib/Source/MediaInfo/Multiple
mkdir -p .deps/MediaInfoLib/Source/MediaInfo/Text
mkdir -p .deps/MediaInfoLib/Source/MediaInfo/Video
mkdir -p .objs/MediaInfo/Source/CLI
mkdir -p .objs/MediaInfoLib/Source/MediaInfo/Archive
mkdir -p .objs/MediaInfoLib/Source/MediaInfo/Audio
mkdir -p .objs/MediaInfoLib/Source/MediaInfo/Image
mkdir -p .objs/MediaInfoLib/Source/MediaInfo/Multiple
mkdir -p .objs/MediaInfoLib/Source/MediaInfo/Text
mkdir -p .objs/MediaInfoLib/Source/MediaInfo/Video
make
cd ../../../..
	
#-----------------------------------------------------------------------
# at the root...
echo MediaInfo is in MediaInfo/Release/GCC_Linux_i386/CLI/ directory
