// GUI_Main_Menu - WxWidgets GUI for MediaInfo, Menu
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#include "GUI/WxWidgets/GUI_Main.h"
#include "Common/Core.h"
//---------------------------------------------------------------------------

//***************************************************************************
// Events
//***************************************************************************

enum
{
    ID_Menu_File_Open_Files,
    ID_Menu_File_Open_Directory,
    ID_Menu_File_Quit,
    ID_Menu_View_HTML,
    ID_Menu_View_Text,
    ID_Menu_Debug_Details,
    ID_Menu_Help_About,
};

BEGIN_EVENT_TABLE(GUI_Main, wxFrame)
    //Menu
    EVT_MENU(ID_Menu_File_Open_Files,       GUI_Main::OnMenu_File_Open_Files)
    EVT_MENU(ID_Menu_File_Open_Directory,   GUI_Main::OnMenu_File_Open_Directory)
    EVT_MENU(wxID_EXIT,                     GUI_Main::OnMenu_File_Quit)
    EVT_MENU(ID_Menu_View_HTML,             GUI_Main::OnMenu_View_HTML)
    EVT_MENU(ID_Menu_View_Text,             GUI_Main::OnMenu_View_Text)
    EVT_MENU(ID_Menu_Debug_Details,         GUI_Main::OnMenu_Debug_Details)
    EVT_MENU(wxID_ABOUT,                    GUI_Main::OnMenu_Help_About)

    //GUI
    EVT_SIZE(                               GUI_Main::OnSize)
END_EVENT_TABLE()


//***************************************************************************
// Menu creation
//***************************************************************************

//---------------------------------------------------------------------------
void GUI_Main::Menu_Create()
{
    //File
    Menu_File=new wxMenu;
    Menu_File_Quit=Menu_File->Append(ID_Menu_File_Open_Files, _T("Open &files"));
    Menu_File_Quit=Menu_File->Append(ID_Menu_File_Open_Directory, _T("Open &directory"));
    Menu_File_Quit=Menu_File->Append(wxID_EXIT, _T("E&xit\tAlt-X"), _T("Quit this program"));

    //View
    Menu_View=new wxMenu;
    Menu_View_HTML=Menu_View->AppendRadioItem(ID_Menu_View_HTML, _T("HTML"), _T("HTML view"));
    Menu_View_Text=Menu_View->AppendRadioItem(ID_Menu_View_Text, _T("Text"), _T("Text view"));

    //Debug
    Menu_Debug=new wxMenu;
    Menu_Debug_Details=Menu_Debug->AppendCheckItem(ID_Menu_Debug_Details, _T("Details"), _T("Details text view"));

    //Help
    Menu_Help=new wxMenu;
    Menu_Help_About=Menu_Help->Append(wxID_ABOUT, _T("&About...\tF1"), _T("Show about dialog"));

    //Main
    Menu=new wxMenuBar();
    Menu->Append(Menu_File, _T("&File"));
    Menu->Append(Menu_View, _T("&View"));
    Menu->Append(Menu_Debug, _T("&Debug"));
    Menu->Append(Menu_Help, _T("&Help"));
    SetMenuBar(Menu);
}

//***************************************************************************
// Menu actions
//***************************************************************************

//---------------------------------------------------------------------------
void GUI_Main::OnMenu_File_Quit(wxCommandEvent& WXUNUSED(event))
{
    Close(true);
}

//---------------------------------------------------------------------------
void GUI_Main::OnMenu_File_Open_Files(wxCommandEvent& WXUNUSED(event))
{
    wxFileDialog Dialog(this, _T("Choose a file"), _T(""), _T(""), _T("*.*"), wxOPEN|wxFILE_MUST_EXIST|wxMULTIPLE);
    Dialog.ShowModal();
    //wxArrayString& filenames
    //C->Menu_File_Open_Files();
}

//---------------------------------------------------------------------------
void GUI_Main::OnMenu_File_Open_Directory(wxCommandEvent& WXUNUSED(event))
{

}

//---------------------------------------------------------------------------
void GUI_Main::OnMenu_View_HTML(wxCommandEvent& WXUNUSED(event))
{
    //GUI
    Menu_Debug_Details->Check(false);

    //Action
    C->Menu_View_HTML();
    Show_Info();
}

//---------------------------------------------------------------------------
void GUI_Main::OnMenu_View_Text(wxCommandEvent& WXUNUSED(event))
{
    //GUI
    Menu_Debug_Details->Check(false);

    //Action
    C->Menu_View_Text();
    Show_Info();
}

//---------------------------------------------------------------------------
void GUI_Main::OnMenu_Debug_Details(wxCommandEvent& WXUNUSED(event))
{
    //GUI
    Menu_View_HTML->Enable(!Menu_Debug_Details->IsChecked());
    Menu_View_Text->Enable(!Menu_Debug_Details->IsChecked());

    //Action
    if (Menu_Debug_Details->IsChecked())
    {
        C->Menu_Debug_Details();
        Show_Info();
    }
    else
    {
        if (Menu_View_HTML->IsChecked())
            C->Menu_View_HTML();
        else
            C->Menu_View_Text();
        Show_Info();
    }
}

//---------------------------------------------------------------------------
void GUI_Main::OnMenu_Help_About(wxCommandEvent& WXUNUSED(event))
{
    wxMessageBox(_T("This is the About dialog of the minimal MediaInfo sample.\n"), _T("About Minimal"), wxOK | wxICON_INFORMATION, this);
}
