// Core - Main functions
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Core functions
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#ifndef CoreH
#define CoreH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/MediaInfoList.h"
using namespace MediaInfoLib;
//---------------------------------------------------------------------------

//***************************************************************************
// Class Core
//***************************************************************************

class Core
{
public:
    //Constructor/Destructor
    Core();
    ~Core();

    //Menu
    void Menu_File_Open_File            (const MediaInfo_String& FileName);
    void Menu_File_Open_Files_Begin     ();
    void Menu_File_Open_Files_Continue  (const MediaInfo_String& FileName);
    void Menu_File_Open_Directory       (const MediaInfo_String& DirectoryName);
    void Menu_View_HTML();
    void Menu_View_Text();
    void Menu_Debug_Details();

    //Show info
    bool HTML_Get();
    void HTML_Set(bool HTML);

    //Datas
    void Data_Prepare  ();
    MediaInfo_String& TempFile_Get();
    MediaInfo_String& TempText_Get();

private:
    MediaInfoList* MI;
    MediaInfo_String TempFile;
    MediaInfo_String TempText;
    bool HTML;
};

#endif
