// Main - Main functions
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#include "Common/Core.h"
using namespace MediaInfoLib;
//---------------------------------------------------------------------------

//***************************************************************************
// Constructor/Destructor
//***************************************************************************

//---------------------------------------------------------------------------
Core::Core()
{
    MI=new MediaInfoList;
    HTML=true;
}

Core::~Core()
{
    delete MI;
}

//***************************************************************************
// Show Info
//***************************************************************************

//---------------------------------------------------------------------------
void Core::Data_Prepare()
{
    //Creating file
    if (HTML)
        MI->Option(_T("Inform"), _T("HTML"));

    //Inform
    TempText=MI->Inform((size_t)-1).c_str();

    //Show
    /*
    if (HTML)
    {
        wxFile F;
        if (TempFile==_T(""))
        {
            TempFile=wxFileName::CreateTempFileName(_T("MI_"));
            wxRemoveFile(TempFile.c_str());
            TempFile+=_T(".html");
        }
        F.Open(TempFile.c_str(), wxFile::write);
        F.Write(TempText.c_str(), wxConvUTF8);
        F.Close();
    }
    */
}

//***************************************************************************
// Menu
//***************************************************************************

//---------------------------------------------------------------------------
void Core::Menu_File_Open_File (const MediaInfo_String& FileName)
{
    MI->Close(Error);
    MI->Open(FileName.c_str());
}

//---------------------------------------------------------------------------
void Core::Menu_File_Open_Files_Begin ()
{
    MI->Close(Error);
}

//---------------------------------------------------------------------------
void Core::Menu_File_Open_Files_Continue (const MediaInfo_String& FileName)
{
    MI->Open(FileName.c_str());
}

//---------------------------------------------------------------------------
void Core::Menu_View_HTML ()
{
    MediaInfoLib::MediaInfo::Option_Static(_T("Inform"), _T("HTML"));
    HTML=true;
}

//---------------------------------------------------------------------------
void Core::Menu_View_Text ()
{
    MediaInfoLib::MediaInfo::Option_Static(_T("Inform"), _T(""));
    HTML=false;
}

//---------------------------------------------------------------------------
void Core::Menu_Debug_Details ()
{
    MediaInfoLib::MediaInfo::Option_Static(_T("Inform"), _T("Details"));
    HTML=false;
}

//***************************************************************************
// Helpers
//***************************************************************************

//---------------------------------------------------------------------------
bool Core::HTML_Get ()
{
    return HTML;
}

//---------------------------------------------------------------------------
void Core::HTML_Set (bool HTML_)
{
    HTML=HTML_;
}

//---------------------------------------------------------------------------
MediaInfo_String& Core::TempText_Get ()
{
    return TempText;
}

//---------------------------------------------------------------------------
MediaInfo_String& Core::TempFile_Get ()
{
    return TempFile;
}
