// File_Avc - Info for MPEG-4 Visual Visual files
// Copyright (C) 2006-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about MPEG-4 Visual files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#ifndef MediaInfo_Mpeg4vH
#define MediaInfo_Mpeg4vH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/File__Base.h"
#include "MediaInfo/Multiple/File_Mpeg4.h"
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Class File_Mpeg4v
//***************************************************************************

class File_Mpeg4v : public File__Base
{
protected :
    //Format
    void Read_Buffer_Init ();
    void Read_Buffer_Continue ();
    void Read_Buffer_Finalize ();

    //Information
    void HowTo (stream_t StreamKind);

private :
    //Buffer
    bool Buffer_Parse();
    bool Element_Parse();
    int64u Element_Size;
    int8u  Element_Name;
    int64u Element_Next;
    size_t Frame_Count;

    //Size of a Packet
    size_t IVOP_Count;
    size_t PVOP_Count;
    size_t BVOP_Count;
    size_t SVOP_Count;
    size_t NVOP_Count;

    //From VOL, needed in VOP
    size_t interlaced;
    size_t newpred_enable;
    size_t time_size;
    size_t reduced_resolution_vop_enable;
    size_t shape;
    size_t sprite_enable;
    size_t scalability;
    size_t enhancement_type;
    size_t complexity_estimation_disable;

    //Temp
    Ztring Library;
    size_t Chroma;
    size_t Standard;
    size_t PictureStructure;

    //Packets
    void VideoObject_Start();
    void VideoObjectLayer_Start();
    void VisualObjectSequence_Start();
    void VisualObjectSequence_End();
    void User_Start();
    void GroupOfVOP_Start();
    void VisualObject_Start();
    void VideoObjectPlane_Start();

public :
    //Information for container
    size_t RIFF_VOP_Count; //RIFF limited : count the number of VOP in this chunk
    size_t RIFF_VOP_Count_Max; //RIFF limited : count the number of VOP in this chunk
};

} //NameSpace

#endif
