// File_Avc - Info for AVC Video files
// Copyright (C) 2006-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#include <MediaInfo/Setup.h>
#if defined(MEDIAINFO_AVC_YES)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/Video/File_Avc.h"
#include <ZenLib/BitStream.h>
#include <ZenLib/Utils.h>
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Format
//***************************************************************************

//---------------------------------------------------------------------------
void File_Avc::Read_Buffer_Continue()
{
    //Integrity
    if (Buffer_Size<32)
        return;

    Buffer_Offset=Error;

    //Looking for Start code
    if (CC4(Buffer)==0x00000001 && (CC1(Buffer+4)&0x1F)==0x07) //in JVT
        Buffer_Offset=5;
    if (CC3(Buffer)==0x000001   && (CC1(Buffer+3)&0x1F)==0x07) //in MPEG
        Buffer_Offset=4;
    if (Buffer_Offset==Error)
    {
        File_Offset=File_Size;
        return;
    }

    //Filling
    Stream_Prepare(Stream_General);
    Fill("Format", "AVC");
    Stream_Prepare(Stream_Video);
    Fill("Codec", "AVC");

    //Parsing
    SeqParam();

    //No need of more
    File_Offset=File_Size;
}

//---------------------------------------------------------------------------
// SEQ_PARAM
// Profile                          1 byte, Pos=0
//                                  1 byte, Pos=1
// Level                            1 byte, Pos=2
// ...
//
void File_Avc::SeqParam()
{
    //Profile
    Ztring Profile;
         if (CC1(Buffer+Buffer_Offset)==0x42) Profile=_T("Baseline");
    else if (CC1(Buffer+Buffer_Offset)==0x4D) Profile=_T("Main");
    else if (CC1(Buffer+Buffer_Offset)==0x58) Profile=_T("Extended");
    else if (CC1(Buffer+Buffer_Offset)==0x64) Profile=_T("High");
    else if (CC1(Buffer+Buffer_Offset)==0x6E) Profile=_T("High 10");
    else if (CC1(Buffer+Buffer_Offset)==0x7A) Profile=_T("High 4:2:2");
    else if (CC1(Buffer+Buffer_Offset)==0x90) Profile=_T("High 4:4:4");

    //Level
    Ztring Level;
    Level.From_Number((float)CC1(Buffer+Buffer_Offset+2)/10, 1); //Level is Value*10, can have one digit example 5.1

    //Filling
    Fill("Codec_Profile", Profile+_T("@L")+Level);
}

//***************************************************************************
// Information
//***************************************************************************

//---------------------------------------------------------------------------
void File_Avc::HowTo(stream_t StreamKind)
{
    switch (StreamKind)
    {
        case (Stream_General) :
            Fill_HowTo("Format", "R");
            break;
        case (Stream_Video) :
            Fill_HowTo("Codec", "R");
            break;
        case (Stream_Audio) :
            break;
        case (Stream_Text) :
            break;
        case (Stream_Chapters) :
            break;
        case (Stream_Image) :
            break;
        case (Stream_Menu) :
            break;
        case (Stream_Max) :
            break;
    }
}

} //NameSpace

#endif //MEDIAINFO_AVC_YES
