//----------------------------------------------------------------------------
#include "GUI/WxWidgets/GUI_Main.h"
#include "GUI/WxWidgets/GUI_Main_FileDrop.h"
#include "Common/Core.h"
#include <wx/html/htmlwin.h>
#include <wx/file.h>
#include <wx/dnd.h>
#include <MediaInfo/MediaInfoList.h>
using namespace MediaInfoLib;

//----------------------------------------------------------------------------
//Menu
BEGIN_EVENT_TABLE(GUI_Main, wxFrame)
    EVT_MENU(1,  GUI_Main::OnQuit)
    EVT_MENU(wxID_ABOUT, GUI_Main::OnAbout)
END_EVENT_TABLE()


// ----------------------------------------------------------------------------
// main frame
// ----------------------------------------------------------------------------

// frame constructor
GUI_Main::GUI_Main(const wxPoint& pos, const wxSize& size, long style)
:wxFrame(NULL, -1, _T("MediaInfo"), pos, size, style)
{
    // set the frame icon
    SetIcon(wxICON(mondrian));

    //Menu
    wxMenu *Menu_File = new wxMenu;
    Menu_File->Append(1, _T("E&xit\tAlt-X"), _T("Quit this program"));
    wxMenu *Menu_Help = new wxMenu;
    Menu_Help->Append(wxID_ABOUT, _T("&About...\tF1"), _T("Show about dialog"));

    wxMenuBar *menuBar = new wxMenuBar();
    menuBar->Append(Menu_File, _T("&File"));
    menuBar->Append(Menu_Help, _T("&Help"));
    SetMenuBar(menuBar);

    //Status bar
    CreateStatusBar(2);

    //HTML
    wxHtmlWindow* HTML=new wxHtmlWindow(this, -1);

    //Drag n drop
    M=new Core;
    FD=new FileDrop(M, HTML);
    SetDropTarget(FD);
    DragAcceptFiles(true);

}

GUI_Main::~GUI_Main()
{
    SetDropTarget(NULL);
    DragAcceptFiles(false);
    //delete FD;
}


void GUI_Main::OnQuit(wxCommandEvent& WXUNUSED(event))
{
    Close(true);
}

void GUI_Main::OnAbout(wxCommandEvent& WXUNUSED(event))
{
    wxMessageBox(_T("This is the About dialog of the minimal sample.\n"), _T("About Minimal"), wxOK | wxICON_INFORMATION, this);
}
