// GUI_Main - Main interface of MediaInfo
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Main interface of MediaInfo
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "GUI/VCL/GUI_Main.h"
#include "GUI/VCL/GUI_Preferences.h"
#include "GUI/VCL/GUI_About.h"
#include "GUI/VCL/GUI_Export.h"
#include "GUI/VCL/GUI_Web.h"
#include "Common/Preferences.h"
#include "Common/Utils.h"
#include <wx/file.h>
#include <wx/filename.h>
#include <wx/strconv.h>
#ifdef MEDIAINFO_DLL
    #include "MediaInfoDLL/MediaInfoDLL.h"
#else
    #include "MediaInfo/MediaInfoList.h"
#endif
using namespace MediaInfoLib;
using namespace ZenLib;
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "SHDocVw_OCX"
#pragma link "TntComCtrls"
#pragma link "TntDialogs"
#pragma link "TntGrids"
#pragma link "TntMenus"
#pragma link "TntStdCtrls"
#pragma link "TntThemeMgr"
#pragma link "ThemeMgr"
#pragma resource "*.dfm"
TMainF *MainF;
MediaInfoList *I;

//Page specific
int Page_Position; //Index of MediaInfo file
//-Page_Easy
const int EASY_STREAM_MAX=3;
TTntGroupBox* Page_Easy_X           [Stream_Max][EASY_STREAM_MAX];
TTntLabel*    Page_Easy_X_Codec     [Stream_Max][EASY_STREAM_MAX];
TTntButton*   Page_Easy_X_Web       [Stream_Max][EASY_STREAM_MAX];
Ztring        Page_Easy_X_Web_Url   [Stream_Max][EASY_STREAM_MAX];
TTntLabel*    Page_Easy_X_List      [Stream_Max];
const int EASY_TAG_MAX=5;
TTntLabel*    Page_Easy_X_Tag       [EASY_TAG_MAX];
//-Page_Sheet
TTntComboBox* Page_Sheet_X          [Stream_Max];
TTntButton*   Page_Sheet_X_Web      [Stream_Max];
Ztring        Page_Sheet_X_Web_Url  [Stream_Max];
//-Page_System
bool Page_System_Already=false; //Already done?
int Page_System_Sheet_ColumnToSort=0;
ZenLib::ZtringListList Page_System_Video; //List of Video codecs
ZenLib::ZtringListList Page_System_Audio; //List of Audio codecs
ZenLib::ZtringListList Page_System_Text; //List of Text codecs

//Temp
wxString FileName_Temp; //Temporary file used for HTML presentation
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
const ZenLib::Char* MEDIAINFO_TITLE=_T("MediaInfo - http:\/\/mediainfo.sourceforge.net");
//---------------------------------------------------------------------------

//***************************************************************************
// Constructor/Destructor
//***************************************************************************

//---------------------------------------------------------------------------
__fastcall TMainF::TMainF(TComponent* Owner)
	: TTntForm(Owner)
{
    //Configuration of internal pointers
    //-Easy
    for (int KindOfStream=0; KindOfStream<Stream_Max; KindOfStream++)
        for (int Pos=0; Pos<EASY_STREAM_MAX; Pos++)
        {
            Page_Easy_X      [KindOfStream][Pos]=NULL;
            Page_Easy_X_Codec[KindOfStream][Pos]=NULL;
            Page_Easy_X_Web  [KindOfStream][Pos]=NULL;
        }
    Page_Easy_X      [Stream_General][0]=Page_Easy_G1;
    Page_Easy_X      [Stream_Visual ][0]=Page_Easy_V1;
    Page_Easy_X      [Stream_Audio  ][0]=Page_Easy_A1;
    Page_Easy_X      [Stream_Audio  ][1]=Page_Easy_A2;
    Page_Easy_X      [Stream_Text   ][0]=Page_Easy_T1;
    Page_Easy_X      [Stream_Text   ][1]=Page_Easy_T2;
    Page_Easy_X      [Stream_Text   ][2]=Page_Easy_T3;
    Page_Easy_X_Codec[Stream_General][0]=Page_Easy_G1_Codec;
    Page_Easy_X_Codec[Stream_Visual][0] =Page_Easy_V1_Codec;
    Page_Easy_X_Codec[Stream_Audio][0]  =Page_Easy_A1_Codec;
    Page_Easy_X_Codec[Stream_Audio][1]  =Page_Easy_A2_Codec;
    Page_Easy_X_Codec[Stream_Text][0]   =Page_Easy_T1_Codec;
    Page_Easy_X_Codec[Stream_Text][1]   =Page_Easy_T2_Codec;
    Page_Easy_X_Codec[Stream_Text][2]   =Page_Easy_T3_Codec;
    Page_Easy_X_Web  [Stream_General][0]=Page_Easy_G1_Web;
    Page_Easy_X_Web  [Stream_Visual][0] =Page_Easy_V1_Web;
    Page_Easy_X_Web  [Stream_Audio][0]  =Page_Easy_A1_Web;
    Page_Easy_X_Web  [Stream_Audio][1]  =Page_Easy_A2_Web;
    Page_Easy_X_Web  [Stream_Text][0]   =Page_Easy_T1_Web;
    Page_Easy_X_Web  [Stream_Text][1]   =Page_Easy_T2_Web;
    Page_Easy_X_Web  [Stream_Text][2]   =Page_Easy_T3_Web;
    Page_Easy_X_List [Stream_General]   =Page_Easy_G1_Codec;
    Page_Easy_X_List [Stream_Visual]    =Page_Easy_General_List_V;
    Page_Easy_X_List [Stream_Audio]     =Page_Easy_General_List_A;
    Page_Easy_X_List [Stream_Text]      =Page_Easy_General_List_T;
    Page_Easy_X_List [Stream_Chapters]  =Page_Easy_General_List_C;
    Page_Easy_X_Tag[0]=Page_Easy_General_Tag1;
    Page_Easy_X_Tag[1]=Page_Easy_General_Tag2;
    Page_Easy_X_Tag[2]=Page_Easy_General_Tag3;
    Page_Easy_X_Tag[3]=Page_Easy_General_Tag4;
    Page_Easy_X_Tag[4]=Page_Easy_General_Tag5;
    //-Sheet
    Page_Sheet_X[Stream_General]=Page_Sheet_G;
    Page_Sheet_X[Stream_Visual]=Page_Sheet_V;
    Page_Sheet_X[Stream_Audio]=Page_Sheet_A;
    Page_Sheet_X[Stream_Text]=Page_Sheet_T;
    Page_Sheet_X[Stream_Chapters]=Page_Sheet_C;
    Page_Sheet_X_Web[Stream_General]=Page_Sheet_G_Web;
    Page_Sheet_X_Web[Stream_Visual]=Page_Sheet_V_Web;
    Page_Sheet_X_Web[Stream_Audio]=Page_Sheet_A_Web;
    Page_Sheet_X_Web[Stream_Text]=Page_Sheet_T_Web;
    Page_Sheet_X_Web[Stream_Chapters]=Page_Sheet_C_Web;

	//Configuration of properties
    Page->Top=-6; //Not done with BCB because I want to easy select tabs in it
    Page->TabHeight=1; //Not done with BCB because I want to easy select tabs in it
    Page_Position=-1;
    Caption=MEDIAINFO_TITLE;
    DragAcceptFiles(Handle, true);

    //Configuration of MediaInfoLib
    if (I==NULL)
        I=new MediaInfoList;
}

//***************************************************************************
// GUI - Form
//***************************************************************************

//---------------------------------------------------------------------------
void __fastcall TMainF::GUI_Configure()
{
    //Hard coded
    Width=700;
    Height=392;
    Left=(Screen->Width-Width)/2;
    Top=(Screen->Height-Height)/2;

    //Load Configuration
    if (Prefs->Config_Load()==2) //Showing options if no config
    {
        TPreferencesF* PreferencesF=new TPreferencesF(this);
        PreferencesF->Cancel->Enabled=false;
        PreferencesF->ShowModal();
        delete PreferencesF;
        Prefs->Config_Load(); //Again...
    }

    //Web Updates
    if (Prefs->Config(_T("CheckUpdate"))==_T("1"))
    {
        WebF=new TWebF(this);
        WebF->Execute();
    }

    //Menu - View
         if (Prefs->Config(_T("Output"))==_T("Basic")) {M_View_EasyClick(NULL); M_View_Easy->Checked=true;}
	else if (Prefs->Config(_T("Output"))==_T("Sheet")) {M_View_SheetClick(NULL); M_View_Sheet->Checked=true;}
    else if (Prefs->Config(_T("Output"))==_T("Tree")) {M_View_TreeClick(NULL); M_View_Tree->Checked=true;}
    else if (Prefs->Config(_T("Output"))==_T("Text")) {M_View_TextClick(NULL); M_View_Text->Checked=true;}
    else if (Prefs->Config(_T("Output"))==_T("HTML")) {M_View_HTMLClick(NULL); M_View_HTML->Checked=true;}
    else if (Prefs->Config(_T("Output"))==_T("Custom")) {M_View_CustomClick(NULL); M_View_Custom->Checked=true;}

    //Menu - Options
    M_Options_ShowToolBar->Checked=Prefs->Config(_T("ShowToolBar")).To_int32s();
    M_Options_ShowMenu->Checked=Prefs->Config(_T("ShowMenu")).To_int32s();
    M_Options_CloseAllAuto->Checked=Prefs->Config(_T("CloseAllAuto")).To_int32s();

    //Toolbar
    ToolBar->Visible=M_Options_ShowToolBar->Checked;

	//Translation
    Translate();

    //Refresh global
    FormResize(NULL);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::FormShow(TObject *Sender)
{
    //Load GUI preferences
    GUI_Configure();

    //File(s) in command line
    if (ParamCount()>=1)
    {
        for (int I1=1; I1<=ParamCount(); I1++)
            I->Open(wxString(ParamStr(I1).c_str(), wxConvLocal).c_str());
        Refresh();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainF::FormClose(TObject *Sender, TCloseAction &Action)
{
	if (Page->ActivePage==Page_Sheet) //TODO : find WHY there is a crash without this...
		ChangePage(Page_Easy);

	delete Prefs; Prefs=NULL;
	delete I; I=NULL;
}

//---------------------------------------------------------------------------
void __fastcall TMainF::FormResize(TObject *Sender)
{
    //Main View
    Page->Left  =(ToolBar->Visible?ToolBar->Width:0)-2;
    Page->Width =ClientWidth-Page->Left+2;
    Page->Height=ClientHeight-Page->Top+3;

    //Page - Easy
         if (Page->ActivePage==Page_Easy)
	{
        //Main
        Page_Easy_File->Width=Page_Easy->ClientWidth-Page_Easy_FileSelect->Width;
        Page_Easy_FileSelect->Left=Page_Easy->ClientWidth-Page_Easy_FileSelect->Width;

        //GroupBoxes
        for (int KindOfStream=0; KindOfStream<Stream_Max; KindOfStream++)
        {
            //How many visible streams?
            int StreamCount=0;
            while (Page_Easy_X[KindOfStream][StreamCount]!=NULL && Page_Easy_X[KindOfStream][StreamCount]->Visible)
                StreamCount++;
            //Resize
            for (int StreamPos=0; StreamPos<StreamCount; StreamPos++)
            {
                Page_Easy_X    [KindOfStream][StreamPos]->Left =(Page_Sheet->ClientWidth-2)/StreamCount*StreamPos;
                Page_Easy_X    [KindOfStream][StreamPos]->Width=(Page_Sheet->ClientWidth-2)/StreamCount;
                Page_Easy_X_Web[KindOfStream][StreamPos]->Width=(Page_Sheet->ClientWidth-2)/StreamCount-8;
            }
        }

        //General list
        int Divider=Page_Easy_X_Tag[0]->Caption.Length()>0?2:1;
        for (int Pos=0; Pos<Stream_Max; Pos++)
            if (Page_Easy_X_List[Pos])
                Page_Easy_X_List[Pos]->Width=Page_Easy_G1->Width/Divider-6;

        //Tags
        for (int Pos=0; Pos<EASY_TAG_MAX; Pos++)
            if (Page_Easy_X_Tag[Pos])
            {
                Page_Easy_X_Tag[Pos]->Left=Page_Easy_G1->Width/2;
                Page_Easy_X_Tag[Pos]->Width=Page_Easy_G1->Width/2-6;
            }

        //Bottom
        Page_Easy_DifferentView->Left=Page_Sheet->ClientWidth-Page_Easy_DifferentView->Width;
        Page_Easy_Note->Width=Page_Easy_DifferentView->Left-Page_Easy_Note->Left;
    }

    //Page - Sheet
    else if (Page->ActivePage==Page_Sheet)
	{
        //Bottom
        Page_Sheet_Text->Width=Page_Sheet->ClientWidth;
        Page_Sheet_Text->Top  =Page_Sheet->ClientHeight-Page_Sheet_Text->Height;

        //Streams
        for (int KindOfStream=Stream_Max-1; KindOfStream>=0; KindOfStream--)
        {
            if (KindOfStream!=Stream_Max-1)
                Page_Sheet_X[KindOfStream]->Top =Page_Sheet_X[KindOfStream+1]->Top-Page_Sheet_X[KindOfStream]->Height;
            else
                Page_Sheet_X[KindOfStream]->Top =Page_Sheet_Text->Top-Page_Sheet_X[KindOfStream]->Height; //1st stream, need reference
            Page_Sheet_X[KindOfStream]->Width   =Page_Sheet->ClientWidth-Page_Sheet_X_Web[KindOfStream]->Width;
            Page_Sheet_X_Web[KindOfStream]->Top =Page_Sheet_X[KindOfStream]->Top+1;
            Page_Sheet_X_Web[KindOfStream]->Left=Page_Sheet_X[KindOfStream]->Width;
        }

        //Sheet
        Page_Sheet_Sheet->Width =Page_Sheet->ClientWidth;
        Page_Sheet_Sheet->Height=Page_Sheet_G->Top;

        //Columns
        //-Calculate total width
        int Total=0;
        for (int Pos=0; Pos<Page_Sheet_Sheet->ColCount; Pos++)
        {
            Ztring Z1=_T("Column"); Z1+=Ztring::ToZtring(Pos);
            Total+=Prefs->Details[Sheet](Z1, 4).To_int32s();
        }
        if (Total==0)
            Total=100;
        //Set column widthes
        for (int Pos=0; Pos<Page_Sheet_Sheet->ColCount; Pos++)
        {
            Ztring Z1=_T("Column"); Z1+=Ztring::ToZtring(Pos);
            Page_Sheet_Sheet->ColWidths[Pos]=Prefs->Details[Sheet](Z1, 4).To_int32s()*Page_Sheet_Sheet->ClientWidth/Total-1;
        }
    }

    //Page - Tree
    else if (Page->ActivePage==Page_Tree)
	{
        Page_Tree_Tree->Top   =-1;
        Page_Tree_Tree->Left  =-1;
        Page_Tree_Tree->Width =Page_Tree->ClientWidth+2;
        Page_Tree_Tree->Height=Page_Tree->ClientHeight+2;
    }
    
    //Page - Text
    else if (Page->ActivePage==Page_Text)
	{
        Page_Text_Text->Top   =-1;
        Page_Text_Text->Left  =-1;
        Page_Text_Text->Width =Page_Text->ClientWidth+2;
        Page_Text_Text->Height=Page_Text->ClientHeight+2;
    }

    //Page - HTML
    else if (Page->ActivePage==Page_HTML)
	{
        Page_HTML_HTML->Top   =-1;
        Page_HTML_HTML->Left  =-1;
        Page_HTML_HTML->Width =Page_HTML->ClientWidth+2;
        Page_HTML_HTML->Height=Page_HTML->ClientHeight+2;
    }

    //Page - Custom
    else if (Page->ActivePage==Page_Custom)
	{
        Page_Custom_Text->Top   =-1;
        Page_Custom_Text->Left  =-1;
        Page_Custom_Text->Width =Page_Custom->ClientWidth+2;
        Page_Custom_Text->Height=Page_Custom->ClientHeight+2;
        if (Page_Custom_HTML->Visible)
            Page_Custom_HTML->Left=Page_Custom_Text->Left;
        else
            Page_Custom_HTML->Left=ClientWidth; //Bug? I can't have the canvas hidden
        Page_Custom_HTML->Top   =Page_Custom_Text->Top;
        Page_Custom_HTML->Width =Page_Custom_Text->Width;
        Page_Custom_HTML->Height=Page_Custom_Text->Height;
    }

    //Page - System
    else if (Page->ActivePage==Page_System)
	{
        Page_System_Sheet->Width = Page_System->ClientWidth - 2;
        Page_System_Sheet->Height = Page_System->ClientHeight - Page_System_Sheet->Top - 2;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Translate()
{
    //Menu - Language
    M_Language->Clear();
    for (size_t Pos=0; Pos<Prefs->FilesList[Language].size(); Pos++)
    {
        TTntMenuItem* MenuItem=new TTntMenuItem(NULL);
        MenuItem->Caption=Prefs->FilesList[Language_List](Pos).c_str(); //Special case : Languages, should show the name of language in the local version
        MenuItem->OnClick=M_LanguageClick;
        M_Language->Add(MenuItem);
    }

    //Menu
    M_File->Caption=Prefs->Translate(_T("File")).c_str();
    M_File_Open->Caption=Prefs->Translate(_T("Open")).c_str();
    M_File_Open_File->Caption=Prefs->Translate(_T("File")).c_str();
    M_File_Open_Folder->Caption=(Prefs->Translate(_T("Folder"))+_T("...")).c_str();
    M_File_Close->Caption=Prefs->Translate(_T("Close")).c_str();
    M_File_Close_File->Caption=Prefs->Translate(_T("File")).c_str();
    M_File_Close_All->Caption=Prefs->Translate(_T("All")).c_str();
    M_File_Export->Caption=Prefs->Translate(_T("Export")).c_str();
    M_File_Exit->Caption=Prefs->Translate(_T("Exit")).c_str();
    M_View->Caption=Prefs->Translate(_T("View")).c_str();
    M_View_Easy->Caption=Prefs->Translate(_T("Basic")).c_str();
    M_View_Sheet->Caption=Prefs->Translate(_T("Sheet")).c_str();
    M_View_Tree->Caption=Prefs->Translate(_T("Tree")).c_str();
    M_View_Text->Caption=Prefs->Translate(_T("Text")).c_str();
    M_View_HTML->Caption=Prefs->Translate(_T("HTML")).c_str();
    M_View_Custom->Caption=Prefs->Translate(_T("Custom")).c_str();
    M_View_System->Caption=Prefs->Translate(_T("Your system")).c_str();
    M_Options->Caption=Prefs->Translate(_T("Options")).c_str();
    M_Options_ShowToolBar->Caption=Prefs->Translate(_T("Show toolbar")).c_str();
    M_Options_ShowMenu->Caption=Prefs->Translate(_T("Show menu")).c_str();
    M_Options_CloseAllAuto->Caption=Prefs->Translate(_T("Close all before open")).c_str();
    M_Options_Preferences->Caption=Prefs->Translate(_T("Preferences")).c_str();
    M_Debug->Caption=Prefs->Translate(_T("Debug")).c_str();
    M_Debug_Header->Caption=Prefs->Translate(_T("Header file")).c_str();
    M_Debug_Advanced->Caption=Prefs->Translate(_T("Advanced mode")).c_str();
    M_Help->Caption=Prefs->Translate(_T("Help")).c_str();
    M_Help_About->Caption=Prefs->Translate(_T("About")).c_str();
    M_Help_SupportedFormats->Caption=Prefs->Translate(_T("Known formats")).c_str();
    M_Help_SupportedCodecs->Caption=Prefs->Translate(_T("Known codecs")).c_str();
    M_Help_SupportedParameters->Caption=Prefs->Translate(_T("Known parameters")).c_str();

    //ToolBar
    Tool_File->Hint=Prefs->Translate(_T("File_Hint")).c_str();
    Tool_Folder->Hint=Prefs->Translate(_T("Folder_Hint")).c_str();
    Tool_Export->Hint=Prefs->Translate(_T("Export_Hint")).c_str();
    Tool_Options->Hint=Prefs->Translate(_T("Options_Hint")).c_str();
    Tool_About->Hint=Prefs->Translate(_T("About_Hint")).c_str();
    Tool_View->Hint=Prefs->Translate(_T("View_Hint")).c_str();
    //TODO : Tool_View Hint
    ToolBar_View_Easy->Caption=M_View_Easy->Caption;
    ToolBar_View_Sheet->Caption=M_View_Sheet->Caption;
    ToolBar_View_Tree->Caption=M_View_Tree->Caption;
    ToolBar_View_Text->Caption=M_View_Text->Caption;
    ToolBar_View_HTML->Caption=M_View_HTML->Caption;
    ToolBar_View_Custom->Caption=M_View_Custom->Caption;
    ToolBar_View_System->Caption=M_View_System->Caption;
    ToolBar_View_ShowMenu->Caption=M_Options_ShowMenu->Caption;

    //Main interface
    Page_Easy->Caption=Prefs->Translate(_T("Basic")).c_str();
    Page_Sheet->Caption=Prefs->Translate(_T("Sheet")).c_str();
    Page_Tree->Caption=Prefs->Translate(_T("Tree")).c_str();
    Page_Text->Caption=Prefs->Translate(_T("Text")).c_str();
    Page_HTML->Caption=Prefs->Translate(_T("HTML")).c_str();
    Page_Custom->Caption=Prefs->Translate(_T("Custom")).c_str();
    Page_System->Caption=Prefs->Translate(_T("Your system")).c_str();

    //Easy interface
    Page_Easy_G1_Web->Caption =Prefs->Translate(_T("WebSite_General")).c_str();
    Page_Easy_V1_Web->Caption=Prefs->Translate(_T("WebSite_Video")).c_str();
    Page_Easy_A1_Web->Caption=Prefs->Translate(_T("WebSite_Audio")).c_str();
    Page_Easy_A2_Web->Caption=Prefs->Translate(_T("WebSite_Audio")).c_str();
    Page_Easy_T1_Web->Caption=Prefs->Translate(_T("WebSite_Text")).c_str();
    Page_Easy_T2_Web->Caption=Prefs->Translate(_T("WebSite_Text")).c_str();
    Page_Easy_G1->Caption=Prefs->Translate(_T("Container and general information")).c_str();
    Page_Easy_V1->Caption=Prefs->Translate(_T("Video1")).c_str();
    Page_Easy_A1->Caption=Prefs->Translate(_T("Audio1")).c_str();
    Page_Easy_A2->Caption=Prefs->Translate(_T("Audio2")).c_str();
    Page_Easy_T1->Caption=Prefs->Translate(_T("Text1")).c_str();
    Page_Easy_T2->Caption=Prefs->Translate(_T("Text2")).c_str();
    Page_Easy_T3->Caption=Prefs->Translate(_T("Text3")).c_str();
    Page_Easy_Note->Caption=Prefs->Translate(_T("Basic_Note")).c_str();

    //Sheet interface
    Page_Sheet_G->Hint=Prefs->Translate(_T("Format")).c_str();
    Page_Sheet_V->Hint=Prefs->Translate(_T("Video")).c_str();
    Page_Sheet_A->Hint=Prefs->Translate(_T("Audio")).c_str();
    Page_Sheet_T->Hint=Prefs->Translate(_T("Text")).c_str();
    Page_Sheet_C->Hint=Prefs->Translate(_T("Chapters")).c_str();
    Page_Sheet_Text->Hint=Prefs->Translate(_T("Stream_MoreInfo")).c_str();

    //System interface
    Page_System_Buttons_Video->Caption=Prefs->Translate(_T("Video")).c_str();
    Page_System_Buttons_Audio->Caption=Prefs->Translate(_T("Audio")).c_str();
    Page_System_Buttons_Text->Caption=Prefs->Translate(_T("Text")).c_str();
    Page_System_Sheet->Columns->Items[0]->Caption=Prefs->Translate(_T("SystemId")).c_str();
    Page_System_Sheet->Columns->Items[1]->Caption=Prefs->Translate(_T("Name")).c_str();
    Page_System_Sheet->Columns->Items[2]->Caption=Prefs->Translate(_T("More")).c_str();
    Page_System_Sheet->Columns->Items[3]->Caption=Prefs->Translate(_T("Web")).c_str();
    Page_System_Sheet->Columns->Items[4]->Caption=Prefs->Translate(_T("Supported?")).c_str();

    //Title
    OpenDialog1->Title=Prefs->Translate(_T("Choose files")).c_str();

    //MediaInfo
    I->Option_Static(_T("Language"), Prefs->Details[Language].Read());
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Refresh(TTabSheet *Page)
{
	if (Page==NULL)
		Page=this->Page->ActivePage;

    //Easy
		 if (Page==Page_Easy)
	{
		int ItemIndex_Save=Page_Easy_File->ItemIndex;
        Page_Easy_File->Items->Clear();
		for (int FilePos=0; FilePos<I->Count_Get(); FilePos++)
			Page_Easy_File->Items->Add(I->Get(FilePos, Stream_General, 0, _T("CompleteName")).c_str());
		if (ItemIndex_Save!=-1 && ItemIndex_Save<I->Count_Get())
			Page_Easy_File->ItemIndex=ItemIndex_Save;
		else if (I->Count_Get()>0)
			Page_Easy_File->ItemIndex=0;

		Page_Easy_FileChange(NULL);
	}

    //Sheet
	else if (Page==Page_Sheet)
	{
		if (I->Count_Get())
		{
			//Configure
			Page_Sheet_Sheet->RowCount=1+I->Count_Get();
			Page_Sheet_Sheet->FixedRows=1;
			Page_Sheet_Sheet->ColCount=Prefs->Details[Sheet](_T("ColumnsCount")).To_int32s();
			for (int Pos=0; Pos<Page_Sheet_Sheet->ColCount; Pos++)
			{
				Ztring Z1=_T("Column"); Z1+=Ztring::ToZtring(Pos);
				//Searching kind of stream
				stream_t S;
				ZenLib::Char C=_T('G');
				if (Prefs->Details[Sheet](Z1, 1).size())
					C=Prefs->Details[Sheet](Z1, 1)[0];
				switch (C)
				{
				  case _T('G'): S=Stream_General; break;
				  case _T('V'): S=Stream_Visual; break;
				  case _T('A'): S=Stream_Audio; break;
				  case _T('T'): S=Stream_Text; break;
				  case _T('C'): S=Stream_Chapters; break;
				  default: S=Stream_General;
				}
				Page_Sheet_Sheet->Cells[Pos][0]=I->Get(0, S, Prefs->Details[Sheet](Z1, 2).To_int32u(), Prefs->Details[Sheet](Z1, 3), Info_Name_Text).c_str();
				if (C!=_T('G'))
					Page_Sheet_Sheet->Cells[Pos][0]=WideString((Prefs->Details[Sheet](Z1, 1)+Prefs->Details[Sheet](Z1, 2)).c_str())+WideString(' ')+Page_Sheet_Sheet->Cells[Pos][0];
				FormResize(NULL);
			}
			//Show all available files
			for (int FilePos=0; FilePos<I->Count_Get(); FilePos++)
                for (int Pos=0; Pos<Page_Sheet_Sheet->ColCount; Pos++)
                {
                    Ztring Z1=_T("Column"); Z1+=Ztring::ToZtring(Pos);
                    //Searching Stream kind
                    stream_t S;
                    ZenLib::Char C=_T('G');
                    if (Prefs->Details[Sheet](Z1, 1).size())
                        C=Prefs->Details[Sheet](Z1, 1)[0];
                    switch (C)
                    {
                      case _T('G'): S=Stream_General; break;
                      case _T('V'): S=Stream_Visual; break;
                      case _T('A'): S=Stream_Audio; break;
                      case _T('T'): S=Stream_Text; break;
                      case _T('C'): S=Stream_Chapters; break;
                      default: S=Stream_General;
                    }
                    //Showing
                    Page_Sheet_Sheet->Cells[Pos][1+FilePos]=I->Get(FilePos, S, Prefs->Details[Sheet](Z1, 2).To_int32u(), Prefs->Details[Sheet](Z1, 3)).c_str();
                }
        }
        else
        {
            Page_Sheet_Sheet->RowCount=1;
            Page_Sheet_Sheet->ColCount=1;
			Page_Sheet_Sheet->ColWidths[0]=Page_Sheet_Sheet->ClientWidth;
			Page_Sheet_Sheet->Cells[0][0]=Prefs->Translate(_T("At least one file")).c_str();
            Page_Sheet_G->Text=_T("");
        }
        bool B;
        Page_Sheet_SheetSelectCell(Page_Sheet_Sheet, Page_Sheet_Sheet->Col, Page_Sheet_Sheet->Row, B);
    }

    //Tree
    else if (Page==Page_Tree)
    {
        Page_Tree_Tree->Visible=false;
        Page_Tree_Tree->Items->Clear();
        for (int FilePos=0; FilePos<I->Count_Get(); FilePos++)
        {
            //Pour chaque fichier
            TTntTreeNode* Parent=Page_Tree_Tree->Items->Add(NULL, I->Get(FilePos, Stream_General, 0, _T("CompleteName")).c_str());

            for (stream_t StreamKind=Stream_General; StreamKind<Stream_Max; StreamKind=(stream_t)(StreamKind+1))
            {
                //Pour chaque type de flux
                for (int StreamPos=Stream_General; StreamPos<I->Count_Get(FilePos, StreamKind); StreamPos++)
                {
                    //Pour chaque stream
                    Ztring A=I->Get(FilePos, StreamKind, StreamPos, _T("StreamKind"), Info_Text).c_str();
                    Ztring B=I->Get(FilePos, StreamKind, StreamPos, _T("StreamKindID"), Info_Text).c_str();
                    if (B!=_T(""))
                    {
                        A+=_T(" #");
                        A+=B;
                    }
                    TTntTreeNode* Node=Page_Tree_Tree->Items->AddChild(Parent, A.c_str());
                    for (int Champ_Pos=0; Champ_Pos<I->Count_Get(FilePos, StreamKind, StreamPos); Champ_Pos++)
                    {
                        //Pour chaque champ
                        Ztring A=I->Get(FilePos, StreamKind, StreamPos, Champ_Pos, Info_Text);
                        A+=I->Get(FilePos, StreamKind, StreamPos, Champ_Pos, Info_Measure_Text);
                        if ((I->Option_Static(_T("Complete_Get"))!=_T("") || I->Get(FilePos, StreamKind, StreamPos, Champ_Pos, Info_Options)[InfoOption_ShowInInform]==_T('Y')) && I->Get(FilePos, StreamKind, StreamPos, Champ_Pos, Info_Text)!=_T(""))
                        {
                            //Quoi Refresh?
                            Ztring D=I->Get(FilePos, StreamKind, StreamPos, Champ_Pos, Info_Name_Text);
                            if (D==_T(""))
                                D=I->Get(FilePos, StreamKind, StreamPos, Champ_Pos, Info_Name); //Texte n'existe pas
                            //Affichage
                            Page_Tree_Tree->Items->AddChild(Node, (D + _T(": ") + A.c_str()).c_str());
                        }
                    }
                }
            }
        }
        Page_Tree_Tree->FullExpand();
        Page_Tree_Tree->Visible=true;
    }

    //Text
    else if (Page==Page_Text)
    {
        I->Option_Static(_T("Inform"));
        Page_Text_Text->Text=I->Inform(-1).c_str();
    }

    //HTML
    else if (Page==Page_HTML)
    {
        I->Option_Static(_T("Inform"), _T("HTML"));
        if (I->Count_Get()!=0)
        {
            //Creating file
            wxString S1=I->Inform().c_str();
            wxFile F;
            if (FileName_Temp==_T(""))
            {
                FileName_Temp=wxFileName::CreateTempFileName(_T("MI_"));
                wxRemoveFile(FileName_Temp);
                FileName_Temp+=_T(".html");
            }
            F.Open(FileName_Temp, wxFile::write);
            F.Write(S1, wxConvUTF8);
            F.Close();
            //Navigate
            WideString ToShow=FileName_Temp.c_str();
			Page_HTML_HTML->Navigate((wchar_t*)GUI_Text(ToShow));
        }
        else
            Page_HTML_HTML->Navigate(L"about:blank");
    }

    //Custom
    else if (Page==Page_Custom)
    {
        I->Option_Static(_T("Inform"), Prefs->Details[Custom].Read());
        WideString S1=I->Inform().c_str();
        if (S1.Length()>0 && S1[1]=='<')
        {
            //Supposing this is HTML
            //Creating file
            wxFile F;
            if (FileName_Temp==_T(""))
            {
                FileName_Temp=wxFileName::CreateTempFileName(_T("MI_"));
                wxRemoveFile(FileName_Temp);
                FileName_Temp+=_T(".html");
            }
            F.Open(FileName_Temp, wxFile::write);
            F.Write(S1.c_bstr(), wxConvUTF8);
            F.Close();
            //Navigate
            WideString ToShow=FileName_Temp.c_str();
			Page_Custom_HTML->Navigate((wchar_t*)GUI_Text(ToShow));
            Page_Custom_Text->Visible=false;
            Page_Custom_HTML->Visible=true;
            FormResize(NULL);
        }
        else
        {
            //Text
            Page_Custom_Text->Text=S1;
            Page_Custom_Text->Visible=true;
            Page_Custom_HTML->Visible=false;
        }
    }

    //System
    else if (Page==Page_System)
    {
        if (!Page_System_Already)
        {
            //Know codecs
            ZtringListList ListT=I->Option_Static(_T("Info_Codecs")).c_str();
            ZtringListList List; //TODO : replace by Ztring::Delete1
            for (size_t Pos=0; Pos<ListT.size(); Pos++)
            {
                List(Pos, 0)=ListT(Pos, 0);
                List(Pos, 1)=ListT(Pos, 1);
                List(Pos, 2)=ListT(Pos, 6);
                List(Pos, 3)=ListT(Pos, 7);
                if (ListT(Pos, 2)==_T("2CC"))
                {
                    //Format 2CC
                    while (List(Pos, 0).size()<4)
                        List(Pos, 0)=Ztring(_T("0"))+List(Pos, 0);
                }
            }
            bool Audio=false;
            bool Subtitle=false;
            for (size_t I=0; I<List.size(); I++)
            {
                if (List(I, 0)==_T("0000"))
                    Audio=true;
                if (List(I, 0)==_T("S_TEXT/UTF8"))
                    Subtitle=true;
                if (Subtitle)
                    Page_System_Text.push_back(List.Read(I));
                else if (Audio)
                    Page_System_Audio.push_back(List.Read(I));
                else
                    Page_System_Video.push_back(List.Read(I));
            }

            //enumerate codecs in system
			Codecs_Enumerate(Page_System_Video, Page_System_Audio);

            //MAJ
            Page_System_Buttons_VideoClick(NULL);
            Page_System_Already=true;
        }
    }

    //Form title
    Ztring Title=GUI_Text(Caption);
    Title=Title.SubString(_T(""), _T(" - "));
         if (I->Count_Get()==0)
        //0 fichier
        Caption=MEDIAINFO_TITLE;
    else if (I->Count_Get()==1)
        //un fichier
        Caption=(Title+_T(" - ")+I->Get(0, Stream_General, 0, _T("CompleteName"))).c_str();
    else
        //Plusieurs selections
        Caption=(Title+_T(" - ")+Prefs->Translate(Ztring::ToZtring(I->Count_Get()), _T(" file"))).c_str();

    //Configure Default options
    if (I->Count_Get()!=0)
    {
        M_File_Close->Visible=true;
        M_File_Close_File->Visible=true;
        M_File_Close_All->Visible=true;
        M_File_Export->Visible=true;
        Tool_Export->Enabled=true;
        if (Page==Page_Easy || Page==Page_Sheet)
            M_File_Close_File->Visible=true;
        else
            M_File_Close_File->Visible=false;
    }
    else
    {
        M_File_Close->Visible=false;
        M_File_Close_File->Visible=false;
        M_File_Close_All->Visible=false;
        M_File_Export->Visible=false;
        Tool_Export->Enabled=false;
    }
}

//***************************************************************************
// GUI - Menu
//***************************************************************************

//---------------------------------------------------------------------------
void __fastcall TMainF::M_File_Open_FileClick(TObject *Sender)
{
	if (!OpenDialog1->Execute())
		return;

	if (M_Options_CloseAllAuto->Checked)
		M_File_Close_AllClick(Sender);

	//Retrieving filenames, manage them
	if (OpenDialog1->Files->Count==1)
		//un fichier
		I->Open(GUI_Text(OpenDialog1->FileName));
	else
		//Plusieurs selections
		for (int I1=0; I1<OpenDialog1->Files->Count; I1++)
				I->Open(GUI_Text(OpenDialog1->Files->Strings[I1]));

	Refresh();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_File_Open_FolderClick(TObject *Sender)
{
    Ztring S1=ShowOpenFolder();

    if (S1!=_T(""))
    {
        // First we clear the list
        if (M_Options_CloseAllAuto->Checked)
            M_File_Close_AllClick(Sender);

        I->Open(S1, FileOption_Recursive);
        Refresh();
	}
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_File_Close_FileClick(TObject *Sender)
{
    size_t Position=-1;
    if (Page->ActivePage==Page_Easy)
        Position=Page_Easy_File->ItemIndex;

    if (Page->ActivePage==Page_Sheet)
        Position=Page_Sheet_Sheet->Row-1;

    if (Position==-1)
        return;

    I->Close(Position);
	Refresh();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_File_Close_AllClick(TObject *Sender)
{
    I->Close(-1);
	Refresh();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Help_SupportedParametersClick(TObject *Sender)
{
    Page_Custom_Text->Visible=true;
    Page_Custom_HTML->Visible=false;
    Page->ActivePage=Page_Custom;
    FormResize(Sender);
	Page_Custom_Text->Text=I->Option_Static(_T("Info_Parameters")).c_str();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_File_ExportClick(TObject *Sender)
{
	Ztring Name;
    if (!ExportF)
    {
        ExportF=new TExportF(this);
    }
    if (ExportF->Name->Text.Length()==0)
    {
        //No initial name
        if (OpenDialog1->InitialDir.Length()==0)
        {
            Name=Prefs->BaseFolder;
            Name.resize(Name.size()-1);
            Name=Name.substr(0, Name.rfind(_T("\\"))+1); //Folder of MediaInfo
        }
        else
            Name=GUI_Text(OpenDialog1->InitialDir);
    }

	ExportF->Run(*I, Name);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_File_ExitClick(TObject *Sender)
{
	Close();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_View_EasyClick(TObject *Sender)
{
    M_View_Easy->Checked=true;
    ToolBar_View_Easy->Checked=true;
    ChangePage(Page_Easy);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_View_SheetClick(TObject *Sender)
{
    M_View_Sheet->Checked=true;
    ToolBar_View_Sheet->Checked=true;
	ChangePage(Page_Sheet);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_View_TreeClick(TObject *Sender)
{
    M_View_Tree->Checked=true;
    ToolBar_View_Tree->Checked=true;
    ChangePage(Page_Tree);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_View_TextClick(TObject *Sender)
{
    M_View_Text->Checked=true;
    ToolBar_View_Text->Checked=true;
    ChangePage(Page_Text);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_View_HTMLClick(TObject *Sender)
{
    M_View_HTML->Checked=true;
    ToolBar_View_HTML->Checked=true;
    ChangePage(Page_HTML);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_View_CustomClick(TObject *Sender)
{
    M_View_Custom->Checked=true;
    ToolBar_View_Custom->Checked=true;
    ChangePage(Page_Custom);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_View_SystemClick(TObject *Sender)
{
    ChangePage(Page_System);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Options_ShowToolBarClick(TObject *Sender)
{
	if (M_Options_ShowToolBar->Checked)
		ToolBar->Visible=true;
	else
		ToolBar->Visible=false;

	FormResize(Sender);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Options_ShowMenuClick(TObject *Sender)
{
    //ToolBar
    if (Sender==ToolBar_View_ShowMenu)
        M_Options_ShowMenu->Checked=!M_Options_ShowMenu->Checked;

	int Height_Save=ClientHeight; //To have the same client heigth with or without menu

	bool Visible=false;
	if (M_Options_ShowMenu->Checked)
		Visible=true;

	for (int Pos=MainMenu->Items->Count-1; Pos>=0; Pos--)
		MainMenu->Items->Items[Pos]->Visible=Visible;
	ToolBar_View_ShowMenu->Visible=!Visible;

	if (!M_Options_ShowToolBar->Checked)
	{
		M_Options_ShowToolBar->Checked=true;
		M_Options_ShowToolBarClick(NULL);
	}

    ClientHeight=Height_Save;
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Options_PreferencesClick(TObject *Sender)
{
	TPreferencesF* PreferencesF=new TPreferencesF(this);
    PreferencesF->ShowModal();
    delete PreferencesF;

    GUI_Configure();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Debug_HeaderClick(TObject *Sender)
{
	if (!OpenDialog1->Execute())
        return;
    Debug_Header_Create(GUI_Text(OpenDialog1->FileName), Handle);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Help_AboutClick(TObject *Sender)
{
	TAboutF* A=new TAboutF(this);
	A->ShowModal();
	delete A;
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Debug_AdvancedClick(TObject *Sender)
{
    if (I->Option_Static(_T("Complete_Get"))!=_T(""))
    {
        I->Option_Static(_T("Complete"));
        M_Debug_Advanced->Checked=false;
        M_Debug_Avanced_More->Visible=false;
    }
    else
    {
        I->Option_Static(_T("Complete"), _T("1"));
        M_Debug_Advanced->Checked=true;
        M_Debug_Avanced_More->Visible=true;
    }

    Refresh();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Debug_DummyClick(TObject *Sender)
{
    I->Option(_T("Create_Dummy"));
    Refresh();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Debug_Dummy_MovieClick(TObject *Sender)
{
    I->Option(_T("Create_Dummy"), _T("Movie"));
    Refresh();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Help_SupportedCodecsClick(TObject *Sender)
{
    Page_Custom_Text->Visible=true;
    Page_Custom_HTML->Visible=false;
    Page->ActivePage=Page_Custom;
    FormResize(Sender);

    Page_Custom_Text->Text=I->Option_Static(_T("Info_Codecs")).c_str();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_Help_SupportedFormatsClick(TObject *Sender)
{
    Page_Custom_Text->Visible=true;
    Page_Custom_HTML->Visible=false;
    Page->ActivePage=Page_Custom;
    FormResize(Sender);

	Page_Custom_Text->Text=I->Option_Static(_T("Info_Capacities")).c_str();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::M_LanguageClick(TObject *Sender)
{
    TTntMenuItem* Menu=(TTntMenuItem*)Sender;
    Ztring Title=GUI_Text(Menu->Caption);
    Title.FindAndReplace(_T("&"), _T("")); //BCB adds a "&" in menus

    //Special case : Languages, should show the name of language in the local version
    size_t Language_Pos=Prefs->FilesList[Language_List].Find(Title);
    if (Language_Pos==(size_t)-1)
        return;
    Title=Prefs->FilesList[Language](Language_Pos);

    //Load
    Prefs->Load(Language, Title);
	Translate();
}

//***************************************************************************
// GUI - User actions
//***************************************************************************

//---------------------------------------------------------------------------
void __fastcall TMainF::ChangePage(TTabSheet *Page)
{
    Refresh(Page);
    this->Page->ActivePage=Page;
    FormResize(NULL);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_Easy_FileChange(TObject *Sender)
{
    Page_Position=Page_Easy_File->ItemIndex;
    if (Page_Position<0)
        Page_Position=0;

    I->Option(_T("Inform"), _T("Summary"));
    for (int KindOfStream=0; KindOfStream<Stream_Max; KindOfStream++)
    {
        //Inform
        for (int StreamPos=0; StreamPos<EASY_STREAM_MAX; StreamPos++)
        {
            if (Page_Easy_X_Codec[KindOfStream][StreamPos])
            {
                //Main
                Page_Easy_X_Codec[KindOfStream][StreamPos]->Caption=I->Get(Page_Position, (stream_t)KindOfStream, StreamPos, _T("Inform")).c_str();
                if (Page_Easy_File->ItemIndex!=-1) //To avoid refresh on the first GUI show
                    Page_Easy_X[KindOfStream][StreamPos]->Visible=Page_Easy_X_Codec[KindOfStream][StreamPos]->Caption.Length();
                //Web
                Page_Easy_X_Web_Url[KindOfStream][StreamPos]=I->Get(Page_Position, (stream_t)KindOfStream, StreamPos, _T("Codec/Url")).c_str();
                Page_Easy_X_Web[KindOfStream][StreamPos]->Visible=Page_Easy_X_Web_Url[KindOfStream][StreamPos].size();
            }
        }
        //List
        if (Page_Easy_X_List[KindOfStream] && KindOfStream!=Stream_General)
        {
            if (I->Get(Page_Position, (stream_t)KindOfStream, 0, _T("StreamKind")).size()>0)
            {
                Ztring Z1=Ztring(I->Get(Page_Position, (stream_t)KindOfStream, 0, _T("StreamKind"), Info_Measure)+_T("Count"));
                Ztring Z2=Ztring(_T(" "))+I->Get(Page_Position, (stream_t)KindOfStream, 0, _T("StreamKind"), Info_Measure);
                Z2.MakeLowerCase();
                Z2+=_T(" stream");
                Ztring Z3=Ztring(I->Get(Page_Position, (stream_t)KindOfStream, 0, _T("StreamKind"), Info_Measure)+_T("_Codec_List"));
                if (KindOfStream!=Stream_Chapters)
                    Page_Easy_X_List[KindOfStream]->Caption=(Prefs->Translate(I->Get(Page_Position, Stream_General, 0, Z1), Z2)+Prefs->Translate(_T(": "))+I->Get(Page_Easy_File->ItemIndex, Stream_General, 0, Z3)).c_str();
                else //Exception : chapters have no codec
                    Page_Easy_X_List[KindOfStream]->Caption=(Prefs->Translate(I->Get(Page_Position, Stream_General, 0, Z1), Z2)).c_str();
            }
            else
                Page_Easy_X_List[KindOfStream]->Caption=_T("");
        }
    }

    //Tag
    for (int Tag_Pos=0; Tag_Pos<EASY_TAG_MAX; Tag_Pos++)
        if (Page_Easy_X_Tag[Tag_Pos])
            Page_Easy_X_Tag[Tag_Pos]->Visible=false;
    int Tag_Pos=0;
    int MI_Pos=42; //Should begin with "Title"
    while(MI_Pos<I->Count_Get(Page_Position, Stream_General, 0))
    {
        Ztring Z1=I->Get(Page_Position, Stream_General, 0, MI_Pos);
        Ztring Options=I->Get(Page_Position, Stream_General, 0, MI_Pos, Info_Options);
        if (Options.size()>InfoOption_ShowInInform && Options[InfoOption_ShowInInform]==_T('Y') && Z1.size()>0)
        {
            Ztring Z2=I->Get(Page_Position, Stream_General, 0, MI_Pos, Info_Name_Text);
            if (Z2.size()==0)
                Z2=I->Get(Page_Position, Stream_General, 0, MI_Pos, Info_Name);
            Z2+=Prefs->Translate(_T(": "));
            Z2+=Z1;
            if (Tag_Pos<EASY_TAG_MAX)
            {
                Page_Easy_X_Tag[Tag_Pos]->Caption=Z2.c_str();
                Page_Easy_X_Tag[Tag_Pos]->Visible=true;
            }
            Tag_Pos++;
        }
        MI_Pos++;
	}
    FormResize(NULL); //Resize GroupBoxes
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_Easy_WebClick(TObject *Sender)
{
    //Find KindOfStream and StreamPos
    size_t KindOfStream=0;
    size_t StreamPos=0;
    while (Page_Easy_X_Web[KindOfStream][StreamPos]!=Sender)
    {
        KindOfStream++;
        if (KindOfStream>=Stream_Max)
        {
            StreamPos++;
            KindOfStream=0;
        }
    }

    ShellExecute(NULL, _T("open"), Page_Easy_X_Web_Url[KindOfStream][StreamPos].c_str(), NULL, NULL, 0);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_Easy_DifferentViewClick(TObject *Sender)
{
	ToolBar_View_Menu->Popup(Left+Page->Left+Page_Easy->Left+Page_Easy_DifferentView->Left, Top+Page->Top+Page_Easy->Top+Page_Easy_DifferentView->Top+Page_Easy_DifferentView->Height);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_Sheet_SheetSelectCell(TObject *Sender, int ACol,
      int ARow, bool &CanSelect)
{
    Page_Position=ARow-1;

    for (int KindOfStream=0; KindOfStream<Stream_Max; KindOfStream++)
    {
        int Stream_Count=I->Count_Get(Page_Position, (stream_t)KindOfStream);
        if (Stream_Count==0 || Stream_Count==-1)
        {
            Page_Sheet_X[KindOfStream]->Enabled=false;
            Page_Sheet_X[KindOfStream]->Style=csSimple;
            Page_Sheet_X[KindOfStream]->Text=_T("");
            Page_Sheet_X[KindOfStream]->Enabled=false;
        }
        else if (Stream_Count==1)
        {
			Page_Sheet_X[KindOfStream]->Style=Stdctrls::csDropDownList;
            Page_Sheet_X[KindOfStream]->Items->Clear();
            I->Option(_T("Inform"), _T("Summary"));
            Page_Sheet_X[KindOfStream]->Items->Add(I->Get(Page_Position, (stream_t)KindOfStream, 0, _T("Inform")).c_str());
            Page_Sheet_X[KindOfStream]->ItemIndex=0;
            Page_Sheet_X[KindOfStream]->Enabled=true;
        }
        else
        {
            Page_Sheet_X[KindOfStream]->Style=Stdctrls::csDropDownList;
            Page_Sheet_X[KindOfStream]->Items->Clear();
            I->Option(_T("Inform"), _T("Summary"));
            Ztring Z1=Ztring(I->Get(Page_Position, (stream_t)KindOfStream, 0, _T("StreamKind"), Info_Measure)+_T("Count"));
            Ztring Z2=Ztring(_T(" "))+I->Get(Page_Position, (stream_t)KindOfStream, 0, _T("StreamKind"), Info_Measure)+_T(" streams"); Z2.MakeLowerCase();
            Page_Sheet_X[KindOfStream]->Items->Add((I->Get(Page_Position, Stream_General, 0, Z1.c_str())+Prefs->Translate(Z2)+Prefs->Translate(_T(", "))+Prefs->Translate(_T("see below"))).c_str());
            for (int A=0; A<Stream_Count; A++)
                Page_Sheet_X[KindOfStream]->Items->Add(I->Get(Page_Position, (stream_t)KindOfStream, A, _T("Inform")).c_str());
            Page_Sheet_X[KindOfStream]->ItemIndex=0;
            Page_Sheet_X[KindOfStream]->Enabled=true;
        }
		Page_Sheet_Change(Page_Sheet_X[KindOfStream]);
    }

    //Show General first
	Page_Sheet_Change(Page_Sheet_G);

    //Menu
    M_File_Close_File->Enabled=true;
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_Sheet_Change(TObject *Sender)
{
    //Find KindOfStream
    size_t KindOfStream=0;
    while (Page_Sheet_X[KindOfStream]!=Sender)
        KindOfStream++;

    if (Page_Position<0)
        return;

    //Get Stream Page_Position
    int I1;
    if (Page_Sheet_X[KindOfStream]->Items->Count==1)
        I1=0;
    else
        I1=Page_Sheet_X[KindOfStream]->ItemIndex-1;

    //Fill info
    Ztring Type;
    if (KindOfStream==Stream_General)
        Type=_T("Format");
    else
        Type=_T("Codec");
    Page_Sheet_X[KindOfStream]->Hint=I->Get(Page_Position, (stream_t)KindOfStream, I1, Type+_T("/Info")).c_str();
    Page_Sheet_X_Web_Url[KindOfStream]=I->Get(Page_Position, (stream_t)KindOfStream, I1, Type+_T("/Url")).c_str();
    if (Page_Sheet_X_Web_Url[KindOfStream]==_T(""))
    {
        Page_Sheet_X_Web[KindOfStream]->Enabled=false;
        Page_Sheet_X_Web[KindOfStream]->Hint=_T("");
    }
    else
    {
        Page_Sheet_X_Web[KindOfStream]->Enabled=true;
        Ztring Z1=Ztring(_T("WebSite_"))+I->Get(Page_Position, (stream_t)KindOfStream, 0, _T("StreamKind"))+_T("_More");
        Z1=Prefs->Translate(Z1);
        Z1.FindAndReplace(_T("%Url%"), Page_Sheet_X_Web_Url[KindOfStream]);
        Page_Sheet_X_Web[KindOfStream]->Hint=Z1.c_str();
    }

    I->Option(_T("Inform"), _T(""));
    Page_Sheet_Text->Text=I->Get(Page_Position, (stream_t)KindOfStream, I1, _T("Inform")).c_str();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_Sheet_WebClick(TObject *Sender)
{
    //Find KindOfStream
    size_t KindOfStream=0;
    while (Page_Sheet_X_Web[KindOfStream]!=Sender)
        KindOfStream++;

    ShellExecute(NULL, _T("open"), Page_Sheet_X_Web_Url[KindOfStream].c_str(), NULL, NULL, 0);
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_System_Buttons_VideoClick(TObject *Sender)
{
    Page_System_Sheet_ColumnToSort=0;
    Page_System_Sheet->Clear();
    for (size_t count=0; count<Page_System_Video.size(); count++)
    {
        TListItem* Parent=Page_System_Sheet->Items->Add();
        Parent->Caption=Page_System_Video(count, 0).c_str();
        Parent->SubItems->Add(Page_System_Video(count, 1).c_str());
        Parent->SubItems->Add(Page_System_Video(count, 2).c_str());
        Parent->SubItems->Add(Page_System_Video(count, 3).c_str());
        Parent->SubItems->Add(Page_System_Video(count, 4).c_str());
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_System_Buttons_AudioClick(TObject *Sender)
{
    Page_System_Sheet_ColumnToSort=0;
    Page_System_Sheet->Clear();
    for (size_t count=0; count<Page_System_Audio.size(); count++)
    {
        TListItem* Parent=Page_System_Sheet->Items->Add();
        Parent->Caption=Page_System_Audio(count, 0).c_str();
        Parent->SubItems->Add(Page_System_Audio(count, 1).c_str());
        Parent->SubItems->Add(Page_System_Audio(count, 2).c_str());
        Parent->SubItems->Add(Page_System_Audio(count, 3).c_str());
        Parent->SubItems->Add(Page_System_Audio(count, 4).c_str());
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_System_Buttons_TextClick(TObject *Sender)
{
    Page_System_Sheet_ColumnToSort=0;
    Page_System_Sheet->Clear();
    for (size_t count=0; count<Page_System_Text.size(); count++)
    {
        TListItem* Parent=Page_System_Sheet->Items->Add();
        Parent->Caption=Page_System_Text(count, 0).c_str();
        Parent->SubItems->Add(Page_System_Text(count, 1).c_str());
        Parent->SubItems->Add(Page_System_Text(count, 2).c_str());
        Parent->SubItems->Add(Page_System_Text(count, 3).c_str());
        Parent->SubItems->Add(Page_System_Text(count, 4).c_str());
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_System_SheetColumnClick(TObject *Sender,
      TListColumn *Column)
{
    Page_System_Sheet_ColumnToSort = Column->Index;
    ((TCustomListView *)Sender)->AlphaSort();
}

//---------------------------------------------------------------------------
void __fastcall TMainF::Page_System_SheetCompare(TObject *Sender,
      TListItem *Item1, TListItem *Item2, int Data, int &Compare)
{
    if (Page_System_Sheet_ColumnToSort == 0)
        Compare = CompareText(Item1->Caption, Item2->Caption);
    else
		Compare = CompareText(Item1->SubItems->Strings[Page_System_Sheet_ColumnToSort-1], Item2->SubItems->Strings[Page_System_Sheet_ColumnToSort-1]);
}

//***************************************************************************
// System
//***************************************************************************

//---------------------------------------------------------------------------
MESSAGE void __fastcall TMainF::HandleDropFiles (TMessage& Msg)
{
    //Clear the existing filelist
    if (M_Options_CloseAllAuto->Checked)
        M_File_Close_AllClick(NULL);

	//Retrieving infos
    ZenLib::Char File[65536];
	HDROP hDrop=(HDROP)Msg.WParam;
    int	NbFiles=DragQueryFile(hDrop, -1, NULL, 0);
    for (int i=0; i<NbFiles; i++)
    {
    	DragQueryFile(hDrop, i, File, 65536-1);
        I->Open(File, FileOption_Recursive);
	}
    DragFinish (hDrop);

    Refresh();
}

//---------------------------------------------------------------------------


