// Main - Mains functions
// Copyright (C) 2002-2005 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Main functions
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// 2005-12-01, Zen@MediaArea.net
// Init of file
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#include "Common/Core.h"
#include "MediaInfo/MediaInfoList.h"
#include <wx/file.h>
#include <wx/filename.h>
using namespace MediaInfoLib;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
Core::Core()
{
    MI=new MediaInfoList;
}

Core::~Core()
{
    delete MI;
}

//---------------------------------------------------------------------------
void Core::Files_Open (const wxArrayString& FileNames)
{
    //Analyse
    MI->Close(-1);
    MI->Open(FileNames[0].c_str()); //Only one to begin

    //Creating file
    MI->Option(_T("Inform"), _T("HTML"));
    wxString S1=MI->Inform((size_t)-1).c_str();
    wxFile F;
    if (TempFile==_T(""))
    {
        TempFile=wxFileName::CreateTempFileName(_T("MI_"));
        wxRemoveFile(TempFile);
        TempFile+=_T(".html");
    }
    F.Open(TempFile, wxFile::write);
    F.Write(S1, wxConvUTF8);
    F.Close();
}

//---------------------------------------------------------------------------
wxString& Core::TempFile_Get ()
{
    return TempFile;
}
