#include <iostream>
#include <string>
#include <vector>
#include "ZenLib/Ztring.h"
#include "MediaInfo/MediaInfoList.h"

using namespace std;
using namespace MediaInfoLib;
using namespace ZenLib;

int main(int argc, char* argv[])
{
    MediaInfoList I;

    //gestion Full
    int DoNotAnalyse_Pos=0;
    int Raw_Pos=0;
    for (int Pos=1; Pos<argc; Pos++)
    {
        if (std::string(argv[Pos])=="-f")
        {
            DoNotAnalyse_Pos = Pos;
            I.Option(_T("Complete"), _T("1"));
        }
		if (std::string(argv[Pos]).substr(0, 6)=="-lang=")
        {
			Raw_Pos = Pos;
			Ztring Language; Language.From_Local(argv[Pos]);
			Language.FindAndReplace(_T("-lang="), _T("")); 
			Language.MakeLowerCase();
			I.Option(_T("Language"), Language);
        }
    }

    //recuperation des nom
    vector<string> Liste;
    if ((DoNotAnalyse_Pos==0 && argc<=1) || (DoNotAnalyse_Pos>0 && argc<=2))
    {
        cout<<"MediaInfo Command line v0.7.2.1\r\n"
			  "Usage : \"MediaInfo [-f] [-raw] FileName1 [Filename2...]\",\r\n"
			  "\r\n"
			  "options :\r\n"
			  "-f for full information\r\n"
			  "-lang=raw for non-translated words (internal text)\r\n"
			  "\r\n"
			  "Enter one FileName : ";
        char C2[10000];
        cin.getline(C2, 10000-1);
        Liste.push_back(C2);
    }
    else
    {
        for (int Pos=1; Pos<argc; Pos++)
            if (Pos!=DoNotAnalyse_Pos && Pos!=Raw_Pos)
                Liste.push_back(argv[Pos]);
    }

    for (unsigned int Pos=0; Pos<Liste.size(); Pos++)
        I.Open(Ztring().From_Local(Liste[Pos]));
    cout<<Ztring(I.Inform()).To_Local();

    cout<<"using ";
    cout<<Ztring(I.Option(_T("Info_Version"))).To_Local()<<endl;
    //cin>>DoNotAnalyse_Pos;
    return 0;
}
//---------------------------------------------------------------------------

