// MediaInfoShlExt_.cpp : Implementation of CMediaInfoShlExt_
#include "stdafx.h"
#include "MediaInfoShellExt_.h"
#ifdef MEDIAINFOLIB
	#include "MediaInfo/MediaInfo.h"
#else
	#include "MediaInfoDLL/MediaInfoDLL.h"
#endif

// CMediaInfoShlExt_
HRESULT CMediaInfoShellExt_::Load (LPCOLESTR wszFilename, DWORD)
{
    //Save FileName
    FileName = wszFilename;

    //OK
	return S_OK;
}

HRESULT CMediaInfoShellExt_::GetInfoTip (DWORD, LPWSTR* ppwszTip)
{
    //Get an IMalloc interface from the shell.
    LPMALLOC Malloc;
    if (FAILED(SHGetMalloc(&Malloc)))
        return E_FAIL;

    //Configure MediaInfo
	MediaInfoLib::MediaInfo I;
	I.Option(_T("Inform"), _T("General;[%Format%$: $]%FileSize/String%[, %PlayTime/String%]\\r\\n")
						   _T("[Movie name: %Movie%\\r\\n]")
						   _T("[Album name: %Album%\\r\\n]")
						   _T("[Performer: %Artist%\\r\\n]")
						   _T("[Director: %Director%\\r\\n]")
						   _T("[Encoded date: %Date_Encoded%\\r\\n]")
						   _T("[Copyright: %Copyright%\\r\\n]")
						   _T("[Comment: %Comment%\\r\\n]")
						   _T("\r\n")
						   _T("Video;Video: [%Language/String%, ][%BitRate/String%, ][%Width%*][%Height%][ (%AspectRatio/String%),][ $at$ %FrameRate/String%, ][%Codec/String%][ (%Standard%)]\\r\\n\r\n")
						   _T("Audio;Audio: [%Language/String%, ][%BitRate/String%, ][%SamplingRate/String%, ][%Channel(s)/String%, ][%Codec/String%]\\r\\n\r\n")
						   _T("Text;Subtitle: [%Language/String%, ][%Codec/String%]\\r\\n\r\n")
						   _T("Chapters;Chapters: [%Language/String%, ]%Total% chapters[, %Codec/String%]\\r\\n\r\n")
						   );
	
	//Creating tooltip
    std::wstring ToolTip;
	I.Open(FileName);
	ToolTip+=I.Inform();
	ToolTip+=_T("-- MediaInfo (http://mediainfo.sourceforge.net) --");
	
	//Delete the line feed at the end
	if (ToolTip.size()>2 && ToolTip[ToolTip.size()-2]==_T('\r'))
		ToolTip.resize(ToolTip.size()-2);

    //Allocate a buffer for Explorer.  Note that the must pass the string 
    //back as a Unicode string, so the string length is multiplied by the 
    //size of a Unicode character.
    *ppwszTip=(LPWSTR)Malloc->Alloc((ToolTip.size()+1)*sizeof(wchar_t));

    //Release the IMalloc interface now that we're done using it.
    Malloc->Release();

    //Enough memory?
	if (*ppwszTip==NULL)
        return E_OUTOFMEMORY;

    //Use the Unicode string copy function to put the tooltip text in the buffer.
    wcscpy_s(*ppwszTip, ToolTip.size()+1, T2COLE(ToolTip.c_str()));

    //OK
	return S_OK;
}