//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <wx/file.h>
#include <ZenLib/ZtringListListF.h>
#include "PreRelease/Ressources.h"
using namespace ZenLib;
using namespace std;
#define FILE_MAX 20000
//---------------------------------------------------------------------------

ZenLib::Ztring Ressources_Create_Load(Ztring FileName, Ztring &Contents)
{
    wxFile F;
    if (F.Open(FileName.c_str(), wxFile::read)==false)
    {
        Ztring ToReturn=L"Problems to open ";
        ToReturn+=FileName;
        ToReturn+=L"\r\n";
        return ToReturn;
    }

    char C[FILE_MAX];
    size_t Size=F.Read(C, FILE_MAX-1);
    Contents.From_Local(C, Size);
    return L"";
}

ZenLib::Ztring Ressources_Create_Save(Ztring FileName, Ztring &Contents)
{
    wxFile F;
    if (F.Create(FileName.c_str(), true)==false)
    {
        Ztring ToReturn=L"Problems to create ";
        ToReturn+=FileName;
        ToReturn+=L"\r\n";
        return ToReturn;
    }

    //size_t Size=F.Write(Contents.To_Local().c_str(), Contents.size());
    //Contents.From_Number(Size);
    Contents+=L" bytes writen\r\n";
    return L"";
}

ZenLib::Ztring Ressources_Create_Item(Ztring Name, Ztring &Contents)
{
    Contents.resize(0);
    Ztring Result;

    Ztring Partial;
    Result=Ressources_Create_Load(L"../Source/Ressource/Text/_.2.txt", Partial);
    if (Result.size()>0)
        return Result;

    Ztring Line;
    Result=Ressources_Create_Load(L"../Source/Ressource/Text/_.5.txt", Line);
    if (Result.size()>0)
        return Result;
    Partial.FindAndReplace(L"%Name%", Name);
    Contents+=Partial;

    ZtringListListF ZLL;
    ZLL.Load(Ztring(L"../Source/Ressource/Text/")+Name+L".csv");

    for (size_t Pos=0; Pos<ZLL.size(); Pos++)
    {
        Ztring Line_Temp=Line;
        Line_Temp.FindAndReplace(L"%Line%", ZLL.Read(Pos));
        Contents+=Line_Temp;
    }

    Result=Ressources_Create_Load(L"../Source/Ressource/Text/_.8.txt", Partial);
    if (Result.size()>0)
        return Result;
    Contents+=Partial;

    return L"";
}

ZenLib::Ztring Ressources_Create()
{
    Ztring ToReturn;
    Ztring Out;
    Ztring Result;
    Ztring Contents;

    Result=Ressources_Create_Load(L"../Source/Ressource/Text/_.1.txt", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_CustomLanguage", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_Format", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_Codec", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_General", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_Video", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_Audio", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_Text", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_Chapters", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_Iso639", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_Encoder", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Item(L"File__Base_Summary", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Load(L"../Source/Ressource/Text/_.9.txt", Contents);
    if (Result.size()>0)
        return Result;
    Out+=Contents;

    Result=Ressources_Create_Save(L"../Source/MediaInfo/File__Base_Automatic.cpp", Out);
    if (Result.size()>0)
        return Result;

    ToReturn+=Out;
    return ToReturn;

}
//---------------------------------------------------------------------------

