// File_Mpegv - Info for MPEG Video files
// Copyright (C) 2004-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about MPEG Video files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#ifndef MediaInfo_MpegvH
#define MediaInfo_MpegvH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/File__Base.h"
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Class File_Mpegv
//***************************************************************************

class File_Mpegv : public File__Base
{
protected :
    //Theses classes need access to internal structure for optimization. There is recursivity with theses formats
    friend class File_Mpeg;

    //Formats
    int Read  (const int8u* Begin, size_t Begin_Size, const int8u* End=NULL, size_t End_Size=0, int64u FileSize=0);

    //Information
    void HowTo (stream_t StreamKind);

public :
    int MPEG_Version;
    File_Mpegv() {MPEG_Version=0;}; //Unknown version is default

private :
    //Buffer
    const int8u* Begin;
    size_t Begin_Size;
    const int8u* End;
    size_t End_Size;
    size_t Offset;
	bool ShouldStop; //Offset is too far, should stop analyse
	bool Corrupted; //Bytes are not aligned

    //Size of a Packet
    size_t Offset_Next;
    size_t Size;

    //Temp
    size_t Library_Offset;
    size_t Library_Size;
    size_t MPEG_Time_Seconds;
    size_t MPEG_Time_Frames;
    size_t Width;
    size_t Height;
    size_t Chroma;
    size_t Standard;
    size_t PictureStructure;
    size_t RatioValue;
    size_t FrameRate;
    size_t BitRate;
    size_t Profile;
    size_t Level;

    //Packets
    void Picture_Start();
    void Slice_Start();
    void User_Start();
    void Sequence_Header();
    void Sequence_Error();
    void Extension_Start();
    void Sequence_End();
    void Group_Start(const int8u* Begin);
    void System_Start();
};

} //NameSpace

#endif
