// File_Wm - Info for Windows Media files
// Copyright (C) 2002-2003 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_WM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_WM_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <ZenLib/ZtringListList.h>
#include <ZenLib/Utils.h>
#include "MediaInfo/Multiple/File_Wm.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

//---------------------------------------------------------------------------
int File_Wm::Read (const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    if (Begin_Size<128)
        return -1;

    size_t Offset=0; //Offset debut
    int32u* BeginInt;

    //Format
    BeginInt=(int32u*)Begin;
    while (Offset<=Begin_Size-128 && !(BeginInt[0]==0x75B22630 && BeginInt[1]==0x11CF668E && BeginInt[2]==0xAA00D9A6 && BeginInt[3]==0x6CCE6200))
    {
        Offset++;
        BeginInt=(int32u*)(Begin+Offset);
    }
    if (Offset>Begin_Size-128)
        return -1;

    Stream_Prepare(Stream_General);
    General[0](_T("Format"))=_T("WM");
    General[0](_T("Format/String"))=_T("Windows Media");
    General[0](_T("Format/Extensions"))=_T("ASF WMA WMV");

    //Play time
    Offset=0;
    BeginInt=(int32u*)Begin;
    while (Offset<=Begin_Size-4 && !(BeginInt[0]==0x8CABDCA1 && BeginInt[1]==0x11CFA947 && BeginInt[2]==0xC000E48E && BeginInt[3]==0x6553200C))
    {
        Offset++;
        BeginInt=(int32u*)(Begin+Offset);
    }
    if (Offset<=Begin_Size-4)
    {
        General[0](_T("PlayTime")).From_Number(LittleEndian2int64u((char*)Begin+Offset+64)/10000-LittleEndian2int64u((char*)Begin+Offset+80));
    }

    //Description Title
    Offset=0;
    BeginInt=(int32u*)Begin;
    while (Offset<=Begin_Size-4 && !(BeginInt[0]==0x75B22633 && BeginInt[1]==0x11CF668E && BeginInt[2]==0xAA00D9A6 && BeginInt[3]==0x6CCE6200))
    {
        Offset++;
        BeginInt=(int32u*)(Begin+Offset);
    }
    if (Offset<=Begin_Size-4)
    {
        Offset+=24;
        int Taille0=Begin[Offset+0]+Begin[Offset+1]*0x100;
        int Taille1=Begin[Offset+2]+Begin[Offset+3]*0x100;
        int Taille2=Begin[Offset+4]+Begin[Offset+5]*0x100;
        int Taille3=Begin[Offset+6]+Begin[Offset+7]*0x100;

        Offset+=10;

        General[0](_T("Title")).From_Unicode((wchar_t*)(Begin+Offset), 0, Taille0);
        General[0](_T("Author")).From_Unicode((wchar_t*)(Begin+Offset+Taille0), 0, Taille1);
        General[0](_T("Copyright")).From_Unicode((wchar_t*)(Begin+Offset+Taille0+Taille1), 0, Taille2);
        General[0](_T("Comment")).From_Unicode((wchar_t*)(Begin+Offset+Taille0+Taille1+Taille2), 0, Taille3);
    }

    //Info audio
    Offset=0;
    BeginInt=(int32u*)Begin;
    while (Offset<=Begin_Size/sizeof(int32u)-4 && !(BeginInt[0]==0xF8699E40 && BeginInt[1]==0x11CF5B4D && BeginInt[2]==0x8000FDA8 && BeginInt[3]==0x2B445C5F))
    {
        Offset++;
        BeginInt=(int32u*)(Begin+Offset);
    }
    if (Offset<=65536-4)
    {
        size_t Audio_Count=Stream_Prepare(Stream_Audio);
        Offset+=54;
        Audio[Audio_Count](_T("Codec")).From_Number(Begin[Offset]+Begin[Offset+1]*0x100, 16);
        Audio[Audio_Count](_T("Channel(s)")).From_Number(Begin[Offset+2]); //2 octets
        BeginInt=(int32u*)(Begin+Offset);
        Audio[Audio_Count](_T("SamplingRate")).From_Number(BeginInt[1]);
        Audio[Audio_Count](_T("BitRate")).From_Number(BeginInt[2]*8);
    }

    //Info video
    Offset=0;
    BeginInt=(int32u*)Begin;
    while (Offset<=Begin_Size-4 && !(BeginInt[0]==0xBC19EFC0 && BeginInt[1]==0x11CF5B4D && BeginInt[2]==0x8000FDA8 && BeginInt[3]==0x2B445C5F))
    {
        Offset++;
        BeginInt=(int32u*)(Begin+Offset);
    }
    if (Offset<=65536-4)
    {
        size_t Video_Count=Stream_Prepare(Stream_Visual);
        Offset+=54;
        Offset+=15;
        BeginInt=(int32u*)(Begin+Offset);
        Video[Video_Count](_T("Width")).From_Number(BeginInt[0]);
        Video[Video_Count](_T("Height")).From_Number(BeginInt[1]);
        Video[Video_Count](_T("Codec")).From_Local((char*)Begin+Offset+12, 4);

    }

    //Extended
    Offset=0;
    BeginInt=(int32u*)Begin;
    while (Offset<=Begin_Size-4 && !(BeginInt[0]==0xD2D0A440 && BeginInt[1]==0x11D2E307 && BeginInt[2]==0xA000F097 && BeginInt[3]==0x50A85EC9))
    {
        Offset++;
        BeginInt=(int32u*)(Begin+Offset);
    }

    if (Offset<=65536-4)
    {
        Offset+=24;
        int Nb=Begin[Offset]+Begin[Offset+1]*0x100;
        Offset+=2;
        for (int Pos=0; Pos<Nb; Pos++)
        {
            int TailleNom=Begin[Offset]+Begin[Offset+1]*0x100;
            Offset+=2;
            Ztring Nom; Nom.From_Unicode((wchar_t*)(Begin+Offset), 0, TailleNom/2);
            Offset+=TailleNom;
            int Type=Begin[Offset]+Begin[Offset+1]*0x100;
            Offset+=2;//2 octets du type
            int TailleValeur=Begin[Offset]+Begin[Offset+1]*0x100;
            Offset+=2;
            //Gestion des type
            Ztring Valeur;
            if (Type==0) //Unicode
                Valeur.From_Unicode((wchar_t*)(Begin+Offset), 0, TailleValeur/2);
            else if (Type==1) //Byte
                Valeur.From_Local((char*)(Begin+Offset), 0, TailleValeur/2);
            else if (Type==2)//Bool
                Valeur.From_Number((int)Begin[Offset]);
            else if (Type==3)//DWord
                Valeur.From_Number(Begin[Offset]+Begin[Offset+1]*0x100+Begin[Offset+2]*0x10000+Begin[Offset+3]*0x1000000);
            else if (Type==4)//QWord
                Valeur.From_Number(Begin[Offset]+Begin[Offset+1]*0x100+Begin[Offset+2]*0x10000+Begin[Offset+3]*0x1000000);
            else if (Type==5)//Word
                Valeur.From_Number(Begin[Offset]+Begin[Offset+1]*0x100);
            //Gestion des noms
            if (Nom==_T("WM/AlbumTitle"))
                General[0](_T("Album"))=Valeur;
            if (Nom==_T("WM/AlbumArtist"))
                General[0](_T("Performer"))=Valeur;
            else if (Nom==_T("WM/Genre"))
                General[0](_T("ContentType"))=Valeur;
            else if (Nom==_T("WM/TrackNumber"))
                General[0](_T("Track/Position"))=Valeur;
            else if (Nom==_T("WM/Track"))
                General[0](_T("Title"))=Valeur;
            else if (Nom==_T("WM/Year"))
                General[0](_T("Date"))=Valeur;
            else if (Nom==_T("IsVBR"))
            {}
            else if (Nom==_T("WMFSDKVersion"))
            {}
            else if (Nom==_T("WMFSDKNeeded"))
            {}
            else
            {
                General[0].push_back(Nom);
                General[0](Nom, Info_Name_Text)=Nom;
                General[0](Nom)=Valeur;
            }
            Offset+=TailleValeur;

        }
    }

    return 1;
}


//---------------------------------------------------------------------------
void File_Wm::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
        General[0](_T("OveralBitRate"), Info_HowTo)=_T("R");
        General[0](_T("PlayTime"), Info_HowTo)=_T("R");
        General[0](_T("Album"), Info_HowTo)=_T("R");
        General[0](_T("Movie"), Info_HowTo)=_T("R");
        General[0](_T("Track"), Info_HowTo)=_T("R");
        General[0](_T("Track/Position"), Info_HowTo)=_T("R ");
        General[0](_T("Author"), Info_HowTo)=_T("R");
        General[0](_T("Copyright"), Info_HowTo)=_T("R");
        General[0](_T("Comment"), Info_HowTo)=_T("R");
        General[0](_T("Encoded_Date"), Info_HowTo)=_T("R ");
    }
    else if (StreamKind==Stream_Visual)
    {
        Video[0](_T("Codec"), Info_HowTo)=_T("R");
        Video[0](_T("BitRate"), Info_HowTo)=_T("R Overall BitRate - Audio BitRates");
        Video[0](_T("Width"), Info_HowTo)=_T("R");
        Video[0](_T("Height"), Info_HowTo)=_T("R");
        Video[0](_T("AspectRatio"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Audio)
    {
        Audio[0](_T("Codec"), Info_HowTo)=_T("R");
        Audio[0](_T("BitRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Channel(s)"), Info_HowTo)=_T("R");
        Audio[0](_T("SamplingRate"), Info_HowTo)=_T("R");
    }
}

} //NameSpace

#endif //MEDIAINFO_WM_*

