// File_Rm - Info for Real Media files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about Real Maedia files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// 2005-11-07, Zen@MediaArea.net
// Adapted to new File__Base
//
// 2003-05-31, Zen@MediaArea.net
// Adapt to new architecture and being LGPL
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_RM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_RM_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <wx/file.h>
#include <ZenLib/ZtringListList.h>
#include <ZenLib/Utils.h>
#include "MediaInfo/Multiple/File_Rm.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//---------------------------------------------------------------------------
//Global PROPerties
typedef struct
{
	int16u ObjectVersion;           //0
    int32u MaxBitrate;              //2
    int32u AverageBitrate;          //6
    int32u MaxPacketSize;           //10
    int32u AveragePacketSize;       //14
    int32u NumberPackets;           //18
    int32u Duration;                //22
    int32u Preroll;                 //26
    int32u IndexOffset;             //28
    int16u NumStreams;              //30
    int16u Flags;                   //32 : bit0=Save_Enabled, bit1=Perfect_Play, bit2=Live_Broadcast
} RM_Prop;

//MeDia PRoperties
typedef struct
{
	int16u ObjectVersion;           //0
    int16u StreamNumber;            //2
    int32u MaxBitrate;              //4
    int32u AverageBitrate;          //8
    int32u MaxPacketSize;           //12
    int32u AveragePacketSize;       //16
	int32u StartTime;               //20
    int32u Preroll;                 //24
    int32u Duration;                //28
    //int8u  StreamNameSize;        //32
    //char   StreamName[];		    //33
    //int8u  MimeTypeSize;          //33+StreamNameSize
    //char   MimeType[];		    //34+StreamNameSize
    //int32u TypeSpecificLength;    //34+StreamNameSize+MimeTypeSize
    //char   TypeSpecific[];        //38+StreamNameSize+MimeTypeSize
} RM_Mdpr;

//MeDia PRoperties - Audio
typedef struct
{
	char   FourCC1[4];              //0
	int16u Version;                 //4
	int16u HeaderSize;              //6
    int16u Channels;                //8
    int16u Unknown1;                //10
    int16u Unknown2;                //12
    int16u Unknown3;                //14
    int16u Bytes_Per_Minute;        //16
    int32u Bytes;                   //18
    int8u  Title_length;            //Not sure
    //char   Title[];
    int8u  Artist_length;
    //char   Artist[];
    int8u  Copyright_length;
    //char   Copyright[];
} RM_Mdpr_Audio3;

typedef struct
{
	char   FourCC1[4];
	int16u Version;
	char   FourCC2[4];
    int32u Unknown1;
    int16u Unknown2;
	int32u HeaderSize;
    int16u AudCodecInfo;
    int32u CodedFrameSize;
    int32u Unknown3;
    int32u Unknown4;
    int32u Unknown5;
    int16u CodedFrameSize2;
    int32u Unknown6;
    int32u Unknown7;
    int16u SampleRate;
    int32u Unknown8;
    int32u Unknown9;
    int16u Channels;
	int32u Genre; //Not sure
	int32u AudCodec; //"cook", "atrc", "sipr"
} RM_Mdpr_Audio;

//MeDia PRoperties - Video
typedef struct
{
	int32u Size;            //0
	char   FourCC1[4];      //4
	char   FourCC2[4];      //8
	int16u Width;           //12
    int16u Height;          //14
	int16u BitsPerSample;   //16
	int16u Unknown1;        //18
	int16u Unknown2;        //20
    int16u FrameRate;       //22
	int16u Unknown3;        //24
	int16u Unknown4;        //26
	int16u Unknown5;        //28
	int16u Unknown6;        //30
	int16u Unknown7;        //32
	int16u Unknown8;        //34
	int16u Unknown9;        //36
} RM_Mdpr_Video;

//logical-fileinfo
typedef struct
{
	int32u Size;            //0
	int32u Unknown1;        //4
	int32u Tags_Count;      //8
	int32u Unknown2;        //12
} RM_FileInfo;

//CONTent
typedef struct
{
	int16u Version;
    int16u Title_length;
    //char   Title[];
    int16u Artist_length;
    //char   Artist[];
    int16u Copyright_length;
    //char   Copyright[];
    int16u Comment_length;
    //char   Comment[];
} RM_Cont;

//---------------------------------------------------------------------------



//***************************************************************************
// Functions
//***************************************************************************

int File_Rm::Read(const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    //Verification
    if (Begin_Size<128)
        return -1;
    if (CC4(Begin)!=CC4(".RMF"))
        return -1;

    Stream_Prepare(Stream_General);
    General[0](_T("Format"))=_T("Real");
    General[0](_T("Format/String"))=_T("Real Media Format");
    General[0](_T("Format/Extensions"))=_T("RA RM RMVB");
    General[0](_T("Format/Url"))=_T("http://www.real.com");

    size_t Offset=0;

    while (Offset+512<Begin_Size)
    {
             if (CC4(Begin+Offset)==CC4("PROP"))
        {
            char* Prop=(char*)Begin+Offset+8;
    		General[0](_T("OveralBitRate")).From_Number(BigEndian2int32u(Prop+6)); //AverageBitrate
            General[0](_T("PlayTime")).From_Number(BigEndian2int32u(Prop+22)); //Duration

        }
        else if (CC4(Begin+Offset)==CC4("MDPR"))
        {
            char* Mdpr=(char*)Begin+Offset+8;
            int8u Name_Size=Mdpr[32]; //StreamNameSize
            char* Name=Mdpr+33; //StreamName
            int8u Desc_Size=Mdpr[33+Name_Size]; //MimeTypeSize
            char* Desc=Mdpr+34+Name_Size; //MimeType
            char* Mdpr_Datas=Mdpr+38+Name_Size+Desc_Size;
            if (Desc_Size>=16)
            {
                     if (CC5(Desc)==CC5("audio"))
                {
                    size_t Audio_Count=Stream_Prepare(Stream_Audio);
                    if (CC4(Mdpr_Datas)==CC4(".ra\xFD"))
                    {
                        int16u Version=BigEndian2int16u(Mdpr_Datas+4);//Version
                             if (Version==3)
                        {
                            Audio[Audio_Count](_T("Codec"))=_T(".ra3"); //FourCC1
                            Audio[Audio_Count](_T("SamplingRate")).From_Number(8000);
                            Audio[Audio_Count](_T("Resolution")).From_Number(16);
                            Audio[Audio_Count](_T("Channel(s)")).From_Number(BigEndian2int16u(Mdpr_Datas+8)); //Channels
                        }
                        else if (Version==4)
                        {
                            Audio[Audio_Count](_T("Codec")).From_Local(Mdpr_Datas+62, 4); //FourCC2
                            Audio[Audio_Count](_T("SamplingRate")).From_Number(BigEndian2int16u(Mdpr_Datas+48)); //SampleRate
                            Audio[Audio_Count](_T("Channel(s)")).From_Number(BigEndian2int16u(Mdpr_Datas+54)); //Channels
                        }
                        else if (Version==5)
                        {
                            Audio[Audio_Count](_T("Codec")).From_Local(Mdpr_Datas+66, 4); //FourCC2
                            Audio[Audio_Count](_T("SamplingRate")).From_Number(BigEndian2int32u(Mdpr_Datas+48)); //SampleRate
                            Audio[Audio_Count](_T("Channel(s)")).From_Number(BigEndian2int16u(Mdpr_Datas+60)); //Channels
                        }
                    }
                    else if (CC4(Mdpr_Datas)==CC4("LSD:"))
                    {
                            Audio[Audio_Count](_T("Codec"))=_T("RealAudio Lossless"); //FourCC2
                            Audio[Audio_Count](_T("SamplingRate")).From_Number(BigEndian2int32u(Mdpr_Datas+12)); //SampleRate
                    }
                    Audio[Audio_Count](_T("BitRate")).From_Number(BigEndian2int32u(Mdpr+8)); //AverageBitrate
                    Audio[Audio_Count](_T("Delay")).From_Number(BigEndian2int32u(Mdpr+20)); //StartTime
                    Audio[Audio_Count](_T("PlayTime")).From_Number(BigEndian2int32u(Mdpr+28)); //Duration
                }
                else if (CC5(Desc)==CC5("video"))
                {
                    size_t Video_Count=Stream_Prepare(Stream_Visual);
                    Video[Video_Count](_T("Codec")).From_Local(Mdpr_Datas+8, 4); //FourCC2
                    Video[Video_Count](_T("Width")).From_Number(BigEndian2int16u(Mdpr_Datas+12)); //Width
                    Video[Video_Count](_T("Height")).From_Number(BigEndian2int16u(Mdpr_Datas+14)); //Height
                    Video[Video_Count](_T("Resolution")).From_Number(BigEndian2int16u(Mdpr_Datas+16)); //Resolution
                    Video[Video_Count](_T("FrameRate")).From_Number(BigEndian2int16u(Mdpr_Datas+22)); //FrameRate
                    Video[Video_Count](_T("BitRate")).From_Number(BigEndian2int32u(Mdpr+8)); //AverageBitrate
                    Video[Video_Count](_T("Delay")).From_Number(BigEndian2int32u(Mdpr+20)); //StartTime
                    Video[Video_Count](_T("PlayTime")).From_Number(BigEndian2int32u(Mdpr+28)); //Duration
                }
                else if (CC8(Desc+8)==CC5("fileinfo"))
                {
                }
            }
        }
        else if (CC4(Begin+Offset)==CC4("CONT"))
        {
            char* Tags=(char*)Begin+Offset+8;
            int16u Size;
            Tags+=2; //Version
            Size=BigEndian2int16u(Tags);
            Tags+=2; //Size
            General[0](_T("PlayTime")).From_Local(Tags, Size);
            Tags+=Size; //XXX_Size
            Size=BigEndian2int16u(Tags);
            Tags+=2; //Size
            General[0](_T("Performer")).From_Local(Tags, Size);
            Tags+=Size; //XXX_Size
            Size=BigEndian2int16u(Tags);
            Tags+=2; //Size
            General[0](_T("Copyright")).From_Local(Tags, Size);
            Tags+=Size; //XXX_Size
            Size=BigEndian2int16u(Tags);
            Tags+=2; //Size
            General[0](_T("Comment")).From_Local(Tags, Size);
        }
        Offset+=BigEndian2int32u((const char*)Begin+Offset+4);
    }

    return 1;
}

//---------------------------------------------------------------------------
void File_Rm::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
        General[0](_T("OveralBitRate"), Info_HowTo)=_T("R");
        General[0](_T("Performer"), Info_HowTo)=_T("R");
        General[0](_T("Copyright"), Info_HowTo)=_T("R");
        General[0](_T("Comment"), Info_HowTo)=_T("R");
        General[0](_T("PlayTime"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Visual)
    {
        Video[0](_T("Codec"), Info_HowTo)=_T("R");
        Video[0](_T("Width"), Info_HowTo)=_T("R");
        Video[0](_T("Height"), Info_HowTo)=_T("R");
        Video[0](_T("Resolution"), Info_HowTo)=_T("R");
        Video[0](_T("FrameRate"), Info_HowTo)=_T("R");
        Video[0](_T("BitRate"), Info_HowTo)=_T("R");
        Video[0](_T("Delay"), Info_HowTo)=_T("R");
        Video[0](_T("PlayTime"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Audio)
    {
        Audio[0](_T("Codec"), Info_HowTo)=_T("R");
        Audio[0](_T("SamplingRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Channel(s)"), Info_HowTo)=_T("R");
        Audio[0](_T("BitRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Delay"), Info_HowTo)=_T("R");
        Audio[0](_T("PlayTime"), Info_HowTo)=_T("R");
    }
}

} //NameSpace

#endif //MEDIAINFO_RM_*

