// File_Riff - Info for RIFF files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about RIFF files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#ifndef MediaInfo_File_RiffH
#define MediaInfo_File_RiffH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/File__Base.h"
#include <vector>
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Class File_Riff
//***************************************************************************

class File_Riff : public File__Base
{
protected :
    //Formats
    int Read  (const int8u* Begin, size_t Begin_Size, const int8u* End=NULL, size_t End_Size=0, int64u FileSize=0);

    //Information
    void HowTo ();

private :
    //Buffer
    const int8u* Begin;
    size_t Begin_Size;
    const int8u* End;
    size_t End_Size;
    size_t Offset;
	bool ShouldStop; //Offset is too far, should stop analyse

    //Hierarchy
    size_t Level;
    size_t Element_Offset[10];
    size_t Element_Size  [10];
    int32u Element_List  [10]; //4CC of the list type

    //Save of some positions
    size_t Avih_Offset;
    size_t Strh_Offset;
    int32u Strh_StreamType;

    //Global information
    int32u TotalFrame; //Count of frame in all AVI file (with odml too)
    float32 FrameRate;
    std::vector<File__Base*> Codec_External;

    //Chunks
    void Avih_Analyse();
    void Cset_Analyse();
    void Dmlh_Analyse();
    void Exif_Analyse(const char* Parameter);
    void Fact_Analyse();
    void Info_Analyse(const char* Parameter);
    void Junk_Analyse();
    void Movi_Analyse(const char* Parameter);
    void Strf_Analyse();
    void Strf_Auds_Analyse();
    void Strf_Iavs_Analyse();
    void Strf_Mids_Analyse();
    void Strf_Txts_Analyse();
    void Strf_Vids_Analyse();
    void Strh_Analyse();
    void Strl_Analyse();
    void Strn_Analyse();
    void Vprp_Analyse();
};

} //NameSpace

#endif
