// File_Mxf - Info for MXF files
// Copyright (C) 2006-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about Mxf files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_MXF_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_MXF_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/Multiple/File_Mxf.h"
#include "ZenLib/Utils.h"
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

//---------------------------------------------------------------------------
int File_Mxf::Read (const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    if (Begin_Size<128)
        return -2;

    //Header
    if (CC4(Begin)!=0x060E2B34)
        return -1;

    Stream_Prepare(Stream_General);
    General[0](_T("Format"))=_T("MXF");
    General[0](_T("Format/String"))=_T("");
    General[0](_T("Format/Extensions"))=_T("mxf");
    General[0](_T("Format/Url"))=_T("");

    return 1;
}

//---------------------------------------------------------------------------
void File_Mxf::HowTo(stream_t StreamKind)
{
        if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
    }
}

} //NameSpace

#endif //MEDIAINFO_AAC_*

