// File_Mpeg4 - Info for MPEG4 files
// Copyright (C) 2005-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_MPEG4_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPEG4_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#if defined(_WIN32) && !defined(WIN32)
    #define WIN32
#endif
#if defined(_WIN32_WINNT)
    #undef _WIN32_WINNT
#endif
#include <mpeg4ip/mp4common.h>
#include <mpeg4ip/mp4av_aac.h>
#if defined(WIN32)
//Needed because Win32 define FindAtom, so the linker does not find the rigth one :(
MP4Atom* MP4File::FindAtom(const char* name)
{
	MP4Atom* pAtom = NULL;
	if (!name || !strcmp(name, "")) {
		pAtom = m_pRootAtom;
	} else {
		pAtom = m_pRootAtom->FindAtom(name);
	}
	return pAtom;
}
MP4Atom* MP4Atom::FindAtom(const char* name)
{
	if (!IsMe(name)) {
		return NULL;
	}

	if (!IsRootAtom()) {
		VERBOSE_FIND(m_pFile->GetVerbosity(),
			printf("FindAtom: matched %s\n", name));

		name = MP4NameAfterFirst(name);

		// I'm the sought after atom
		if (name == NULL) {
			return this;
		}
	}

	// else it's one of my children
	return FindChildAtom(name);
}
//gettimeofday is not known by win32
#include <sys/timeb.h>
int gettimeofday(struct timeval *tv_, void *)
{
#if defined(_MSC_VER) && _MSC_VER >= 1300
	struct __timeb64 tb;
	_ftime64(&tb);
#else
# ifndef __BORLANDC__
	struct _timeb tb;
	_ftime(&tb);
# else
	struct timeb tb;
	ftime(&tb);
# endif
#endif
	tv_->tv_sec = (long)tb.time;
	tv_->tv_usec = tb.millitm * 1000;
	return 0;
}
#endif
#include "MediaInfo/Multiple/File_Mpeg4.h"
#include "MediaInfo/MediaInfo.h"
#include "ZenLib/Utils.h"
using namespace ZenLib;
//---------------------------------------------------------------------------


namespace MediaInfoLib
{

//---------------------------------------------------------------------------
const u_int8_t MPEG4_VideoTypes[] = {
    MP4_MPEG2_SIMPLE_VIDEO_TYPE,	// 0x60
    MP4_MPEG2_MAIN_VIDEO_TYPE,		// 0x61
    MP4_MPEG2_SNR_VIDEO_TYPE,		// 0x62
    MP4_MPEG2_SPATIAL_VIDEO_TYPE,	// 0x63
    MP4_MPEG2_HIGH_VIDEO_TYPE,		// 0x64
    MP4_MPEG2_442_VIDEO_TYPE,		// 0x65
    MP4_MPEG1_VIDEO_TYPE,			// 0x6A
    MP4_JPEG_VIDEO_TYPE,			// 0x6C
    MP4_YUV12_VIDEO_TYPE,
    MP4_H263_VIDEO_TYPE,
    MP4_H261_VIDEO_TYPE,
};
u_int8_t MPEG4_VideoTypes_Count=sizeof(MPEG4_VideoTypes)/sizeof(u_int8_t);
const char* MPEG4_VideoNames[] = {
    "MPEG-2 Simple",
    "MPEG-2 Main",
    "MPEG-2 SNR",
    "MPEG-2 Spatial",
    "MPEG-2 High",
    "MPEG-2 4:2:2",
    "MPEG-1",
    "JPEG",
    "YUV12",
    "H.263",
    "H.261",
};
const u_int8_t MPEG4_AudioTypes[]=
{
    MP4_MPEG2_AAC_MAIN_AUDIO_TYPE,
    MP4_MPEG2_AAC_LC_AUDIO_TYPE,
    MP4_MPEG2_AAC_SSR_AUDIO_TYPE,
    MP4_MPEG2_AUDIO_TYPE,
    MP4_MPEG1_AUDIO_TYPE,
    MP4_PCM16_LITTLE_ENDIAN_AUDIO_TYPE,
    MP4_VORBIS_AUDIO_TYPE,
    MP4_ALAW_AUDIO_TYPE,
    MP4_ULAW_AUDIO_TYPE,
    MP4_G723_AUDIO_TYPE,
    MP4_PCM16_BIG_ENDIAN_AUDIO_TYPE,
};
u_int8_t MPEG4_AudioTypes_Count=sizeof(MPEG4_AudioTypes)/sizeof(u_int8_t);
const char* MPEG4_AudioNames[]=
{
    "AAC Main",
    "AAC LC",
    "AAC SSR",
    "MPEG-2 Audio",
    "MPEG-1 Audio",
    "PCM16 (LE)",
    "Vorbis",
    "G.711 aLaw",
    "G.711 uLaw",
    "G.723.1",
    "PCM16 (BE)",
};
//---------------------------------------------------------------------------

//***************************************************************************
// Functions
//***************************************************************************

int File_Mpeg4::Read()
{
    MP4File File;

    try {File.Read(CompleteFileName.c_str());} catch (...){return -1;}
    Stream_Prepare(Stream_General);

    //Debugging purpose : dump all info in a file
    //FILE* F=fopen("c:\\MediaInfo_Debug.txt", "wt");
    //File.SetVerbosity(5);
    //File.Dump(F);

    try {
    General[0](_T("PlayTime")).From_Number(1000*File.GetDuration()/File.GetTimeScale());
    MP4Atom* Ftyp=File.FindAtom("ftyp");
    if (Ftyp)
    {
        MP4Property* Ftyp_Prop=Ftyp->GetProperty(0);
        if (Ftyp_Prop)
        {
            const char* Ftyp_MajorBrand=((MP4StringProperty*)Ftyp_Prop)->GetValue();
            MPEG4_Analyze_Ftyp((int8u*)Ftyp_MajorBrand);
        }
    }
    } catch (...){return -1;}

    u_int32_t Track_Count=File.GetNumberOfTracks();
    for (u_int32_t Track_Pos=0; Track_Pos<Track_Count; Track_Pos++)
	{
        MP4TrackId Track_ID=File.FindTrackId(Track_Pos);
        MP4Track* Track=File.GetTrack(Track_ID);
        const char* Track_Type=Track->GetType();
             if (CC4(Track_Type)==CC4("odsm"))
        {
            //Object Descriptor
        }
        else if (CC4(Track_Type)==CC4("sdsm"))
        {
            //Scene
        }
        else if (CC4(Track_Type)==CC4("soun"))
        {
            //Audio
            size_t Audio_Count=Stream_Prepare(Stream_Audio);
            Audio[Audio_Count](_T("ID")).From_Number(Track_ID);
            try {Audio[Audio_Count](_T("PlayTime")).From_Number(File.ConvertFromTrackDuration(Track_ID, Track->GetDuration(), MP4_MSECS_TIME_SCALE));} catch (...){}
            try {Audio[Audio_Count](_T("Codec")).From_Local(File.GetTrackMediaDataName(Track_ID));} catch (...){}
            if (Audio[Audio_Count](_T("Codec"))==_T("mp4a"))
            {
                //Not exatly the rigth name
                u_int8_t Type=MP4_INVALID_AUDIO_TYPE;
                try {Type=File.GetTrackEsdsObjectTypeId(Track_ID);} catch (...){}
                     if (Type==MP4_INVALID_AUDIO_TYPE)
                {
                    Audio[Audio_Count](_T("Codec"))==_T("AAC");
                    try {Audio[Audio_Count](_T("SamplingRate")).From_Number(Track->GetTimeScale());} catch (...){}
                    try {Audio[Audio_Count](_T("Channel(s)")).From_Number(File.GetTrackAudioChannels(Track_ID));} catch (...){}
                    //TODO: find the rigth value
                    if (Audio[Audio_Count](_T("Channel(s)"))==_T("3"))
                        Audio[Audio_Count](_T("Channel(s)"))=_T("6");
                }
                else if (Type==MP4_MPEG4_AUDIO_TYPE)
                {
                    u_int8_t* pAacConfig = NULL;
                    u_int32_t aacConfigLength;

                    try {File.GetTrackESConfiguration(Track_ID, &pAacConfig, &aacConfigLength);} catch (...){}
                    if (pAacConfig && aacConfigLength>=2)
                    {
                        //TODO: use MP4AV_*
                        Type=(pAacConfig[0]>>3)&0x1F;
                        if (Type==0 || Type>=10)
                            Audio[Audio_Count](_T("Codec"))=_T("MPEG-4");
                        else
                            Audio[Audio_Count](_T("Codec")).From_Local(MPEG4_AudioNames[Type-1]);
                        Audio[Audio_Count](_T("Channel(s)")).From_Number(MP4AV_AacConfigGetChannels(pAacConfig));
                        Audio[Audio_Count](_T("SamplingRate")).From_Number(MP4AV_AacConfigGetSamplingRate(pAacConfig));
                    }
                    free(pAacConfig);
                }
                else
                    for (u_int8_t i=0; i<MPEG4_AudioTypes_Count; i++)
                        if (Type==MPEG4_AudioTypes[i])
                            Audio[Audio_Count](_T("Codec")).From_Local(MPEG4_AudioNames[i]);
            }
            try {Audio[Audio_Count](_T("BitRate")).From_Number(File.GetTrackIntegerProperty(Track_ID, "mdia.minf.stbl.stsd.*.esds.decConfigDescr.avgBitrate"));}
                catch (...)
                {
                    try
                    {
                        uint64_t Duration=File.ConvertFromTrackDuration(Track_ID, Track->GetDuration(), MP4_MSECS_TIME_SCALE);
                        if (Duration!=0)
                            Audio[Audio_Count](_T("BitRate")).From_Number(8*1000*Track->GetTotalOfSampleSizes()/Duration);
                    } catch (...) {}
                }
        }
        else if (CC4(Track_Type)==CC4("vide"))
        {
            //Video
            size_t Video_Count=Stream_Prepare(Stream_Visual);
            Video[Video_Count](_T("ID")).From_Number(Track_ID);
            try {Video[Video_Count](_T("PlayTime")).From_Number(File.ConvertFromTrackDuration(Track_ID, Track->GetDuration(), MP4_MSECS_TIME_SCALE));} catch (...){}
            try {Video[Video_Count](_T("Codec")).From_Local(File.GetTrackMediaDataName(Track_ID));} catch (...){}
            if (Video[Video_Count](_T("Codec"))==_T("mp4v") || Video[Video_Count](_T("Codec"))==_T("encv"))
            {
                //Not exatly the rigth name
                u_int8_t Type=File.GetTrackEsdsObjectTypeId(Track_ID);
                     if (Type==MP4_MPEG4_VIDEO_TYPE)
                        Video[Video_Count](_T("Codec"))=_T("MPEG-4");
                else
                    for (u_int8_t i=0; i<MPEG4_VideoTypes_Count; i++)
                        if (Type==MPEG4_VideoTypes[i])
                            Video[Video_Count](_T("Codec")).From_Local(MPEG4_VideoNames[i]);
            }
            try {Video[Video_Count](_T("BitRate")).From_Number(File.GetTrackIntegerProperty(Track_ID, "mdia.minf.stbl.stsd.*.esds.decConfigDescr.avgBitrate"));}
                catch (...)
                {
                    try
                    {
                        uint64_t Duration=File.ConvertFromTrackDuration(Track_ID, Track->GetDuration(), MP4_MSECS_TIME_SCALE);
                        if (Duration!=0)
                            Video[Video_Count](_T("BitRate")).From_Number(8*1000*Track->GetTotalOfSampleSizes()/Duration);
                    } catch (...) {}
                }
            try {Video[Video_Count](_T("Width")).From_Number(File.GetTrackIntegerProperty(Track_ID, "mdia.minf.stbl.stsd.*.width"));} catch (...){}
            try {Video[Video_Count](_T("Height")).From_Number(File.GetTrackIntegerProperty(Track_ID, "mdia.minf.stbl.stsd.*.height"));} catch (...){}
            try {Video[Video_Count](_T("Codec")).From_Local(File.GetTrackMediaDataName(Track_ID));} catch (...){}
            try {Video[Video_Count](_T("FrameRate")).From_Number(File.GetTrackVideoFrameRate(Track_ID), 3);} catch (...){}
        }
        else if (CC4(Track_Type)==CC4("hint"))
        {
            //Hint
        }
        else if (CC4(Track_Type)==CC4("cntl"))
        {
            //Control
        }
        else if (CC4(Track_Type)==CC4("crsm"))
        {
            //System - Clock
        }
        else if (CC4(Track_Type)==CC4("m7sm"))
        {
            //System - MPEG7
        }
        else if (CC4(Track_Type)==CC4("ocsm"))
        {
            //System - OCI
        }
        else if (CC4(Track_Type)==CC4("ipsm"))
        {
            //System - IPMP
        }
        else if (CC4(Track_Type)==CC4("mjsm"))
        {
            //System - MPEGJ
        }
    }

    //Metadatas (iTunes)
    char* Buffer; u_int16_t I1; u_int16_t I2; u_int8_t* Buffer2; u_int32_t Buffer2_Size;
    try {File.GetMetadataName(&Buffer);if (Buffer) General[0](_T("Title")).From_Local(Buffer);} catch (...){}
    try {File.GetMetadataArtist(&Buffer);if (Buffer) General[0](_T("Performer")).From_Local(Buffer);} catch (...){}
    try {File.GetMetadataWriter(&Buffer);if (Buffer) General[0](_T("Encoded_Application")).From_Local(Buffer);} catch (...){}
    try {File.GetMetadataAlbum(&Buffer);if (Buffer) General[0](_T("Album")).From_Local(Buffer);} catch (...){}
    try {File.GetMetadataTool(&Buffer);if (Buffer) General[0](_T("Encoded_Library")).From_Local(Buffer);} catch (...){}
    try {File.GetMetadataComment(&Buffer);if (Buffer) General[0](_T("Comment")).From_Local(Buffer);} catch (...){}
    try {File.GetMetadataYear(&Buffer);if (Buffer) General[0](_T("Encoded_Date")).From_Local(Buffer);} catch (...){}
    try {File.GetMetadataDisk(&I1, &I2);if (I1) General[0](_T("Part/Position")).From_Number(I1);if (I2) General[0](_T("Album/Total_Parts")).From_Number(I2);} catch (...){}
    try {File.GetMetadataTrack(&I1, &I2);if (I1) General[0](_T("Track/Position")).From_Number(I1);
        if (I2)
        {
            if (General[0](_T("Part/Position")).empty())
                General[0](_T("Album/Total_Parts")).From_Number(I2);
            else
                General[0](_T("Part/Total_Parts")).From_Number(I2);
        } } catch (...){}
    try {File.GetMetadataGenre(&Buffer);if (Buffer) General[0](_T("ContentType")).From_Local(Buffer);} catch (...){}
    try {File.GetMetadataGrouping(&Buffer);if (Buffer) General[0](_T("")).From_Local(Buffer);} catch (...){}
    try {File.GetMetadataTempo(&I1);if (I1) General[0](_T("BPM")).From_Number(I1);} catch (...){}
    try {File.GetMetadataCoverArt(&Buffer2, &Buffer2_Size);if (Buffer2_Size) General[0](_T(""))=_T("Yes");} catch (...){}

    File.Close();
    return 1;
}

int File_Mpeg4::Read (const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    //Testing ftyp header
    if (Begin_Size<12)
        return -1;
    if (CC4(Begin+4)!=CC4("ftyp"))
        return -1;

    Stream_Prepare(Stream_General);
    return MPEG4_Analyze_Ftyp(Begin+8);
}


int File_Mpeg4::MPEG4_Analyze_Ftyp(const int8u* Ftyp)
{
    int32u Type4=CC4(Ftyp);
    int32u Type3=CC3(Ftyp);
        if (Type4==CC4("isom") || Type4==CC4("mp41"))
    {
        General[0](_T("Format"))=_T("MPEG-4");
        General[0](_T("Format/String"))=_T("MPEG-4 version 1");
        General[0](_T("Format/Extensions"))=_T("MP4");
    }
    else if (Type4==CC4("mp42"))
    {
        General[0](_T("Format"))=_T("MPEG-4");
        General[0](_T("Format/String"))=_T("MPEG-4 version 2");
        General[0](_T("Format/Extensions"))=_T("MP4");
    }
    else if (Type4==CC4("iso2"))
    {
        General[0](_T("Format"))=_T("MPEG-4");
        General[0](_T("Format/String"))=_T("MPEG-4 part 12");
        General[0](_T("Format/Extensions"))=_T("MP4");
    }
    else if (Type4==CC4("mp7t") || Type4==CC4("mp7b"))
    {
        General[0](_T("Format"))=_T("MPEG-4");
        General[0](_T("Format/String"))=_T("MPEG-4 with MPEG-7 XML");
        General[0](_T("Format/Extensions"))=_T("MP4");
    }
    else if (CC3(Ftyp)==CC3("3gp"))
    {
        General[0](_T("Format"))=_T("3GPP");
        General[0](_T("Format/String"))=_T("3GPP (MPEG-4)");
        General[0](_T("Format/Extensions"))=_T("3GP");

        Stream_Prepare(Stream_Visual);
        switch ((char)(Ftyp[3]))
        {
            case '3'  : ;
            case '4'  : Video[0](_T("Codec"))=_T("H.263"); break;
            case '5'  : Video[0](_T("Codec"))=_T("H.264"); Video[0](_T("Codec/Url"))=_T("http://developers.videolan.org/x264.html"); break;
            default : ;
        }
        return 2;
    }
    else if (Type4==CC4("mmp4"))
    {
        General[0](_T("Format"))=_T("3GPP");
        General[0](_T("Format/String"))=_T("3GPP Mobile (MPEG-4)");
        General[0](_T("Format/Extensions"))=_T("3GP");
    }
    else if (Type4==CC4("avc1"))
    {
        General[0](_T("Format"))=_T("3GPP");
        General[0](_T("Format/String"))=_T("3GPP JVT AVC (MPEG-4)");
        General[0](_T("Format/Extensions"))=_T("3GP");
    }
    else if (Type3==CC3("M4A"))
    {
        General[0](_T("Format"))=_T("iTunes");
        General[0](_T("Format/String"))=_T("Apple iTunes (MPEG-4)");
        General[0](_T("Format/Extensions"))=_T("M4A");
        General[0](_T("Format/Url"))=_T("http://www.apple.com/itunes/");
        return 2;
    }
    else if (Type3==CC3("M4P"))
    {
        General[0](_T("Format"))=_T("iTunes");
        General[0](_T("Format/String"))=_T("Apple iTunes protected (MPEG-4)");
        General[0](_T("Format/Extensions"))=_T("M4A");
        General[0](_T("Format/Url"))=_T("http://www.apple.com/itunes/");
        return 2;
    }
    else if (Type3==CC3("M4B"))
    {
        General[0](_T("Format"))=_T("iTunes");
        General[0](_T("Format/String"))=_T("Apple iTunes Bookmarked (MPEG-4)");
        General[0](_T("Format/Extensions"))=_T("M4A");
        General[0](_T("Format/Url"))=_T("http://www.apple.com/itunes/");
        return 2;
    }
    else if (Type3==CC3("jp2"))
    {
        General[0](_T("Format"))=_T("JPEG2000");
        General[0](_T("Format/String"))=_T("JPEG2000 (MPEG-4)");
        General[0](_T("Format/Extensions"))=_T("jp2");
        General[0](_T("Format/Url"))=_T("http://www.morgan-multimedia.com/JPEG2000/");
        Stream_Prepare(Stream_Visual);
        Video[0](_T("Codec"))=_T("JPEG2000");
        return 2;
    }
    else if (Type4==CC4("qt  "))
    {
        General[0](_T("Format"))=_T("Quicktime");
        General[0](_T("Format/String"))=_T("Quicktime");
        General[0](_T("Format/Extensions"))=_T("QT MOV");
        General[0](_T("Format/Url"))=_T("http://www.apple.com/quicktime/download/standalone.html");
        return 1;
    }
    else
    {
        General[0](_T("Format"))=_T("MPEG-4");
        General[0](_T("Format/String"))=_T("MPEG-4 Generic");
        General[0](_T("Format/Extensions"))=_T("MP4");
    }
    return 1;
}

void File_Mpeg4::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
        General[0](_T("PlayTime"), Info_HowTo)=_T("R");
        General[0](_T("Album"), Info_HowTo)=_T("R");
        General[0](_T("Part/Track_Total"), Info_HowTo)=_T("R");
        General[0](_T("Movie"), Info_HowTo)=_T("R");
        General[0](_T("Track"), Info_HowTo)=_T("R");
        General[0](_T("Track/Position"), Info_HowTo)=_T("R");
        General[0](_T("Performer"), Info_HowTo)=_T("R");
        General[0](_T("Encoded_Application"), Info_HowTo)=_T("R");
        General[0](_T("Encoded_Date"), Info_HowTo)=_T("R");
        General[0](_T("Encoded_Library"), Info_HowTo)=_T("R");
        General[0](_T("Comment"), Info_HowTo)=_T("R");
        General[0](_T("ContentType"), Info_HowTo)=_T("R");
        General[0](_T("Cover"), Info_HowTo)=_T("R");
        General[0](_T("Cover_Datas"), Info_HowTo)=_T("N");
    }
    else if (StreamKind==Stream_Visual)
    {
        Video[0](_T("Codec"), Info_HowTo)=_T("R");
        Video[0](_T("BitRate"), Info_HowTo)=_T("R");
        Video[0](_T("Width"), Info_HowTo)=_T("R");
        Video[0](_T("Height"), Info_HowTo)=_T("R");
        Video[0](_T("AspectRatio"), Info_HowTo)=_T("N");
        Video[0](_T("FrameRate"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Audio)
    {
        Audio[0](_T("Codec"), Info_HowTo)=_T("R");
        Audio[0](_T("BitRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Channel(s)"), Info_HowTo)=_T("N");
        Audio[0](_T("SamplingRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Resolution"), Info_HowTo)=_T("N");
    }
}

} //NameSpace

#endif //MEDIAINFO_MPEG4_*

