// File_Mpeg - Info for MPEG files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about MPEG files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#ifndef MediaInfo_MpegH
#define MediaInfo_MpegH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/File__Base.h"
#include <ZenLib/Conf.h>
#include <vector>
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//---------------------------------------------------------------------------
typedef struct
{
  int64u PTS;
  int64u DTS;
  bool Have_PTS;
  bool Have_DTS;
} Mpeg_TimeStamp;

//---------------------------------------------------------------------------

//***************************************************************************
// Class File_Mpeg
//***************************************************************************

class File_Mpeg : public File__Base
{
protected :
    //Formats
    int Read  (const int8u* Begin, size_t Begin_Size, const int8u* End=NULL, size_t End_Size=0, int64u FileSize=0);

    //Information
    void HowTo (stream_t StreamKind);

private :
    const int8u* Begin;
    size_t Begin_Size;
    const int8u* End;
    size_t End_Size;
    size_t Offset;
    size_t Offset_End; //Offset of end of a PES
    Mpeg_TimeStamp TimeStamp;
    int8u Stream_ID;
    std::vector<ZenLib::int8u> Stream_List;
    std::vector<ZenLib::int8u> Private_List;
    size_t MPEG_Version;

    size_t MPEG_PES_Header ();
    size_t MPEG_PES_Data   ();
    size_t MPEG_Stream     ();


};

} //NameSpace

#endif
