// File_Cdxa - Info for CDXA files
// Copyright (C) 2004-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_CDXA_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_CDXA_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include "ZenLib/Utils.h"
#include "MediaInfo/Multiple/File_Cdxa.h"
#include "MediaInfo/MediaInfo.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

// CDXA = RIFF header + Raw sectors
// Riff header size = 44
// Raw sector size = 2352      
//
// Raw sector :
// Sync             12 bytes (00 FF .. FF 00)
// Header           4 bytes
// SubHeader        8 bytes
// Datas            2324 bytes
// EDC (CRC)        4 bytes

//---------------------------------------------------------------------------
int File_Cdxa::Read (const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    if (Begin_Size<128)
        return -2;

    size_t Offset=0;
    while (Offset<=Begin_Size-128 && !(CC4(Begin+Offset)==CC4("RIFF") && CC4(Begin+Offset+8)==CC4("CDXA")
                                    && LittleEndian2int32u(Begin+Offset+0x04)==LittleEndian2int32u(Begin+Offset+0x28)+0x24)) //Sizes of chunks
        Offset++;
    if (Offset>Begin_Size-128)
        return -1;

    //RIFF Header
    Offset+=44;

    //Create a Begin buffer without CDXA header
    int8u* Begin2=new int8u[Begin_Size];
    size_t Begin2_Offset=0;
    while (Offset+2352<Begin_Size) //2324 to not have to work with a partial chunk at the end
    {
        Offset+=24;//Sync+Header+SubHeader
        memcpy(Begin2+Begin2_Offset, Begin+Offset, 2324);
        Offset+=2324+4; //+4 for CRC
        Begin2_Offset+=2324;
    }

    //Create a End buffer without CDXA header
    int8u* End2=NULL;
    size_t End2_Offset=0;
    if (FileSize>End_Size)
    {
        int64u Synchro=FileSize-44-End_Size;
        Synchro/=2352;
        Synchro+=1;
        Synchro*=2352;
        End2=new int8u[End_Size];
        Offset=End_Size-FileSize+Synchro;
        while (Offset+2352<End_Size) //2324 to not have to work with a partial chunk at the end
        {
            Offset+=24;//Header
            memcpy(End2+End2_Offset, End+Offset, 2324);
            Offset+=2324+4; //+4 for CRC
            End2_Offset+=2324;
        }
    }

    MediaInfo MI;
    if (MI.Open(Begin2, Begin2_Offset, End2, End2_Offset, (FileSize-44)*2324/2352)>0) //Test
    {
        //General
        Stream_Prepare(Stream_General);
        Merge(*(MI.Info));
        General[0](_T("Format"))=Ztring(_T("CDXA/"))+General[0](_T("Format"));
        General[0](_T("Format/String"))=Ztring(_T("CD Mode 2 / "))+General[0](_T("Format/String"));
    }

    delete[] Begin2;
    delete[] End2;
    return 1;
}

//---------------------------------------------------------------------------
void File_Cdxa::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
    }
}

} //NameSpace

#endif //MEDIAINFO_CDXA_*

