// MediaInfo - All info about media files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <wx/file.h>
#include <wx/filename.h>
#include "MediaInfo/MediaInfo.h"
#include "MediaInfo/File__Base.h"
#if defined(MEDIAINFO_MK_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MK_NO))
    #include "MediaInfo/Multiple/File_Mk.h"
#endif
#if defined(MEDIAINFO_RIFF_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_RIFF_NO))
    #include "MediaInfo/Multiple/File_Riff.h"
#endif
#if defined(MEDIAINFO_OGG_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_OGG_NO))
    #include "MediaInfo/Multiple/File_Ogg.h"
#endif
#if defined(MEDIAINFO_MPEG_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MPEG_NO))
    #include "MediaInfo/Multiple/File_Mpeg.h"
#endif
#if defined(MEDIAINFO_MPEG4_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MPEG4_NO))
    #include "MediaInfo/Multiple/File_Mpeg4.h"
#endif
#if defined(MEDIAINFO_FLIC_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_FLIC_NO))
    #include "MediaInfo/Video/File_flic.h"
#endif
#if defined(MEDIAINFO_MPEGV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_MPEGV_NO))
    #include "MediaInfo/Video/File_Mpegv.h"
#endif
#if defined(MEDIAINFO_MPEG4V_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_MPEG4V_NO))
    #include "MediaInfo/Video/File_Mpeg4v.h"
#endif
#if defined(MEDIAINFO_AVC_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_AVC_NO))
    #include "MediaInfo/Video/File_Avc.h"
#endif
#if defined(MEDIAINFO_MPEGA_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPEGA_NO))
    #include "MediaInfo/Audio/File_Mpega.h"
#endif
#if defined(MEDIAINFO_MPC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPC_NO))
    #include "MediaInfo/Audio/File_Mpc.h"
#endif
#if defined(MEDIAINFO_WM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_WM_NO))
    #include "MediaInfo/Multiple/File_Wm.h"
#endif
#if defined(MEDIAINFO_QT_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_QT_NO))
    #include "MediaInfo/Multiple/File_Qt.h"
#endif
#if defined(MEDIAINFO_RM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_RM_NO))
    #include "MediaInfo/Multiple/File_Rm.h"
#endif
#if defined(MEDIAINFO_DVDV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_DVDV_NO))
    #include "MediaInfo/Multiple/File_Dvdv.h"
#endif
#if defined(MEDIAINFO_SNDFILE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_SNDFILE_NO))
    #include "MediaInfo/Audio/File_SndFile.h"
#endif
#if defined(MEDIAINFO_AC3_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_AC3_NO))
    #include "MediaInfo/Audio/File_Ac3.h"
#endif
#if defined(MEDIAINFO_DTS_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_DTS_NO))
    #include "MediaInfo/Audio/File_Dts.h"
#endif
#if defined(MEDIAINFO_AAC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_AAC_NO))
    #include "MediaInfo/Audio/File_Aac.h"
#endif
#if defined(MEDIAINFO_APE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_APE_NO))
    #include "MediaInfo/Audio/File_Ape.h"
#endif
#if defined(MEDIAINFO_FLAC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_FLAC_NO))
    #include "MediaInfo/Audio/File_Flac.h"
#endif
#if defined(MEDIAINFO_CDXA_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_CDXA_NO))
    #include "MediaInfo/Multiple/File_Cdxa.h"
#endif
#if defined(MEDIAINFO_SWF_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_SWF_NO))
    #include "MediaInfo/Multiple/File_Swf.h"
#endif
#if defined(MEDIAINFO_FLV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_FLV_NO))
    #include "MediaInfo/Multiple/File_Flv.h"
#endif
#if defined(MEDIAINFO_MXF_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_MXF_NO))
    #include "MediaInfo/Multiple/File_Mxf.h"
#endif
#if defined(MEDIAINFO_GIF_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_GIF_NO))
    #include "MediaInfo/Image/File_Gif.h"
#endif
#if defined(MEDIAINFO_BMP_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_BMP_NO))
    #include "MediaInfo/Image/File_Bmp.h"
#endif
#if defined(MEDIAINFO_TIFF_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_TIFF_NO))
    #include "MediaInfo/Image/File_Tiff.h"
#endif
#if defined(MEDIAINFO_JPEG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_JPEG_NO))
    #include "MediaInfo/Image/File_Jpeg.h"
#endif
#if defined(MEDIAINFO_PNG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_PNG_NO))
    #include "MediaInfo/Image/File_Png.h"
#endif
#if defined(MEDIAINFO_ICO_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_ICO_NO))
    #include "MediaInfo/Image/File_Ico.h"
#endif
#if defined(MEDIAINFO_ZIP_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_ZIP_NO))
    #include "MediaInfo/Archive/File_Zip.h"
#endif
#if defined(MEDIAINFO_RAR_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_RAR_NO))
    #include "MediaInfo/Archive/File_Rar.h"
#endif
#if defined(MEDIAINFO_7Z_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_7Z_NO))
    #include "MediaInfo/Archive/File_7z.h"
#endif
#if defined(MEDIAINFO_ACE_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_ACE_NO))
    #include "MediaInfo/Archive/File_Ace.h"
#endif
#if defined(MEDIAINFO_OTHERTEXT_YES) || (!defined(MEDIAINFO_TEXT_NO) && !defined(MEDIAINFO_OTHERTEXT_NO))
    #include "MediaInfo/Text/File_OtherText.h"
#endif
#if !defined(MEDIAINFO_OTHER_NO)
    #include "MediaInfo/File_Other.h"
#endif
#if !defined(MEDIAINFO_DUMMY_NO)
    #include "MediaInfo/File_Dummy.h"
#endif
#if !defined(MEDIAINFO_UNKNOWN_NO)
    #include "MediaInfo/File_Unknown.h"
#endif
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//---------------------------------------------------------------------------
const size_t READ_SIZE=524288; //1048576
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
extern MediaInfo_Config Config;
       ZtringListList   MediaInfo_Temp;
       ZtringListList   MediaInfo_Capacities;
       MediaInfo_String MediaInfo_Capacities_Final;
       size_t           MediaInfo_Capacities_Pos;
//---------------------------------------------------------------------------

//***************************************************************************
// Constructor/destructor
//***************************************************************************

//---------------------------------------------------------------------------
MediaInfo::MediaInfo()
{
    Thread=NULL;
    BlockMethod=1; //After Local information
    Info=NULL;
    Begin=NULL; Begin2=NULL; Begin_Size=0;
    End=NULL; End2=NULL; End_Size=0;
    FileSize=0;
}

//---------------------------------------------------------------------------
MediaInfo::~MediaInfo()
{
    Close();
}

//***************************************************************************
// Fichiers
//***************************************************************************

//---------------------------------------------------------------------------
int MediaInfo::Open(const MediaInfo_String &File)
{
    FileName=File;

    //Initialiser un nouveau info avec l'extension
    //-Recherche extension
    wxFileName FN(FileName.c_str());
    Ztring Extension=FN.GetExt().c_str(); Extension.MakeLowerCase();

    //-Creation de la classe adquate
    delete Info; Info=NULL;
             if (0) {} //For #defines
    #if defined(MEDIAINFO_MK_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MK_NO))
        else if (Extension==_T("mkv"))  Info=new File_Mk();
        else if (Extension==_T("mka"))  Info=new File_Mk();
        else if (Extension==_T("mks"))  Info=new File_Mk();
    #endif
    #if defined(MEDIAINFO_RIFF_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_RIFF_NO))
        else if (Extension==_T("avi"))  Info=new File_Riff();
        else if (Extension==_T("wav"))  Info=new File_Riff();
        else if (Extension==_T("divx")) Info=new File_Riff();
    #endif
    #if defined(MEDIAINFO_OGG_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_OGG_NO))
        else if (Extension==_T("ogg"))  Info=new File_Ogg();
        else if (Extension==_T("ogm"))  Info=new File_Ogg();
    #endif
    #if defined(MEDIAINFO_CDXA_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_CDXA_NO))
        else if (Extension==_T("dat"))  Info=new File_Cdxa();
    #endif
    #if defined(MEDIAINFO_MPEG_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MPEG_NO))
        else if (Extension==_T("mpeg")) Info=new File_Mpeg();
        else if (Extension==_T("mpgx")) Info=new File_Mpeg();
        else if (Extension==_T("mpg"))  Info=new File_Mpeg();
        else if (Extension==_T("mpe"))  Info=new File_Mpeg();
        else if (Extension==_T("mpm"))  Info=new File_Mpeg();
        else if (Extension==_T("vob"))  Info=new File_Mpeg();
        else if (Extension==_T("m1s"))  Info=new File_Mpeg();
        else if (Extension==_T("m2s"))  Info=new File_Mpeg();
        else if (Extension==_T("m1p"))  Info=new File_Mpeg();
        else if (Extension==_T("m2p"))  Info=new File_Mpeg();
    #endif
    #if defined(MEDIAINFO_MPEG4_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MPEG4_NO))
        else if (Extension==_T("mp4")) Info=new File_Mpeg4();
        else if (Extension==_T("m4v")) Info=new File_Mpeg4();
        else if (Extension==_T("m4a")) Info=new File_Mpeg4();
        else if (Extension==_T("3gp")) Info=new File_Mpeg4();
        else if (Extension==_T("3gpp")) Info=new File_Mpeg4();
    #endif
    #if defined(MEDIAINFO_MPEGV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_MPEGV_NO))
        else if (Extension==_T("mpgv")) Info=new File_Mpegv();
        else if (Extension==_T("mpv"))  Info=new File_Mpegv();
        else if (Extension==_T("m1v"))  Info=new File_Mpegv();
        else if (Extension==_T("m2v"))  Info=new File_Mpegv();
    #endif
    #if defined(MEDIAINFO_AVC_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_AVC_NO))
        else if (Extension==_T("h264")) Info=new File_Avc();
        else if (Extension==_T("avc"))  Info=new File_Avc();
    #endif
    #if defined(MEDIAINFO_MPEGA_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPEGA_NO))
        else if (Extension==_T("mpga")) Info=new File_Mpega();
        else if (Extension==_T("mpa"))  Info=new File_Mpega();
        else if (Extension==_T("m1a"))  Info=new File_Mpega();
        else if (Extension==_T("m2a"))  Info=new File_Mpega();
        else if (Extension==_T("mp2"))  Info=new File_Mpega();
        else if (Extension==_T("mp3"))  Info=new File_Mpega();
    #endif
    #if defined(MEDIAINFO_MPC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPC_NO))
        else if (Extension==_T("mpc"))  Info=new File_Mpc();
        else if (Extension==_T("mp+"))  Info=new File_Mpc();
    #endif
    #if defined(MEDIAINFO_WM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_WM_NO))
        else if (Extension==_T("asf"))  Info=new File_Wm();
        else if (Extension==_T("wmv"))  Info=new File_Wm();
        else if (Extension==_T("wma"))  Info=new File_Wm();
    #endif
    #if defined(MEDIAINFO_QT_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_QT_NO))
        else if (Extension==_T("qt"))   Info=new File_Qt();
        else if (Extension==_T("mov"))  Info=new File_Qt();
    #endif
    #if defined(MEDIAINFO_RM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_RM_NO))
        else if (Extension==_T("rm"))   Info=new File_Rm();
        else if (Extension==_T("rv"))   Info=new File_Rm();
        else if (Extension==_T("rmvb")) Info=new File_Rm();
        else if (Extension==_T("ra"))   Info=new File_Rm();
    #endif
    #if defined(MEDIAINFO_DVDV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_DVDV_NO))
        else if (Extension==_T("ifo"))  Info=new File_Dvdv();
    #endif
    #if defined(MEDIAINFO_SNDFILE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_SNDFILE_NO))
        else if (Extension==_T("aiff")) Info=new File_SndFile();
        else if (Extension==_T("aifc")) Info=new File_SndFile();
        else if (Extension==_T("au"))   Info=new File_SndFile();
        else if (Extension==_T("iff"))  Info=new File_SndFile();
        else if (Extension==_T("paf"))  Info=new File_SndFile();
        else if (Extension==_T("sd2"))  Info=new File_SndFile();
        else if (Extension==_T("sf"))   Info=new File_SndFile();
        else if (Extension==_T("voc"))  Info=new File_SndFile();
        else if (Extension==_T("w64"))  Info=new File_SndFile();
        else if (Extension==_T("mat"))  Info=new File_SndFile();
        else if (Extension==_T("pvf"))  Info=new File_SndFile();
        else if (Extension==_T("xi"))   Info=new File_SndFile();
        else if (Extension==_T("htk"))  Info=new File_SndFile();
        else if (Extension==_T("sds"))  Info=new File_SndFile();
        else if (Extension==_T("avr"))  Info=new File_SndFile();
        else if (Extension==_T("sd2"))  Info=new File_SndFile();
    #endif
    #if defined(MEDIAINFO_AC3_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_AC3_NO))
        else if (Extension==_T("ac3"))  Info=new File_Ac3();
    #endif
    #if defined(MEDIAINFO_DTS_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_DTS_NO))
        else if (Extension==_T("dts"))  Info=new File_Dts();
    #endif
    #if defined(MEDIAINFO_AAC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_AAC_NO))
        else if (Extension==_T("aac"))  Info=new File_Aac();
    #endif
    #if defined(MEDIAINFO_APE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_APE_NO))
        else if (Extension==_T("ape"))  Info=new File_Ape();
        else if (Extension==_T("mac"))  Info=new File_Ape();
    #endif
    #if defined(MEDIAINFO_FLAC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_FLAC_NO))
        else if (Extension==_T("flac")) Info=new File_Flac();
    #endif
    #if defined(MEDIAINFO_CDXA_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_CDXA_NO))
        else if (Extension==_T("dat"))  Info=new File_Cdxa();
    #endif
    #if defined(MEDIAINFO_SWF_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_SWF_NO))
        else if (Extension==_T("swf"))  Info=new File_Swf();
    #endif
    #if defined(MEDIAINFO_FLV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_FLV_NO))
        else if (Extension==_T("flv"))  Info=new File_Swf();
    #endif
    #if defined(MEDIAINFO_GIF_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_GIF_NO))
        else if (Extension==_T("gif"))  Info=new File_Gif();
    #endif
    #if defined(MEDIAINFO_BMP_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_BMP_NO))
        else if (Extension==_T("bmp"))  Info=new File_Bmp();
    #endif
    #if defined(MEDIAINFO_TIFF_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_TIFF_NO))
        else if (Extension==_T("tiff")) Info=new File_Tiff();
        else if (Extension==_T("tif"))  Info=new File_Tiff();
    #endif
    #if defined(MEDIAINFO_JPEG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_JPEG_NO))
        else if (Extension==_T("jpeg")) Info=new File_Jpeg();
        else if (Extension==_T("jpg"))  Info=new File_Jpeg();
        else if (Extension==_T("jpe"))  Info=new File_Jpeg();
    #endif
    #if defined(MEDIAINFO_PNG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_PNG_NO))
        else if (Extension==_T("png"))  Info=new File_Png();
    #endif
    #if defined(MEDIAINFO_ICO_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_ICO_NO))
        else if (Extension==_T("ico"))  Info=new File_Ico();
    #endif
    #if defined(MEDIAINFO_ZIP_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_ZIP_NO))
        else if (Extension==_T("zip"))  Info=new File_Zip();
    #endif
    #if defined(MEDIAINFO_RAR_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_RAR_NO))
        else if (Extension==_T("rar"))  Info=new File_Rar();
    #endif
    #if defined(MEDIAINFO_7Z_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_7Z_NO))
        else if (Extension==_T("7z"))   Info=new File_7z();
    #endif
    #if defined(MEDIAINFO_ACE_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_ACE_NO))
        else if (Extension==_T("ace"))  Info=new File_Ace();
    #endif
    //-Test
    if (Info && Info->Open(FileName)>0) return 1;

    //Open in buffer mode
    File2Buffer();
    if (Info && Info->Open(Begin, Begin_Size, End, End_Size, FileSize)>0) return 1;

    //Extension non reconnue : on se les tape un par un
    delete Info; Info=NULL;
    InternalMethod=1;
    int ToReturn=ListFormats1();

    ClearBuffer();
    return ToReturn;
}

//---------------------------------------------------------------------------
int MediaInfo::Open (const int8u* Begin2, size_t Begin_Size2, const int8u* End2, size_t End_Size2, int64u FileSize2)
{
    Begin=Begin2;
    Begin_Size=Begin_Size2;
    End=End2;
    End_Size=End_Size2;
    FileSize=FileSize2;

    InternalMethod=2;
    int ToReturn=ListFormats1();

    ClearBuffer();
    return ToReturn;
}

//---------------------------------------------------------------------------
int MediaInfo::Save()
{
    return 0; //Not yet implemented
}

//---------------------------------------------------------------------------
void MediaInfo::Close()
{
    delete Info; Info=NULL;
    ClearBuffer();
}

//***************************************************************************
// Get File info
//***************************************************************************

//---------------------------------------------------------------------------
MediaInfo_String MediaInfo::Inform(size_t)
{
    if (!Info)
        return Config.EmptyString_Get();

    return Info->Inform();
}

//---------------------------------------------------------------------------
MediaInfo_String MediaInfo::Get(stream_t KindOfStream, int StreamNumber, int Parameter, info_t KindOfInfo)
{
    if (!Info)
        return Config.EmptyString_Get();

    return Info->Get(KindOfStream, StreamNumber, Parameter, KindOfInfo).c_str();
}

//---------------------------------------------------------------------------
MediaInfo_String MediaInfo::Get(stream_t KindOfStream, int StreamNumber, const MediaInfo_String &Parameter, info_t KindOfInfo, info_t KindOfSearch)
{
    if (!Info)
        return Config.EmptyString_Get();

    return Info->Get(KindOfStream, StreamNumber, Parameter, KindOfInfo, KindOfSearch).c_str();
}

//***************************************************************************
// Set File info
//***************************************************************************

//---------------------------------------------------------------------------
int MediaInfo::Set(const MediaInfo_String &ToSet, stream_t StreamKind, int StreamNumber, int Parameter, const MediaInfo_String &OldValue)
{
    if (!Info)
        return -1;

    return Info->Set(StreamKind, StreamNumber, Parameter, ToSet, OldValue);
}

//---------------------------------------------------------------------------
int MediaInfo::Set(const MediaInfo_String &ToSet, stream_t StreamKind, int StreamNumber, const MediaInfo_String &Parameter, const MediaInfo_String &OldValue)
{
    if (!Info)
        return -1;

    return Info->Set(StreamKind, StreamNumber, Parameter, ToSet, OldValue);
}

//***************************************************************************
// Information
//***************************************************************************

//---------------------------------------------------------------------------
MediaInfo_String MediaInfo::Option (const MediaInfo_String &Option, const MediaInfo_String &Value)
{
         if (Option.empty())
        return _T("");
    else if (Option==_T("Language_Update"))
    {
        if (!Info || Info->Get(Stream_General, 0, _T("CompleteName"))==_T(""))
            return _T("");

        ZtringListList Language=Value.c_str();
        Config.Language_Set(Language);

        return _T("");
    }
    else if (Option==_T("Create_Dummy"))
    {
        #if !defined(MEDIAINFO_DUMMY_NO)
            Info=new File_Dummy();
            ((File_Dummy*)Info)->KindOfDummy=Value;
            if (Info->Open(Begin, Begin_Size, End, End_Size, FileSize)>0) return _T("Y");
            delete Info; Info=NULL;
        #endif
        return _T("");
    }
    else if (Option==_T("Info_Capacities"))
    {
        //If already done
        if (!MediaInfo_Capacities_Final.empty())
            return MediaInfo_Capacities_Final;

        //Header
        Ztring Header;
        Header+=MediaInfo::Option_Static(_T("Info_Version"))+_T("\r\n");
        Header+=_T("What's supported?\r\n");
        Header+=_T("Known Format :\r\n");
        Header+=_T("Matroska (mkv/mka/mks),\r\n");
        Header+=_T("Ogg (ogg/ogm),\r\n");
        Header+=_T("Riff (avi/wav),\r\n");
        Header+=_T("Mpeg 1&2 container (mpeg/mpg/vob),\r\n");
        Header+=_T("Mpeg 4 container (mp4),\r\n");
        Header+=_T("Mpeg video specific (mpgv/mpv/m1v/m2v),\r\n");
        Header+=_T("Mpeg audio specific (mp2/mp3),\r\n");
        Header+=_T("Musepack (mpc),\r\n");
        Header+=_T("Windows Media (asf/wma/wmv),\r\n");
        Header+=_T("Quicktime (qt/mov),\r\n");
        Header+=_T("Real (rm/rmvb/ra)\r\n");
        Header+=_T("flic (fli/flc)\r\n");
        Header+=_T("DVD-Video (ifo)\r\n");
        Header+=_T("AC3 (ac3),\r\n");
        Header+=_T("DTS (dts),\r\n");
        Header+=_T("AAC (aac),\r\n");
        Header+=_T("Monkey Audio (ape/mac),\r\n");
        Header+=_T("Flac (flac),\r\n");
        Header+=_T("CDXA, like Video-CD (dat),\r\n");
        Header+=_T("Apple/SGI (aiff/aifc) ,\r\n");
        Header+=_T("Sun/NeXT (au),\r\n");
        Header+=_T("Amiga IFF/SVX8/SV16 (iff),\r\n");
        Header+=_T("Ensoniq PARIS (paf),\r\n");
        Header+=_T("Sound Designer 2 (sd2),\r\n");
        Header+=_T("Berkeley/IRCAM/CARL (irca),\r\n");
        Header+=_T("SoundFoundry WAVE 64 (w64),\r\n");
        Header+=_T("Matlab (mat),\r\n");
        Header+=_T("Portable Voice format (pvf),\r\n");
        Header+=_T("FastTracker2 Extanded (xi),\r\n");
        Header+=_T("Midi Sample dump Format (sds),\r\n");
        Header+=_T("Audio Visual Research (avr),\r\n");
        Header+=_T("JPEG (jpeg/jpg/jpe\r\n");
        Header+=_T("Portable Network Graphic (png)\r\n");
        Header+=_T("Graphic Interchange Format (gif)\r\n");
        Header+=_T("Tagged Image Format File (tiff)\r\n");
        Header+=_T("Bitmap (bmp)\r\n");
        Header+=_T("Icon (ico)\r\n");
        Header+=_T("7-Zip (7z)\r\n");
        Header+=_T("Rar (rar)\r\n");
        Header+=_T("Zip (zip)\r\n");
        Header+=_T("Ace (ace)\r\n");
        Header+=_T("R=Read\r\n");
        Header+=_T("W=Read and Write\r\n");
        Header+=_T("N=Not yet supported\r\n");
        Header+=_T("\r\n");
        Header+=_T("                      m o r m m m m m w q r f d a d a a f c s f m a a i p s i w m x s a j p g t b i 7 r z a\r\n");
        Header+=_T("                      k g i p p p p p m t m l v c t a p l d w l x i u f a d r 6 a i d v p n i i m c z a i c\r\n");
        Header+=_T("                        g f e e e e c       i d 3 s c e a x f v f f   f f 2 c 4 t   s r e g f f p o   r p e\r\n");
        Header+=_T("                          f g g g g         c v         c a       f         a           g     f           \r\n");
        Header+=_T("                              4 v a                                                                       \r\n");

        //Filling
        MediaInfo_Capacities_Pos=1; //Column 0 is for name
        ListFormats2();

        //First column
        Ztring C1;
        for (size_t Pos=0; Pos<MediaInfo_Capacities.size(); Pos++)
        {
            C1=MediaInfo_Capacities(Pos, 0);
            if (!C1.empty())
            {
                C1.resize(19, _T(' '));
                MediaInfo_Capacities(Pos, 0)=C1+_T(" :");
            }
        }

        //Formating
        for (size_t Pos0=0; Pos0<MediaInfo_Capacities.size(); Pos0++)
            for (size_t Pos=0; Pos<MediaInfo_Capacities_Pos; Pos++)
                MediaInfo_Capacities(Pos0, Pos).resize(1, _T(' '));

        //Merging
        MediaInfo_Capacities.Separator_Set(0, _T("\r\n"));
        MediaInfo_Capacities.Separator_Set(1, _T(" "));
        MediaInfo_Capacities_Final=Header+MediaInfo_Capacities.Read();
        return MediaInfo_Capacities_Final;
    }
    else
        return Option_Static(Option, Value);
}

//---------------------------------------------------------------------------
MediaInfo_String MediaInfo::Option_Static (const MediaInfo_String &Option, const MediaInfo_String &Value)
{
         if (Option==_T("Info_Capacities"))
    {
        if (MediaInfo_Capacities_Final.empty())
        {
            MediaInfo MI;
            MI.Option(Option);
        }
        return MediaInfo_Capacities_Final;
    }
    else if (Option==_T("Info_Version"))
    {
        Ztring ToReturn=Config.Info_Version_Get();
        #if defined(MEDIAINFO_VIDEO_NO) || defined(MEDIAINFO_AUDIO_NO) || defined(MEDIAINFO_RIFF_NO) || defined(MEDIAINFO_OGG_NO) || defined(MEDIAINFO_MPEG_NO) || defined(MEDIAINFO_MPEGA_NO) || defined(MEDIAINFO_WM_NO) || defined(MEDIAINFO_QT_NO) || defined(MEDIAINFO_RM_NO) || defined(MEDIAINFO_DVDV_NO) || defined(MEDIAINFO_AAC_NO) || defined(MEDIAINFO_MK_NO) || defined(MEDIAINFO_APE_NO) || defined(MEDIAINFO_FLAC_NO) || defined(MEDIAINFO_SNDFILE_NO) || defined(MEDIAINFO_FLV_NO) || defined(MEDIAINFO_SWF_NO)
            ToReturn+=_T(" modified");
        #endif
        return ToReturn;
    }
    else
        return Config.Option(Option, Value);
}

//---------------------------------------------------------------------------
int MediaInfo::Count_Get (stream_t StreamKind, int StreamNumber)
{
    if (!Info)
        return -1;

    return Info->Count_Get(StreamKind, StreamNumber);
}

//---------------------------------------------------------------------------
int MediaInfo::State_Get ()
{
    return 0; //Not yet implemented
}

//---------------------------------------------------------------------------
int MediaInfo::File2Buffer()
{
    //Filling Buffer
    ClearBuffer();
    Begin2=new int8u[READ_SIZE];
    End2  =new int8u[READ_SIZE];
    #ifdef _WIN32 //Awful hack to be able to read files with Unicode in their name, and have FileSize>4 GiB
    //Open the file (win32)
    HANDLE Handle=CreateFile(FileName.c_str(), GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
    if (Handle!=INVALID_HANDLE_VALUE)
    {
        //FileSize
        DWORD High;DWORD Low=GetFileSize(Handle,&High);
        FileSize=0x100000000ULL*High+Low;
        int Read_Size=FileSize<READ_SIZE?FileSize:READ_SIZE;
        //Begin
        ReadFile(Handle, Begin2, Read_Size, (DWORD*)&Begin_Size, NULL);
        //End
        SetFilePointer(Handle, -Read_Size, NULL, FILE_END);
        ReadFile(Handle, End2, Read_Size, (DWORD*)&End_Size, NULL);
        //Close
        CloseHandle(Handle); Handle=NULL;
    }
    else
    {
    #endif
        //Open the file
        wxFile FB;
        FB.Open(FileName.c_str());
        //FileSize
        FileSize=FB.Length();
        int Read_Size=FileSize<READ_SIZE?FileSize:READ_SIZE;
        //Begin
        Begin_Size=FB.Read(Begin2, Read_Size);
        //End
        FB.Seek(-Read_Size, wxFromEnd);
        End_Size=FB.Read(End2, Read_Size);
        //Close
        FB.Close();
    #ifdef _WIN32 //Awful hack to be able to read files with Unicode in their name
    }
    #endif
    Begin=Begin2;
    End=End2;
    return 1;
}

//---------------------------------------------------------------------------
void MediaInfo::ClearBuffer()
{
    delete[] Begin2; Begin2=NULL; Begin=NULL; Begin_Size=0;
    delete[] End2;   End2  =NULL; End=NULL;   End_Size  =0;
    FileSize=0;
}

//---------------------------------------------------------------------------
int MediaInfo::ApplyMethod()
{
    switch (InternalMethod)
    {
        case 1 : //Open file
            if (Info->Open(FileName)>0)
                return 1;
            //No break wanted, we continue to open buffer
        case 2 : //Open buffer
            if (Info->Open(Begin, Begin_Size, End, End_Size, FileSize)>=0)
                return 1;
            else
            {
                delete Info; Info=NULL;
                return 0;
            }
        case 3 : //Supported formats
            MediaInfo_Temp=Info->Info_Capacities();
            for (size_t Pos=0; Pos<MediaInfo_Temp.size(); Pos++)
                MediaInfo_Capacities(Pos, MediaInfo_Capacities_Pos)=MediaInfo_Temp(Pos, 1);
            MediaInfo_Capacities_Pos++;
            delete Info; Info=NULL;
            return 1;
    }
    return 0;
}

//---------------------------------------------------------------------------
int MediaInfo::ListFormats1()
{
    delete Info; Info=NULL;
    #if defined(MEDIAINFO_RIFF_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_RIFF_NO))
        Info=new File_Riff();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_AVC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_AVC_NO))
        Info=new File_Avc(); if (ApplyMethod()>0) return 1; //TODO: At this time, must do it here because Mp4v2 library freeze with H264 streams
    #endif
    #if defined(MEDIAINFO_MPEG4_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MPEG4_NO))
        Info=new File_Mpeg4();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_MPEG_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MPEG_NO))
        Info=new File_Mpeg();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_MK_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MK_NO))
        Info=new File_Mk(); if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_CDXA_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_CDXA_NO))
        Info=new File_Cdxa();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_OGG_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_OGG_NO))
        Info=new File_Ogg();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_WM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_WM_NO))
        Info=new File_Wm();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_RM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_RM_NO))
        Info=new File_Rm();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_DVDV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_DVDV_NO))
        Info=new File_Dvdv();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_SNDFILE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_SNDFILE_NO))
        Info=new File_SndFile();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_APE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_APE_NO))
        Info=new File_Ape();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_FLAC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_FLAC_NO))
        Info=new File_Flac();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_SWF_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_SWF_NO))
        Info=new File_Swf();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_FLV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_FLV_NO))
        Info=new File_Flv();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_GIF_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_GIF_NO))
        Info=new File_Gif();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_BMP_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_BMP_NO))
        Info=new File_Bmp();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_TIFF_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_TIFF_NO))
        Info=new File_Tiff();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_JPEG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_JPEG_NO))
        Info=new File_Jpeg();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_PNG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_PNG_NO))
        Info=new File_Png();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_ICO_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_ICO_NO))
        Info=new File_Ico();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_ZIP_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_ZIP_NO))
        Info=new File_Zip();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_RAR_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_RAR_NO))
        Info=new File_Rar();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_7Z_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_7Z_NO))
        Info=new File_7z();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_ACE_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_ACE_NO))
        Info=new File_Ace();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_MXF_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MXF_NO))
        Info=new File_Mxf();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_QT_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_QT_NO))
        Info=new File_Qt();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_FLIC_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_FLIC_NO))
        Info=new File_Flic();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_OTHERTEXT_YES) || (!defined(MEDIAINFO_TEXT_NO) && !defined(MEDIAINFO_OTHERTEXT_NO))
        Info=new File_OtherText();  if (ApplyMethod()>0) return 1;
    #endif
    #if !defined(MEDIAINFO_OTHER_NO)
        Info=new File_Other();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_AC3_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_AC3_NO))
        Info=new File_Ac3();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_DTS_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_DTS_NO))
        Info=new File_Dts();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_AAC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_AAC_NO))
        Info=new File_Aac();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_MPEGV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_MPEGV_NO))
        Info=new File_Mpegv();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_MPEG4V_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_MPEG4V_NO))
        Info=new File_Mpeg4v(); if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_MPEGA_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPEGA_NO))
        Info=new File_Mpega();  if (ApplyMethod()>0) return 1;
    #endif
    #if defined(MEDIAINFO_MPC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPC_NO))
        Info=new File_Mpc();  if (ApplyMethod()>0) return 1;
    #endif
    #if !defined(MEDIAINFO_UNKNOWN_NO)
        Info=new File_Unknown();  if (ApplyMethod()>0) return 1;
    #endif
    return 0;
}

//---------------------------------------------------------------------------
int MediaInfo::ListFormats2()
{
    delete Info; Info=NULL;
    #if defined(MEDIAINFO_MK_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MK_NO))
        Info=new File_Mk();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_OGG_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_OGG_NO))
        Info=new File_Ogg();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_RIFF_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_RIFF_NO))
        Info=new File_Riff();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_MPEG_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MPEG_NO))
        Info=new File_Mpeg();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_MPEG4_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MPEG4_NO))
        Info=new File_Mpeg4();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_MPGV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_MPGV_NO))
        Info=new File_Mpegv();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_MPEGA_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPEGA_NO))
        Info=new File_Mpega();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_MPC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPC_NO))
        Info=new File_Mpc();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_WM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_WM_NO))
        Info=new File_Wm();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_QT_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_QT_NO))
        Info=new File_Qt();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_RM_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_RM_NO))
        Info=new File_Rm();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_FLIC_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_FLIC_NO))
        Info=new File_Flic();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_DVDV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_DVDV_NO))
        Info=new File_Dvdv();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_AC3_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_AC3_NO))
        Info=new File_Ac3();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_DTS_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_DTS_NO))
        Info=new File_Dts();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_AAC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_AAC_NO))
        Info=new File_Aac();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_APE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_APE_NO))
        Info=new File_Ape();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_FLAC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_FLAC_NO))
        Info=new File_Flac();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_CDXA_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_CDXA_NO))
        Info=new File_Cdxa();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_SWF_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_SWF_NO))
        Info=new File_Swf();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_FLV_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_FLV_NO))
        Info=new File_Flv();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_MXF_YES) || (!defined(MEDIAINFO_VIDEO_NO) && !defined(MEDIAINFO_MXF_NO))
        Info=new File_Mxf();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_SNDFILE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_SNDFILE_NO))
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
        Info=new File_SndFile();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_JPEG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_JPEG_NO))
        Info=new File_Jpeg();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_PNG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_PNG_NO))
        Info=new File_Png();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_GIF_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_GIF_NO))
        Info=new File_Gif();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_TIFF_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_TIFF_NO))
        Info=new File_Tiff();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_BMP_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_BMP_NO))
        Info=new File_Bmp();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_ICO_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_ICO_NO))
        Info=new File_Ico();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_7Z_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_7Z_NO))
        Info=new File_7z();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_RAR_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_RAR_NO))
        Info=new File_Rar();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_ZIP_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_ZIP_NO))
        Info=new File_Zip();  ApplyMethod();
    #endif
    #if defined(MEDIAINFO_ACE_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_ACE_NO))
        Info=new File_Ace();  ApplyMethod();
    #endif
    return 1;
}

} //NameSpace


