// File_Png - Info for PNG files
// Copyright (C) 2005-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about PNG files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// PNG - Format
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// From http://www.fileformat.info/format/png/
//
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_PNG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_PNG_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/Image/File_Png.h"
#include "ZenLib/Utils.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

int File_Png::Read(const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    //Test
    if (Begin_Size<=128) //Test if there is enougth bytes
        return -2;

    if (CC4(Begin)==0x89504E47 && CC4(Begin+4)==0x0D0A1A0A)
    {
        Stream_Prepare(Stream_General);
        General[0](_T("Format"))=_T("PNG");
        General[0](_T("Format/String"))=_T("Portable Network Graphic");
        General[0](_T("Format/Extensions"))=_T("png");

        Stream_Prepare(Stream_Visual);
        Video[0](_T("Codec"))=_T("LZ77 variant");
    }
    else if (CC4(Begin)==0x8A4E4E47 && CC4(Begin+4)==0x0D0A1A0A)
    {
        Stream_Prepare(Stream_General);
        General[0](_T("Format"))=_T("MNG");
        General[0](_T("Format/String"))=_T("");
        General[0](_T("Format/Extensions"))=_T("mng");

        Stream_Prepare(Stream_Visual);
        Video[0](_T("Codec"))=_T("MNG");
    }
    else if (CC4(Begin)==0x8B4A4E47 && CC4(Begin+4)==0x0D0A1A0A)
    {
        Stream_Prepare(Stream_General);
        General[0](_T("Format"))=_T("JNG");
        General[0](_T("Format/String"))=_T("");
        General[0](_T("Format/Extensions"))=_T("jng");

        Stream_Prepare(Stream_Visual);
        Video[0](_T("Codec"))=_T("JNG");
    }

    return -1;
}

void File_Png::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Visual)
    {
        Video[0](_T("Codec"), Info_HowTo)=_T("Raw");
    }

    return;
}

} //NameSpace

#endif
