// File_Jpeg - Info for NewFormat files
// Copyright (C) 2005-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//// Information about JPEG files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// GIF - Format
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// From http://www.fileformat.info/format/jpeg/
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_JPEG_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_JPEG_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/Image/File_Jpeg.h"
#include "ZenLib/Utils.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

int File_Jpeg::Read(const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    //Test
    if (Begin_Size<=128) //Test if there is enougth bytes
        return -2;

         if (CC4(Begin+6)==CC4("JFIF"))
    {
        Stream_Prepare(Stream_General);
        General[0](_T("Format"))=_T("JPEG");
        General[0](_T("Format/String"))=_T("JPEG");
        General[0](_T("Format/Extensions"))=_T("jpeg jpg jpe");

        Stream_Prepare(Stream_Visual);
        Video[0](_T("Codec"))=_T("JPEG");
        Video[0](_T("Codec/String"))=_T("JPEG"); //To Avoid automatic filling

        return 1;
    }
    else if (CC2(Begin+4)==CC2("jP"))
    {
        Stream_Prepare(Stream_General);
        General[0](_T("Format"))=_T("JPEG2000");
        General[0](_T("Format/String"))=_T("JPEG2000 (MPEG-4)");
        General[0](_T("Format/Extensions"))=_T("jp2");
        General[0](_T("Format/Url"))=_T("http://www.morgan-multimedia.com/JPEG2000/");

        Stream_Prepare(Stream_Visual);
        Video[0](_T("Codec"))=_T("JPEG2000");

        return 1;
    }
    else
        return -1;
}

void File_Jpeg::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Visual)
    {
        Video[0](_T("Codec"), Info_HowTo)=_T("Raw");
    }

    return;
}

} //NameSpace

#endif
