// File_Gif - Info for GIF files
// Copyright (C) 2005-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about GIF files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// GIF - Format
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// From http://www.onicos.com/staff/iz/formats/gif.html
//
// Header                               3 bytes - "GIF"
// Version                              3 bytes - "87a" or "89a"
// Logical Screen Width                 2 bytes
// Logical Screen Height                2 bytes
// Global Color Table Flag (GCTF)       1 bit
// Color Resolution                     3 bits
// Sort Flag to Global Color Table      1 bit
// Size of Global Color Table:          3 bits - 2^(1+n)
// Background Color Index               1 byte
// Pixel Aspect Ratio                   1 byte
// Global Color Table                   256*3 bytes (only if GCTF)
// Blocks                               ...
// Trailer                              1 byte - 0x3B
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_GIF_YES) || (!defined(MEDIAINFO_IMAGE_NO) && !defined(MEDIAINFO_GIF_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/Image/File_Gif.h"
#include "ZenLib/Utils.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

int File_Gif::Read(const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    //Test
    if (Begin_Size<=128) //Test if there is enougth bytes
        return -2;

    if (CC3(Begin)!=CC3("GIF"))
        return -1;

    Stream_Prepare(Stream_General);
    General[0](_T("Format"))=_T("GIF");
    General[0](_T("Format/String"))=_T("Graphics Interchange Format");
    General[0](_T("Format/Extensions"))=_T("gif");

    Stream_Prepare(Stream_Visual);
    Video[0](_T("Width")).From_Number(LittleEndian2int16u((char*)Begin+6));
    Video[0](_T("Height")).From_Number(LittleEndian2int16u((char*)Begin+8));
    Video[0](_T("Codec")).From_Local((char*)Begin, 6);

    return 1;
}

void File_Gif::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Visual)
    {
        Video[0](_T("Width"), Info_HowTo)=_T("R");
        Video[0](_T("Height"), Info_HowTo)=_T("R");
    }

    return;
}

} //NameSpace

#endif
