// File__Template - Info for _Template files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about _Template files
// This is an EXAMPLE FILE.
// Do not use in the real project
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// 2005-11-07, Zen@MediaArea.net
// Adapted to new File__Base
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#ifndef MediaInfo_File__TemplateH
#define MediaInfo_File__TemplateH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/File__Base.h"
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Class File__Template
//***************************************************************************

class File__Template : public File__Base
{
protected :
    //Formats
    int Read  ();
    int Read  (const int8u* Begin, size_t Begin_Size, const int8u* End=NULL, size_t End_Size=0, int64u FileSize=0);
    int Write (const Ztring &ToSet, stream_t StreamKind, size_t StreamNumber, const Ztring &Parameter, const Ztring &OldValue);

    //Information
    void HowTo (stream_t StreamKind);
};

} //NameSpace

#endif

/* HOW TO - DELETE THIS AFTER COPYING A NEW FILE
Replace in .h and .cpp the term "_Template" by your format name
Save in File_NewFormat.h and .cpp
In MediaInfo.cpp, add : include "MediaInfo/File_NewFormat.h"
In MediaInfo.cpp(MediaInfo::Open), add your extensions and at the and of the method, add a new File_NewFormat line
In MediaInfo.cpp(MediaInfo::Info_Capacities), add a new File_NewFormat line
Work on Read (Begin...) and HowTo, and Read (File) only if needed
*/
