// File__Base_Inform - Base for other files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Give common methods for all file types
// Init and Finalize part
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <time.h>
#include <wx/file.h>
#include <wx/filename.h>
#include <ZenLib/Utils.h>
#include "MediaInfo/File__Base.h"
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//---------------------------------------------------------------------------
extern MediaInfo_Config Config;
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void PlayTime_PlayTime123   (ZtringListList &List); //Internal function
//---------------------------------------------------------------------------

//***************************************************************************
// Init
//***************************************************************************

//---------------------------------------------------------------------------
void File__Base::General_Fill()
{
    //Coherancy
    if (Count_Get(Stream_General)==0)
        Stream_Prepare(Stream_General);

    //FileName and FileSize
    if (CompleteFileName.size()>0 && (General[0](_T("CompleteName")).empty() || General[0](_T("FileSize")).empty()))
    {
        //FileName
        General[0](_T("CompleteName"))=CompleteFileName;
        wxFileName FN; FN=CompleteFileName.c_str();
        General[0](_T("FolderName"))=FN.GetPath().c_str();
        General[0](_T("FileName"))=FN.GetName().c_str();
        General[0](_T("FileExtension"))=Ztring(FN.GetExt().c_str()).MakeLowerCase();

        //FileSize
        int64u FileSize=0;
        #ifdef _WIN32 //Awful hack to be able to read files with Unicode in their name, and have FileSize>4 GiB
        HANDLE Handle=CreateFile(CompleteFileName.c_str(), GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
        if (Handle!=INVALID_HANDLE_VALUE)
        {
            DWORD High; DWORD Low=GetFileSize(Handle,&High);
            FileSize=0x100000000ULL*High+Low;
            CloseHandle(Handle); Handle=NULL;
        }
        else
        {
        #endif
            wxFile FB;
            if (FB.Open(CompleteFileName.c_str()))
            {
                FileSize=FB.Length();
                FB.Close();
            }
        #ifdef _WIN32 //Awful hack to be able to read files with Unicode in their name
        }
        #endif
        if (FileSize)
            General[0](_T("FileSize")).From_Number(FileSize);
    }
}

//***************************************************************************
// Finalize
//***************************************************************************

//---------------------------------------------------------------------------
void File__Base::Finalize()
{
    //General, bases
    General_Fill(); //Not always done by File_*
    if (!Config.Format_Get(General[0](_T("Format")), InfoFormat_Format).empty())
    {
        Fill(Stream_General, 0, "Format/String", Config.Format_Get(General[0](_T("Format")), InfoFormat_LongName));
        Fill(Stream_General, 0, "Format/Info", Config.Format_Get(General[0](_T("Format")), InfoFormat_Info));
        Fill(Stream_General, 0, "Format/Url", Config.Format_Get(General[0](_T("Format")), InfoFormat_Url));
        Fill(Stream_General, 0, "Format/Extensions", Config.Format_Get(General[0](_T("Format")), InfoFormat_Extensions));
    }

    //Corelation
    //-OveralBitRate is we have one Audio stream with bitrate
    if (General[0](_T("PlayTime")).empty() && Video.empty() && Audio.size()==1 && Audio[0](_T("BitRate")).To_int64u()!=0)
        General[0](_T("PlayTime")).From_Number(General[0](_T("FileSize")).To_int64u()*1000/Audio[0](_T("BitRate")).To_int64u()*8);
    //-OveralBitRate
    if (General[0](_T("OveralBitRate")).empty() && General[0](_T("PlayTime")).To_int32u()!=0)
        General[0](_T("OveralBitRate")).From_Number(General[0](_T("FileSize")).To_int64u()*8*1000/General[0](_T("PlayTime")).To_int64u());
    intu BitRateK=float32_int32s((float)General[0](_T("OveralBitRate")).To_int32s()/1000);
    if (BitRateK)
        General[0](_T("OveralBitRate/String"))=Ztring::ToZtring(BitRateK)+Config.Language_Get(_T(" Kbps"));

    //-Playtime
    if (General[0](_T("PlayTime")).empty() && General[0](_T("OveralBitRate")).To_int32s()!=0)
        General[0](_T("PlayTime")).From_Number((int)(General[0](_T("FileSize")).To_int64s()*8/General[0](_T("OveralBitRate")).To_int64s()/1000));

    //-Video bitrate if we have all audio bitrates and overal bitrate
    if (Video.size()==1 && General[0](_T("OveralBitRate")).size()>4 && Video[0](_T("BitRate")).empty()) //OveralBitRate is > 10 000, to avoid strange behavior
    {
        int32s VideoBitRate=General[0](_T("OveralBitRate")).To_int32s()-5000; //5000 bps because of a "classic" format overhead
        for (size_t Pos=0; Pos<Audio.size(); Pos++)
            VideoBitRate-=Audio[Pos](_T("BitRate")).To_int32s()-2000; //5000 bps because of a "classic" stream overhead
        if (VideoBitRate>=10000) //to avoid strange behavior
            Video[0](_T("BitRate")).From_Number((float)VideoBitRate*0.98); //Default container overhead=2%
    }

    //For all streams
    for (size_t StreamKind=Stream_Visual; StreamKind<Stream_Max; StreamKind++)
    {
        Ztring Z1, Z2; //For Codec_List
        for (size_t Pos=0; Pos<(*Stream[StreamKind]).size(); Pos++)
        {
            //Codec
            if (!(*Stream[StreamKind])[Pos](_T("Codec")).empty())
            {
                const Ztring &C1=Config.Codec_Get((*Stream[StreamKind])[Pos](_T("Codec")));
                if (C1.empty())
                {
                    if ((*Stream[StreamKind])[Pos](_T("Codec/String")).empty()) (*Stream[StreamKind])[Pos](_T("Codec/String"))=(*Stream[StreamKind])[Pos](_T("Codec"));
                }
                else
                {
                    if ((*Stream[StreamKind])[Pos](_T("Codec/String")).empty()) (*Stream[StreamKind])[Pos](_T("Codec/String"))=C1;
                    if ((*Stream[StreamKind])[Pos](_T("Codec/Family")).empty()) (*Stream[StreamKind])[Pos](_T("Codec/Family"))=Config.Codec_Get((*Stream[StreamKind])[Pos](_T("Codec")), InfoCodec_KindofCodec);
                    if ((*Stream[StreamKind])[Pos](_T("Codec/Info"  )).empty()) (*Stream[StreamKind])[Pos](_T("Codec/Info"  ))=Config.Codec_Get((*Stream[StreamKind])[Pos](_T("Codec")), InfoCodec_Description);
                    if ((*Stream[StreamKind])[Pos](_T("Codec/Url"   )).empty()) (*Stream[StreamKind])[Pos](_T("Codec/Url"   ))=Config.Codec_Get((*Stream[StreamKind])[Pos](_T("Codec")), InfoCodec_Url);
                }
            }
            //Special cases
            if ((*Stream[StreamKind])[Pos](_T("Channel(s)")).empty()
             &&((*Stream[StreamKind])[Pos](_T("Codec"))==_T("samr")
             || (*Stream[StreamKind])[Pos](_T("Codec"))==_T("sawb")
             || (*Stream[StreamKind])[Pos](_T("Codec"))==_T("7A21")
             || (*Stream[StreamKind])[Pos](_T("Codec"))==_T("7A22"))
                )
                (*Stream[StreamKind])[Pos](_T("Channel(s)")).From_Number(1); //AMR is always with 1 channel

            //Language
            //-Find 2-digit language
            (*Stream[StreamKind])[Pos](_T("Language")).MakeLowerCase();
            if ((*Stream[StreamKind])[Pos](_T("Language")).size()==3 && (*Stream[StreamKind])[Pos](_T("Language"))==_T("und"))
                (*Stream[StreamKind])[Pos](_T("Language")).clear();
            if ((*Stream[StreamKind])[Pos](_T("Language")).size()==3 && !Config.Iso639_Get((*Stream[StreamKind])[Pos](_T("Language"))).empty())
               (*Stream[StreamKind])[Pos](_T("Language"))=Config.Iso639_Get((*Stream[StreamKind])[Pos](_T("Language")));
            //-Translate
            Ztring Temp=_T("Language_"); Temp+=(*Stream[StreamKind])[Pos](_T("Language"));
            const Ztring& Z3=Config.Language_Get(Temp);
            if (!Z3.empty())
                (*Stream[StreamKind])[Pos](_T("Language/String"))=Z3;
            else
                (*Stream[StreamKind])[Pos](_T("Language/String"))=(*Stream[StreamKind])[Pos](_T("Language"));

            //Codec_List
            Z1+=(*Stream[StreamKind])[Pos](_T("Codec/String"))+_T(" / ");
            Z2+=(*Stream[StreamKind])[Pos](_T("Language/String"))+_T(" / ");
        }
        //Codec_List
        if (!Z1.empty())
        {
            Z1.resize(Z1.size()-3); //Delete extra " / "
            Z2.resize(Z2.size()-3); //Delete extra " / "
            Ztring Z3=Get((stream_t)StreamKind, 0, _T("StreamKind"), Info_Measure);
            General[0](Z3+_T("_Codec_List"))=Z1;
            General[0](Z3+_T("_Language_List"))=Z2;
        }
    }

    //Video
    for (size_t Pos=0; Pos<Video.size(); Pos++)
    {
        //FrameRate
        if (!Video[Pos](_T("FrameRate")).empty())
        {
            Ztring Z1; Z1.From_Number(Video[Pos](_T("FrameRate")).To_float32(), 3, Ztring_NoZero);
            Video[Pos](_T("FrameRate/String"))=Z1+Config.Language_Get(_T(" fps"));
        }
        //BitRate
        int BitRate=Video[Pos](_T("BitRate")).To_int32s();
        if (BitRate>=2000)
        {
            BitRate=float32_int32s((float)BitRate/1000);
            Video[Pos](_T("BitRate/String"))=Ztring::ToZtring(BitRate)+Config.Language_Get(_T(" Kbps"));
        }
        else if (BitRate>0)
            Video[Pos](_T("BitRate/String"))=Video[Pos](_T("BitRate"))+Config.Language_Get(_T(" bps"));
        //Aspect Ratio
        if (Video[Pos](_T("AspectRatio")).empty())
        {
            float F1=Video[Pos](_T("Height")).To_float32();
            float F2=Video[Pos](_T("Width")).To_float32();
            if (F1 && F2)
                Video[Pos](_T("AspectRatio")).From_Number(F2/F1);
        }
        if (!Video[Pos](_T("AspectRatio")).empty())
        {
            float F1=Video[Pos](_T("AspectRatio")).To_float32();
            Ztring C1;
                 if (F1<1.25) C1.From_Number(F1);
            else if (F1<1.5)  C1=_T("4/3");
            else if (F1<2)    C1=_T("16/9");
            else if (F1<2.22) C1=_T("2.2");
            else if (F1<2.3)  C1=_T("2.25");
            else if (F1<2.5)  C1=_T("2.35");
            else              C1.From_Number(F1);
            Video[Pos](_T("AspectRatio/String"))=C1;
        }
        //Standard
        if (Video[Pos](_T("Standard")).empty() && Video[Pos](_T("Width"))==_T("720"))
        {
                 if (Video[Pos](_T("Height"))==_T("576"))
                Video[Pos](_T("Standard"))=_T("PAL");
            else if (Video[Pos](_T("Height"))==_T("480"))
                Video[Pos](_T("Standard"))=_T("NTSC");
        }
        //Bits/(Pixel*Frame)
        if (!Video[Pos](_T("BitRate")).empty())
        {
            float F1=(float)Video[Pos](_T("Width")).To_int32s()*(float)Video[Pos](_T("Height")).To_int32s()*Video[Pos](_T("FrameRate")).To_float32();
            if (F1)
                Video[Pos](_T("Bits-(Pixel*Frame)")).From_Number(Video[Pos](_T("BitRate")).To_float32()/F1);
        }
        //FrameCount
        if (Video[Pos](_T("FrameCount")).empty())
        {
            int64s PlayTime=Video[Pos](_T("PlayTime")).To_int64s();
            if (PlayTime==0)
                PlayTime=General[0](_T("PlayTime")).To_int64s();
            float FrameRate=Video[Pos](_T("FrameRate")).To_float32();
            if (PlayTime && FrameRate)
               Video[Pos](_T("FrameCount")).From_Number(int64u(((float64)PlayTime)/1000*FrameRate));
        }
        //Playtime
        if (General[0](_T("PlayTime")).empty())
        {
            int64s PlayTime=Video[Pos](_T("PlayTime")).To_int64s();
            if (PlayTime==0 && !Video[Pos](_T("FrameRate")).empty())
                PlayTime=Video[0](_T("FrameCount")).To_int64s()*1000/Video[0](_T("FrameRate")).To_int64s();
            if (PlayTime)
               General[0](_T("PlayTime")).From_Number(PlayTime);
        }
    }

    //Audio
    for (size_t Pos=0; Pos<Audio.size(); Pos++)
    {
        //BitRate
        int BitRate=Audio[Pos](_T("BitRate")).To_int32s();
        if (BitRate>=2000)
        {
            BitRate=float32_int32s((float)BitRate/1000);
            Audio[Pos](_T("BitRate/String"))=Ztring::ToZtring(BitRate)+Config.Language_Get(_T(" Kbps"));
        }
        else if (BitRate>0)
            Audio[Pos](_T("BitRate/String"))=Audio[Pos](_T("BitRate"))+Config.Language_Get(_T(" bps"));
        //Channels
        Audio[Pos](_T("Channel(s)/String"))=Config.Language_Get(Audio[Pos](_T("Channel(s)")), _T(" channel"));
        //SamplingRate
        int SamplingRate=Audio[Pos](_T("SamplingRate")).To_int32s();
        if (SamplingRate>=2000)
        {
            SamplingRate=float32_int32s((float)SamplingRate/1000);
            Audio[Pos](_T("SamplingRate/String"))=Ztring::ToZtring(SamplingRate)+Config.Language_Get(_T(" KHz"));
        }
        else if (SamplingRate>0)
            Audio[Pos](_T("SamplingRate/String"))=Audio[Pos](_T("SamplingRate"))+Config.Language_Get(_T(" Hz"));
        //SamplingCount
        if (Audio[Pos](_T("SamplingCount")).empty())
        {
            int64s PlayTime=Audio[Pos](_T("PlayTime")).To_int64s();
            if (PlayTime==0)
                PlayTime=General[0](_T("PlayTime")).To_int64s();
            float SamplingRate=Audio[Pos](_T("SamplingRate")).To_float32();
            if (PlayTime && SamplingRate)
               Audio[Pos](_T("SamplingCount")).From_Number(int64u(((float64)PlayTime)/1000*SamplingRate));
        }
        //Playtime
        if (General[0](_T("PlayTime")).empty())
        {
            int64s PlayTime=Audio[Pos](_T("PlayTime")).To_int64s();
            if (PlayTime==0 && Audio[Pos](_T("SamplingRate")).To_int64s()!=0)
                PlayTime=Audio[Pos](_T("SamplingCount")).To_int64s()*1000/Audio[Pos](_T("SamplingRate")).To_int64s();
            if (PlayTime)
               General[0](_T("PlayTime")).From_Number(PlayTime);
        }
        //Delay/Video0
        if (Video.size() && !Audio[Pos](_T("Delay")).empty())
            Audio[Pos](_T("Video0_Delay")).From_Number(Audio[Pos](_T("Delay")).To_int32s()-Video[0](_T("Delay")).To_int32s());
        //CBR/VBR
        if (Audio[Pos](_T("BitRate_Mode")).empty() && !Audio[Pos](_T("Codec")).empty())
        {
            Ztring Z1=Config.Codec_Get(Audio[Pos](_T("Codec")), InfoCodec_BitRate_Mode);
            if (!Z1.empty())
                Audio[Pos](_T("BitRate_Mode"))=Z1;
        }
    }

    //Counts
    General[0](_T("Count")).From_Number(General[0].size());
    General[0](_T("VideoCount")).From_Number(Video.size());
    General[0](_T("AudioCount")).From_Number(Audio.size());
    General[0](_T("TextCount")).From_Number(Text.size());
    General[0](_T("ChaptersCount")).From_Number(Chapters.size());
    for (size_t StreamKind=0; StreamKind<Stream_Max; StreamKind++)
        for (size_t Pos=0; Pos<(*Stream[StreamKind]).size(); Pos++)
        {
            (*Stream[StreamKind])[Pos](_T("Count")).From_Number((*Stream[StreamKind])[Pos].size());
            (*Stream[StreamKind])[Pos](_T("StreamCount")).From_Number((*Stream[StreamKind]).size());
            (*Stream[StreamKind])[Pos](_T("StreamKindID")).From_Number(Pos);
        }

    //Tags
    //-Movie/Album
    if (!General[0](_T("Title")).empty() && General[0](_T("Movie")).empty() && General[0](_T("Track")).empty())
    {
        if (Video.size()!=0)
            General[0](_T("Movie"))=General[0](_T("Title"));
        else
            General[0](_T("Track"))=General[0](_T("Title"));
    }
    //-Title
    if (General[0](_T("Title")).empty() && !General[0](_T("Movie")).empty())
        General[0](_T("Title"))=General[0](_T("Movie"));
    if (General[0](_T("Title")).empty() && !General[0](_T("Album")).empty())
        General[0](_T("Title"))=General[0](_T("Track"));

    //-Artist
    if (General[0](_T("Artist")).empty() && !General[0](_T("Performer")).empty())
        General[0](_T("Artist"))=General[0](_T("Performer"));
    if (General[0](_T("Performer")).empty() && !General[0](_T("Artist")).empty())
        General[0](_T("Performer"))=General[0](_T("Artist"));

    //-Genre
    if (!General[0](_T("Genre")).empty() && General[0](_T("Genre")).size()<4 && General[0](_T("Genre"))[0]>=_T('0') && General[0](_T("Genre"))[0]<=_T('9'))
    {
        Ztring Genre;
        if (General[0](_T("Genre")).size()==1) Genre=Ztring(_T("Genre_00"))+General[0](_T("Genre"));
        if (General[0](_T("Genre")).size()==2) Genre=Ztring(_T("Genre_0" ))+General[0](_T("Genre"));
        if (General[0](_T("Genre")).size()==3) Genre=Ztring(_T("Genre_"  ))+General[0](_T("Genre"));
        General[0](_T("Genre"))=Config.Language_Get(Genre);
    }

    //Format
    General[0](_T("Codec"))=General[0](_T("Format"));
    General[0](_T("Codec/String"))=General[0](_T("Format/String"));
    General[0](_T("Codec/Info"))=General[0](_T("Format/Info"));
    General[0](_T("Codec/Url"))=General[0](_T("Format/Url"));
    General[0](_T("Codec/Extensions"))=General[0](_T("Format/Extensions"));
    General[0](_T("Codec_Settings"))=General[0](_T("Format_Settings"));
    General[0](_T("Codec_Settings_Automatic"))=General[0](_T("Format_Settings_Automatic"));

    //Update of "/String" elements
    //-PlayTime
    for (size_t StreamKind=0; StreamKind<Stream_Max; StreamKind++)
        for (size_t Pos=0; Pos<(*Stream[StreamKind]).size(); Pos++)
            PlayTime_PlayTime123((*Stream[StreamKind])[Pos]);
    //-FileSize
    float F1=(float)General[0](_T("FileSize")).To_int64s(); //Visual C++ 6 patch, should be int64u
    //--Bytes, KiB, MiB or GiB...
    int Pow3=0;
    while(F1>=1024)
    {
        F1/=1024;
        Pow3++;
    }
    //--Count of digits
    int I2, I3, I4;
         if (F1>=100)
    {
        I2=0;
        I3=0;
        I4=1;
    }
    else if (F1>=10)
    {
        I2=0;
        I3=1;
        I4=2;
    }
    else //if (F1>=1)
    {
        I2=1;
        I3=2;
        I4=3;
    }
    Ztring Measure;
    switch (Pow3)
    {
        case  0 : Measure=Config.Language_Get(Ztring::ToZtring(F1, 0), _T(" Byte")); Measure.FindAndReplace(Ztring::ToZtring(F1, 0), _T("")); break; //This is only to have measure with multiple plurals
        case  1 : Measure=Config.Language_Get(_T(" KiB")); break;
        case  2 : Measure=Config.Language_Get(_T(" MiB")); break;
        case  3 : Measure=Config.Language_Get(_T(" GiB")); break;
        default : Measure=Config.Language_Get(_T(" ????Bytes"));
    }
    General[0](_T("FileSize/String1"))=Ztring::ToZtring(F1, 0)+Measure;
    General[0](_T("FileSize/String2"))=Ztring::ToZtring(F1, I2)+Measure;
    General[0](_T("FileSize/String3"))=Ztring::ToZtring(F1, I3)+Measure;
    General[0](_T("FileSize/String4"))=Ztring::ToZtring(F1, I4)+Measure;
    General[0](_T("FileSize/String"))=General[0](_T("FileSize/String3"));
}

//***************************************************************************
// Internal Functions
//***************************************************************************

//---------------------------------------------------------------------------
//PlayTime
void PlayTime_PlayTime123(ZtringListList &List)
{
    if (List.Find(_T("PlayTime/String"))==Error)
        return;

    int HH, MM, SS, MS;
    Ztring PlayTimeString1, PlayTimeString2, PlayTimeString3;
    MS=List(_T("PlayTime")).To_int32s(); //en ms
    if (MS==0)
        return;
    HH=MS/1000/60/60; //h
    if (HH>0)
    {
        PlayTimeString1+=Ztring::ToZtring(HH)+Config.Language_Get(_T("h"));
        PlayTimeString2+=Ztring::ToZtring(HH)+Config.Language_Get(_T("h"));
        if (HH<10)
            PlayTimeString3+=Ztring(_T("0"))+Ztring::ToZtring(HH)+_T(":");
        else
            PlayTimeString3+=Ztring::ToZtring(HH)+_T(":");
        MS-=HH*60*60*1000;
    }
    if (HH==0)
    {
        PlayTimeString3+=_T("00:");
    }

    MM=MS/1000/60; //mn
    if (MM>0)
    {
        if (PlayTimeString1.size()>0)
            PlayTimeString1+=_T(" ");
        PlayTimeString1+=Ztring::ToZtring(MM)+Config.Language_Get(_T("mn"));
        if (PlayTimeString2.size()<5)
        {
            if (PlayTimeString2.size()>0)
                PlayTimeString2+=_T(" ");
            PlayTimeString2+=Ztring::ToZtring(MM)+Config.Language_Get(_T("mn"));
        }
        if (MM<10)
            PlayTimeString3+=Ztring(_T("0"))+Ztring::ToZtring(MM)+_T(":");
        else
            PlayTimeString3+=Ztring::ToZtring(MM)+_T(":");
        MS-=MM*60*1000;
    }
    if (MM==0)
    {
        PlayTimeString3+=_T("00:");
    }

    SS=MS/1000; //s
    if (SS>0)
    {
        if (PlayTimeString1.size()>0)
            PlayTimeString1+=_T(" ");
        PlayTimeString1+=Ztring::ToZtring(SS)+Config.Language_Get(_T("s"));
        if (PlayTimeString2.size()<5 && MM>0)
        {
            if (PlayTimeString2.size()>0)
                PlayTimeString2+=_T(" ");
            PlayTimeString2+=Ztring::ToZtring(SS)+Config.Language_Get(_T("s"));
        }
        else if (PlayTimeString2.size()==0)
            PlayTimeString2+=Ztring::ToZtring(SS)+Config.Language_Get(_T("s"));
        if (SS<10)
            PlayTimeString3+=Ztring(_T("0"))+Ztring::ToZtring(SS)+_T(".");
        else
            PlayTimeString3+=Ztring::ToZtring(SS)+_T(".");
        MS-=SS*1000;
    }
    if (SS==0)
    {
        PlayTimeString3+=_T("00.");
    }

    if (MS>0) //ms
    {
        if (PlayTimeString1.size()>0)
            PlayTimeString1+=_T(" ");
        PlayTimeString1+=Ztring::ToZtring(MS)+Config.Language_Get(_T("ms"));
        if (PlayTimeString2.size()<5 && SS>0)
        {
            if (PlayTimeString2.size()>0)
                PlayTimeString2+=_T(" ");
            PlayTimeString2+=Ztring::ToZtring(MS)+Config.Language_Get(_T("ms"));
        }
        if (MS<10)
            PlayTimeString3+=Ztring(_T("00"))+Ztring::ToZtring(MS);
        else if (MS<100)
            PlayTimeString3+=Ztring(_T("0"))+Ztring::ToZtring(MS);
        else
            PlayTimeString3+=Ztring::ToZtring(MS);
    }
    if (MS==0)
    {
        PlayTimeString3+=_T("000");
    }

    List(_T("PlayTime/String"))=PlayTimeString2;
    List(_T("PlayTime/String1"))=PlayTimeString1;
    List(_T("PlayTime/String2"))=PlayTimeString2;
    List(_T("PlayTime/String3"))=PlayTimeString3;
}

} //NameSpace

