// File_Other - Use magic number to detect only the format
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Use magic number to detect only the format
// Theses formats are not planned to be expanded, this is only to detect
// well all files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if !defined(MEDIAINFO_OTHER_NO)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/File_Other.h"
#include "ZenLib/Utils.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

int File_Other::Read(const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    Ztring Format, Format_String, Url, Extensions;
         if (CC4(Begin)==0xC5C6CBC3) {Format=_T("RISC OS Chunk data");}
    else if (CC4(Begin)==0x110000EF) {Format=_T("RISC OS AIF executable");}
    else if (CC4(Begin)==CC4("Draw")) {Format=_T("RISC OS Draw");}
    else if (CC4(Begin)==CC4("FONT")) {Format=_T("RISC OS Font");}
    else if (CC8(Begin)==CC8("Maestro\r")) {Format=_T("RISC OS music file");}
    else if (CC4(Begin)==CC4("FC14")) {Format=_T("Amiga Future Composer");}
    else if (CC4(Begin)==CC4("SMOD")) {Format=_T("Amiga Future Composer");}
    else if (CC4(Begin)==CC4("AON4")) {Format=_T("Amiga Art Of Noise");}
    else if (CC8(Begin+1)==CC8("MUGICIAN")) {Format=_T("Amiga Mugician");}
    else if (CC8(Begin+58)==CC8("SIDMON I")) {Format=_T("Amiga Sidmon");}
    else if (CC8(Begin)==CC8("Synth4.0")) {Format=_T("Amiga Synthesis");}
    else if (CC4(Begin)==CC4("ARP.")) {Format=_T("Amiga Holy Noise");}
    else if (CC4(Begin)==CC4("BeEp")) {Format=_T("Amiga JamCracker");}
    else if (CC4(Begin)==CC4("COSO")) {Format=_T("Amiga Hippel-COSO");}
    else if (CC3(Begin)==CC3("LSX")) {Format=_T("Amiga LZX");}
    else if (CC4(Begin)==CC4("MOVI")) {Format=_T("Silicon Graphics movie");}
    else if (CC3(Begin)==0x1F0700) {Format=_T("DIF");}
    else if (CC4(Begin+10)==CC4("Vivo")) {Format=_T("Vivo");}
    else if (CC4(Begin+1)==CC4("VRML")) {Format=_T("VRML");}
    else if (CC5(Begin)==CC5("HVQM4")) {Format=_T("GameCube Movie");}
    else if (CC8(Begin)==CC8("KW-DIRAC")) {Format=_T("Dirac"); Extensions=_T("drc"); Url=_T("http://dirac.sourceforge.net/");}
    else if (CC5(Begin)==CC5("ustar")) {Format=_T("Tar archive");}
    //TODO: all archive magic numbers
    else if (CC4(Begin+1)==CC4("MSCB")) {Format=_T("MS Cabinet");}
    else if (CC4(Begin)==CC4(".snd")) {Format=_T("SUN Audio");}
    else if (CC4(Begin)==0x2E736400) {Format=_T("DEC Audio");}
    else if (CC4(Begin)==CC4("MThd")) {Format=_T("MIDI");}
    else if (CC4(Begin)==CC4("CTMF")) {Format=_T("CMF");}
    else if (CC3(Begin)==CC3("SBI")) {Format=_T("SoundBlaster");}
    else if (CC4(Begin)==CC4("EMOD")) {Format=_T("Ext. MOD");}
    else if (CC3(Begin)==CC3("TTA")) {Format=_T("True Audio"); Url=_T("http://www.true-audio.com/site.download"); Extensions=_T("tta");}
    else if (CC4(Begin)==CC4("wvpk")) {Format=_T("WavePack"); Url=_T("http://www.wavpack.com/downloads.html"); Extensions=_T("wv");}
    //TODO: Other Sound magic numbers
    else if (CC7(Begin)==CC7("BLENDER")) {Format=_T("Blender"); Url=_T("http://www.blender3d.com"); Extensions=_T("blenders");}
    else if (CC4(Begin)==CC4("AC10")) {Format=_T("AutoCAD"); Url=_T("http://www.autodesk.com"); Extensions=_T("dwg");}
    else if (CC2(Begin)==0x1F9D) {Format=_T("Compress");}
    else if (CC2(Begin)==0x1F8B) {Format=_T("GZip");}
    else if (CC2(Begin)==0x1F1E) {Format=_T("Huffman");}
    else if (CC3(Begin)==CC3("BZh")) {Format=_T("BZip2");}
    else if (CC2(Begin)==CC2("BZ")) {Format=_T("BZip1");}
    else if (CC3(Begin)==CC3("NES")) {Format=_T("NES ROM");}
    else if (CC4(Begin+0x104)==0xCEED6666) {Format=_T("GameBoy");}
    else if (CC4(Begin+0x100)==CC4("SEGA")) {Format=_T("MegaDrive");}
    else if (CC4(Begin+0x280)==CC4("EAGN")) {Format=_T("SupeMegaDrive");}
    else if (CC4(Begin+0x280)==CC4("EAMG")) {Format=_T("SupeMegaDrive");}
    else if (CC4(Begin)==0x21068028) {Format=_T("Dreamcast");}
    else if (CC4(Begin)==CC4("LCDi")) {Format=_T("Dreamcast");}
    else if (CC4(Begin)==0x37804012) {Format=_T("Nintendo64");}
    else if (CC8(Begin)==CC8("PS-X EXE")) {Format=_T("Playstation");}
    else if (CC4(Begin)==CC4("LCDi")) {Format=_T("Dreamcast");}
    else if (CC4(Begin)==CC4("XBEH")) {Format=_T("X-Box");}
    else if (CC4(Begin)==CC4("XIP0")) {Format=_T("X-Box");}
    else if (CC4(Begin)==CC4("XTF0")) {Format=_T("X-Box");}
    else if (CC2(Begin)==0x8008) {Format=_T("Lynx");}
    else if (CC7(Begin)==CC7("\x01ZZZZZ\x01")) {Format=_T("");}
    else if (CC4(Begin)==CC4("")) {Format=_T("");}
    else if (CC4(Begin)==CC4("")) {Format=_T("");}
    else if (CC4(Begin)==CC4("")) {Format=_T("");}
    else if (CC6(Begin)==CC6("1\r\n00:")) {Format=_T("SRT"); Extensions=_T("srt"); Url=_T("http://ffdshow.sourceforge.net/tikiwiki/tiki-index.php?page=Getting+ffdshow");
                                           Stream_Prepare(Stream_Text); Text[0](_T("Codec"))=_T("SRT");}
    else if (CC1(Begin+0)==CC1("[") && CC1(Begin+2)==CC1("S") && CC1(Begin+22)==CC1("o") && CC1(Begin+24)==CC1("]") //Unicode Text is : "[Script Info]
          || CC1(Begin+2)==CC1("[") && CC1(Begin+4)==CC1("S") && CC1(Begin+24)==CC1("o") && CC1(Begin+26)==CC1("]"))
                                          {Format=_T("SSA"); Extensions=_T("ssa"); Url=_T("http://ffdshow.sourceforge.net/tikiwiki/tiki-index.php?page=Getting+ffdshow");
                                           Stream_Prepare(Stream_Text); Text[0](_T("Codec"))=_T("SSA");}
    else if (CC6(Begin)==CC6("#!AMR\n"))
                {Format=_T("AMR"); Format_String=_T("Adaptive Multi-Rate"); Url=_T("http://www.apple.com/quicktime/download/standalone.html"); Extensions=_T("amr");
                Stream_Prepare(Stream_Audio); Audio[0](_T("Codec"))=_T("AMR"); Audio[0](_T("Codec/Url"))=_T("http://www.apple.com/quicktime/download/standalone.html");}

    if (Format.empty())
        return Error;
    Stream_Prepare(Stream_General);
    General[0](_T("Format"))=Format;
    General[0](_T("Format/Url"))=Url;
    General[0](_T("Format/Extensions"))=Extensions;
    return 1;
}

} //NameSpace

#endif
