// File_Aac - Info for SndFile files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about SndFile files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// 2005-11-07, Zen@MediaArea.net
// Adapted to new File__Base
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_SNDFILE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_SNDFILE_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <SndFile/SndFile.h>
#include "MediaInfo/Audio/File_SndFile.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

//---------------------------------------------------------------------------
int File_SndFile::Read ()
{
    SF_INFO Info;
    SNDFILE* File=sf_open(CompleteFileName.To_Local().c_str(), SFM_READ, &Info);
    if (!File)
        return -1;
    sf_close(File);

    Stream_Prepare(Stream_General);
    switch (Info.format&0xFFFF0000) //Major
    {
        case SF_FORMAT_WAV :
            General[0](_T("Format"))=_T("WAV");
            General[0](_T("Format/String"))=_T("Wave");
            General[0](_T("Format/Extensions"))=_T("wav");
            break;
        case SF_FORMAT_AIFF :
            General[0](_T("Format"))=_T("AIFF");
            General[0](_T("Format/String"))=_T("Apple/SGI AIFF");
            General[0](_T("Format/Extensions"))=_T("aiff aifc");
             break;
        case SF_FORMAT_AU :
            General[0](_T("Format"))=_T("Au");
            General[0](_T("Format/String"))=_T("Sun/NeXT AU");
            General[0](_T("Format/Extensions"))=_T("au");
             break;
        case SF_FORMAT_RAW :
            General[0](_T("Format"))=_T("Raw");
            General[0](_T("Format/String"))=_T("Raw");
            General[0](_T("Format/Extensions"))=_T("");
            break;
        case SF_FORMAT_PAF :
            General[0](_T("Format"))=_T("PAF");
            General[0](_T("Format/String"))=_T("Ensoniq PARIS");
            General[0](_T("Format/Extensions"))=_T("par");
            break;
        case SF_FORMAT_SVX :
            General[0](_T("Format"))=_T("SVX");
            General[0](_T("Format/String"))=_T("Amiga Iff / SVX8 / SV16");
            General[0](_T("Format/Extensions"))=_T("iff");
            break;
        case SF_FORMAT_NIST :
            General[0](_T("Format"))=_T("NIST");
            General[0](_T("Format/String"))=_T("Sphere NIST");
            General[0](_T("Format/Extensions"))=_T("nist");
            break;
        case SF_FORMAT_VOC :
            General[0](_T("Format"))=_T("VOC");
            General[0](_T("Format/String"))=_T("VOC");
            General[0](_T("Format/Extensions"))=_T("voc");
             break;
        case SF_FORMAT_IRCAM :
            General[0](_T("Format"))=_T("Ircam");
            General[0](_T("Format/String"))=_T("Berkeley/IRCAM/CARL");
            General[0](_T("Format/Extensions"))=_T("");
            break;
        case SF_FORMAT_W64 :
            General[0](_T("Format"))=_T("W64");
            General[0](_T("Format/String"))=_T("Sonic Foundry's Riff");
            General[0](_T("Format/Extensions"))=_T("w64");
            break;
        case SF_FORMAT_MAT4 :
            General[0](_T("Format"))=_T("MAT4");
            General[0](_T("Format/String"))=_T("Matlab 4");
            General[0](_T("Format/Extensions"))=_T("mat");
            break;
        case SF_FORMAT_MAT5 :
            General[0](_T("Format"))=_T("MAT5");
            General[0](_T("Format/String"))=_T("Matlab 5");
            General[0](_T("Format/Extensions"))=_T("mat");
            break;
        case SF_FORMAT_PVF :
            General[0](_T("Format"))=_T("PVF");
            General[0](_T("Format/String"))=_T("Portable Voice Format");
            General[0](_T("Format/Extensions"))=_T("pvf");
            break;
        case SF_FORMAT_XI :
            General[0](_T("Format"))=_T("XI");
            General[0](_T("Format/String"))=_T("FastTracker 2 Extended");
            General[0](_T("Format/Extensions"))=_T("xi");
            break;
        case SF_FORMAT_HTK :
            General[0](_T("Format"))=_T("HTK");
            General[0](_T("Format/String"))=_T("HMM Toolkit");
            General[0](_T("Format/Extensions"))=_T("htk");
            break;
        case SF_FORMAT_SDS :
            General[0](_T("Format"))=_T("SDS");
            General[0](_T("Format/String"))=_T("Midi Sample");
            General[0](_T("Format/Extensions"))=_T("sds");
            break;
        case SF_FORMAT_AVR :
            General[0](_T("Format"))=_T("AVR");
            General[0](_T("Format/String"))=_T("Audio Visual Research");
            General[0](_T("Format/Extensions"))=_T("avr");
            break;
        case SF_FORMAT_WAVEX :
            General[0](_T("Format"))=_T("RIFF");
            General[0](_T("Format/String"))=_T("RIFF");
            General[0](_T("Format/Extensions"))=_T("wav");
            break;
        case SF_FORMAT_SD2 :
            General[0](_T("Format"))=_T("SD2");
            General[0](_T("Format/String"))=_T("Sound Designer 2");
            General[0](_T("Format/Extensions"))=_T("sd2");
        }

    //Codec
    Stream_Prepare(Stream_Audio);
    switch (Info.format&0x0000FFFF) //Minor
    {
        case SF_FORMAT_PCM_S8 :
            Audio[0](_T("Codec"))=_T("PCM");
            Audio[0](_T("Resolution"))=_T("8");
            break;
        case SF_FORMAT_PCM_16 :
            Audio[0](_T("Codec"))=_T("PCM");
            Audio[0](_T("Resolution"))=_T("16");
            break;
        case SF_FORMAT_PCM_24 :
            Audio[0](_T("Codec"))=_T("PCM");
            Audio[0](_T("Resolution"))=_T("24");
            break;
        case SF_FORMAT_PCM_32 :
            Audio[0](_T("Codec"))=_T("PCM");
            Audio[0](_T("Resolution"))=_T("8");
            break;
        case SF_FORMAT_PCM_U8 :
            Audio[0](_T("Codec"))=_T("PCM");
            Audio[0](_T("Resolution"))=_T("8");
            break;
        case SF_FORMAT_FLOAT :
            Audio[0](_T("Codec"))=_T("Float");
            Audio[0](_T("Resolution"))=_T("32");
            break;
        case SF_FORMAT_DOUBLE :
            Audio[0](_T("Codec"))=_T("Float");
            Audio[0](_T("Resolution"))=_T("64");
            break;
        case SF_FORMAT_ULAW :
            Audio[0](_T("Codec"))=_T("U-Law");
            Audio[0](_T("Resolution"))=_T("");
            break;
        case SF_FORMAT_ALAW :
            Audio[0](_T("Codec"))=_T("A-Law");
            Audio[0](_T("Resolution"))=_T("");
            break;
        case SF_FORMAT_IMA_ADPCM :
            Audio[0](_T("Codec"))=_T("ADPCM");
            Audio[0](_T("Resolution"))=_T("");
            break;
        case SF_FORMAT_MS_ADPCM :
            Audio[0](_T("Codec"))=_T("ADPCM");
            Audio[0](_T("Resolution"))=_T("");
            break;
        case SF_FORMAT_GSM610 :
            Audio[0](_T("Codec"))=_T("GSM 6.10");
            Audio[0](_T("Resolution"))=_T("");
            break;
        case SF_FORMAT_G721_32 :
            Audio[0](_T("Codec"))=_T("G721");
            Audio[0](_T("Resolution"))=_T("");
            break;
        case SF_FORMAT_G723_24 :
            Audio[0](_T("Codec"))=_T("G723");
            Audio[0](_T("Resolution"))=_T("");
            break;
        case SF_FORMAT_DWVW_12 :
            Audio[0](_T("Codec"))=_T("Delta");
            Audio[0](_T("Resolution"))=_T("12");
            break;
        case SF_FORMAT_DWVW_16 :
            Audio[0](_T("Codec"))=_T("Delta");
            Audio[0](_T("Resolution"))=_T("16");
            break;
        case SF_FORMAT_DWVW_24 :
            Audio[0](_T("Codec"))=_T("Delta");
            Audio[0](_T("Resolution"))=_T("24");
            break;
        case SF_FORMAT_DWVW_N :
            Audio[0](_T("Codec"))=_T("Delta");
            Audio[0](_T("Resolution"))=_T("");
            break;
        case SF_FORMAT_DPCM_8 :
            Audio[0](_T("Codec"))=_T("8 bits diff");
            Audio[0](_T("Resolution"))=_T("");
            break;
        case SF_FORMAT_DPCM_16 :
            Audio[0](_T("Codec"))=_T("16 bits diff");
            Audio[0](_T("Resolution"))=_T("");
            break;
        }

    Audio[0](_T("SamplingCount")).From_Number(Info.frames);
    Audio[0](_T("SamplingRate")).From_Number(Info.samplerate);
    Audio[0](_T("PlayTime")).From_Number(Info.frames*1000/Info.samplerate);
    Audio[0](_T("Channel(s)")).From_Number(Info.channels);

    General_Fill(); //To have filesize
    Audio[0](_T("BitRate")).From_Number(General[0](_T("FileSize")).To_int32s()*8*Info.samplerate/Info.frames/1000);

    return 1;
}

//---------------------------------------------------------------------------
void File_SndFile::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
        General[0](_T("PlayTime"), Info_HowTo)=_T("R");
        General[0](_T("OveralBitrate"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Audio)
    {
        Audio[0](_T("Codec"), Info_HowTo)=_T("R");
        Audio[0](_T("BitRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Channel(s)"), Info_HowTo)=_T("R");
        Audio[0](_T("SamplingRate"), Info_HowTo)=_T("R");
        Audio[0](_T("SamplingCount"), Info_HowTo)=_T("R");
        Audio[0](_T("Resolution"), Info_HowTo)=_T("R");
        Audio[0](_T("PlayTime"), Info_HowTo)=_T("R");
    }
}

} //NameSpace

#endif //MEDIAINFO_SNDFILE_*

