// File_Mpc - Info for Musepack files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about Musepack files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// 2005-12-10, Zen@MediaArea.net
// First release
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_MPC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_MPC_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <cstdio>
#if defined(_WIN32) && !defined(WIN32)
    #define WIN32
#endif
#include <mpcdec/mpcdec.h>
#include <mpcdec/reader.h>
#include <mpcdec/streaminfo.h>
#include "MediaInfo/Audio/File_Mpc.h"
using namespace std;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

int File_Mpc::Read()
{
    #ifdef UNICODE
        FILE *File=_wfopen(CompleteFileName.c_str(), L"rb");
    #else //UNICODE
        FILE *File=fopen(CompleteFileName.c_str(), "rb");
    #endif //UNICODE
    if (!File)
        return -1;

    mpc_reader_file Reader;
    mpc_reader_setup_file_reader(&Reader, File);

    mpc_streaminfo Info;
    mpc_streaminfo_init(&Info);
    if (mpc_streaminfo_read(&Info, &Reader.reader)!=ERROR_CODE_OK)
    {
        fclose(File);
        return -1; //Not a Musepack file
    }

    Stream_Prepare(Stream_General);
    General[0](_T("Format"))=_T("Musepack");
    General[0](_T("Format/String"))=_T("Musepack");
    General[0](_T("Format/Url"))=_T("http://www.musepack.net");
    General[0](_T("Format/Extensions"))=_T("MPC MP+");

    Stream_Prepare(Stream_Audio);
    if (Info.sample_freq)
        Audio[0](_T("SamplingRate")).From_Number(Info.sample_freq);
    if (Info.pcm_samples)
        Audio[0](_T("SamplingCount")).From_Number(Info.pcm_samples);
    if (Info.average_bitrate)
        Audio[0](_T("BitRate")).From_Number(Info.average_bitrate, 0);
    if (Info.stream_version)
        Audio[0](_T("Codec"))=Ztring::Ztring(_T("SV"))+Ztring::ToZtring(Info.stream_version);
    if (Info.profile<16 && Info.profile_name)
        Audio[0](_T("Codec/Info")).From_Local(Info.profile_name);
    if (Info.channels)
        Audio[0](_T("Channel(s)")).From_Number(Info.channels);
    if (Info.encoder)
        General[0](_T("Encoded_Library")).From_Local(Info.encoder);
    Audio[0](_T("Resolution")).From_Number(16); //MPC support only 16 bits

    fclose(File);
    return 1;
}

void File_Mpc::HowTo(stream_t StreamKind)
{
        if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
        General[0](_T("OverallBitRate"), Info_HowTo)=_T("R");
        General[0](_T("PlayTime"), Info_HowTo)=_T("R");
        General[0](_T("Encoded_Library"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Audio)
    {
        Audio[0](_T("Codec"), Info_HowTo)=_T("R");
        Audio[0](_T("BitRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Channel(s)"), Info_HowTo)=_T("R");
        Audio[0](_T("SamplingRate"), Info_HowTo)=_T("R");
        Audio[0](_T("SamplingCount"), Info_HowTo)=_T("R");
        Audio[0](_T("Resolution"), Info_HowTo)=_T("R");
    }
}

} //NameSpace

#endif

