// File_Id3 - Info for ID3v2 tagged files
// Copyright (C) 2005-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about ID3v2 tagged files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_ID3_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_ID3_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <wx/file.h>
#include <wx/filename.h>
#include <ZenLib/Utils.h>
#include <ZenLib/ZtringListList.h>
#include "MediaInfo/Audio/File_Id3.h"
#define ID3LIB_LINKOPTION 1 //Needed by id3lib
#include <id3/tag.h>
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//---------------------------------------------------------------------------
void Id3_Normalize_Date(Ztring& Date);
//---------------------------------------------------------------------------

//***************************************************************************
// Functions
//***************************************************************************

//---------------------------------------------------------------------------
int File_Id3::Read()
{
	char Infos[10002];
    ID3_Tag ID3v2;  //ID3v2
	try{ID3v2.Link(CompleteFileName.To_Local().c_str());} catch (...){return -1;}

    ID3_Frame *Frame;
    ID3_Tag::Iterator* iter = ID3v2.CreateIterator();
    Frame=iter->GetNext();
    if (Frame==NULL) //No Id3 tags
        return -1;
    Stream_Prepare(Stream_General);
    Stream_Prepare(Stream_Audio);

    ID3_FieldID FieldID;
    Ztring FrameName, Value;
    Ztring Year, Month, Day, Hour, Minute;
    size_t Method;
    while (Frame!=NULL)
    {
        FieldID=ID3FN_TEXT;
        Method=0;
        switch (Frame->GetID())
        {
            case ID3FID_PICTURE : General[0](_T("Cover"))=_T("Yes"); FieldID=ID3FN_NOFIELD; break;
            case ID3FID_COMMENT :
                         //Comments from v2 comes before comment from v1 --> If already a v2 comment, skip v1 comment
                         if (General[0](_T("Comment")).empty())
                            FrameName=_T("Comment");
                        else
                            FieldID=ID3FN_NOFIELD;
                        break;
            case ID3FID_ALBUM : FrameName=_T("Album"); break;
            case ID3FID_BPM : FrameName=_T("BPM"); break;
            case ID3FID_COMPOSER : FrameName=_T("Composer"); break;
            case ID3FID_CONTENTTYPE : FrameName=_T("Genre"); break;
            case ID3FID_COPYRIGHT : FrameName=_T("Copyright"); break;
            case ID3FID_DATE :
                        //Format : DDMM
                        Frame->Field(ID3FN_TEXT).Get(Infos, 4);
                        Month.From_Local(Infos, 2, 2);
                        Day.From_Local(Infos, 0, 2);
                        FieldID=ID3FN_NOFIELD;
                        break;
            case ID3FID_ENCODINGTIME : FrameName=_T("Encoded_Date"); break;
            case ID3FID_ORIGRELEASETIME : FrameName=_T("Original/Released_Date"); break;
            case ID3FID_RECORDINGTIME : FrameName=_T("Recorded_Date"); break;
            case ID3FID_RELEASETIME : FrameName=_T("Released_Date"); break;
            case ID3FID_TAGGINGTIME : FrameName=_T("Tagged_Date"); break;
            case ID3FID_INVOLVEDPEOPLE2 : FrameName=_T("ThanksTo"); break;
            case ID3FID_ENCODEDBY : FrameName=_T("Encoded_Library"); break;
            case ID3FID_LYRICIST : FrameName=_T("Lyricist"); break;
            case ID3FID_TIME :
                        //Format : HHMM
                        Frame->Field(ID3FN_TEXT).Get(Infos, 4);
                        Hour.From_Local(Infos, 0, 2);
                        Minute.From_Local(Infos, 2, 2);
                        FieldID=ID3FN_NOFIELD;
                        break;
            case ID3FID_CONTENTGROUP : FrameName=_T("ContentType"); break;
            case ID3FID_TITLE: FrameName=_T("Track"); break;
            case ID3FID_SUBTITLE : FrameName=_T("Track/More"); break;
            case ID3FID_LANGUAGE : FrameName=_T("Language"); Method=2; break;
            case ID3FID_MUSICIANCREDITLIST : FieldID=ID3FN_NOFIELD; break; //TODO: Musician\0Instrument\0Musician\0Instrument...
            case ID3FID_MEDIATYPE : FrameName=_T("Encoded_Original"); break;
            case ID3FID_MOOD : FrameName=_T("Mood"); break;
            case ID3FID_ORIGALBUM : FrameName=_T("Original/Album"); break;
            case ID3FID_ORIGLYRICIST : FrameName=_T("Original/Lyricist"); break;
            case ID3FID_ORIGARTIST : FrameName=_T("Original/Performer"); break;
            case ID3FID_ORIGYEAR : FrameName=_T("Original/Released_Date"); break;
            case ID3FID_FILEOWNER : FrameName=_T("Purchased_Owner"); break;
            case ID3FID_LEADARTIST : FrameName=_T("Performer"); break;
            case ID3FID_BAND : FrameName=_T("Accompaniment"); break;
            case ID3FID_CONDUCTOR : FrameName=_T("Conductor"); break;
            case ID3FID_MIXARTIST : FrameName=_T("RemixedBy"); break;
            case ID3FID_PARTINSET : FrameName=_T("Part/Position"); break;
            case ID3FID_PRODUCEDNOTICE : FrameName=_T("Producer_Copyright"); break;
            case ID3FID_PUBLISHER : FrameName=_T("Publisher"); break;
            case ID3FID_TRACKNUM : FrameName=_T("Track/Position"); break;
            case ID3FID_RECORDINGDATES : FrameName=_T("Recorded_Date"); break;
            case ID3FID_NETRADIOSTATION : FrameName=_T("RadioStation"); break;
            case ID3FID_NETRADIOOWNER : FrameName=_T("RadioStation/Owner"); break;
            case ID3FID_ALBUMSORTORDER : FrameName=_T("Album/Sort"); break;
            case ID3FID_PERFORMERSORTORDER : FrameName=_T("Performer/Sort"); break;
            case ID3FID_TITLESORTORDER : FrameName=_T("Track/Sort"); break;
            case ID3FID_ISRC : FrameName=_T("ISRC"); break;
            case ID3FID_ENCODERSETTINGS : FrameName=_T("Encoded_Library_Settings"); break;
            case ID3FID_YEAR :
                        //Format : YYYY
                        Frame->Field(ID3FN_TEXT).Get(Infos, 4);
                        Year.From_Local(Infos, 4);
                        FieldID=ID3FN_NOFIELD;
                        break;
            case ID3FID_USERTEXT : Method=1; break;
            case ID3FID_WWWUSER : FieldID=ID3FN_URL; Method=1; break;
            default : FieldID=ID3FN_NOFIELD;
        }

        //Feed MediaInfo
        if (FieldID!=ID3FN_NOFIELD)
        {
            //Character encoding
            //TODO : Character encoding support.

            //Format
            //-Value
                 if (Method==0)
            {
                size_t Size=Frame->Field(FieldID).Get(Infos, 10000);
                General[0](FrameName).From_Local(Infos, Size);
            }
            //-Description\x00\Value
            else if (Method==1)
            {
                size_t Size=Frame->Field(FieldID).Get(Infos, 10000);
                Infos[Size-1]=_T('\0');
                Ztring Description; Description.From_Local(Infos);
                Ztring Value; Value.From_Local(Infos, Description.size()+1, Size-Description.size()-1);
                General[0](Description)=Value;
            }
            //-Value but in Audio part
            else if (Method==2)
            {

                size_t Size=Frame->Field(FieldID).Get(Infos, 10000);
                Audio[0](FrameName).From_Local(Infos, Size);
            }
        }
        Frame=iter->GetNext();
    }
    delete iter;

    //Specific formats (multiple Id3 tags for one MI tag)
    Ztring Recorded_Date;
    if (Get(Stream_General, 0, _T("Recorded_Date")).empty() && !Year.empty())
    {
        Recorded_Date+=Year;
        if (!Month.empty() && !Month.empty())
        {
            Recorded_Date+=_T("-");
            Recorded_Date+=Year;
            Recorded_Date+=_T("-");
            Recorded_Date+=Day;
            if (!Month.empty() && !Month.empty())
            {
                Recorded_Date+=_T(" ");
                Recorded_Date+=Hour;
                Recorded_Date+=_T(":");
                Recorded_Date+=Minute;
            }
        }
    }
    if (!Recorded_Date.empty())
        General[0](_T("Recorded_Date"))=Recorded_Date;

    //Special cases
    //-Specific Id3 formating
    Id3_Normalize_Date(General[0](_T("Encoded_Date")));
    Id3_Normalize_Date(General[0](_T("Original/Released_Date")));
    Id3_Normalize_Date(General[0](_T("Recorded_Date")));
    Id3_Normalize_Date(General[0](_T("Released_Date")));
    Id3_Normalize_Date(General[0](_T("Tagged_Date")));
    //-Position and total parts
    if (General[0](_T("Part/Position")).find(_T("/"))!=Error)
    {
        General[0](_T("Album/Total_Parts"))=General[0](_T("Part/Position")).SubString(_T("/"), _T(""));
        General[0](_T("Part/Position"))=General[0](_T("Part/Position")).SubString(_T(""), _T("/"));
    }
    if (General[0](_T("Track/Position")).find(_T("/"))!=Error)
    {
        General[0](_T("Part/Total_Parts"))=General[0](_T("Track/Position")).SubString(_T("/"), _T(""));
        General[0](_T("Track/Position"))=General[0](_T("Track/Position")).SubString(_T(""), _T("/"));
        if (General[0](_T("Part/Position")).empty())
        {
            //There is no parts
            General[0](_T("Album/Total_Parts"))=General[0](_T("Part/Total_Parts"));
            General[0](_T("Part/Total_Parts")).clear();
        }
    }
    //-Genre
    if (General[0](_T("Genre")).find(_T("("))==0)
    {
        if (General[0](_T("Genre")).find(_T(")"))==General[0](_T("Genre")).size()-1)
        {
            size_t Pos=General[0](_T("Genre")).SubString(_T("("), _T(")")).To_int32s();
            if (Pos<ID3_NR_OF_V1_GENRES)
                General[0](_T("Genre"))=General[0](_T("Genre")).SubString(_T("("), _T(")")); //Replace (nn) by nn
        }
        else
            General[0](_T("Genre"))=General[0](_T("Genre")).SubString(_T("("), _T(")")); //Replace (XX)HardRock by XX
    }


    //Close
    ID3v2.Clear();

	return 1;
}

//---------------------------------------------------------------------------
int File_Id3::Read(const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    //Use a temporary file
    wxString FileName_Temp=wxFileName::CreateTempFileName(_T("MI_"));
    Ztring CompleteFileName_Save=CompleteFileName;
    CompleteFileName=FileName_Temp.c_str();

    //Write the file
    wxFile F;
    F.Open(FileName_Temp, wxFile::write);
    if (Begin_Size>0)
        F.Write(Begin, Begin_Size);
    if (End_Size>0)
        F.Write(End, End_Size);
    F.Close();

    //Read file
    int ToReturn=Read();

    //Replace the real filename if exists, and cleanup
    CompleteFileName=CompleteFileName_Save;
    wxRemoveFile(FileName_Temp);

    return ToReturn;
}

//---------------------------------------------------------------------------
void File_Id3::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Cover"), Info_HowTo)=_T("R");
        General[0](_T("Comment"), Info_HowTo)=_T("R");
        General[0](_T("Album"), Info_HowTo)=_T("R");
        General[0](_T("BPM"), Info_HowTo)=_T("R");
        General[0](_T("Composer"), Info_HowTo)=_T("R");
        General[0](_T("Genre"), Info_HowTo)=_T("R");
        General[0](_T("Copyright"), Info_HowTo)=_T("R");
        General[0](_T("Encoded_Date"), Info_HowTo)=_T("R");
        General[0](_T("Original/Released_Date"), Info_HowTo)=_T("R");
        General[0](_T("Recorded_Date"), Info_HowTo)=_T("R");
        General[0](_T("Released_Date"), Info_HowTo)=_T("R");
        General[0](_T("Tagged_Date"), Info_HowTo)=_T("R");
        General[0](_T("ThanksTo"), Info_HowTo)=_T("R");
        General[0](_T("Encoded_Library"), Info_HowTo)=_T("R");
        General[0](_T("Lyricist"), Info_HowTo)=_T("R");
        General[0](_T("ContentType"), Info_HowTo)=_T("R");
        General[0](_T("Track"), Info_HowTo)=_T("R");
        General[0](_T("Track/More"), Info_HowTo)=_T("R");
        General[0](_T("Encoded_Original"), Info_HowTo)=_T("R");
        General[0](_T("Mood"), Info_HowTo)=_T("R");
        General[0](_T("Original/Album"), Info_HowTo)=_T("R");
        General[0](_T("Original/Lyricist"), Info_HowTo)=_T("R");
        General[0](_T("Original/Performer"), Info_HowTo)=_T("R");
        General[0](_T("Original/Released_Date"), Info_HowTo)=_T("R");
        General[0](_T("Purchased_Owner"), Info_HowTo)=_T("R");
        General[0](_T("Performer"), Info_HowTo)=_T("R");
        General[0](_T("Accompaniment"), Info_HowTo)=_T("R");
        General[0](_T("Conductor"), Info_HowTo)=_T("R");
        General[0](_T("RemixedBy"), Info_HowTo)=_T("R");
        General[0](_T("Part/Position"), Info_HowTo)=_T("R");
        General[0](_T("Producer_Copyright"), Info_HowTo)=_T("R");
        General[0](_T("Publisher"), Info_HowTo)=_T("R");
        General[0](_T("Track/Position"), Info_HowTo)=_T("R");
        General[0](_T("Track/Position"), Info_HowTo)=_T("R");
        General[0](_T("Recorded_Date"), Info_HowTo)=_T("R");
        General[0](_T("RadioStation"), Info_HowTo)=_T("R");
        General[0](_T("RadioStation/Owner"), Info_HowTo)=_T("R");
        General[0](_T("Album/Sort"), Info_HowTo)=_T("R");
        General[0](_T("Performer/Sort"), Info_HowTo)=_T("R");
        General[0](_T("Track/Sort"), Info_HowTo)=_T("R");
        General[0](_T("ISRC"), Info_HowTo)=_T("R");
        General[0](_T("Encoded_Library_Settings"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Audio)
    {
        Audio[0](_T("Language"), Info_HowTo)=_T("R");
    }
}

void Id3_Normalize_Date(Ztring& Date)
{
    if (Date.size()<=8)
        return; //Format unknown
    Date[8]=_T(' '); //could be "T"
    Date=Ztring(_T("UTC "))+Date; //Id3v2 specify a UTC date
}

} //NameSpace

#endif //MEDIAINFO_MPEG_*

