// File_Flac - Info for Flac files
// Copyright (C) 2003-2004 Jasper van de Gronde, th.v.d.gronde@hccnet.nl
// Copyright (C) 2003-2006 Jerome Martinez, zen@mediaarea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about Flac files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// 2005-11-07, Zen@MediaArea.net
// Adapted to new File__Base
//
// 2004-09-10, th.v.d.gronde@hccnet.nl
// Adaptation to some changes in File_Base
//
// 2003-??-??, th.v.d.gronde@hccnet.nl
// Creation of file
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_FLAC_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_FLAC_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <sstream>
#include <map>
#include <boost/tokenizer.hpp>
#include <wx/string.h>
#include <ZenLib/ZtringListList.h>
#include <ZenLib/Utils.h>
#define FLAC__NO_DLL
#include <FLAC++/metadata.h>
#undef FLAC__NO_DLL
#include "MediaInfo/Audio/File_Flac.h"
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

typedef std::pair<const Char*,const Char*> mapping_t;

static const mapping_t to_mediainfo_data[]={
    mapping_t(_T("ARTIST"),_T("Performer")),
    mapping_t(_T("PERFORMER"),_T("Performer")),
    mapping_t(_T("DESCRIPTION"),_T("Comment")),
    mapping_t(_T("DATE"),_T("Date")),
    mapping_t(_T("LOCATION"),_T("RecordingLocation")),
    mapping_t(_T("TITLE"),_T("Title")),
    mapping_t(_T("ALBUM"),_T("Album")),
    mapping_t(_T("TRACKNUMBER"),_T("Track")),
    mapping_t(_T("COPYRIGHT"),_T("Copyright"))
};

static const std::pair<tstring, tstring> from_mediainfo_data[]={
    mapping_t(_T("PERFORMER"),_T("PERFORMER")),
    mapping_t(_T("COMMENT"),_T("DESCRIPTION")),
    mapping_t(_T("DATE"),_T("DATE")),
    mapping_t(_T("RECORDINGLOCATION"),_T("LOCATION")),
    mapping_t(_T("TITLE"),_T("TITLE")),
    mapping_t(_T("ALBUM"),_T("ALBUM")),
    mapping_t(_T("TRACK"),_T("TRACKNUMBER")),
    mapping_t(_T("COPYRIGHT"),_T("COPYRIGHT"))
};

typedef const std::map<tstring, tstring> to_mediainfo_t;
static to_mediainfo_t to_mediainfo(to_mediainfo_data,to_mediainfo_data+(sizeof(to_mediainfo_data)/sizeof(to_mediainfo_data[0])));

typedef to_mediainfo_t from_mediainfo_t;
static from_mediainfo_t from_mediainfo(from_mediainfo_data,from_mediainfo_data+(sizeof(from_mediainfo_data)/sizeof(from_mediainfo_data[0])));

//***************************************************************************
// Functions
//***************************************************************************

int File_Flac::Read()
{
    FLAC::Metadata::SimpleIterator metadata_it;
    if ( metadata_it.is_valid() == false ) return -1;
    if ( metadata_it.init(wxString(CompleteFileName.c_str()).mb_str(*wxConvCurrent), true, true) == false ) return -1;
    Stream_Prepare(Stream_General);

    // This happens after we have checked everything is okay with the file.
    size_t Audio_Count=Stream_Prepare(Stream_Audio);
    if (Audio_Count!=0)
        return -1;
    General[0](_T("Format"))=_T("FLAC");
    General[0](_T("Format/String"))=_T("Free Lossless Audio Codec");
    General[0](_T("Format/Extensions"))=_T("FLAC");
    General[0](_T("Format/Url"))=_T("http://flac.sourceforge.net/");
    Audio[Audio_Count](_T("Codec"))=_T("FLAC");

    do {
        switch(metadata_it.get_block_type()) {
        case FLAC__METADATA_TYPE_STREAMINFO:
            {
                FLAC::Metadata::StreamInfo* streaminfo=(FLAC::Metadata::StreamInfo*)metadata_it.get_block();
                if ( streaminfo )
                {
                    if ( streaminfo->get_min_framesize() == streaminfo->get_max_framesize() && streaminfo->get_min_framesize() != 0 ) { // 0 means it is unknown
                        Audio[0](_T("BitRate_Mode"))=_T("CBR");
                    } else {
                        Audio[0](_T("BitRate_Mode"))=_T("VBR");
                    }
                    Audio[0](_T("SamplingRate")).From_Number(streaminfo->get_sample_rate());
                    Audio[0](_T("Channel(s)")).From_Number(streaminfo->get_channels());
                    Audio[0](_T("Resolution")).From_Number(streaminfo->get_bits_per_sample());
                    General[0](_T("PlayTime")).From_Number(static_cast<unsigned int>(static_cast<double>(int64u_float64(streaminfo->get_total_samples()))*double(1000)/static_cast<double>(streaminfo->get_sample_rate())));

                    std::basic_stringstream<Char> md5sum;
                    md5sum << std::hex;
                    md5sum.width(2);
                    md5sum.fill('0');
                    for(int t=16; t!=0; --t) {
                        md5sum << static_cast<int>(streaminfo->get_md5sum()[t]);
                        if ( t!=1 ) md5sum << _T(":");
                    }
                    //if ( Audio[0].Rechercher(_T("MD5_Sum")) == -1 ) Audio[0].push_back(_T("MD5_Sum"));
                    Audio[0](_T("MD5_Sum"))=md5sum.str();
                }
            }
            break;
        case FLAC__METADATA_TYPE_PADDING:
            break;
        case FLAC__METADATA_TYPE_APPLICATION:
            {
                // At the moment there are only two registered id's and I don't think they're used much.
            }
            break;
        //case FLAC__METADATA_TYPE_SEEKTABLE: // Not needed
            //break;
        case FLAC__METADATA_TYPE_VORBIS_COMMENT:
            {
                FLAC::Metadata::VorbisComment* vorbiscomment =(FLAC::Metadata::VorbisComment*)metadata_it.get_block();
                if ( vorbiscomment )
                {
                    Audio[0](_T("Encoded_Library"))=Ztring(wxString(std::string(vorbiscomment->get_vendor_string().get_field(),vorbiscomment->get_vendor_string().get_field_length()).c_str(),wxConvUTF8).c_str());
                    for(unsigned int t=0; t<vorbiscomment->get_num_comments(); ++t)
                    {
                        const Ztring key_org(wxString(std::string(vorbiscomment->get_comment(t).get_field_name(),vorbiscomment->get_comment(t).get_field_name_length()).c_str(),wxConvUTF8).c_str());
                        const Ztring value(wxString(std::string(vorbiscomment->get_comment(t).get_field_value(),vorbiscomment->get_comment(t).get_field_value_length()).c_str(),wxConvUTF8).c_str());
                        Ztring fieldname;
                        Ztring key(key_org);

                        key.MakeUpperCase();
                        {
                            to_mediainfo_t::const_iterator it(to_mediainfo.find(key));
                            if ( it != to_mediainfo.end() ) {
                                fieldname=it->second;
                            } else {
                                fieldname=key_org;
                            }
                        }
                        if ( General[0](fieldname) != _T("") ) General[0](fieldname)+=_T("/");
                        General[0](fieldname)+=value; // Is it correct to use += here?
                    }
                }
            }
            break;
        case FLAC__METADATA_TYPE_CUESHEET:
            {
                // Should the cue sheet data be processed too?
                // Zen : Yes, in the Chapters[0] string list.
            }
            break;
        };
    } while(metadata_it.next());

    return 1;
}

int File_Flac::Write (const Ztring &ToSet, stream_t StreamKind, size_t StreamNumber, const Ztring &Parameter, const Ztring &OldValue)
{
    if ( StreamNumber != 0 )
        return 1;

    FLAC::Metadata::SimpleIterator metadata_it;
    if ( metadata_it.is_valid() == false ) return -1;
    if ( metadata_it.init(wxString(General[0](_T("CompleteName")).c_str()).mb_str(*wxConvCurrent), true, true) == false ) return -1;
    if ( metadata_it.is_writable() == false ) return -1;

    Ztring key_org;
    {
        from_mediainfo_t::const_iterator it(from_mediainfo.find(Parameter));
        if ( it != from_mediainfo.end() ) {
            key_org=it->second;
        } else {
            key_org=Parameter;
        }
    }
    Ztring key(key_org);
    key.MakeUpperCase();

    switch(StreamKind)
    {
    //case Stream_General:
    case Stream_Audio:
        {
            bool have_found_vorbiscomment=false;
            do {
                switch(metadata_it.get_block_type()) {
                case FLAC__METADATA_TYPE_VORBIS_COMMENT:
                    {
                        have_found_vorbiscomment=true;
                        FLAC::Metadata::VorbisComment* vorbiscomment =(FLAC::Metadata::VorbisComment*)metadata_it.get_block();
                        if ( vorbiscomment )
                        {
                            if ( key == _T("Encoded_Library") )
                            {
                                std::string temp_vendor_string(wxString(ToSet.c_str()).mb_str(wxConvUTF8));
                                vorbiscomment->set_vendor_string(FLAC::Metadata::VorbisComment::Entry(temp_vendor_string.c_str(), temp_vendor_string.size()));
                                //TODO metadata_it.set_block(vorbiscomment.get());
                            }
                            else
                            {
                                for(unsigned int t=0; t<vorbiscomment->get_num_comments(); ++t)
                                {
                                    const Ztring curkey_org(wxString(std::string(vorbiscomment->get_comment(t).get_field_name(),vorbiscomment->get_comment(t).get_field_name_length()).c_str(),wxConvUTF8).c_str());
                                    const Ztring curvalue(wxString(std::string(vorbiscomment->get_comment(t).get_field_value(),vorbiscomment->get_comment(t).get_field_value_length()).c_str(),wxConvUTF8).c_str());
                                    Ztring fieldname;
                                    Ztring curkey(curkey_org);

                                    curkey.MakeUpperCase();
                                    {
                                        to_mediainfo_t::const_iterator it(to_mediainfo.find(curkey));
                                        if ( it != to_mediainfo.end() ) {
                                            fieldname=it->second;
                                        } else {
                                            fieldname=curkey_org;
                                        }
                                    }
                                    if ( key == curkey || key == fieldname )
                                    {
                                        vorbiscomment->delete_comment(t);
                                        --t;
                                    }
                                }
                                if ( !ToSet.empty() )
                                {
                                    typedef boost::tokenizer<boost::char_separator<Char>,tstring::iterator,tstring > tokenizer_t;
                                    boost::char_separator<Char> sep(_T("/"));
                                    tstring tempstr(ToSet); // This shouldn't be necessary, but somehow I couldn't get it to work without this.
                                    tokenizer_t tokens(tempstr.begin(), tempstr.end(), sep);
                                    for(tokenizer_t::iterator tok_it=tokens.begin(); tok_it!=tokens.end();++tok_it) {
                                        const std::string t_tok_it(wxString(tok_it->c_str()).mb_str(wxConvUTF8));
                                        vorbiscomment->insert_comment(vorbiscomment->get_num_comments(),FLAC::Metadata::VorbisComment::Entry(wxString(key_org.c_str()).mb_str(wxConvUTF8),t_tok_it.c_str(),t_tok_it.size()));
                                    }
                                }
                                //TODO metadata_it.set_block(vorbiscomment.get());
                            }
                            return 1;
                        }
                    }
                    break;
                };
            } while(metadata_it.next());

            if ( !have_found_vorbiscomment && !ToSet.empty() )
            {
                FLAC::Metadata::VorbisComment* vorbiscomment =(FLAC::Metadata::VorbisComment*)metadata_it.get_block();

                std::string temp_vendor_string((wxString(_T("MediaInfo library "))+wxString(__DATE__,wxConvLibc)).mb_str(wxConvUTF8));
                vorbiscomment->set_vendor_string(FLAC::Metadata::VorbisComment::Entry(temp_vendor_string.c_str(), temp_vendor_string.size()));
                {
                    typedef boost::tokenizer<boost::char_separator<Char>,Ztring::iterator,Ztring > tokenizer_t;
                    boost::char_separator<Char> sep(_T("/"));
                    tstring tempstr(ToSet); // This shouldn't be necessary, but somehow I couldn't get it to work without this.
                    tokenizer_t tokens(tempstr.begin(), tempstr.end(), sep);
                    for(tokenizer_t::iterator tok_it=tokens.begin(); tok_it!=tokens.end();++tok_it) {
                        const std::string t_tok_it(wxString(tok_it->c_str()).mb_str(wxConvUTF8));
                        vorbiscomment->insert_comment(vorbiscomment->get_num_comments(),FLAC::Metadata::VorbisComment::Entry(wxString(key_org.c_str()).mb_str(wxConvUTF8),t_tok_it.c_str(),t_tok_it.size()));
                    }
                }

                //TODO metadata_it.insert_block_after(vorbiscomment.get());
            }
        }
        break;
    }

    return -1;
}

void File_Flac::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
        General[0](_T("OveralBitRate"), Info_HowTo)=_T("R");
        General[0](_T("Title"), Info_HowTo)=_T("R");
        General[0](_T("Title/More"), Info_HowTo)=_T("R");
        General[0](_T("PlayTime"), Info_HowTo)=_T("R");
        General[0](_T("Author"), Info_HowTo)=_T("R");
        General[0](_T("Album"), Info_HowTo)=_T("R");
        General[0](_T("Track"), Info_HowTo)=_T("R");
        General[0](_T("Comment"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Audio)
    {
        Audio[0](_T("BitRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Channel(s)"), Info_HowTo)=_T("R");
        Audio[0](_T("SamplingRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Codec"), Info_HowTo)=_T("R");
    }
}

} //NameSpace

#endif //MEDIAINFO_FLAC_*

