// File_Ape - Info for Ape files
// Copyright (C) 2003-2004 Jasper van de Gronde, th.v.d.gronde@hccnet.nl
// Copyright (C) 2003-2006 Jerome Martinez, zen@mediaarea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about Ape files
// General note: support for lists in one value is questionable.
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// 2005-11-07, Zen@MediaArea.net
// Adapted to new File__Base
//
// 2004-09-10, th.v.d.gronde@hccnet.nl
// Adaptation to some changes in File_Base
//
// 2003-??-??, th.v.d.gronde@hccnet.nl
// Creation of file
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_APE_YES) || (!defined(MEDIAINFO_AUDIO_NO) && !defined(MEDIAINFO_APE_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <map>
#include <algorithm>
#include <vector>
#include <wx/file.h>
#include <ZenLib/ZtringListList.h>
#include <ZenLib/Utils.h>
#include <MACLib/All.h>
#include <MACLib/MACLib.h>
#include <MACLib/APETag.h>
#include "MediaInfo/Audio/File_Ape.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//---------------------------------------------------------------------------

typedef std::pair<const Char*,const Char*> mapping_t;

static const mapping_t to_mediainfo_data[]={
    mapping_t(_T("ARTIST"),_T("Performer")),
    mapping_t(_T("COMMENTS"),_T("Comment")),
    mapping_t(_T("YEAR"),_T("Recorded_Date")),
    mapping_t(_T("FILE URL"),_T("Url")),
    mapping_t(_T("COMPOSER"),_T("Author"))
};

static const mapping_t from_mediainfo_data[]={
    mapping_t(_T("PERFORMER"),_T("Artist")),
    mapping_t(_T("COMMENTS"),_T("Comment")),
    mapping_t(_T("RECORDED_DATE"),_T("Year")),
    mapping_t(_T("URL"),_T("File Url")),
    mapping_t(_T("AUTHOR"),_T("COMPOSER"))
};

typedef const std::map<tstring, tstring> to_mediainfo_t;
static to_mediainfo_t to_mediainfo(to_mediainfo_data,to_mediainfo_data+(sizeof(to_mediainfo_data)/sizeof(to_mediainfo_data[0])));

typedef to_mediainfo_t from_mediainfo_t;
static from_mediainfo_t from_mediainfo(from_mediainfo_data,from_mediainfo_data+(sizeof(from_mediainfo_data)/sizeof(from_mediainfo_data[0])));

//***************************************************************************
// Functions
//***************************************************************************

//---------------------------------------------------------------------------
int File_Ape::Read()
{
    {
	#ifndef _UNICODE
		return -1;
	#endif

		int					nRetVal = 0;										// generic holder for return values

	    // open the file and error check
        IAPEDecompress *	pAPEDecompress = CreateIAPEDecompress(wxString(CompleteFileName.c_str()).wc_str(*wxConvCurrent), &nRetVal);
	    if (nRetVal != ERROR_SUCCESS)
	    {
		    return -1;
	    }
        Stream_Prepare(Stream_General);

        // Now that we're sure it's Monkey's Audio, we can safely do this.
        size_t Audio_Count=Stream_Prepare(Stream_Audio);
        if (Audio_Count!=0)
            return -1;
        General[0](_T("Format"))=_T("APE");
        General[0](_T("Format/String"))=_T("Monkey's Audio");
        General[0](_T("Format/Extensions"))=_T("APE MAC");
        General[0](_T("Format/Url"))=_T("http://www.monkeysaudio.com/");
        Audio[Audio_Count](_T("Codec"))=_T("Monkey's Audio");

	    // audio format information
        Audio[0](_T("SamplingRate")).From_Number(pAPEDecompress->GetInfo(APE_INFO_SAMPLE_RATE));
        Audio[0](_T("Resolution")).From_Number(pAPEDecompress->GetInfo(APE_INFO_BITS_PER_SAMPLE));
        Audio[0](_T("Channel(s)")).From_Number(pAPEDecompress->GetInfo(APE_INFO_CHANNELS));

	    // size and duration information
        General[0](_T("PlayTime")).From_Number(pAPEDecompress->GetInfo(APE_INFO_LENGTH_MS));

        //Audio[0](_T("BitRate"))=pAPEDecompress->GetInfo(APE_INFO_AVERAGE_BITRATE); //Average bitrate indicated by Ape seems false
        Audio[0](_T("BitRate_Mode"))=_T("VBR");

        //General[0](_T("TotalBytes")).From_Number(pAPEDecompress->GetInfo(APE_INFO_APE_TOTAL_BYTES));

	    // tag information
	    CAPETag * pAPETag = (CAPETag *) pAPEDecompress->GetInfo(APE_INFO_TAG);
	    BOOL bHasID3Tag = pAPETag->GetHasID3Tag();
	    BOOL bHasAPETag = pAPETag->GetHasAPETag();

	    if (bHasID3Tag || bHasAPETag)
	    {
		    // iterate through all the tag fields
		    CAPETagField * pTagField;
		    for(int i = 0; 0 != (pTagField=pAPETag->GetTagField(i)); ++i)
		    {
                Ztring fieldname;
                {
                    const Ztring key_org(wxString(pTagField->GetFieldName(),wxConvUTF8).c_str());
                    Ztring key(key_org);
                    key.MakeUpperCase();
                    if ( key == _T("LANGUAGE") ) {
                        fieldname=key_org;
                        if ( Audio[0](fieldname) != _T("") ) Audio[0](fieldname)+=_T("/");
                        Audio[0](fieldname)+=wxString(pTagField->GetFieldValue(),wxConvUTF8,pTagField->GetFieldValueSize()).c_str();
                    } else {
                        {
                            to_mediainfo_t::const_iterator it(to_mediainfo.find(key));
                            if ( it != to_mediainfo.end() ) {
                                fieldname=it->second;
                            } else {
                                fieldname=key_org;
                            }
                        }

                        const char* begin = pTagField->GetFieldValue();
                        const char* const end = begin+pTagField->GetFieldValueSize();
                        while(begin != end) {
                          const char* cur_end = begin;
                          while(*cur_end && cur_end != end) ++cur_end;

                          if ( General[0](fieldname) != _T("") ) General[0](fieldname)+=_T("/");
                          General[0](fieldname)+=wxString(begin,wxConvUTF8,cur_end-begin).c_str();

                          begin = cur_end;
                          if ( begin != end ) ++begin;
                        }
                    }
                }
		    }
	    }
    }

    return 1;
}

//---------------------------------------------------------------------------
int File_Ape::Write (const Ztring &ToSet, stream_t StreamKind, size_t StreamNumber, const Ztring &Parameter, const Ztring &OldValue)
{
	#ifndef _UNICODE
		return -1;
	#endif

	if ( StreamNumber != 0 )
        return 1;

    Ztring key_org;
    {
        from_mediainfo_t::const_iterator it(from_mediainfo.find(Parameter));
        if ( it != from_mediainfo.end() ) {
            key_org=it->second;
        } else {
            key_org=Parameter;
        }
    }
    Ztring key(key_org);
    key.MakeUpperCase();
    switch(StreamKind)
    {
    case Stream_General:
    case Stream_Audio:
        {
	        // variable declares
	        int					nRetVal = 0;										// generic holder for return values

	        // open the file and error check
            IAPEDecompress *	pAPEDecompress = CreateIAPEDecompress(wxString(General[0](_T("CompleteName")).c_str()).wc_str(*wxConvCurrent), &nRetVal);
	        if (nRetVal != ERROR_SUCCESS)
	        {
		        return -1;
	        }

	        // set tag
	        CAPETag * pAPETag = (CAPETag *) pAPEDecompress->GetInfo(APE_INFO_TAG);
            Ztring key_to_set;
            Ztring value_to_set;
            if ( pAPETag->GetHasID3Tag() || pAPETag->GetHasAPETag() ) {
		        CAPETagField * pTagField;
		        for(int i = 0; 0 != (pTagField=pAPETag->GetTagField(i)); ++i)
		        {
                    const Ztring curkey_org(wxString(pTagField->GetFieldName(),wxConvUTF8).c_str());
                    Ztring curkey(curkey_org);
                    curkey.MakeUpperCase();
                    if ( key == curkey )
                    {
                        key_to_set=curkey_org;
                        if ( pTagField->GetIsReadOnly() ) {
                            return -1;
                        }
                        else {
                            break;
                        }
                    }
                }
            }
            if ( key_to_set.empty() ) key_to_set=key_org;
            if ( !value_to_set.empty() ) value_to_set+=_T("/");
            value_to_set+=ToSet;

            if ( ToSet.empty() )
            {
                std::string temp_value_to_set(wxString(key_to_set.c_str()).mb_str(wxConvUTF8));
                for(std::string::iterator it=temp_value_to_set.begin(); it!=temp_value_to_set.end(); ++it) {
                    if ( *it == '/' ) *it=0;
                }

                pAPETag->SetFieldString(wxString(key_to_set.c_str()).wc_str(*wxConvCurrent), temp_value_to_set.c_str(), true);
            }
            else
            {
                pAPETag->RemoveField(wxString(key_to_set.c_str()).wc_str(*wxConvCurrent));
            }

            pAPETag->Save();
	    }
        break;
    }

    return 1;
}

//---------------------------------------------------------------------------
void File_Ape::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
        General[0](_T("OveralBitRate"), Info_HowTo)=_T("R");
        General[0](_T("PlayTime"), Info_HowTo)=_T("R");
        General[0](_T("Author"), Info_HowTo)=_T("R");
        General[0](_T("Album"), Info_HowTo)=_T("R");
        General[0](_T("Track"), Info_HowTo)=_T("R");
        General[0](_T("Comment"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Audio)
    {
        Audio[0](_T("BitRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Channel(s)"), Info_HowTo)=_T("R");
        Audio[0](_T("SamplingRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Codec"), Info_HowTo)=_T("R");
    }
}

} //NameSpace

#endif //MEDIAINFO_APE_*

