// File_Ace - Info for ACE files
// Copyright (C) 2005-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about ACE files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_ACE_YES) || (!defined(MEDIAINFO_ARCHIVE_NO) && !defined(MEDIAINFO_ACE_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/Archive/File_Ace.h"
#include "ZenLib/Utils.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Functions
//***************************************************************************

int File_Ace::Read(const int8u* Begin, size_t Begin_Size, const int8u* End, size_t End_Size, int64u FileSize)
{
    //Test
    if (Begin_Size<=128) //Test if there is enougth bytes
        return -2;

    if (CC7(Begin+7)!=CC4("**ACE**"))
        return -1;

    Stream_Prepare(Stream_General);
    General[0](_T("Format"))=_T("ACE");
    General[0](_T("Format/String"))=_T("ACE");
    General[0](_T("Format/Url"))=_T(""); //TODO
    General[0](_T("Format/Extensions"))=_T("ace");

    return 1;
}

void File_Ace::HowTo(stream_t StreamKind)
{
    return;
}

} //NameSpace

#endif
