// HowToUse - Example for MediaInfo.Dll (commandline version)
// Copyright (C) 2004-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Example for MediaInfo.Dll
// Command line version
// Note : it uses Ansi version of MediaInfoLib for regression tests
//        but you can use Unicode version
//        (replace MediaInfoA_XXX by MediaInfo_XXX)
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// 2005-01-05, Zen@Mediaarea.net
// Adaptation to new interface (Ansi)
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#include <iostream>
#include <string>
#include <stdlib.h>
#include "MediaInfoDLL/MediaInfoDLL.h"

int main(int argc, char* argv[])
{
	//Test if version of DLL is compatible : 3rd argument is "version of DLL tested;Your application name;Your application version"
	std::string ToDisplay = MediaInfoA_Option(NULL, "Info_Version", "0.7.0.0;MediaInfoDLL_Example_VC;0.7.0.0");
	if (ToDisplay.size() == 0)
		return -1; //This version of the DLL is not compatible

	//Information about MediaInfo
    std::string To_Display=MediaInfoA_Option(NULL, "Info_Version", "");

    To_Display += "\r\n\r\nInfo_Parameters\r\n";
    To_Display += MediaInfoA_Option(NULL, "Info_Parameters", "");

    To_Display += "\r\n\r\nInfo_Capacities\r\n";
    To_Display += MediaInfoA_Option(NULL, "Info_Capacities", "");

    To_Display += "\r\n\r\nInfo_Codecs\r\n";
    To_Display += MediaInfoA_Option(NULL, "Info_Codecs", "");

	//An example of how to use the library
    To_Display += "\r\n\r\nOpen\r\n";
    void* Handle = MediaInfoA_New();
    MediaInfoA_Open(Handle, "Example.ogg");

    To_Display += "\r\n\r\nInform with Complete=false\r\n";
    MediaInfoA_Option(Handle, "Complete", "");
    To_Display += MediaInfoA_Inform(Handle, NULL);

    To_Display += "\r\n\r\nInform with Complete=true\r\n";
    MediaInfoA_Option(Handle, "Complete", "1");
    To_Display += MediaInfoA_Inform(Handle, NULL);

    To_Display += "\r\n\r\nCustom Inform\r\n";
    MediaInfoA_Option(Handle, "Inform", "General;Example : FileSize=%FileSize%");
    To_Display += MediaInfoA_Inform(Handle, NULL);

    To_Display += "\r\n\r\nGetI with Stream=General and Parameter=13\r\n";
	To_Display += MediaInfoA_GetI(Handle, MediaInfo_Stream_General, 0, 13, MediaInfo_Info_Text);

    To_Display += "\r\n\r\nCount_Get with StreamKind=Stream_Audio\r\n";
	char Temp[100];
	itoa(MediaInfoA_Count_Get(Handle, MediaInfo_Stream_Audio, -1), Temp, 10);
    To_Display +=Temp;

    To_Display += "\r\n\r\nGet with Stream=General and Parameter=\"AudioCount\"\r\n";
    To_Display += MediaInfoA_Get(Handle, MediaInfo_Stream_General, 0, "AudioCount", MediaInfo_Info_Text, MediaInfo_Info_Name);

    To_Display += "\r\n\r\nGet with Stream=Audio and Parameter=\"StreamCount\"\r\n";
    To_Display += MediaInfoA_Get(Handle, MediaInfo_Stream_Audio, 0, "StreamCount", MediaInfo_Info_Text, MediaInfo_Info_Name);

    To_Display += "\r\n\r\nGet with Stream=General and Parameter=\"FileSize\"\r\n";
    To_Display += MediaInfoA_Get(Handle, MediaInfo_Stream_General, 0, "FileSize", MediaInfo_Info_Text, MediaInfo_Info_Name);

    To_Display += "\r\n\r\nClose\r\n";
    MediaInfoA_Close(Handle);

    MediaInfoA_Delete(Handle);

	//Displaying the text
	std::cout<<To_Display;
    system("PAUSE");

	return 0;
}
//---------------------------------------------------------------------------



