Public Class Form1
    Private Declare Unicode Function MediaInfo_New Lib "MediaInfo.DLL" () As Integer
    Private Declare Unicode Sub MediaInfo_Delete Lib "MediaInfo.DLL" (ByVal Handle As Integer)
    Private Declare Unicode Function MediaInfo_Open Lib "MediaInfo.DLL" (ByVal Handle As Integer, ByVal File As String) As Integer
    Private Declare Unicode Function MediaInfo_Close Lib "MediaInfo.DLL" (ByVal Handle As Integer) As Integer
    Private Declare Unicode Function MediaInfo_Inform Lib "MediaInfo.DLL" (ByVal Handle As Integer, ByVal Options As Integer) As String
    Private Declare Unicode Function MediaInfo_GetI Lib "MediaInfo.DLL" (ByVal Handle As Integer, ByVal StreamKind As Integer, ByVal StreamNumber As Integer, ByVal Parameter As Integer, ByVal KindOfInfo As Integer) As String 'See MediaInfoDLL.h for enumeration values
    Private Declare Unicode Function MediaInfo_Get Lib "MediaInfo.DLL" (ByVal Handle As Integer, ByVal StreamKind As Integer, ByVal StreamNumber As Integer, ByVal Parameter As String, ByVal KindOfInfo As Integer, ByVal KindOfSearch As Integer) As String
    Private Declare Unicode Function MediaInfo_Option Lib "MediaInfo.DLL" (ByVal Handle As Integer, ByVal Optionn As String, ByVal Value As String) As String
    Private Declare Unicode Function MediaInfo_State_Get Lib "MediaInfo.DLL" (ByVal Handle As Integer) As Integer 'see MediaInfo.h for details
    Private Declare Unicode Function MediaInfo_Count_Get Lib "MediaInfo.DLL" (ByVal Handle As Integer, ByVal StreamKind As Integer, ByVal StreamNumber As Integer) As Integer 'see MediaInfoDLL.h for enumeration values


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim Handle As Object
        Dim To_Display As String
        Dim Temp As String

        To_Display = MediaInfo_Option(0, "Info_Version", "0.7.0.0;MediaInfoDLL_Example_VB;0.7.0.0")
        If (To_Display.Length() = 0) Then
            RichTextBox1.Text = "This version of the DLL is not compatible"
            Return
        End If

        'Information about MediaInfo
        To_Display += vbCrLf + vbCrLf + "Info_Parameters" + vbCrLf
        To_Display += MediaInfo_Option(0, "Info_Parameters", "")

        To_Display += vbCrLf + vbCrLf + "Info_Capacities" + vbCrLf
        To_Display += MediaInfo_Option(0, "Info_Capacities", "")

        To_Display += vbCrLf + vbCrLf + "Info_Codecs" + vbCrLf
        To_Display += MediaInfo_Option(0, "Info_Codecs", "")

        'An example of how to use the library
        To_Display += vbCrLf + vbCrLf + "Open" + vbCrLf
        Handle = MediaInfo_New()
        MediaInfo_Open(Handle, "Example.ogg")

        To_Display += vbCrLf + vbCrLf + "Inform with Complete=false" + vbCrLf
        MediaInfo_Option(Handle, "Complete", "")
        To_Display += MediaInfo_Inform(Handle, 0)

        To_Display += vbCrLf + vbCrLf + "Inform with Complete=true" + vbCrLf
        MediaInfo_Option(Handle, "Complete", "1")
        To_Display += MediaInfo_Inform(Handle, 0)

        To_Display += vbCrLf + vbCrLf + "Custom Inform" + vbCrLf
        MediaInfo_Option(Handle, "Inform", "General;Example : FileSize=%FileSize%")
        To_Display += MediaInfo_Inform(Handle, 1)

        To_Display += vbCrLf + vbCrLf + "Get with Stream=General and Parameter='FileSize'" + vbCrLf
        To_Display += MediaInfo_Get(Handle, 0, 0, "FileSize", 1, 0)

        To_Display += vbCrLf + vbCrLf + "GetI with Stream=General and Parameter=13" + vbCrLf
        To_Display += MediaInfo_GetI(Handle, 0, 0, 13, 1)

        To_Display += vbCrLf + vbCrLf + "Count_Get with StreamKind=Stream_Audio" + vbCrLf
        Temp = MediaInfo_Count_Get(Handle, 2, -1)
        To_Display += Temp

        To_Display += vbCrLf + vbCrLf + "Get with Stream=General and Parameter='AudioCount'" + vbCrLf
        To_Display += MediaInfo_Get(Handle, 0, 0, "AudioCount", 1, 0)

        To_Display += vbCrLf + vbCrLf + "Get with Stream=Audio and Parameter='StreamCount'" + vbCrLf
        To_Display += MediaInfo_Get(Handle, 2, 0, "StreamCount", 1, 0)

        To_Display += RichTextBox1.Text + vbCrLf + vbCrLf + "Close" + vbCrLf
        MediaInfo_Close(Handle)

        MediaInfo_Delete(Handle)

        'Displaying the text
        RichTextBox1.Text = To_Display
    End Sub
End Class
