using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;
using System.Text;

namespace MediaInfoLib_MSCS
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.RichTextBox richTextBox1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Mthode requise pour la prise en charge du concepteur - ne modifiez pas
		/// le contenu de cette mthode avec l'diteur de code.
		/// </summary>
		private void InitializeComponent()
		{
			this.richTextBox1 = new System.Windows.Forms.RichTextBox();
			this.SuspendLayout();
			// 
			// richTextBox1
			// 
			this.richTextBox1.Location = new System.Drawing.Point(0, 0);
			this.richTextBox1.Name = "richTextBox1";
			this.richTextBox1.Size = new System.Drawing.Size(768, 512);
			this.richTextBox1.TabIndex = 0;
			this.richTextBox1.Text = "";
			this.richTextBox1.TextChanged += new System.EventHandler(this.richTextBox1_TextChanged);
			// 
			// Form1
			// 
			this.ClientSize = new System.Drawing.Size(770, 514);
			this.Controls.Add(this.richTextBox1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D;
			this.Name = "Form1";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "How to use MediaInfo.Dll";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		
		//YOU MUST DO : Put MediaInfo.Dll and Example.ogg in the "./Bin/Configuration name" folder

		public enum StreamKind
		{
			General,
			Video,
			Audio,
			Text,
			Chapters,
			Image
		}
 
		public enum InfoKind
		{
			Name,
			Text,
			Measure,
			Options,
			NameText,
			MeasureText,
			Info,
			HowTo
		}
 
		public enum InfoOptions
		{
			ShowInInform,
			Support,
			ShowInSupported,
			TypeOfValue
		}
 
		[DllImport("MediaInfo.dll")]public static extern IntPtr MediaInfo_New();
		[DllImport("MediaInfo.dll")]public static extern void MediaInfo_Delete(IntPtr Handle);
		[DllImport("MediaInfo.dll")]public static extern int MediaInfo_Open(IntPtr Handle, [MarshalAs(UnmanagedType.LPWStr)] string FileName);
 		[DllImport("MediaInfo.dll")]public static extern int MediaInfo_Close(IntPtr Handle);
		[DllImport("MediaInfo.dll")][return: MarshalAs(UnmanagedType.LPWStr)]public static extern string MediaInfo_Inform(IntPtr Handle, [MarshalAs(UnmanagedType.U4)] uint Reserved);
		[DllImport("MediaInfo.dll")][return: MarshalAs(UnmanagedType.LPWStr)]public static extern string MediaInfo_GetI( IntPtr Handle, [MarshalAs(UnmanagedType.U4)] StreamKind StreamKind, uint StreamNumber, uint Parameter, [MarshalAs(UnmanagedType.U4)] InfoKind KindOfInfo);
 		[DllImport("MediaInfo.dll")][return: MarshalAs(UnmanagedType.LPWStr)]public static extern string MediaInfo_Get( IntPtr Handle, [MarshalAs(UnmanagedType.U4)] StreamKind StreamKind, uint StreamNumber, [MarshalAs(UnmanagedType.LPWStr)] string Parameter, [MarshalAs(UnmanagedType.U4)] InfoKind KindOfInfo, [MarshalAs(UnmanagedType.U4)] InfoKind KindOfSearch);
		[DllImport("MediaInfo.dll")][return: MarshalAs(UnmanagedType.LPWStr)]public static extern string MediaInfo_Option(IntPtr Handle, [MarshalAs(UnmanagedType.LPWStr)] string Option, [MarshalAs(UnmanagedType.LPWStr)] string Value);
		[DllImport("MediaInfo.dll")]public static extern int MediaInfo_State_Get(IntPtr Handle);
		[DllImport("MediaInfo.dll")]public static extern int MediaInfo_Count_Get(IntPtr Handle, [MarshalAs(UnmanagedType.U4)] StreamKind StreamKind, int StreamNumber);


		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			//Test if version of DLL is compatible : 3rd argument is "version of DLL tested;Your application name;Your application version"
			String ToDisplay = MediaInfo_Option((IntPtr)0, "Info_Version", "0.7.0.0;MediaInfoDLL_Example_CS;0.7.0.0");
			if (ToDisplay.Length == 0)
			{
				richTextBox1.Text = "This version of the DLL is not compatible";
				return;
			}

			//Information about MediaInfo
			ToDisplay += "\r\n\r\nInfo_Parameters\r\n";
			ToDisplay += MediaInfo_Option((IntPtr)0, "Info_Parameters", "");

			ToDisplay += "\r\n\r\nInfo_Capacities\r\n";
			ToDisplay += MediaInfo_Option((IntPtr)0, "Info_Capacities", "");

			ToDisplay += "\r\n\r\nInfo_Codecs\r\n";
			ToDisplay += MediaInfo_Option((IntPtr)0, "Info_Codecs", "");

			//An example of how to use the library
			ToDisplay += "\r\n\r\nOpen\r\n";
			IntPtr Handle = MediaInfo_New();
			MediaInfo_Open(Handle, "_test.mp3");

			ToDisplay += "\r\n\r\nInform with Complete=false\r\n";
			MediaInfo_Option(Handle, "Complete", "");
			ToDisplay += MediaInfo_Inform(Handle, 0);

			ToDisplay += "\r\n\r\nInform with Complete=true\r\n";
			MediaInfo_Option(Handle, "Complete", "1");
			ToDisplay += MediaInfo_Inform(Handle, 0);

			ToDisplay += "\r\n\r\nCustom Inform\r\n";
			MediaInfo_Option(Handle, "Inform", "General;File size is %FileSize% bytes");
			ToDisplay += MediaInfo_Inform(Handle, 0);

			ToDisplay += "\r\n\r\nGet with Stream=General and Parameter='FileSize'\r\n";
			ToDisplay += MediaInfo_Get(Handle, 0, 0, "FileSize", InfoKind.Text, 0);

			ToDisplay += "\r\n\r\nGetI with Stream=General and Parameter=13\r\n";
			ToDisplay += MediaInfo_GetI(Handle, 0, 0, 13, InfoKind.Text);

			ToDisplay += "\r\n\r\nCount_Get with StreamKind=Stream_Audio\r\n";
			ToDisplay += MediaInfo_Count_Get(Handle, StreamKind.Audio, -1);

			ToDisplay += "\r\n\r\nGet with Stream=General and Parameter='AudioCount'\r\n";
			ToDisplay += MediaInfo_Get(Handle, StreamKind.General, 0, "AudioCount", InfoKind.Text, 0);

			ToDisplay += "\r\n\r\nGet with Stream=Audio and Parameter='StreamCount'\r\n";
			ToDisplay += MediaInfo_Get(Handle, StreamKind.Audio, 0, "StreamCount", InfoKind.Text, 0);

			ToDisplay += "\r\n\r\nClose\r\n";
			MediaInfo_Close(Handle);

			MediaInfo_Delete(Handle);

			//Displaying the text
			richTextBox1.Text = ToDisplay;
		}

		private void richTextBox1_TextChanged(object sender, System.EventArgs e)
		{
		}
	}
}
