//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "HowToUse_.h"
#include "MediaInfoDLL/MediaInfoDLL.h"
#include <string>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
    Left=(Screen->Width-Width)/2;
    Top=(Screen->Height-Height)/2;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    //Information about MediaInfo
    WideString To_Display=MediaInfo_Option(NULL, _T("Info_Version"), _T(""));

    To_Display += _T("\r\n\r\nInfo_Parameters\r\n");
    To_Display += MediaInfo_Option(NULL, _T("Info_Parameters"), _T(""));

    To_Display += _T("\r\n\r\nInfo_Capacities\r\n");
    To_Display += MediaInfo_Option(NULL, _T("Info_Capacities"), _T(""));

    To_Display += _T("\r\n\r\nInfo_Codecs\r\n");
    To_Display += MediaInfo_Option(NULL, _T("Info_Codecs"), _T(""));

	//An example of how to use the library
    To_Display += _T("\r\n\r\nNew\r\nHandle=");
    void* Handle = MediaInfo_New();
    To_Display += WideString((int)Handle);

    To_Display += _T("\r\n\r\nOpen\r\nCount of opened files=");
    To_Display += WideString(MediaInfo_Open(Handle, _T("Example.ogg")));

    To_Display += _T("\r\n\r\nInform with Complete=false\r\n");
    MediaInfo_Option(Handle, _T("Complete"), _T(""));
    To_Display += MediaInfo_Inform(Handle, NULL);

    To_Display += _T("\r\n\r\nInform with Complete=true\r\n");
    MediaInfo_Option(Handle, _T("Complete"), _T("1"));
    To_Display += MediaInfo_Inform(Handle, NULL);

    To_Display += _T("\r\n\r\nCustom Inform\r\n");
    MediaInfo_Option(Handle, _T("Inform"), _T("General;Example : FileSize=%FileSize%"));
    To_Display += MediaInfo_Inform(Handle, NULL);

    To_Display += _T("\r\n\r\nGetI with Stream=General and Parameter=13\r\n");
    To_Display += MediaInfo_GetI(Handle, MediaInfo_Stream_General, 0, 13, MediaInfo_Info_Text);

    To_Display += _T("\r\n\r\nCount_Get with StreamKind=Stream_Audio\r\n");
    To_Display += WideString(MediaInfo_Count_Get(Handle, MediaInfo_Stream_Audio, -1));

    To_Display += _T("\r\n\r\nGet with Stream=General and Parameter=\"AudioCount\"\r\n");
    To_Display += MediaInfo_Get(Handle, MediaInfo_Stream_General, 0, _T("AudioCount"), MediaInfo_Info_Text, MediaInfo_Info_Name);

    To_Display += _T("\r\n\r\nGet with Stream=Audio and Parameter=\"StreamCount\"\r\n");
    To_Display += MediaInfo_Get(Handle, MediaInfo_Stream_Audio, 0, _T("StreamCount"), MediaInfo_Info_Text, MediaInfo_Info_Name);

    To_Display += _T("\r\n\r\nGet with Stream=General and Parameter=\"FileSize\"\r\n");
    To_Display += MediaInfo_Get(Handle, MediaInfo_Stream_General, 0, _T("FileSize"), MediaInfo_Info_Text, MediaInfo_Info_Name);

    To_Display += _T("\r\n\r\nClose\r\n");
    MediaInfo_Close(Handle);

    To_Display += _T("\r\n\r\nDelete the Handle\r\n");
    MediaInfo_Delete(Handle);

    //C++
    MediaInfoLib::MediaInfoList MI;
    MI.Open(_T("Example.ogg"));
    To_Display += _T("\r\n\r\nC++ Example : Get with Stream=General and Parameter=\"FileSize\"\r\n");
    To_Display += MI.Get(0, MediaInfoLib::Stream_General, 0, _T("FileSize"), MediaInfoLib::Info_Text, MediaInfoLib::Info_Name).c_str();

    To_Display += _T("\r\n\r\nC++ Example : Get Inform with Complete=true\r\n");
    MI.Option(_T("Complete"), _T("1"));
    MI.Option(_T("Inform"), _T(""));
    To_Display += MI.Inform(0).c_str();

    //Displaying the text
    Memo1->Text = To_Display;
}
//---------------------------------------------------------------------------








