//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "HowToUse_.h"
#include "MediaInfo\MediaInfo.h"
using namespace MediaInfoLib;
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
    Left=(Screen->Width-Width)/2;
    Top=(Screen->Height-Height)/2;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
	//Information about MediaInfo
    MediaInfo MI;
    WideString To_Display=MI.Option(L"Info_Version").c_str(); //Note : I would have liked to use std::wstring, but I have a big bug with it (+= operator doesn't suprress '\0' if used with MediaInfo methods)

    To_Display += L"\r\n\r\nInfo_Parameters\r\n";
    To_Display += MI.Option(L"Info_Parameters").c_str();

    To_Display += L"\r\n\r\nInfo_Capacities\r\n";
    To_Display += MI.Option(L"Info_Capacities").c_str();

    To_Display += L"\r\n\r\nInfo_Codecs\r\n";
    To_Display += MI.Option(L"Info_Codecs").c_str();

	//An example of how to use the library
    To_Display += L"\r\n\r\nOpen\r\n";
    MI.Open(L"Example.ogg");

    To_Display += L"\r\n\r\nInform with Complete=false\r\n";
    MI.Option(L"Complete");
    To_Display += MI.Inform().c_str();

    To_Display += L"\r\n\r\nInform with Complete=true\r\n";
    MI.Option(L"Complete", L"1");
    To_Display += MI.Inform().c_str();

    To_Display += L"\r\n\r\nCustom Inform\r\n";
    MI.Option(L"Inform", L"General;%FileSize%");
    To_Display += MI.Inform().c_str();

    To_Display += L"\r\n\r\nGetI with Stream=General and Parameter=13\r\n";
    To_Display += MI.Get(Stream_General, 0, 13, Info_Text).c_str();

    To_Display += L"\r\n\r\nCount_Get with StreamKind=Stream_Audio\r\n";
    To_Display += WideString(MI.Count_Get(Stream_Audio));

    To_Display += L"\r\n\r\nGet with Stream=General and Parameter=\"AudioCount\"\r\n";
    To_Display += MI.Get(Stream_General, 0, L"AudioCount", Info_Text, Info_Name).c_str();

    To_Display += L"\r\n\r\nGet with Stream=Audio and Parameter=\"StreamCount\"\r\n";
    To_Display += MI.Get(Stream_Audio, 0, L"StreamCount", Info_Text, Info_Name).c_str();

    To_Display += L"\r\n\r\nGet with Stream=General and Parameter=\"FileSize\"\r\n";
    To_Display += MI.Get(Stream_General, 0, L"FileSize", Info_Text, Info_Name).c_str();

    To_Display += L"\r\n\r\nClose\r\n";
    MI.Close();

    //Displaying the text
    Memo1->Text = To_Display;
}
//---------------------------------------------------------------------------
