public enum StreamKind
{
    General,
    Visual,
    Audio,
    Text,
    Chapters,
    Max
}

public enum InfoKind
{
    Name,
    Text,
    Measure,
    Options,
    NameText,
    MeasureText,
    Info,
    HowTo,
    Max
}

public enum InfoOptions
{
    ShowInInform,
    Support,
    ShowInSupported,
    TypeOfValue,
    Max
}

[DllImport("MediaInfo.dll")]public static extern IntPtr MediaInfo_New();
[DllImport("MediaInfo.dll")]public static extern void MediaInfo_Delete(IntPtr Handle);
[DllImport("MediaInfo.dll")]public static extern int MediaInfo_Open(IntPtr Handle, [MarshalAs(UnmanagedType.LPWStr)]string FileName);
[DllImport("MediaInfo.dll")]public static extern void MediaInfo_Close(IntPtr Handle);
[DllImport("MediaInfo.dll")][return: MarshalAs(UnmanagedType.LPWStr)]public static extern string MediaInfo_Inform(IntPtr Handle, [MarshalAs(UnmanagedType.U4)] uint Reserved);
[DllImport("MediaInfo.dll")][return: MarshalAs(UnmanagedType.LPWStr)]public static extern string MediaInfo_GetI(IntPtr Handle, [MarshalAs(UnmanagedType.U4)] StreamKind StreamKind, uint StreamNumber, uint Parameter, [MarshalAs(UnmanagedType.U4)]InfoKind KindOfInfo);
[DllImport("MediaInfo.dll")][return: MarshalAs(UnmanagedType.LPWStr)]public static extern string MediaInfo_Get(IntPtr Handle, [MarshalAs(UnmanagedType.U4)] StreamKind StreamKind, uint StreamNumber, [MarshalAs(UnmanagedType.LPWStr)]string Parameter, [MarshalAs(UnmanagedType.U4)]InfoKind KindOfInfo, [MarshalAs(UnmanagedType.U4)]InfoKind KindOfSearch);
[DllImport("MediaInfo.dll")][return: MarshalAs(UnmanagedType.LPWStr)]public static extern string MediaInfo_Option(IntPtr Handle, [MarshalAs(UnmanagedType.LPWStr)]string Option, [MarshalAs(UnmanagedType.LPWStr)]string Value);
[DllImport("MediaInfo.dll")]public static extern int MediaInfo_State_Get(IntPtr Handle);
[DllImport("MediaInfo.dll")]public static extern int MediaInfo_Count_Get(IntPtr Handle, [MarshalAs(UnmanagedType.U4)]StreamKind StreamKind, int StreamNumber);
