<?php

namespace AppBundle\Entity;

use Doctrine\ORM\EntityRepository;

/**
 * DisplayFileRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class DisplayFileRepository extends EntityRepository
{
    public function getUserAndSystemDisplays($user)
    {
        $list = array();
        $displays = $this->getEntityManager()->getRepository('AppBundle:DisplayFile')->findByUser($user);
        foreach ($displays as $display) {
            $list['User displays'][$display->getId()] = $display;
        }
        $displays = $this->getEntityManager()->getRepository('AppBundle:DisplayFile')->findByUser(null);
        foreach ($displays as $display) {
            $list['System displays'][$display->getId()] = $display;
        }

        return $list;
    }

    public function findOneByUserOrSystem($display, $user)
    {
        $query = $this->getEntityManager()->getRepository('AppBundle:DisplayFile')->createQueryBuilder('d')
            ->where('d.id = :displayID AND d.user = :userID')
            ->orWhere('d.id = :displayID AND d.user IS NULL')
            ->setParameter('displayID', $display)
            ->setParameter('userID', $user)
            ->setMaxResults(1)
            ->getQuery();

        return $query->getSingleResult();
    }
}
