Chapter 7. About this Project
=============================

The main author of this bundle works for SensioLabs, the company behind the
Symfony framework. However, this bundle is not promoted, endorsed or sponsored
by SensioLabs in any way. **This is not the official Symfony admin generator**.

Our philosophy
--------------

EasyAdmin is an open source project with a very **opinionated development**. We
don't make decisions by committee and we're not afraid to refuse the feature
requests proposed by our users. We prefer to focus on as few features as
possible to keep the original vision of the project.

These are some of our **development principles**:

  * Developers and end users are our priorities. We'll always prioritize
    UX (user experience) and DX (developer experience) over code purity.
  * Backend customization is balanced between configuration files and PHP code.
    We'll add new options when they are easy and make sense. Otherwise, we'll
    provide code extension points.
  * Features will only be added if they are useful for a majority of users and
    they don't overcomplicate the application code.
  * Documentation is more important than code. Everything must be documented
    and documentation must be always up-to-date.

How to Collaborate in this Project
----------------------------------

Read the [Contributing Guide](../../../CONTRIBUTING.md)

Alternative Projects
--------------------

EasyAdmin deliberately discards the most complex and customized backends,
focusing on the simplest 80% of the backend projects. In case you encounter an
unavoidable limitation to develop your backend with EasyAdmin, consider using
any of the following alternative admin generators:

  * [GeneratorBundle](https://github.com/symfony2admingenerator/GeneratorBundle),
    a project similar to EasyAdmin and based on YAML configuration files. It
    provides support for Propel, Doctrine ORM and Doctrine ODM models.
  * [SonataAdminBundle](https://github.com/sonata-project/SonataAdminBundle),
    the most advanced and most customizable admin generator for Symfony
    applications. There's nothing you can't do with Sonata.
  * [NgAdminGeneratorBundle](https://github.com/marmelab/NgAdminGeneratorBundle),
    an AngularJS-based admin generator compatible with any Symfony project
    that provides a RESTFul API.

-------------------------------------------------------------------------------

&larr; [Chapter 6. Menu Configuration](6-menu-configuration.md)
