<?php

namespace AppBundle\Entity;

use Doctrine\ORM\EntityRepository;

/**
 * XslPolicyFileRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class XslPolicyFileRepository extends EntityRepository
{
    public function getUserAndSystemPolicies($user)
    {
        $list = array();
        $policy = $this->getEntityManager()->getRepository('AppBundle:XslPolicyFile')->findByUser($user);
        foreach ($policy as $policy) {
            $list['User policies'][$policy->getId()] = $policy;
        }
        $policy = $this->getEntityManager()->getRepository('AppBundle:XslPolicyFile')->findByUser(null);
        foreach ($policy as $policy) {
            $list['System policies'][$policy->getId()] = $policy;
        }

        return $list;
    }

    public function findOneByUserOrSystem($policy, $user)
    {
        $query = $this->getEntityManager()->getRepository('AppBundle:XslPolicyFile')->createQueryBuilder('p')
            ->where('p.id = :policyID AND p.user = :userID')
            ->orWhere('p.id = :policyID AND p.user IS NULL')
            ->setParameter('policyID', $policy)
            ->setParameter('userID', $user)
            ->setMaxResults(1)
            ->getQuery();

        return $query->getSingleResult();
    }
}
