---
layout: page
title: Digital Video Commander
permalink: /
---

# Grant Announcement

Moving Image Preservation of Puget Sound (MIPoPS) has been awarded funds via a Tier II National Endowment for the Humanities Research and Development (NEH R&D) grant to expand the DV Rescue project’s scope beyond its focus on the DV family of videotapes, to build upon our findings and community work, and to encompass the development of new preservation strategies and tools for most digital videotape formats. This expansion project, Digital Video Commander, will entail two years of work to research the challenges and opportunities of digital videotape preservation, develop open-source and freely available software, facilitate user testing, and create documentation to help define and perform comprehensive, automated, and intuitive data migration techniques. MIPoPS will collaborate with RiceCapades, a consulting and development company, and nine partner institutions currently collecting digital videotape to conduct research, define preservation workflows, establish standards, and develop the most impactful, preservation-efficient, and user-friendly tools for capturing content from these digital videotape formats.


The Digital Video Commander project seeks to reframe the entire paradigm of preservation when applied to digital videotapes rather than adopt upon the practices used for analog videotape. Capturing the contents of a digital videotape does not need to be as restrained as attempting to record an ideal, singular presentation of a videotape, but there is a potential that such effort could mimic the more accurate data transfers of hard drives or sectored optical discs where the quality of the data transferred could be verified piece-by-piece and retried as needed to create a more accurate result.


During the NEH R&D funded project, DV Rescue, MIPoPS has found that digitization software does not need to solely work as a diligent scribe that documents the contents recorded on legacy videotapes, but that such software can take control of the hardware, guide the user, automate actions, and orchestrate the entire reformatting event. Such an approach requires skilled development, but the results place this essential preservation practice within reach for more collecting institutions who would benefit from it while producing more accurate representations of digital videotape contents than is currently feasible with more traditional workflows. Additionally, whereas expert calibration of analog signals is essential for presenting data loss while digitizing analog videotapes, the opposite is somewhat true for digital videotapes, where signal manipulation of the digital videotape decoding adds generational loss rather than accuracy. We see that the characteristics of digital videotape provide an opportunity for automation, ease, and increased accuracy within the preservation of digital videotapes and the potential to promote project results in a way that reduces barriers for institutions seeking to establish in-house audiovisual preservation services.
We seek support from the National Endowment for the Humanities in order to generate, document, and disseminate these new tools, which will benefit the entire audiovisual preservation field, and in turn, benefit all areas of the humanities that relied on digital videotape as a form of source material and documentation, therefore saving valuable historic content from extinction.


